/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.components.indicator;

import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxPlatform;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReference;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.HBox;
import org.apache.log4j.Logger;

public class FxRunIndicator
extends HBox {
    private final Logger logger = Logger.getLogger(FxRunIndicator.class);
    private Set<String> flags = Collections.synchronizedSet(new HashSet());
    @FXML
    private ProgressIndicator progressIndicator;
    @FXML
    private Label labelStatusLine;

    public FxRunIndicator() {
        try {
            CustomFXMLLoader.loadElement((Object)((Object)this), FxRunIndicator.class);
            this.setVisible(false);
        }
        catch (Throwable t) {
            this.logger.error((Object)"Failed create instance of FxRunIndicator", t);
        }
    }

    public <T> CompletableFuture<T> progress(CompletableFuture<T> task, String status) {
        return this.progress(task, status, 500L);
    }

    public <T> CompletableFuture<T> progress(CompletableFuture<T> task, String status, long minimumDisplayDuration) {
        AtomicReference<Long> startProgressTimeStamp = new AtomicReference<Long>(System.currentTimeMillis());
        this.startRunningProcess(status);
        Runnable waitAndFinishRunningProcess = () -> {
            long totalDisplayDuration = System.currentTimeMillis() - (Long)startProgressTimeStamp.get();
            long minimumSleep = 0L;
            long sleepFor = Math.max(0L, minimumDisplayDuration - totalDisplayDuration);
            if (sleepFor > 0L) {
                try {
                    Thread.sleep(sleepFor);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.finishRunningProcess(status);
        };
        return task.whenComplete((v, t) -> {
            new Thread(waitAndFinishRunningProcess).start();
            if (t != null) {
                throw new CompletionException((Throwable)t);
            }
        });
    }

    public void setText(String title) {
        this.labelStatusLine.setText(title);
    }

    public void startRunningProcess(String status) {
        FxPlatform.RunFxThread(() -> {
            this.logger.debug((Object)String.format("Start running process indicator: %s", status));
            this.labelStatusLine.setText(status);
            this.flags.add(status);
            this.setVisible(this.isProcessRunning());
        });
    }

    public void finishRunningProcess(String status) {
        FxPlatform.RunFxThread(() -> {
            this.logger.debug((Object)String.format("Stop running process indicator: %s", status));
            this.flags.remove(status);
            this.setVisible(this.isProcessRunning());
            this.flags.stream().findFirst().ifPresent(text -> this.labelStatusLine.setText(text));
        });
    }

    public void finishRunningAllProcess() {
        FxPlatform.RunFxThread(() -> {
            this.flags.clear();
            this.setVisible(this.isProcessRunning());
        });
    }

    private boolean isProcessRunning() {
        return this.flags.size() > 0;
    }
}

