/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.javafx.utils.FxColor;
import java.io.IOException;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;

public class UIValueControlColor
extends AnchorPane
implements UIValueControl {
    private UIControlEventHandler eventHandler;
    private SControl structureControl;
    @FXML
    private ColorPicker colorPicker;
    @FXML
    private TextField textFieldValue;
    private final ChangeListener<Color> colorChangeListener = (ob, oldValue, newValue) -> {
        if (oldValue.equals(newValue)) {
            return;
        }
        String hexColor = FxColor.toHtml((Color)newValue, (!newValue.isOpaque() ? 1 : 0) != 0);
        this.changeStringValue(hexColor);
        this.eventHandler.onValueChange(this.structureControl, hexColor);
    };
    private final ChangeListener<String> stringChangeListener = (ob, oldValue, newValue) -> {
        if (oldValue.equals(newValue)) {
            return;
        }
        this.changeColorValue((String)newValue);
        this.eventHandler.onValueChange(this.structureControl, newValue);
    };

    UIValueControlColor() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.colorPicker.valueProperty().addListener(this.colorChangeListener);
            this.textFieldValue.textProperty().addListener(this.stringChangeListener);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        if (property.getVal() == null) {
            return;
        }
        String hexColor = property.getVal().toString();
        this.changeColorValue(hexColor);
        this.changeStringValue(hexColor);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        String defaultColor;
        this.structureControl = structureControl;
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            this.colorPicker.setTooltip((Tooltip)new StareTooltip(hint));
        }
        if ((defaultColor = structureControl.getDef()) != null && !defaultColor.isEmpty()) {
            this.changeStringValue(defaultColor);
            this.changeColorValue(defaultColor);
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    private void changeColorValue(String value) {
        this.colorPicker.valueProperty().removeListener(this.colorChangeListener);
        try {
            this.colorPicker.setValue((Object)FxColor.toFxColor((String)value.trim()));
        }
        catch (Throwable ignore) {
            this.colorPicker.setValue((Object)Color.BLACK);
        }
        this.colorPicker.valueProperty().addListener(this.colorChangeListener);
    }

    private void changeStringValue(String value) {
        this.textFieldValue.textProperty().removeListener(this.stringChangeListener);
        this.textFieldValue.setText(value);
        this.textFieldValue.textProperty().addListener(this.stringChangeListener);
    }
}

