/*
 * Decompiled with CFR 0.152.
 */
package com.siams.fx.control;

import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.worker.control.SCValue;
import com.siams.cv.monitor.model.worker.control.SControl;
import com.siams.fx.components.jsoneditor.JsonEditor;
import com.siams.fx.components.tooltip.StareTooltip;
import com.siams.fx.control.UIControlEventHandler;
import com.siams.fx.control.UIValueControl;
import com.siams.fx.process.TextEditByExternalApp;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.notifications.StareNotification;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.net.URISyntaxException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import net.algart.json.Jsons;
import org.apache.log4j.Logger;

public class UIValueControlTextArea
extends AnchorPane
implements UIValueControl,
ChangeListener<String> {
    private static final String EXTERNAL_EDITOR_HINT = "Opens this text in the system\u2019s default editor based on the file extension provided here.\nRemember to SAVE the file after editing to apply changes.\n";
    private static final String EXTERNAL_EXTENSION_HINT = "File extension (format) used to select the system\u2019s default external editor.\nFor example, .txt usually opens Notepad on Windows system.\nNote: .json format is always opened in the built-in JSON editor and doesn\u2019t require saving.\n";
    private Logger logger = Logger.getLogger(UIValueControlTextArea.class);
    private SControl structureControl;
    private String userDefinedExtension = ".txt";
    private UIControlEventHandler eventHandler;
    @FXML
    protected TextArea textAreaValue;
    @FXML
    protected Button btnEdit;
    @FXML
    protected TextField edtExt;

    UIValueControlTextArea() {
        try {
            CustomFXMLLoader.loadElement((Object)this);
            this.textAreaValue.textProperty().addListener((ChangeListener)this);
            this.edtExt.textProperty().addListener((ob, o, n) -> {
                this.userDefinedExtension = n;
            });
            this.btnEdit.setTooltip((Tooltip)new StareTooltip(EXTERNAL_EDITOR_HINT));
            this.edtExt.setTooltip((Tooltip)new StareTooltip(EXTERNAL_EXTENSION_HINT));
            this.setUserDefinedExtension(this.userDefinedExtension);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    protected void setUserDefinedExtension(String ext) {
        this.edtExt.setText(ext);
    }

    protected String getUserDefinedExtension() {
        return this.edtExt.getText().isEmpty() ? ".txt" : this.edtExt.getText();
    }

    protected void adjustTextAreaSize() {
        int linesCount;
        if (this.structureControl instanceof SCValue && (linesCount = ((SCValue)this.structureControl).getEditionRows()) > 0) {
            this.textAreaValue.setPrefRowCount(linesCount);
        }
    }

    @Override
    public void setProperty(SimplePrimitive property) {
        if (property.getVal() == null) {
            return;
        }
        this.textAreaValue.textProperty().removeListener((ChangeListener)this);
        String value = property.getVal().toString();
        if (this.structureControl.getValueType().equals((Object)SControl.ValueType.SETTINGS)) {
            try {
                value = Jsons.toPrettyString((JsonObject)Jsons.toJson((String)value));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.textAreaValue.setText(value);
        this.textAreaValue.textProperty().addListener((ChangeListener)this);
    }

    @Override
    public Node getNode() {
        return this;
    }

    @Override
    public void setControlEventHandler(UIControlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    private String guessFormat(String text) {
        String stripped = text.stripLeading();
        if (stripped.startsWith("{")) {
            return ".json";
        }
        return ".txt";
    }

    @Override
    public void setStructureControl(SControl structureControl) {
        this.structureControl = structureControl;
        String hint = structureControl.getSmartHint();
        if (!hint.isEmpty()) {
            this.textAreaValue.setTooltip((Tooltip)new StareTooltip(hint));
        }
        this.btnEdit.setOnAction(event -> {
            String text = this.textAreaValue.getText();
            String ext = this.getUserDefinedExtension();
            this.runExternalEditor(text, ext);
        });
        this.adjustTextAreaSize();
    }

    protected void runExternalEditor(String text, String userDefinedExtension) {
        boolean runExternalApp = true;
        if (userDefinedExtension.equalsIgnoreCase(".json")) {
            try {
                this.textAreaValue.setText(JsonEditor.show(text, 640, 480, this.structureControl.getName()));
                runExternalApp = false;
            }
            catch (IOException | URISyntaxException e) {
                this.logger.error((Object)"Failed run JsonEditor", (Throwable)e);
            }
        }
        if (runExternalApp) {
            try {
                TextEditByExternalApp.edit(text, userDefinedExtension).ifPresent(value -> this.textAreaValue.setText(value));
            }
            catch (Throwable t) {
                String error = String.format("Failed editing value. %s", t.getMessage());
                this.logger.error((Object)error, t);
                StareNotification.showWarn((String)error);
            }
        }
    }

    @Override
    public SControl getStructureControl() {
        return this.structureControl;
    }

    public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (oldValue.equals(newValue)) {
            return;
        }
        this.eventHandler.onValueChange(this.structureControl, this.textAreaValue.getText());
    }
}

