/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.dashboard;

import com.siams.cv.monitor.dashboard.RpcApi;
import com.siams.cv.monitor.dashboard.data.ChildControl;
import com.siams.cv.monitor.dashboard.data.DashboardNode;
import com.siams.cv.monitor.dashboard.data.DashboardTree;
import com.siams.cv.monitor.dashboard.data.PropertyControl;
import com.siams.cv.monitor.dashboard.viewer.DashboardCompareViewer;
import com.siams.cv.monitor.dashboard.viewer.DashboardStatusTooltip;
import com.siams.cv.monitor.dashboard.viewer.IDashboardViewer;
import com.siams.cv.monitor.model.SimplePrimitive;
import com.siams.cv.monitor.model.viewer.CompareViewerModel;
import com.siams.cv.monitor.model.viewer.ImageViewerModel;
import com.siams.cv.monitor.model.viewer.PlainTextViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import com.siams.cv.monitor.model.viewer.ViewerModel;
import com.siams.cv.monitor.viewers.ui.content.PlainTextViewer;
import com.siams.cv.monitor.viewers.ui.content.ViewerFactory;
import com.siams.fx.components.indicator.FxRunIndicator;
import com.siams.fx.control.UIControlContainer;
import com.siams.fxml.loader.CustomFXMLLoader;
import com.siams.general.Deletable;
import com.siams.javafx.PaneHelper;
import com.siams.javafx.utils.FxPlatform;
import com.siams.notifications.StareNotification;
import com.siams.preferences.UIPreference;
import com.siams.stare.api.CommandStatus;
import com.siams.stare.api.StareApi;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class ChainDashboard
extends Stage
implements UIPreference,
Deletable {
    private final Logger logger = Logger.getLogger(ChainDashboard.class);
    private final RpcApi rpcApi;
    private DashboardTree data = null;
    private File pokeProject = null;
    private ChainDashboardContent root;
    private FxRunIndicator runIndicator = null;
    private ViewModeManager viewModeManager;
    private PublishSubject<Object> autorunSubject = PublishSubject.create();
    private Disposable rxDisposer = null;
    private final AtomicReference<Long> executeRequestTimestamp = new AtomicReference();
    private File workingDirectory = null;
    private Consumer<String> pokeProjectSaveCallback = null;

    public ChainDashboard(StareApi stareApi) {
        RpcApi.instance = new RpcApi(stareApi);
        this.rpcApi = RpcApi.getInstance();
        this.initialize();
    }

    private void initialize() {
        this.initializeStage();
        this.initializeRoot();
        this.initializeViewModes();
        this.initializeRunIndicator();
        this.initializeThrottling();
        this.restorePreference();
    }

    private void initializeStage() {
        this.setTitle("Chain dashboard");
        this.setOnCloseRequest(event -> this.release());
    }

    private void initializeRoot() {
        this.root = new ChainDashboardContent();
        this.root.executeChainHandler = this::executeChain;
        Scene scene = new Scene((Parent)this.root);
        scene.getStylesheets().add((Object)"tooltip.css");
        scene.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            boolean isConsumed = true;
            if (e.getCode() == KeyCode.F5) {
                if (!e.isControlDown() && !e.isShiftDown()) {
                    this.executeChain();
                }
            } else {
                isConsumed = false;
            }
            if (isConsumed) {
                e.consume();
            }
        });
        this.setScene(scene);
    }

    private void initializeViewModes() {
        this.viewModeManager = new ViewModeManager();
        this.root.rmiViewMode.setManaged(false);
        this.root.rmiViewMode.setVisible(false);
        this.root.rmiCompareView.setUserData((Object)ViewMode.COMPARE);
        this.root.rmiPokeView.setUserData((Object)ViewMode.POKE);
        ToggleGroup tgViewMode = new ToggleGroup();
        this.root.rmiCompareView.setToggleGroup(tgViewMode);
        this.root.rmiPokeView.setToggleGroup(tgViewMode);
        tgViewMode.selectedToggleProperty().addListener((ob, o, selected) -> {
            Object mode = selected.getUserData();
            assert (mode instanceof ViewMode);
            this.viewModeManager.show((ViewMode)((Object)((Object)mode)));
        });
    }

    private void initializeRunIndicator() {
        this.runIndicator = new FxRunIndicator();
        this.root.toolbar.getItems().add((Object)this.runIndicator);
    }

    private void initializeThrottling() {
        this.rxDisposer = this.autorunSubject.throttleWithTimeout(500L, TimeUnit.MILLISECONDS).subscribe(obj -> this.executeChain());
    }

    public void setData(DashboardTree data) {
        this.data = data;
        FxPlatform.RunFxThread(() -> {
            try {
                this.initializeTree();
                this.buildTree(data);
                if (this.pokeProject != null) {
                    this.root.rmiPokeView.setSelected(true);
                    this.viewModeManager.show(ViewMode.POKE);
                } else {
                    this.root.rmiCompareView.setSelected(true);
                    this.viewModeManager.show(ViewMode.COMPARE);
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)"Failed display dashboard", t);
                StareNotification.showWarn((String)"Failed display dashboard");
            }
        });
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setPokeProject(File pokeProject) {
        this.pokeProject = pokeProject;
    }

    public void setPokeProjectSaveCallback(Consumer<String> pokeProjectSaveCallback) {
        this.pokeProjectSaveCallback = pokeProjectSaveCallback;
    }

    public void savePreference() {
        this.putPreferredDouble("ChainDashboard.width", this.root.getWidth());
        this.putPreferredDouble("ChainDashboard.height", this.root.getHeight());
        this.putPreferredDouble("ChainDashboard.splitter.dividerPosition0", this.root.splitter.getDividerPositions()[0]);
        this.putPreferredDouble("ChainDashboard.splitter.dividerPosition1", this.root.splitter.getDividerPositions()[1]);
    }

    public void restorePreference() {
        double w = this.getPreferredDouble("ChainDashboard.width", 1400.0);
        this.root.setPrefWidth(w);
        double h = this.getPreferredDouble("ChainDashboard.height", 600.0);
        this.root.setPrefHeight(h);
        double position0 = this.getPreferredDouble("ChainDashboard.splitter.dividerPosition0", 0.25);
        this.root.splitter.setDividerPosition(0, position0);
        double position1 = this.getPreferredDouble("ChainDashboard.splitter.dividerPosition1", 0.5);
        this.root.splitter.setDividerPosition(1, position1);
    }

    public void release() {
        this.savePreference();
        if (this.pokeProjectSaveCallback != null) {
            this.pokeProjectSaveCallback.accept(this.pokeProject == null ? "" : this.pokeProject.getAbsolutePath());
            this.pokeProjectSaveCallback = null;
        }
        this.rxDisposer.dispose();
        this.autorunSubject = null;
        this.viewModeManager.clean();
        this.viewModeManager = null;
        this.runIndicator = null;
        this.root = null;
    }

    private void initializeTree() {
        TreeItem treeRoot = new TreeItem((Object)new TreeNodeWrapper("root"));
        this.root.tvTree.setRoot(treeRoot);
        this.root.tvTree.setShowRoot(false);
        this.root.tvTree.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.root.tvTree.getSelectionModel().selectedItemProperty().addListener((ob, o, selected) -> {
            TreeNodeWrapper treeNode = (TreeNodeWrapper)selected.getValue();
            if (treeNode.node != null) {
                this.displayControls(treeNode.node);
            }
        });
    }

    private void buildTreeNode(TreeItem<TreeNodeWrapper> parent, DashboardNode node) {
        TreeItem currentItem = new TreeItem((Object)new TreeNodeWrapper(node));
        currentItem.setExpanded(true);
        for (DashboardNode child : node.child) {
            this.buildTreeNode((TreeItem<TreeNodeWrapper>)currentItem, child);
        }
        parent.getChildren().add((Object)currentItem);
    }

    private void buildTree(DashboardTree data) {
        TreeItem treeRoot = this.root.tvTree.getRoot();
        TreeItem itemInput = new TreeItem((Object)new TreeNodeWrapper("Inputs"));
        itemInput.setExpanded(true);
        data.input.forEach(node -> this.buildTreeNode((TreeItem<TreeNodeWrapper>)itemInput, (DashboardNode)node));
        TreeItem itemOutput = new TreeItem((Object)new TreeNodeWrapper("Outputs"));
        itemOutput.setExpanded(true);
        data.output.forEach(node -> {
            if (!node.controls.isEmpty()) {
                this.buildTreeNode((TreeItem<TreeNodeWrapper>)itemOutput, (DashboardNode)node);
            }
        });
        TreeItem itemParameters = new TreeItem((Object)new TreeNodeWrapper("Simple parameters"));
        itemParameters.setExpanded(true);
        data.data.forEach(node -> this.buildTreeNode((TreeItem<TreeNodeWrapper>)itemParameters, (DashboardNode)node));
        TreeItem itemSetting = new TreeItem((Object)new TreeNodeWrapper("Settings"));
        itemSetting.setExpanded(true);
        if (data.setting != null) {
            this.buildTreeNode((TreeItem<TreeNodeWrapper>)itemSetting, data.setting);
        }
        if (data.input.size() > 0) {
            treeRoot.getChildren().add((Object)itemInput);
        }
        if (data.output.size() > 0) {
            treeRoot.getChildren().add((Object)itemOutput);
        }
        if (data.data.size() > 0) {
            treeRoot.getChildren().add((Object)itemParameters);
        }
        if (data.setting != null) {
            treeRoot.getChildren().add((Object)itemSetting);
        }
    }

    private void updateControlValue(UIControlContainer controlContainer, String propertyUrl) {
        controlContainer.setWorkingDir(this.workingDirectory);
        String name = controlContainer.getStructureControl().getName();
        ((CompletableFuture)this.rpcApi.rqGetAnyIfExist(String.format("%s/property:%s", propertyUrl, name)).thenAccept(any -> any.getData().ifPresent(value -> controlContainer.setProperty(new SimplePrimitive(name, value))))).whenComplete((ignore, t) -> FxPlatform.RunFxThread(() -> controlContainer.setUIControlEventHandler((structureControl, newValue) -> this.rpcApi.rqSetData(String.format("%s/property:%s", propertyUrl, name), newValue).thenAccept(v -> {
            if (this.root.cbAutorun.isSelected()) {
                this.autorunSubject.onNext(newValue);
            }
        }))));
    }

    private void displayControls(DashboardNode node) {
        this.setHeaderText(node.name, node.description);
        Node[] controls = (Node[])node.controls.stream().map(dashboardControl -> {
            if (dashboardControl instanceof PropertyControl) {
                PropertyControl propertyControl = (PropertyControl)dashboardControl;
                UIControlContainer controlContainer = propertyControl.getControlContainer();
                this.updateControlValue(controlContainer, node.url);
                return propertyControl.getView();
            }
            if (dashboardControl instanceof ChildControl) {
                ChildControl childControl = (ChildControl)dashboardControl;
                return childControl.getView();
            }
            return new Label("No data");
        }).toArray(Node[]::new);
        VBox vBoxControls = new VBox(5.0, controls);
        this.root.apControlsContainer.getChildren().clear();
        this.root.apControlsContainer.getChildren().add((Object)vBoxControls);
        PaneHelper.setAnchorZero((Node)vBoxControls);
    }

    private void setHeaderText(String text, String description) {
        this.root.lbSystemName.setText(text);
        this.root.lbDescription.setText(description);
    }

    private void executeChain() {
        String dashboardExecutingStatus = "Dashboard executing";
        long timestamp = System.currentTimeMillis();
        this.executeRequestTimestamp.set(timestamp);
        this.runIndicator.startRunningProcess("Dashboard executing");
        ((CompletableFuture)((CompletableFuture)this.rpcApi.rqEvaluateProject().thenCompose(status -> this.rpcApi.rqFirstError().thenApply(optError -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("status", status);
            map.put("error", optError);
            return map;
        }))).thenAccept(map -> {
            CommandStatus status = (CommandStatus)map.get("status");
            Optional optError = (Optional)map.get("error");
            if (status == CommandStatus.OK) {
                if (this.checkUnprocessedExecuteRequests(timestamp)) {
                    this.executeChain();
                } else {
                    this.runIndicator.finishRunningProcess("Dashboard executing");
                    if (optError.isEmpty()) {
                        this.viewModeManager.hideMessage();
                        this.viewModeManager.viewer.onChainExecuted();
                    } else {
                        String error = (String)optError.get();
                        this.viewModeManager.showMessage(error);
                    }
                }
            }
        })).exceptionally(t -> {
            this.logger.error((Object)t.getMessage());
            StareNotification.showWarn((String)"ChainDashboard fail to execute chain");
            this.runIndicator.finishRunningProcess("Dashboard executing");
            return null;
        });
    }

    private boolean checkUnprocessedExecuteRequests(long timestamp) {
        return this.executeRequestTimestamp.get() > timestamp;
    }

    private static class ChainDashboardContent
    extends AnchorPane {
        private final Logger logger = Logger.getLogger(ChainDashboardContent.class);
        @FXML
        private SplitPane splitter;
        @FXML
        private ToolBar toolbar;
        @FXML
        private CheckBox cbAutorun;
        @FXML
        private MenuButton rmiViewMode;
        @FXML
        private RadioMenuItem rmiCompareView;
        @FXML
        private RadioMenuItem rmiPokeView;
        @FXML
        private AnchorPane apTreeContainer;
        @FXML
        private TreeView<TreeNodeWrapper> tvTree;
        @FXML
        private AnchorPane apPropertiesContainer;
        @FXML
        private VBox vbControls;
        @FXML
        private Label lbSystemName;
        @FXML
        private Label lbDescription;
        @FXML
        private AnchorPane apControlsContainer;
        @FXML
        private AnchorPane apViewerPlace;
        private Runnable executeChainHandler = null;

        @FXML
        public void onBtnRunPressed(ActionEvent event) {
            if (this.executeChainHandler != null) {
                this.executeChainHandler.run();
            }
        }

        private ChainDashboardContent() {
            try {
                CustomFXMLLoader.loadElement((Object)((Object)this));
            }
            catch (IOException e) {
                this.logger.error((Object)"Failed to load ChainDashboard fxml", (Throwable)e);
                StareNotification.showWarn((String)"Fail to load ChainDashboardContent");
            }
        }
    }

    private final class ViewModeManager {
        private ViewMode currentState = ViewMode.COMPARE;
        private IDashboardViewer viewer = null;
        private final DashboardStatusTooltip statusMessage = new DashboardStatusTooltip();

        private ViewModeManager() {
        }

        public void show(ViewMode mode) {
            this.clean();
            this.currentState = mode;
            switch (mode.ordinal()) {
                case 0: {
                    this.showCompare();
                    break;
                }
                case 1: {
                    this.showPoke();
                    break;
                }
                case 2: {
                    this.showText();
                }
            }
        }

        private void showCompare() {
            CompareViewerModel compareViewerModel = new CompareViewerModel();
            compareViewerModel.setUuid(UUID.randomUUID());
            DashboardCompareViewer compareViewer = new DashboardCompareViewer(compareViewerModel);
            compareViewer.initialize();
            compareViewer.embed((Pane)ChainDashboard.this.root.apViewerPlace);
            this.viewer = compareViewer;
            Stream<ViewerModel> inputs = ChainDashboard.this.data.input.stream().map(this::createViewerModel);
            Stream<ViewerModel> outputs = ChainDashboard.this.data.output.stream().map(this::createViewerModel);
            List viewerModels = Stream.concat(inputs, outputs).collect(Collectors.toList());
            compareViewerModel.setViewerModels(viewerModels);
            if (viewerModels.isEmpty()) {
                this.showMessage("No visual data\nAdd visual IO blocks to view the result");
            }
        }

        private void showPoke() {
            throw new UnsupportedOperationException("Integration with Poke-and-Look is not supported");
        }

        private void showText() {
            PlainTextViewerModel textViewerModel = new PlainTextViewerModel();
            textViewerModel.setUuid(UUID.randomUUID());
            PlainTextViewer textViewer = (PlainTextViewer)ViewerFactory.create((ViewerKind)ViewerKind.PLAIN_TEXT, (ViewerModel)textViewerModel);
            textViewer.initialize();
            textViewer.embed((Pane)ChainDashboard.this.root.apViewerPlace);
            List viewerModels = Collections.emptyList();
            if (viewerModels.isEmpty()) {
                this.showMessage("No visual data\nAdd visual IO blocks to view the result");
            }
        }

        private void showMessage(String text) {
            FxPlatform.RunFxThread(() -> {
                this.statusMessage.setText(text);
                if (!ChainDashboard.this.root.getChildren().contains((Object)this.statusMessage)) {
                    ChainDashboard.this.root.apViewerPlace.getChildren().add((Object)this.statusMessage);
                    PaneHelper.setAnchorZero((Node)this.statusMessage);
                    this.statusMessage.toFront();
                }
            });
        }

        private void hideMessage() {
            FxPlatform.RunFxThread(() -> ChainDashboard.this.root.apViewerPlace.getChildren().remove((Object)this.statusMessage));
        }

        private void clean() {
            if (this.viewer != null) {
                this.viewer.clean();
                this.viewer = null;
            }
            ChainDashboard.this.root.apViewerPlace.getChildren().clear();
            if (this.currentState == ViewMode.POKE) {
                ChainDashboard.this.root.toolbar.getItems().removeIf(item -> item instanceof Separator || "pokeMenuButton".equals(item.getId()) || "pokeReloadButton".equals(item.getId()));
            }
        }

        @Nonnull
        private ViewerModel createViewerModel(DashboardNode dashboardNode) {
            ImageViewerModel viewerModel = new ImageViewerModel();
            viewerModel.setBlockUuid(UUID.fromString(dashboardNode.id));
            viewerModel.setTitle(dashboardNode.name);
            return viewerModel;
        }
    }

    static enum ViewMode {
        COMPARE,
        POKE,
        TEXT;

    }

    private static class TreeNodeWrapper {
        private final String nodeName;
        public final DashboardNode node;

        private TreeNodeWrapper(String nodeName) {
            this.nodeName = nodeName;
            this.node = null;
        }

        private TreeNodeWrapper(DashboardNode node) {
            this.nodeName = "undefined";
            this.node = node;
        }

        public String toString() {
            return this.node != null ? this.node.name : this.nodeName;
        }
    }
}

