/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.dashboard.viewer;

import com.siams.cv.monitor.dashboard.RpcApi;
import com.siams.cv.monitor.viewers.ui.content.ViewerData;
import com.siams.cv.monitor.viewers.ui.content.ViewerDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class DashboardDataSource
implements ViewerDataSource {
    private final List<ViewerDataSource.ChangeViewerDataListener> viewerDataListeners = new ArrayList<ViewerDataSource.ChangeViewerDataListener>();
    private final UUID blockId;
    private ViewerData viewerData = null;

    public DashboardDataSource(UUID blockId) {
        this.blockId = blockId;
    }

    public CompletableFuture<Void> rqViewerData() {
        return ((CompletableFuture)RpcApi.getInstance().rqViewerData(this.blockId).thenAccept(this::notifyListenersViewerDataReceived)).exceptionally(t -> {
            this.notifyListenersErrorReceived((Throwable)t);
            return null;
        });
    }

    public void addListener(ViewerDataSource.ChangeViewerDataListener listener) {
        this.viewerDataListeners.add(listener);
    }

    public void removeDataListener(ViewerDataSource.ChangeViewerDataListener listener) {
        this.viewerDataListeners.remove(listener);
    }

    public void setData(ViewerData viewerData) {
        this.viewerData = viewerData;
    }

    public Optional<ViewerData> getData() {
        return Optional.ofNullable(this.viewerData);
    }

    public void release() {
        this.viewerDataListeners.clear();
        if (this.viewerData != null) {
            this.viewerData.release();
        }
    }

    private void notifyListenersViewerDataReceived(ViewerData viewerData) {
        this.viewerData = viewerData;
        this.viewerDataListeners.forEach(listener -> listener.onViewerDataReceived(viewerData));
    }

    private void notifyListenersErrorReceived(Throwable t) {
        this.viewerDataListeners.forEach(listener -> listener.onViewerDataErrorReceived(t));
    }
}

