/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames;

import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.executors.modules.maps.frames.buffers.MapBufferKey;

public final class RemoveMapBuffer
extends ScalarFilter {
    private boolean doAction = true;

    public RemoveMapBuffer() {
        this.setDefaultInputScalar("map_buffer_id");
        this.setDefaultOutputScalar("map_buffer_id");
    }

    public boolean isDoAction() {
        return this.doAction;
    }

    public RemoveMapBuffer setDoAction(boolean doAction) {
        this.doAction = doAction;
        return this;
    }

    public SScalar process(SScalar source) {
        if (this.doAction) {
            this.remove(source.toLong(), true);
            return source;
        }
        return SScalar.of(null);
    }

    public void remove(long mapBufferId, boolean requireExisting) {
        MapBufferKey key = MapBufferKey.getInstance(mapBufferId);
        if (!key.removeMapBuffer() && requireExisting) {
            throw new IllegalStateException("No already created map buffer for " + String.valueOf(key));
        }
    }
}

