/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.buffers;

import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.algart.executors.modules.maps.frames.buffers.MapBuffer;

public final class MapBufferKey {
    private static final AtomicLong CURRENT_KEY = new AtomicLong(109000000L);
    private static final WeakHashMap<MapBufferKey, MapBuffer> mapBuffers = new WeakHashMap();
    private final long mapBufferId;

    private MapBufferKey(long mapBufferId) {
        this.mapBufferId = mapBufferId;
    }

    public static MapBufferKey getInstance(long mapBufferId) {
        return new MapBufferKey(mapBufferId);
    }

    public static MapBufferKey getUniqueInstance() {
        return new MapBufferKey(CURRENT_KEY.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int numberOfStoredMapBuffers() {
        WeakHashMap<MapBufferKey, MapBuffer> weakHashMap = mapBuffers;
        synchronized (weakHashMap) {
            return mapBuffers.size();
        }
    }

    public long mapBufferId() {
        return this.mapBufferId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapBuffer getOrCreateMapBuffer() {
        WeakHashMap<MapBufferKey, MapBuffer> weakHashMap = mapBuffers;
        synchronized (weakHashMap) {
            return mapBuffers.computeIfAbsent(this, k -> MapBuffer.newInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapBuffer getMapBuffer() {
        WeakHashMap<MapBufferKey, MapBuffer> weakHashMap = mapBuffers;
        synchronized (weakHashMap) {
            return mapBuffers.get(this);
        }
    }

    public MapBuffer reqMapBuffer() {
        MapBuffer result = this.getMapBuffer();
        if (result == null) {
            throw new IllegalStateException("No already created map buffer for " + String.valueOf(this));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMapBuffer() {
        WeakHashMap<MapBufferKey, MapBuffer> weakHashMap = mapBuffers;
        synchronized (weakHashMap) {
            return mapBuffers.remove(this) != null;
        }
    }

    public String toString() {
        return "map buffer key @@" + this.mapBufferId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBufferKey that = (MapBufferKey)o;
        return this.mapBufferId == that.mapBufferId;
    }

    public int hashCode() {
        return Objects.hash(this.mapBufferId);
    }
}

