/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.graph;

import java.util.Arrays;
import java.util.Objects;
import net.algart.executors.modules.maps.frames.graph.WeightedDirectedGraph;

public abstract class ShortestPathFinder {
    final WeightedDirectedGraph graph;
    final int n;
    final int[] previousInPath;
    final double[] distances;

    ShortestPathFinder(WeightedDirectedGraph graph) {
        this.graph = Objects.requireNonNull(graph, "Null graph");
        this.n = graph.numberOfVertices();
        this.previousInPath = new int[this.n];
        this.distances = new double[this.n];
        this.initialize();
    }

    public static ShortestPathFinder newInstance(Algorithm algorithm, WeightedDirectedGraph graph) {
        return algorithm.build(graph);
    }

    public WeightedDirectedGraph graph() {
        return this.graph;
    }

    public int numberOfVertices() {
        return this.n;
    }

    public abstract void findShortestPaths(int var1);

    public boolean pathExists(int targetVertex) {
        return this.previousInPath[targetVertex] >= 0;
    }

    public int getPreviousInPath(int vertex) {
        this.checkPathExists(vertex);
        return this.previousInPath[vertex];
    }

    public double getDistance(int vertex) {
        this.checkPathExists(vertex);
        assert (this.distances[vertex] != Double.POSITIVE_INFINITY);
        return this.distances[vertex];
    }

    public int getPath(int[] result, int targetVertex) {
        int previous;
        Objects.requireNonNull(result, "Null result");
        this.checkPathExists(targetVertex);
        int length = 1;
        int vertex = targetVertex;
        while ((previous = this.previousInPath[vertex]) != vertex) {
            vertex = previous;
            if (++length <= this.n) continue;
            throw new IllegalStateException("Object damaged (probably due multithreading calls)");
        }
        vertex = targetVertex;
        for (int k = length - 1; k >= 0; --k) {
            result[k] = vertex;
            vertex = this.previousInPath[vertex];
        }
        return length;
    }

    void initialize() {
        Arrays.fill(this.previousInPath, 0, this.n, -1);
        Arrays.fill(this.distances, 0, this.n, Double.POSITIVE_INFINITY);
    }

    private void checkPathExists(int vertex) {
        if (this.previousInPath[vertex] < 0) {
            throw new IllegalStateException("Path to the given vertex #" + vertex + " does not exist or not calculated yet");
        }
    }

    public static enum Algorithm {
        SIMPLE_DIJKSTRA{

            @Override
            ShortestPathFinder build(WeightedDirectedGraph graph) {
                return new SimpleDijkstra(graph);
            }
        }
        ,
        FOR_SORTED_ACYCLIC{

            @Override
            ShortestPathFinder build(WeightedDirectedGraph graph) {
                return new ForSortedAcyclic(graph);
            }
        };


        abstract ShortestPathFinder build(WeightedDirectedGraph var1);
    }

    static class ForSortedAcyclic
    extends ShortestPathFinder {
        ForSortedAcyclic(WeightedDirectedGraph graph) {
            super(graph);
            for (int v1 = 0; v1 < this.n; ++v1) {
                int m = graph.numberOfOutgoingEdges(v1);
                for (int i = 0; i < m; ++i) {
                    int v2 = graph.neighbourVertex(v1, i);
                    if (v2 > v1) continue;
                    throw new IllegalArgumentException("It  is not an acyclic topologically-sorted graph:vertex " + v1 + " has an outgoing edge to " + v2 + " <= " + v1);
                }
            }
        }

        @Override
        public void findShortestPaths(int startVertex) {
            this.graph.checkVertexIndex(startVertex);
            this.initialize();
            this.previousInPath[startVertex] = startVertex;
            this.distances[startVertex] = 0.0;
            for (int v1 = startVertex; v1 < this.n; ++v1) {
                double distance = this.distances[v1];
                int m = this.graph.numberOfOutgoingEdges(v1);
                for (int i = 0; i < m; ++i) {
                    int v2 = this.graph.neighbourVertex(v1, i);
                    double newDistance = distance + this.graph.edgeWeight(v1, i);
                    if (!(newDistance < this.distances[v2])) continue;
                    this.distances[v2] = newDistance;
                    this.previousInPath[v2] = v1;
                }
            }
        }
    }

    static class SimpleDijkstra
    extends ShortestPathFinder {
        private final boolean[] ready;

        SimpleDijkstra(WeightedDirectedGraph graph) {
            super(graph);
            this.ready = new boolean[this.n];
        }

        @Override
        public void findShortestPaths(int startVertex) {
            this.graph.checkVertexIndex(startVertex);
            this.initialize();
            Arrays.fill(this.ready, false);
            this.previousInPath[startVertex] = startVertex;
            this.distances[startVertex] = 0.0;
            while (true) {
                int minimalVertex = -1;
                double minimalDistance = Double.POSITIVE_INFINITY;
                for (int v = 0; v < this.n; ++v) {
                    if (this.ready[v] || !(this.distances[v] < minimalDistance)) continue;
                    minimalVertex = v;
                    minimalDistance = this.distances[v];
                }
                if (minimalVertex == -1) break;
                assert (minimalDistance != Double.POSITIVE_INFINITY);
                int m = this.graph.numberOfOutgoingEdges(minimalVertex);
                for (int i = 0; i < m; ++i) {
                    int v = this.graph.neighbourVertex(minimalVertex, i);
                    double newDistance = minimalDistance + this.graph.edgeWeight(minimalVertex, i);
                    if (!(newDistance < this.distances[v])) continue;
                    assert (!this.ready[v]) : "Internal error: ready vertex #" + v + " cannot be relaxed!";
                    this.distances[v] = newDistance;
                    this.previousInPath[v] = minimalVertex;
                }
                this.ready[minimalVertex] = true;
            }
        }
    }
}

