/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.joints;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.algart.arrays.JArrays;
import net.algart.arrays.TooLargeArrayException;

public final class DynamicDisjointSet
implements Cloneable {
    private static final int MAX_NUMBER_OF_OBJECTS = 2147482647;
    private int[] parent;
    private int[] cardinalities;
    int count;

    private DynamicDisjointSet() {
        this.clear();
    }

    public static DynamicDisjointSet newInstance() {
        return new DynamicDisjointSet();
    }

    public int count() {
        return this.count;
    }

    public void expand(int objectIndex) {
        if (objectIndex < 0) {
            throw new IllegalArgumentException("Negative object index: " + objectIndex);
        }
        if (objectIndex >= this.count) {
            long newNumberOfObjects = (long)objectIndex + 1L;
            this.ensureCapacity(newNumberOfObjects);
            this.count = objectIndex + 1;
        }
    }

    public void clear() {
        this.count = 0;
        this.parent = JArrays.EMPTY_INTS;
        this.cardinalities = JArrays.EMPTY_INTS;
    }

    public int[] parent() {
        return Arrays.copyOf(this.parent, this.count);
    }

    public int parentOrThis(int objectIndex) {
        return objectIndex >= this.count ? objectIndex : this.parent[objectIndex];
    }

    public int findBase(int objectIndex) {
        int newBase;
        int base = objectIndex;
        while ((newBase = this.parent[base]) != base) {
            base = newBase;
        }
        this.parent[objectIndex] = base;
        return base;
    }

    public int jointBases(int base1, int base2) {
        if (base1 == base2) {
            return base1;
        }
        int cardinality1 = this.cardinalities[base1];
        int cardinality2 = this.cardinalities[base2];
        if (cardinality1 < cardinality2) {
            int temp = base1;
            base1 = base2;
            base2 = temp;
            cardinality2 = cardinality1;
        }
        this.parent[base2] = base1;
        int n = base1;
        this.cardinalities[n] = this.cardinalities[n] + cardinality2;
        return base1;
    }

    public void jointObjects(int object1, int object2) {
        this.expand(object1);
        this.expand(object2);
        int o1 = this.findBase(object1);
        int o2 = this.findBase(object2);
        this.jointBases(o1, o2);
    }

    public void resolveAllBases() {
        IntStream.range(0, this.count + 255 >>> 8).parallel().forEach(block -> {
            int i;
            int to = (int)Math.min((long)i + 256L, (long)this.count);
            for (i = block << 8; i < to; ++i) {
                this.findBase(i);
            }
        });
    }

    private void ensureCapacity(long newNumberOfObjects) {
        if (newNumberOfObjects > 2147482647L) {
            throw new TooLargeArrayException("Too large array required");
        }
        assert (newNumberOfObjects == (long)((int)newNumberOfObjects));
        int oldNumberOfObjects = this.parent.length;
        if (newNumberOfObjects > (long)oldNumberOfObjects) {
            int newLength = Math.max(16, Math.max((int)newNumberOfObjects, (int)Math.min(2147482647L, (long)(2.0 * (double)oldNumberOfObjects))));
            this.parent = Arrays.copyOf(this.parent, newLength);
            this.cardinalities = Arrays.copyOf(this.cardinalities, newLength);
            for (int k = oldNumberOfObjects; k < this.parent.length; ++k) {
                this.parent[k] = k;
                this.cardinalities[k] = 1;
            }
        }
    }
}

