/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.frames.joints;

import java.util.Arrays;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.executors.modules.maps.frames.joints.DynamicDisjointSet;

public final class QuickLabelsSet {
    private int min;
    private int max;
    private boolean[] bits = JArrays.EMPTY_BOOLEANS;

    private QuickLabelsSet() {
        this.clear();
    }

    public static QuickLabelsSet newEmptyInstance() {
        return new QuickLabelsSet();
    }

    public static QuickLabelsSet newInstance(int min, int max) {
        return QuickLabelsSet.newEmptyInstance().setLabelsRange(min, max);
    }

    public int min() {
        this.checkEmpty();
        return this.min;
    }

    public int max() {
        this.checkEmpty();
        return this.max;
    }

    public boolean isEmpty() {
        return this.max == Integer.MIN_VALUE;
    }

    public QuickLabelsSet setLabelsRange(int min, int max) {
        if (min < 0) {
            throw new IllegalArgumentException("Negative min = " + min);
        }
        if (min > max) {
            throw new IllegalArgumentException("min > max: min = " + min + ", max = " + max);
        }
        this.min = min;
        this.max = max;
        this.prepareToUse();
        return this;
    }

    public void clear() {
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
    }

    public void expand(int label) {
        if (label < 0) {
            throw new IllegalArgumentException("Negative label = " + label);
        }
        if (label < this.min) {
            this.min = label;
        }
        if (label > this.max) {
            this.max = label;
        }
    }

    public void prepareToUse() {
        if (this.isEmpty()) {
            this.max = 0;
            this.min = 0;
        }
        this.ensureCapacityAndClear(this.max - this.min + 1);
        Arrays.fill(this.bits, 0, this.max - this.min + 1, false);
    }

    public void clearAndFreeResources() {
        this.clear();
        this.bits = JArrays.EMPTY_BOOLEANS;
    }

    public boolean get(int objectLabel) {
        return objectLabel >= this.min && objectLabel <= this.max && this.bits[objectLabel - this.min];
    }

    public void set(int objectLabel, boolean value) {
        if (objectLabel < this.min || objectLabel > this.max) {
            this.checkEmpty();
            throw new IndexOutOfBoundsException("Object's label " + objectLabel + " is out of range " + this.min + ".." + this.max);
        }
        this.bits[objectLabel - this.min] = value;
    }

    public void set(int objectLabel) {
        if (objectLabel < this.min || objectLabel > this.max) {
            this.checkEmpty();
            throw new IndexOutOfBoundsException("Object's label " + objectLabel + " is out of range " + this.min + ".." + this.max);
        }
        this.bits[objectLabel - this.min] = true;
    }

    public QuickLabelsSet reindex(DynamicDisjointSet disjointSet) {
        Objects.requireNonNull(disjointSet, "Null disjoint set");
        this.checkEmpty();
        int newMin = Integer.MAX_VALUE;
        int newMax = Integer.MIN_VALUE;
        int n = this.max - this.min + 1;
        for (int k = 0; k < n; ++k) {
            if (!this.bits[k]) continue;
            int base = disjointSet.findBase(this.min + k);
            if (base < newMin) {
                newMin = base;
            }
            if (base <= newMax) continue;
            newMax = base;
        }
        if (newMax == Integer.MIN_VALUE) {
            newMax = 1;
            newMin = 1;
        }
        QuickLabelsSet result = QuickLabelsSet.newInstance(newMin, newMax);
        for (int k = 0; k < n; ++k) {
            if (!this.bits[k]) continue;
            int base = disjointSet.findBase(this.min + k);
            result.set(base);
        }
        return result;
    }

    public String toString() {
        return "quick labels set in range " + this.min + ".." + this.max;
    }

    private void checkEmpty() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(this) + " is not initialized");
        }
    }

    private void ensureCapacityAndClear(int newNumberOfObjects) {
        int oldNumberOfObjects = this.bits.length;
        if (newNumberOfObjects > oldNumberOfObjects) {
            int newLength = Math.max(16, Math.max(newNumberOfObjects, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)oldNumberOfObjects))));
            this.bits = new boolean[newLength];
        }
    }
}

