/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.algart.contours.Contours;
import net.algart.executors.modules.maps.pyramids.io.GridEqualizer;
import net.algart.executors.modules.maps.pyramids.io.ImagePyramidMetadataJson;
import net.algart.executors.modules.maps.pyramids.io.ScanningMapSequence;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.math.IRectangularArea;

public final class ImagePyramidLevelRois {
    private final int numberOfResolutions;
    private final long levelDimX;
    private final long levelDimY;
    private final double scaleX;
    private final double scaleY;
    private final IRectangularArea wholeLevel;
    private IRectangularArea inputRoi;
    private IRectangularArea inputRoiOrWholeLevel;
    private ImagePyramidMetadataJson metadataJson = null;
    private boolean useMetadataRectangles = true;
    private boolean requireNonIntersectingRectangles = false;
    private int minimalROISize = 0;
    private volatile List<IRectangularArea> roiRectanglesCache = null;
    private volatile List<Contours> roiContoursCache = null;

    public ImagePyramidLevelRois(PlanePyramidSource planePyramidSource, int resolutionLevel) {
        this.numberOfResolutions = planePyramidSource.numberOfResolutions();
        this.levelDimX = planePyramidSource.width(resolutionLevel);
        this.levelDimY = planePyramidSource.height(resolutionLevel);
        if (this.levelDimX <= 0L || this.levelDimY <= 0L) {
            throw new IllegalArgumentException("Unsupported pyramid: zero or negative sizes of level #" + resolutionLevel + " " + this.levelDimX + "x" + this.levelDimY);
        }
        if (resolutionLevel == 0) {
            this.scaleY = 1.0;
            this.scaleX = 1.0;
        } else {
            this.scaleX = (double)this.levelDimX / (double)planePyramidSource.width(0);
            this.scaleY = (double)this.levelDimY / (double)planePyramidSource.height(0);
        }
        this.wholeLevel = IRectangularArea.valueOf((long)0L, (long)0L, (long)(this.levelDimX - 1L), (long)(this.levelDimY - 1L));
        this.setInputRoi(null);
    }

    public IRectangularArea getInputRoi() {
        return this.inputRoi;
    }

    public ImagePyramidLevelRois setInputRoi(IRectangularArea inputRoiOrNull) {
        IRectangularArea inputRoiOrWholeLevel;
        if (inputRoiOrNull == null) {
            inputRoiOrWholeLevel = this.wholeLevel;
        } else {
            inputRoiOrWholeLevel = inputRoiOrNull.intersection(this.wholeLevel);
            if (inputRoiOrWholeLevel == null) {
                throw new IllegalArgumentException("Input ROI " + String.valueOf(inputRoiOrNull) + " lies outside pyramid level " + this.levelDimX + "x" + this.levelDimY);
            }
        }
        this.inputRoi = inputRoiOrNull;
        this.inputRoiOrWholeLevel = inputRoiOrWholeLevel;
        this.clearCache();
        return this;
    }

    public ImagePyramidMetadataJson getMetadataJson() {
        return this.metadataJson;
    }

    public ImagePyramidLevelRois setMetadataJson(ImagePyramidMetadataJson metadataJson) {
        this.metadataJson = metadataJson;
        this.clearCache();
        return this;
    }

    public boolean isUseMetadataRectangles() {
        return this.useMetadataRectangles;
    }

    public ImagePyramidLevelRois setUseMetadataRectangles(boolean useMetadataRectangles) {
        this.useMetadataRectangles = useMetadataRectangles;
        this.clearCache();
        return this;
    }

    public boolean isRequireNonIntersectingRectangles() {
        return this.requireNonIntersectingRectangles;
    }

    public ImagePyramidLevelRois setRequireNonIntersectingRectangles(boolean requireNonIntersectingRectangles) {
        this.requireNonIntersectingRectangles = requireNonIntersectingRectangles;
        this.clearCache();
        return this;
    }

    public int getMinimalROISize() {
        return this.minimalROISize;
    }

    public ImagePyramidLevelRois setMinimalROISize(int minimalROISize) {
        if (minimalROISize < 0) {
            throw new IllegalArgumentException("Negative minimalROISize");
        }
        this.minimalROISize = minimalROISize;
        this.clearCache();
        return this;
    }

    public int numberOfResolutions() {
        return this.numberOfResolutions;
    }

    public long levelDimX() {
        return this.levelDimX;
    }

    public long levelDimY() {
        return this.levelDimY;
    }

    public IRectangularArea wholeLevel() {
        return this.wholeLevel;
    }

    public IRectangularArea inputRoiOrWholeLevel() {
        return this.inputRoiOrWholeLevel;
    }

    public long inputMinX() {
        return this.inputRoiOrWholeLevel.minX();
    }

    public long inputMinY() {
        return this.inputRoiOrWholeLevel.minY();
    }

    public long inputMaxX() {
        return this.inputRoiOrWholeLevel.maxX();
    }

    public long inputMaxY() {
        return this.inputRoiOrWholeLevel.maxY();
    }

    public long inputDimX() {
        return this.inputRoiOrWholeLevel.sizeX();
    }

    public long inputDimY() {
        return this.inputRoiOrWholeLevel.sizeY();
    }

    public ImagePyramidMetadataJson metadataJson() {
        return this.metadataJson;
    }

    public List<IRectangularArea> roiRectangles() {
        List<Object> roiRectangles = this.roiRectanglesCache;
        if (roiRectangles == null) {
            List<IRectangularArea> list = roiRectangles = this.metadataJson != null && this.useMetadataRectangles ? Collections.unmodifiableList(this.metadataJson.roiRectangles(this.scaleX, this.scaleY, this.inputRoiOrWholeLevel)) : List.of(this.inputRoiOrWholeLevel);
            if (this.requireNonIntersectingRectangles) {
                this.checkIntersectionOfRectangles(roiRectangles);
            }
            if (this.minimalROISize > 1) {
                roiRectangles = roiRectangles.stream().filter(this::isROILargeEnough).collect(Collectors.toList());
            }
            this.roiRectanglesCache = roiRectangles;
        }
        return roiRectangles;
    }

    public double[] allRoiCentersAndSizes() {
        return ImagePyramidMetadataJson.allRoiCentersAndSizes(this.roiRectangles());
    }

    public Contours allRoiContours() {
        Contours allRoiContours = Contours.newInstance();
        Optional<List<Contours>> contours = this.roiContours();
        if (contours.isEmpty()) {
            return allRoiContours;
        }
        contours.get().forEach(arg_0 -> ((Contours)allRoiContours).addContours(arg_0));
        return allRoiContours;
    }

    public Optional<List<Contours>> roiContours() {
        List<Contours> roiContours = this.roiContoursCache;
        if (roiContours == null) {
            this.roiContoursCache = roiContours = this.metadataJson != null ? Collections.unmodifiableList(this.metadataJson.roiContours(this.scaleX, this.scaleY)) : null;
        }
        return Optional.ofNullable(roiContours);
    }

    public Contours roiContours(int roiIndex) {
        Optional<List<Contours>> contours = this.roiContours();
        if (contours.isEmpty()) {
            return Contours.newInstance();
        }
        List<Contours> contoursList = contours.get();
        if (roiIndex < 0 || roiIndex >= contoursList.size()) {
            throw new IndexOutOfBoundsException("No ROI with index " + roiIndex + " (must be in range 0.." + contoursList.size() + "-1)");
        }
        return contoursList.get(roiIndex);
    }

    public long framesPerSeries(ScanningMapSequence mapSequence, long frameSizeX, long frameSizeY, boolean singleFrameMode) {
        if (mapSequence == null || singleFrameMode) {
            return GridEqualizer.divideCeil(this.inputDimX(), frameSizeX);
        }
        return mapSequence.lowFrameCount(frameSizeX, frameSizeY, this.inputDimX(), this.inputDimY());
    }

    public long totalNumberOfFrames(long frameSizeX, long frameSizeY, boolean singleFrameMode) {
        return singleFrameMode ? 1L : this.roiRectangles().stream().mapToLong(r -> ImagePyramidLevelRois.numberOfFramesInRectangle(frameSizeX, frameSizeY, r)).sum();
    }

    private void clearCache() {
        this.roiRectanglesCache = null;
        this.roiContoursCache = null;
    }

    private String inMetaFileMessage() {
        Path file = this.metadataJson == null ? null : this.metadataJson.getMetadataJsonFile();
        return file == null ? null : " in the file " + String.valueOf(file);
    }

    private boolean isROILargeEnough(IRectangularArea r) {
        return r.sizeX() >= (long)this.minimalROISize && r.sizeY() >= (long)this.minimalROISize;
    }

    private void checkIntersectionOfRectangles(List<IRectangularArea> roiRectangles) {
        IRectangularArea[] rectangles = roiRectangles.toArray(new IRectangularArea[0]);
        for (int i = 0; i < rectangles.length; ++i) {
            IRectangularArea r = rectangles[i];
            assert (r.coordCount() == 2);
            for (int j = i + 1; j < rectangles.length; ++j) {
                if (!ImagePyramidLevelRois.quickIntersects(r, rectangles[j])) continue;
                throw new IllegalArgumentException("ROI rectangles intersects each other: rectangle #" + i + " = " + String.valueOf(r) + " intersects rectangle #" + j + " = " + String.valueOf(rectangles[j]) + this.inMetaFileMessage());
            }
        }
    }

    private static boolean quickIntersects(IRectangularArea r1, IRectangularArea r2) {
        return r2.max(0) >= r1.min(0) && r2.min(0) <= r1.max(0) && r2.max(1) >= r1.min(1) && r2.min(1) <= r1.max(1);
    }

    private static long numberOfFramesInRectangle(long frameSizeX, long frameSizeY, IRectangularArea r) {
        return GridEqualizer.divideCeil(r.sizeX(), frameSizeX) * GridEqualizer.divideCeil(r.sizeY(), frameSizeY);
    }
}

