/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.maps.pyramids.io;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.algart.arrays.Arrays;
import net.algart.arrays.TooLargeArrayException;
import net.algart.contours.ContourHeader;
import net.algart.contours.Contours;
import net.algart.json.Jsons;
import net.algart.math.IRectangularArea;

public class ImagePyramidMetadataJson {
    public static final String APP_NAME = "image-pyramid-metadata";
    public static final String CURRENT_VERSION = "1.0";
    private static final String APP_NAME_ALIAS = "plane-pyramid-metadata";
    private Path metadataJsonFile = null;
    private String version = "1.0";
    private List<Roi> rois;
    private List<IRectangularArea> roiRectangles;

    public ImagePyramidMetadataJson() {
    }

    private ImagePyramidMetadataJson(JsonObject json, Path file) {
        if (!ImagePyramidMetadataJson.isPlanePyramidMetadataJson(json)) {
            throw new JsonException("JSON" + (String)(file == null ? "" : " " + String.valueOf(file)) + " is not a plane-pyramid metadata: no \"app\":\"image-pyramid-metadata\" element");
        }
        this.metadataJsonFile = file;
        this.version = json.getString("version", CURRENT_VERSION);
        JsonArray roisJson = Jsons.getJsonArray((JsonObject)json, (String)"rois", (Path)file, (boolean)true);
        if (roisJson != null) {
            this.setRois(roisJson.stream().map(value -> Roi.of(value, file)).collect(Collectors.toList()), file);
        }
    }

    public static ImagePyramidMetadataJson read(Path planePyramidMetadataJsonFile) throws IOException {
        Objects.requireNonNull(planePyramidMetadataJsonFile, "Null planePyramidMetadataJsonFile");
        JsonObject json = Jsons.readJson((Path)planePyramidMetadataJsonFile);
        return new ImagePyramidMetadataJson(json, planePyramidMetadataJsonFile);
    }

    public void write(Path planePyramidMetadataJsonFile, OpenOption ... options) throws IOException {
        Objects.requireNonNull(planePyramidMetadataJsonFile, "Null planePyramidMetadataJsonFile");
        Files.writeString(planePyramidMetadataJsonFile, (CharSequence)Jsons.toPrettyString((JsonObject)this.toJson()), options);
    }

    public static ImagePyramidMetadataJson of(JsonObject metadataJson) {
        return new ImagePyramidMetadataJson(metadataJson, null);
    }

    public static boolean isPlanePyramidMetadataJson(JsonObject metadataJson) {
        Objects.requireNonNull(metadataJson, "Null plane-pyramid metadata JSON");
        String app = metadataJson.getString("app", null);
        return APP_NAME.equals(app) || APP_NAME_ALIAS.equals(app);
    }

    public Path getMetadataJsonFile() {
        return this.metadataJsonFile;
    }

    public String getVersion() {
        return this.version;
    }

    public ImagePyramidMetadataJson setVersion(String version) {
        this.version = Objects.requireNonNull(version, "Null version");
        return this;
    }

    public List<Roi> getRois() {
        return Collections.unmodifiableList(this.rois);
    }

    public ImagePyramidMetadataJson setRois(List<? extends Roi> rois) {
        return this.setRois(rois, null);
    }

    public List<IRectangularArea> roiRectangles() {
        return Collections.unmodifiableList(this.roiRectangles);
    }

    public List<IRectangularArea> roiRectangles(double scaleX, double scaleY, IRectangularArea restriction) {
        if (scaleX <= 0.0) {
            throw new IllegalArgumentException("Zero or negative scaleX = " + scaleX);
        }
        if (scaleY <= 0.0) {
            throw new IllegalArgumentException("Zero or negative scaleY = " + scaleY);
        }
        ArrayList<IRectangularArea> result = new ArrayList<IRectangularArea>();
        for (IRectangularArea r : this.roiRectangles) {
            assert (r.coordCount() == 2) : r.coordCount() + " dimensions in ROI";
            long sizeX = (long)Math.ceil((double)r.sizeX() * scaleX);
            long sizeY = (long)Math.ceil((double)r.sizeY() * scaleY);
            if (sizeX <= 0L || sizeY <= 0L) continue;
            long minX = Math.round((double)r.minX() * scaleX);
            long minY = Math.round((double)r.minY() * scaleY);
            r = IRectangularArea.valueOf((long)minX, (long)minY, (long)(minX + sizeX - 1L), (long)(minY + sizeY - 1L));
            if (restriction != null) {
                r = r.intersection(restriction);
            }
            if (r == null) continue;
            result.add(r);
        }
        return Collections.unmodifiableList(result);
    }

    public static double[] allRoiCentersAndSizes(List<IRectangularArea> rectangles) {
        Objects.requireNonNull(rectangles, "Null rectangles");
        if (4L * (long)rectangles.size() > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of rois");
        }
        double[] result = new double[4 * rectangles.size()];
        int disp = 0;
        for (IRectangularArea r : rectangles) {
            ImagePyramidMetadataJson.pushRectangle(result, disp, r);
            disp += 4;
        }
        return result;
    }

    public List<Contours> roiContours(double scaleX, double scaleY) {
        ArrayList<Contours> roiContours = new ArrayList<Contours>();
        int label = 1;
        for (Roi roi : this.rois) {
            roiContours.add(roi.scaledContours(label++, scaleX, scaleY));
        }
        return roiContours;
    }

    public Contours allRoiContours(double scaleX, double scaleY) {
        Contours allRoiContours = Contours.newInstance();
        int label = 1;
        for (Roi roi : this.rois) {
            allRoiContours.addContours(roi.scaledContours(label++, scaleX, scaleY));
        }
        return allRoiContours;
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("app", APP_NAME);
        builder.add("version", this.version);
        JsonArrayBuilder roisBuilder = Json.createArrayBuilder();
        for (Roi roi : this.rois) {
            roisBuilder.add((JsonValue)roi.toJson());
        }
        builder.add("rois", (JsonValue)roisBuilder.build());
        return builder.build();
    }

    public String jsonString() {
        return Jsons.toPrettyString((JsonObject)this.toJson());
    }

    public String toString() {
        return "PlanePyramidMetadataJson{metadataJsonFile=" + String.valueOf(this.metadataJsonFile) + ", version='" + this.version + "', rois=" + String.valueOf(this.rois) + "}";
    }

    private ImagePyramidMetadataJson setRois(List<? extends Roi> rois, Path file) {
        Objects.requireNonNull(rois, "Null rois");
        ArrayList<? extends Roi> roisList = new ArrayList<Roi>(rois);
        List roiRectangles = roisList.stream().map(Roi::containingRectangle).flatMap(Optional::stream).collect(Collectors.toList());
        this.rois = roisList;
        this.roiRectangles = roiRectangles;
        return this;
    }

    private static void pushRectangle(double[] result, int offset, IRectangularArea r) {
        result[offset++] = 0.5 * ((double)r.minX() + (double)r.maxX());
        result[offset++] = 0.5 * ((double)r.minY() + (double)r.maxY());
        result[offset++] = r.sizeX();
        result[offset++] = r.sizeY();
    }

    public static abstract class Roi {
        Roi() {
        }

        static Roi of(JsonValue json, Path file) {
            assert (json instanceof JsonObject) : "json should be checked before, for example by Jsons.getJsonArray";
            return Roi.of((JsonObject)json, file);
        }

        static Roi of(JsonObject json, Path file) {
            Shape shape = Shape.ofShapeNameOrNull(Jsons.reqString((JsonObject)json, (String)"shape", (Path)file));
            Jsons.requireNonNull((Object)((Object)shape), (JsonObject)json, (String)"shape", (Path)file);
            Roi result = shape.creator.apply(json, file);
            assert (result.getShape() == shape) : "Illegal getShape() method of " + String.valueOf(result.getClass()) + ": it returns " + String.valueOf((Object)result.getShape()) + " instead of " + String.valueOf((Object)shape);
            return result;
        }

        public abstract Shape getShape();

        public final JsonObject toJson() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            this.toJson(builder);
            return builder.build();
        }

        public abstract Optional<IRectangularArea> containingRectangle();

        public abstract Contours contours(int var1);

        public Contours scaledContours(int label, double scaleX, double scaleY) {
            return this.contours(label).transformContours(scaleX, scaleY, 0.0, 0.0, true);
        }

        void toJson(JsonObjectBuilder builder) {
            builder.add("shape", this.getShape().shapeName);
        }

        public static enum Shape {
            RECTANGLE("rectangle", Rectangle::new),
            POLYGON("polygon", Polygon::new),
            MULTIPOLYGON("multipolygon", MultiPolygon::new);

            private final String shapeName;
            private final BiFunction<JsonObject, Path, Roi> creator;

            private Shape(String shapeName, BiFunction<JsonObject, Path, Roi> creator) {
                this.shapeName = shapeName;
                this.creator = creator;
            }

            public String shapeName() {
                return this.shapeName;
            }

            public static Shape ofShapeNameOrNull(String name) {
                Objects.requireNonNull(name, "Null name");
                for (Shape shape : Shape.values()) {
                    if (!shape.shapeName.equals(name)) continue;
                    return shape;
                }
                return null;
            }
        }
    }

    public static final class MultiPolygon
    extends Roi {
        private List<Polygon> polygons = new ArrayList<Polygon>();

        public MultiPolygon() {
        }

        private MultiPolygon(JsonObject json, Path file) {
            for (JsonValue jsonValue : Jsons.reqJsonArray((JsonObject)json, (String)"polygons", (Path)file, (boolean)true)) {
                this.polygons.add(new Polygon((JsonObject)jsonValue, file));
            }
        }

        @Override
        public Roi.Shape getShape() {
            return Roi.Shape.MULTIPOLYGON;
        }

        public List<Polygon> getPolygons() {
            return Collections.unmodifiableList(this.polygons);
        }

        public MultiPolygon setPolygons(List<Polygon> polygons) {
            this.polygons = new ArrayList<Polygon>((Collection)Objects.requireNonNull(polygons, "Null polygons"));
            return this;
        }

        @Override
        public Optional<IRectangularArea> containingRectangle() {
            List nonEmpty = this.polygons.stream().map(Roi::containingRectangle).flatMap(Optional::stream).collect(Collectors.toList());
            return Optional.ofNullable(IRectangularArea.minimalContainingArea(nonEmpty));
        }

        @Override
        public Contours contours(int label) {
            Contours contours = Contours.newInstance();
            for (Polygon polygon : this.polygons) {
                contours.addContours(polygon.contours(label));
            }
            return contours;
        }

        public String toString() {
            return "MultiPolygon{polygons=" + String.valueOf(this.polygons) + "}";
        }

        @Override
        void toJson(JsonObjectBuilder builder) {
            super.toJson(builder);
            JsonArrayBuilder polygonsBuilder = Json.createArrayBuilder();
            for (Polygon polygon : this.polygons) {
                polygonsBuilder.add((JsonValue)polygon.toJson());
            }
            builder.add("vertices", (JsonValue)polygonsBuilder.build());
        }
    }

    public static final class Polygon
    extends Roi {
        private List<Point> vertices = new ArrayList<Point>();

        public Polygon() {
        }

        private Polygon(JsonObject json, Path file) {
            for (JsonValue jsonValue : Jsons.reqJsonArray((JsonObject)json, (String)"vertices", (Path)file, (boolean)true)) {
                this.vertices.add(new Point((JsonObject)jsonValue, file));
            }
        }

        @Override
        public Roi.Shape getShape() {
            return Roi.Shape.POLYGON;
        }

        public List<Point> getVertices() {
            return Collections.unmodifiableList(this.vertices);
        }

        public Polygon setVertices(List<Point> vertices) {
            this.vertices = new ArrayList<Point>((Collection)Objects.requireNonNull(vertices, "Null vertices"));
            return this;
        }

        @Override
        public Optional<IRectangularArea> containingRectangle() {
            if (this.vertices.size() <= 1) {
                return Optional.empty();
            }
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (Point point : this.vertices) {
                minX = Math.min(minX, point.x);
                minY = Math.min(minY, point.y);
                maxX = Math.max(maxX, point.x);
                maxY = Math.max(maxY, point.y);
            }
            long longMinX = (long)Math.floor(minX);
            long longMinY = (long)Math.floor(minY);
            long longMaxX = (long)Math.ceil(maxX);
            long longMaxY = (long)Math.ceil(maxY);
            return longMaxX <= longMinX || longMaxY <= longMinY ? Optional.empty() : Optional.of(IRectangularArea.valueOf((long)longMinX, (long)longMinY, (long)(longMaxX - 1L), (long)(longMaxY - 1L)));
        }

        @Override
        public Contours contours(int label) {
            Contours contours = Contours.newInstance();
            if (this.vertices.size() > 1) {
                int[] verticesXY = this.roundedVerticesXY();
                boolean internal = Contours.area((int[])verticesXY, (int)0, (int)verticesXY.length) < 0.0;
                contours.addContour(new ContourHeader(label, internal), verticesXY);
            }
            return contours;
        }

        public int[] roundedVerticesXY() {
            int n = this.vertices.size();
            if (n > 0x3FFFFFFF) {
                throw new TooLargeArrayException("Too large array of vertices");
            }
            int[] result = new int[2 * n];
            int disp = 0;
            for (Point v : this.vertices) {
                result[disp++] = Arrays.round32((double)v.x);
                result[disp++] = Arrays.round32((double)v.y);
            }
            return result;
        }

        public String toString() {
            return "Polygon{vertices=" + String.valueOf(this.vertices) + "}";
        }

        @Override
        void toJson(JsonObjectBuilder builder) {
            super.toJson(builder);
            JsonArrayBuilder verticesBuilder = Json.createArrayBuilder();
            for (Point point : this.vertices) {
                verticesBuilder.add((JsonValue)point.toJson());
            }
            builder.add("vertices", (JsonValue)verticesBuilder.build());
        }

        public static class Point {
            private double x;
            private double y;

            public Point() {
            }

            private Point(JsonObject json, Path file) {
                this.x = Jsons.reqDouble((JsonObject)json, (String)"x", (Path)file);
                this.y = Jsons.reqDouble((JsonObject)json, (String)"y", (Path)file);
                if (!Double.isFinite(this.x) || !Double.isFinite(this.y)) {
                    throw new JsonException("Illegal point (" + this.x + ", " + this.y + ") " + (String)(file == null ? "" : "in " + String.valueOf(file)) + ": it is not an ordinary point with finite coordinates");
                }
            }

            public double getX() {
                return this.x;
            }

            public Point setX(double x) {
                this.x = x;
                return this;
            }

            public double getY() {
                return this.y;
            }

            public Point setY(double y) {
                this.y = y;
                return this;
            }

            public final JsonObject toJson() {
                JsonObjectBuilder builder = Json.createObjectBuilder();
                builder.add("x", this.x);
                builder.add("y", this.y);
                return builder.build();
            }

            public String toString() {
                return "Point{x=" + this.x + ", y=" + this.y + "}";
            }
        }
    }

    public static final class Rectangle
    extends Roi {
        private int left;
        private int top;
        private int width;
        private int height;

        public Rectangle() {
        }

        private Rectangle(JsonObject json, Path file) {
            this.left = Jsons.reqInt((JsonObject)json, (String)"left", (Path)file);
            this.top = Jsons.reqInt((JsonObject)json, (String)"top", (Path)file);
            this.width = json.containsKey((Object)"right") ? Jsons.reqInt((JsonObject)json, (String)"right", (Path)file) - this.left : Jsons.reqInt((JsonObject)json, (String)"width", (Path)file);
            this.height = json.containsKey((Object)"bottom") ? Jsons.reqInt((JsonObject)json, (String)"bottom", (Path)file) - this.top : Jsons.reqInt((JsonObject)json, (String)"height", (Path)file);
        }

        @Override
        public Roi.Shape getShape() {
            return Roi.Shape.RECTANGLE;
        }

        public int getLeft() {
            return this.left;
        }

        public Rectangle setLeft(int left) {
            this.left = left;
            return this;
        }

        public int getTop() {
            return this.top;
        }

        public Rectangle setTop(int top) {
            this.top = top;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public Rectangle setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getHeight() {
            return this.height;
        }

        public Rectangle setHeight(int height) {
            this.height = height;
            return this;
        }

        @Override
        public Optional<IRectangularArea> containingRectangle() {
            return this.width <= 0 || this.height <= 0 ? Optional.empty() : Optional.of(IRectangularArea.valueOf((long)this.left, (long)this.top, (long)(this.left + this.width - 1), (long)(this.top + this.height - 1)));
        }

        @Override
        public Contours contours(int label) {
            Optional<IRectangularArea> rectangle = this.containingRectangle();
            Contours result = Contours.newInstance();
            if (rectangle.isPresent()) {
                IRectangularArea r = rectangle.get();
                result.addContour(new ContourHeader(label), new int[]{Arrays.round32((double)r.minX()), Arrays.round32((double)r.minY()), Arrays.round32((double)((double)r.maxX() + 1.0)), Arrays.round32((double)r.minY()), Arrays.round32((double)((double)r.maxX() + 1.0)), Arrays.round32((double)((double)r.maxY() + 1.0)), Arrays.round32((double)r.minX()), Arrays.round32((double)((double)r.maxY() + 1.0))});
            }
            return result;
        }

        public String toString() {
            return "Rectangle{left=" + this.left + ", top=" + this.top + ", width=" + this.width + ", height=" + this.height + "}";
        }

        @Override
        void toJson(JsonObjectBuilder builder) {
            super.toJson(builder);
            builder.add("left", this.left);
            builder.add("top", this.top);
            builder.add("width", this.width);
            builder.add("height", this.height);
        }
    }
}

