/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.sources.svs;

import jakarta.json.JsonObject;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.Paths;
import net.algart.json.Jsons;
import net.algart.maps.pyramids.io.api.PlanePyramidSource;
import net.algart.maps.pyramids.io.api.PlanePyramidSourceFactory;
import net.algart.maps.pyramids.io.api.PlanePyramidTools;
import net.algart.maps.pyramids.io.api.sources.RotatingPlanePyramidSource;
import net.algart.maps.pyramids.io.formats.sources.svs.SVSPlanePyramidSource;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSAdditionalCombiningInfo;
import net.algart.matrices.tiff.TiffException;

public class SVSPlanePyramidSourceFactory
implements PlanePyramidSourceFactory {
    private static final System.Logger LOG = System.getLogger(SVSPlanePyramidSource.class.getName());

    @Override
    public PlanePyramidSource newPlanePyramidSource(String pyramidPath, String pyramidConfiguration, String renderingConfiguration) throws IOException {
        RotatingPlanePyramidSource.RotationMode rotationMode;
        JsonObject border;
        SVSPlanePyramidSource source;
        JsonObject pyramidJson = Jsons.toJson((String)pyramidConfiguration, (boolean)true);
        JsonObject renderingJson = Jsons.toJson((String)renderingConfiguration, (boolean)true);
        JsonObject pyramidFormatJson = pyramidJson.getJsonObject("format");
        JsonObject svsJson = Jsons.getJsonObject((JsonObject)pyramidFormatJson, (String)"svs");
        if (svsJson == null) {
            svsJson = Jsons.getJsonObject((JsonObject)pyramidFormatJson, (String)"aperio");
        }
        if (svsJson == null) {
            svsJson = Jsons.newEmptyJson();
        }
        try {
            SVSAdditionalCombiningInfo geometry = SVSAdditionalCombiningInfo.getInstanceFromJson(Jsons.getJsonObject((JsonObject)svsJson, (String)"recommendedGeometry"));
            source = new SVSPlanePyramidSource(Paths.get(pyramidPath, new String[0]), svsJson.getBoolean("combineWithWholeSlideImage", false), geometry);
        }
        catch (TiffException e) {
            throw PlanePyramidTools.rmiSafeWrapper((Exception)((Object)e));
        }
        JsonObject coarseData = renderingJson.getJsonObject("coarseData");
        if (coarseData != null) {
            source.setSkipCoarseData(coarseData.getBoolean("skip", false));
            source.setSkippingFiller(Jsons.getDouble((JsonObject)coarseData, (String)"filler", (double)0.0));
        }
        if ((border = renderingJson.getJsonObject("border")) != null) {
            String color = border.getString("color", "#A3A3A3");
            int width = border.getInt("width", 2);
            source.setDataBorderColor(Color.decode(color));
            source.setDataBorderWidth(width);
        }
        if ((rotationMode = RotatingPlanePyramidSource.RotationMode.of(svsJson.getInt("rotation", 0))) == RotatingPlanePyramidSource.RotationMode.NONE) {
            return source;
        }
        return RotatingPlanePyramidSource.newInstance(source, rotationMode);
    }

    public String toString() {
        return "SVS plane pyramid source factory";
    }
}

