/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.sources.svs.metadata;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import net.algart.json.Jsons;

public final class SVSAdditionalCombiningInfo {
    private static final Double STANDARD_SLIDE_WIDTH = SVSAdditionalCombiningInfo.getDoubleProperty("net.algart.maps.pyramids.io.formats.sources.svs.metadata.slideWidth");
    private static final Double STANDARD_SLIDE_HEIGHT = SVSAdditionalCombiningInfo.getDoubleProperty("net.algart.maps.pyramids.io.formats.sources.svs.metadata.slideHeight");
    private Double slideWidthInMicrons = null;
    private Double slideHeightInMicrons = null;

    public static SVSAdditionalCombiningInfo getInstanceFromSystemRecommendations() {
        SVSAdditionalCombiningInfo result = new SVSAdditionalCombiningInfo();
        result.setSlideWidthInMicrons(STANDARD_SLIDE_WIDTH);
        result.setSlideHeightInMicrons(STANDARD_SLIDE_HEIGHT);
        return result;
    }

    public static SVSAdditionalCombiningInfo getInstanceFromJson(JsonObject json) {
        SVSAdditionalCombiningInfo result = new SVSAdditionalCombiningInfo();
        if (json == null) {
            return result;
        }
        result.setSlideWidthInMicrons(json.containsKey((Object)"slideWidth") ? Double.valueOf(Jsons.reqDouble((JsonObject)json, (String)"slideWidth")) : null);
        result.setSlideHeightInMicrons(json.containsKey((Object)"slideHeight") ? Double.valueOf(Jsons.reqDouble((JsonObject)json, (String)"slideHeight")) : null);
        return result;
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("slideWidth", this.slideWidthInMicrons.doubleValue());
        builder.add("slideHeight", this.slideHeightInMicrons.doubleValue());
        return builder.build();
    }

    public Double getSlideWidthInMicrons() {
        return this.slideWidthInMicrons;
    }

    public void setSlideWidthInMicrons(Double slideWidthInMicrons) {
        if (slideWidthInMicrons != null && slideWidthInMicrons <= 0.0) {
            throw new IllegalArgumentException("Negative or zero slideWidthInMicrons = " + slideWidthInMicrons);
        }
        this.slideWidthInMicrons = slideWidthInMicrons;
    }

    public Double getSlideHeightInMicrons() {
        return this.slideHeightInMicrons;
    }

    public void setSlideHeightInMicrons(Double slideHeightInMicrons) {
        if (slideHeightInMicrons != null && slideHeightInMicrons <= 0.0) {
            throw new IllegalArgumentException("Negative or zero slideHeightInMicrons = " + slideHeightInMicrons);
        }
        this.slideHeightInMicrons = slideHeightInMicrons;
    }

    private static Double getDoubleProperty(String propertyName) {
        try {
            String s = System.getProperty(propertyName);
            if (s != null) {
                return Double.valueOf(s);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

