/*
 * Decompiled with CFR 0.152.
 */
package net.algart.maps.pyramids.io.formats.sources.svs.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.algart.maps.pyramids.io.formats.sources.svs.SVSPlanePyramidSource;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSAdditionalCombiningInfo;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSAttribute;
import net.algart.maps.pyramids.io.formats.sources.svs.metadata.SVSImageDescription;
import net.algart.math.IRectangularArea;
import net.algart.math.RectangularArea;
import net.algart.matrices.tiff.TiffException;

class StandardSVSImageDescription
extends SVSImageDescription {
    private static final String MICRON_PER_PIXEL_ATTRIBUTE = "MPP";
    private static final String MAGNIFICATION_ATTRIBUTE = "AppMag";
    private static final String LEFT_ATTRIBUTE = "Left";
    private static final String TOP_ATTRIBUTE = "Top";
    private static final String ADDED_COMMON_IMAGE_INFO_ATTRIBUTE = "CommonInfo";
    private static final Set<String> IMPORTANT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ScanScope ID", "Date", "Time")));

    StandardSVSImageDescription(String imageDescriptionTagValue) {
        if (imageDescriptionTagValue != null && (imageDescriptionTagValue = imageDescriptionTagValue.trim()).length() > 0) {
            for (String line : imageDescriptionTagValue.split("\\n")) {
                line = line.trim();
                this.text.add(line);
                if (!line.contains("|")) continue;
                String[] records = line.split("[|]");
                if (records.length >= 1) {
                    this.attributes.put(ADDED_COMMON_IMAGE_INFO_ATTRIBUTE, new SVSAttribute(ADDED_COMMON_IMAGE_INFO_ATTRIBUTE, records[0]));
                }
                for (int i = 1; i < records.length; ++i) {
                    String[] record = records[i].trim().split("[=]");
                    if (record.length != 2) continue;
                    String name = record[0].trim();
                    String value = record[1].trim();
                    if (this.attributes.containsKey(name)) continue;
                    this.attributes.put(name, new SVSAttribute(name, value));
                }
            }
        }
    }

    @Override
    public String subFormatTitle() {
        return "Aperio";
    }

    @Override
    public Set<String> importantAttributeNames() {
        return IMPORTANT;
    }

    @Override
    public List<String> importantTextAttributes() {
        return this.text.size() > 1 ? Arrays.asList((String)this.text.get(0)) : Collections.emptyList();
    }

    @Override
    public boolean isPixelSizeSupported() {
        return this.attributes.containsKey(MICRON_PER_PIXEL_ATTRIBUTE);
    }

    @Override
    public boolean isImportant() {
        return this.isPixelSizeSupported();
    }

    @Override
    public double pixelSize() throws TiffException {
        double result;
        SVSAttribute attribute = (SVSAttribute)this.attributes.get(MICRON_PER_PIXEL_ATTRIBUTE);
        if (attribute == null) {
            throw new TiffException("Image description does not contain \"MPP\" attribute");
        }
        try {
            result = Double.parseDouble(attribute.getValue());
        }
        catch (NumberFormatException e) {
            throw new TiffException("Image description contains invalid pixel size attribute: " + String.valueOf(attribute), (Throwable)e);
        }
        if (result <= 0.0) {
            throw new TiffException("Image description contains negative pixel size attribute: " + String.valueOf(attribute));
        }
        return result;
    }

    @Override
    public boolean isMagnificationSupported() {
        return this.attributes.containsKey(MAGNIFICATION_ATTRIBUTE);
    }

    @Override
    public double magnification() throws TiffException {
        SVSAttribute attribute = (SVSAttribute)this.attributes.get(MAGNIFICATION_ATTRIBUTE);
        if (attribute == null) {
            throw new TiffException("Image description does not contain magnification attribute");
        }
        try {
            return Double.parseDouble(attribute.getValue());
        }
        catch (NumberFormatException e) {
            throw new TiffException("Image description contains invalid magnification attribute: " + String.valueOf(attribute), (Throwable)e);
        }
    }

    @Override
    public boolean isGeometrySupported() {
        return this.isPixelSizeSupported() && this.attributes.containsKey(LEFT_ATTRIBUTE) && this.attributes.containsKey(TOP_ATTRIBUTE);
    }

    @Override
    public double imageOnSlideLeftInMicronsAxisRightward() throws TiffException {
        SVSAttribute attribute = (SVSAttribute)this.attributes.get(LEFT_ATTRIBUTE);
        if (attribute == null) {
            throw new TiffException("Image description does not contain Left attribute");
        }
        try {
            return Double.parseDouble(attribute.getValue()) * 1000.0;
        }
        catch (NumberFormatException e) {
            throw new TiffException("Image description contains invalid Left attribute: " + String.valueOf(attribute), (Throwable)e);
        }
    }

    @Override
    public double imageOnSlideTopInMicronsAxisUpward() throws TiffException {
        SVSAttribute attribute = (SVSAttribute)this.attributes.get(TOP_ATTRIBUTE);
        if (attribute == null) {
            throw new TiffException("Image description does not contain Top attribute");
        }
        try {
            return Double.parseDouble(attribute.getValue()) * 1000.0;
        }
        catch (NumberFormatException e) {
            throw new TiffException("Image description contains invalid Top attribute: " + String.valueOf(attribute), (Throwable)e);
        }
    }

    @Override
    public boolean correctCombiningInfoUsingFoundBorder(SVSAdditionalCombiningInfo additionalCombiningInfo, SVSPlanePyramidSource source, long borderLeftTopX, long borderLeftTopY) {
        RectangularArea metricWholeSlide = source.metricWholeSlide();
        RectangularArea metricPyramid = source.metricPyramid();
        IRectangularArea wholeSlideArea = source.pixelWholeSlide();
        double slideWidth = metricWholeSlide.size(0);
        double slideHeight = metricWholeSlide.size(1);
        double oldMetricLeftAxisRightward = metricPyramid.min(0);
        double oldMetricTopAxisUpward = slideHeight - metricPyramid.min(1);
        double newMetricLeftAxisRightward = slideWidth * (double)borderLeftTopX / (double)wholeSlideArea.size(0);
        double newMetricTopAxisUpward = slideHeight * (1.0 - (double)borderLeftTopY / (double)wholeSlideArea.size(1));
        if (newMetricTopAxisUpward > 0.0 && newMetricLeftAxisRightward > 0.0) {
            additionalCombiningInfo.setSlideWidthInMicrons(slideWidth * oldMetricLeftAxisRightward / newMetricLeftAxisRightward);
            additionalCombiningInfo.setSlideHeightInMicrons(slideHeight * oldMetricTopAxisUpward / newMetricTopAxisUpward);
            return true;
        }
        return false;
    }
}

