/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.DebugBuiltins;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=DebugBuiltins.class)
public final class DebugBuiltinsFactory {

    @GeneratedBy(value=DebugBuiltins.DebugNeverPartOfCompilationNode.class)
    public static final class DebugNeverPartOfCompilationNodeGen
    extends DebugBuiltins.DebugNeverPartOfCompilationNode {
        private DebugNeverPartOfCompilationNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return DebugBuiltins.DebugNeverPartOfCompilationNode.neverPartOfCompilation();
        }

        @NeverDefault
        public static DebugBuiltins.DebugNeverPartOfCompilationNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugNeverPartOfCompilationNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugCreateSafeInteger.class)
    public static final class DebugCreateSafeIntegerNodeGen
    extends DebugBuiltins.DebugCreateSafeInteger {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private DebugCreateSafeIntegerNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 6) == 0 && state_0 != 0) {
                return this.execute_int0(state_0, frameValue);
            }
            return this.execute_generic1(state_0, frameValue);
        }

        private Object execute_int0(int state_0__, VirtualFrame frameValue) {
            int arguments0Value_;
            int state_0 = state_0__;
            try {
                arguments0Value_ = this.arguments0_.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            assert ((state_0 & 1) != 0);
            return DebugBuiltins.DebugCreateSafeInteger.createSafeInteger(arguments0Value_);
        }

        private Object execute_generic1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof Integer) {
                    int arguments0Value__ = (Integer)arguments0Value_;
                    return DebugBuiltins.DebugCreateSafeInteger.createSafeInteger(arguments0Value__);
                }
                if ((state_0 & 2) != 0 && arguments0Value_ instanceof SafeInteger) {
                    SafeInteger arguments0Value__ = (SafeInteger)arguments0Value_;
                    return DebugBuiltins.DebugCreateSafeInteger.createSafeInteger(arguments0Value__);
                }
                if ((state_0 & 4) != 0) {
                    return DebugBuiltins.DebugCreateSafeInteger.createSafeInteger(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        private SafeInteger executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof Integer) {
                int arguments0Value_ = (Integer)arguments0Value;
                this.state_0_ = state_0 |= 1;
                return DebugBuiltins.DebugCreateSafeInteger.createSafeInteger(arguments0Value_);
            }
            if (arguments0Value instanceof SafeInteger) {
                SafeInteger arguments0Value_ = (SafeInteger)arguments0Value;
                this.state_0_ = state_0 |= 2;
                return DebugBuiltins.DebugCreateSafeInteger.createSafeInteger(arguments0Value_);
            }
            this.state_0_ = state_0 |= 4;
            return DebugBuiltins.DebugCreateSafeInteger.createSafeInteger(arguments0Value);
        }

        @NeverDefault
        public static DebugBuiltins.DebugCreateSafeInteger create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugCreateSafeIntegerNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugTypedArrayDetachBufferNode.class)
    public static final class DebugTypedArrayDetachBufferNodeGen
    extends DebugBuiltins.DebugTypedArrayDetachBufferNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugTypedArrayDetachBufferNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return DebugBuiltins.DebugTypedArrayDetachBufferNode.detachBuffer(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugTypedArrayDetachBufferNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugTypedArrayDetachBufferNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugSystemProperty.class)
    public static final class DebugSystemPropertyNodeGen
    extends DebugBuiltins.DebugSystemProperty {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugSystemPropertyNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return DebugBuiltins.DebugSystemProperty.systemProperty(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugSystemProperty create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugSystemPropertyNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugSystemProperties.class)
    public static final class DebugSystemPropertiesNodeGen
    extends DebugBuiltins.DebugSystemProperties {
        private DebugSystemPropertiesNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.systemProperties();
        }

        @NeverDefault
        public static DebugBuiltins.DebugSystemProperties create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugSystemPropertiesNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugLoadModuleNode.class)
    public static final class DebugLoadModuleNodeGen
    extends DebugBuiltins.DebugLoadModuleNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private DebugLoadModuleNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.loadModule(arguments0Value_, arguments1Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugLoadModuleNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugLoadModuleNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugJSStackNode.class)
    public static final class DebugJSStackNodeGen
    extends DebugBuiltins.DebugJSStackNode {
        private DebugJSStackNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.printJSStack();
        }

        @NeverDefault
        public static DebugBuiltins.DebugJSStackNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugJSStackNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugIsHolesArrayNode.class)
    public static final class DebugIsHolesArrayNodeGen
    extends DebugBuiltins.DebugIsHolesArrayNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugIsHolesArrayNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.isHolesArray(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugIsHolesArrayNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugIsHolesArrayNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugStringCompareNode.class)
    public static final class DebugStringCompareNodeGen
    extends DebugBuiltins.DebugStringCompareNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private TruffleString.CompareCharsUTF16Node compareNode_;

        private DebugStringCompareNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            TruffleString.CompareCharsUTF16Node compareNode__;
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 && (compareNode__ = this.compareNode_) != null) {
                return this.stringCompare(arguments0Value_, arguments1Value_, compareNode__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private int executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state_0 = this.state_0_;
            TruffleString.CompareCharsUTF16Node compareNode__ = (TruffleString.CompareCharsUTF16Node)this.insert((Node)TruffleString.CompareCharsUTF16Node.create());
            Objects.requireNonNull(compareNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.compareNode_ = compareNode__;
            this.state_0_ = state_0 |= 1;
            return this.stringCompare(arguments0Value, arguments1Value, compareNode__);
        }

        @NeverDefault
        public static DebugBuiltins.DebugStringCompareNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugStringCompareNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugHeapDumpNode.class)
    public static final class DebugHeapDumpNodeGen
    extends DebugBuiltins.DebugHeapDumpNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private DebugHeapDumpNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.heapDump(arguments0Value_, arguments1Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugHeapDumpNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugHeapDumpNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugAssertIntNode.class)
    public static final class DebugAssertIntNodeGen
    extends DebugBuiltins.DebugAssertIntNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;

        private DebugAssertIntNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            return this.assertInt(arguments0Value_, arguments1Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugAssertIntNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugAssertIntNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugArrayTypeNode.class)
    public static final class DebugArrayTypeNodeGen
    extends DebugBuiltins.DebugArrayTypeNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugArrayTypeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.arraytype(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugArrayTypeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugArrayTypeNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugPrintSourceAttribution.class)
    public static final class DebugPrintSourceAttributionNodeGen
    extends DebugBuiltins.DebugPrintSourceAttribution {
        @Node.Child
        private JavaScriptNode arguments0_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private DebugPrintSourceAttributionNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        private boolean fallbackGuard_(int state_0, Object arguments0Value) {
            if ((state_0 & 1) == 0 && arguments0Value instanceof JSFunctionObject) {
                return false;
            }
            return (state_0 & 2) != 0 || !(arguments0Value instanceof TruffleString);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            if (state_0 != 0) {
                if ((state_0 & 1) != 0 && arguments0Value_ instanceof JSFunctionObject) {
                    JSFunctionObject arguments0Value__ = (JSFunctionObject)((Object)arguments0Value_);
                    return this.printSourceAttribution(arguments0Value__);
                }
                if ((state_0 & 2) != 0 && arguments0Value_ instanceof TruffleString) {
                    TruffleString arguments0Value__ = (TruffleString)arguments0Value_;
                    return this.printSourceAttribution(arguments0Value__);
                }
                if ((state_0 & 4) != 0 && this.fallbackGuard_(state_0, arguments0Value_)) {
                    return this.illegalArgument(arguments0Value_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSFunctionObject) {
                JSFunctionObject arguments0Value_ = (JSFunctionObject)((Object)arguments0Value);
                this.state_0_ = state_0 |= 1;
                return this.printSourceAttribution(arguments0Value_);
            }
            if (arguments0Value instanceof TruffleString) {
                TruffleString arguments0Value_ = (TruffleString)arguments0Value;
                this.state_0_ = state_0 |= 2;
                return this.printSourceAttribution(arguments0Value_);
            }
            this.state_0_ = state_0 |= 4;
            return this.illegalArgument(arguments0Value);
        }

        @NeverDefault
        public static DebugBuiltins.DebugPrintSourceAttribution create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugPrintSourceAttributionNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugToJavaStringNode.class)
    public static final class DebugToJavaStringNodeGen
    extends DebugBuiltins.DebugToJavaStringNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugToJavaStringNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return DebugBuiltins.DebugToJavaStringNode.toJavaString(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugToJavaStringNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugToJavaStringNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugPrintObjectNode.class)
    public static final class DebugPrintObjectNodeGen
    extends DebugBuiltins.DebugPrintObjectNode {
        @Node.Child
        private JavaScriptNode arguments0_;
        @Node.Child
        private JavaScriptNode arguments1_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private DebugPrintObjectNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            Object arguments1Value_ = this.arguments1_.execute(frameValue);
            if (state_0 != 0 && arguments0Value_ instanceof JSDynamicObject) {
                JSDynamicObject arguments0Value__ = (JSDynamicObject)((Object)arguments0Value_);
                return this.printObject(arguments0Value__, arguments1Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
        }

        private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
            int state_0 = this.state_0_;
            if (arguments0Value instanceof JSDynamicObject) {
                JSDynamicObject arguments0Value_ = (JSDynamicObject)((Object)arguments0Value);
                this.state_0_ = state_0 |= 1;
                return this.printObject(arguments0Value_, arguments1Value);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
        }

        @NeverDefault
        public static DebugBuiltins.DebugPrintObjectNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugPrintObjectNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugDumpFunctionTreeNode.class)
    public static final class DebugDumpFunctionTreeNodeGen
    extends DebugBuiltins.DebugDumpFunctionTreeNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugDumpFunctionTreeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.dumpFunctionTree(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugDumpFunctionTreeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugDumpFunctionTreeNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugDumpCountersNode.class)
    public static final class DebugDumpCountersNodeGen
    extends DebugBuiltins.DebugDumpCountersNode {
        private DebugDumpCountersNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return DebugBuiltins.DebugDumpCountersNode.dumpCounters();
        }

        @NeverDefault
        public static DebugBuiltins.DebugDumpCountersNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugDumpCountersNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugShapeNode.class)
    public static final class DebugShapeNodeGen
    extends DebugBuiltins.DebugShapeNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugShapeNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return DebugBuiltins.DebugShapeNode.shape(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugShapeNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugShapeNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugClassNameNode.class)
    public static final class DebugClassNameNodeGen
    extends DebugBuiltins.DebugClassNameNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugClassNameNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            super(context, builtin);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return DebugBuiltins.DebugClassNameNode.clazz(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugClassNameNode create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
            return new DebugClassNameNodeGen(context, builtin, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugClassNode.class)
    public static final class DebugClassNodeGen
    extends DebugBuiltins.DebugClassNode {
        @Node.Child
        private JavaScriptNode arguments0_;

        private DebugClassNodeGen(JSContext context, JSBuiltin builtin, boolean getName, JavaScriptNode[] arguments) {
            super(context, builtin, getName);
            this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[]{this.arguments0_};
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arguments0Value_ = this.arguments0_.execute(frameValue);
            return this.clazz(arguments0Value_);
        }

        @NeverDefault
        public static DebugBuiltins.DebugClassNode create(JSContext context, JSBuiltin builtin, boolean getName, JavaScriptNode[] arguments) {
            return new DebugClassNodeGen(context, builtin, getName, arguments);
        }
    }

    @GeneratedBy(value=DebugBuiltins.DebugContinueInInterpreter.class)
    public static final class DebugContinueInInterpreterNodeGen
    extends DebugBuiltins.DebugContinueInInterpreter {
        private DebugContinueInInterpreterNodeGen(JSContext context, JSBuiltin builtin, boolean invalidate, JavaScriptNode[] arguments) {
            super(context, builtin, invalidate);
        }

        @Override
        public JavaScriptNode[] getArguments() {
            return new JavaScriptNode[0];
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.continueInInterpreter();
        }

        @NeverDefault
        public static DebugBuiltins.DebugContinueInInterpreter create(JSContext context, JSBuiltin builtin, boolean invalidate, JavaScriptNode[] arguments) {
            return new DebugContinueInInterpreterNodeGen(context, builtin, invalidate, arguments);
        }
    }
}

