/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.drawing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.model3d.spherepolyhedra.drawing.Orthonormal4DBasis;
import net.algart.model3d.spherepolyhedra.drawing.DrawingColor;
import net.algart.model3d.spherepolyhedra.drawing.SpherePolyhedraDrawer;
import net.algart.model3d.spherepolyhedra.objects.Generatrix;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class Draw4DSpherePolyhedron
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_SEGMENTS = "segments";
    public static final String INPUT_RADIUS = "radius";
    public static final String OUTPUT_DRAWN_INFO = "drawn_info";
    private static final Color AXIS_X_COLOR = new Color(0xFF8080);
    private static final Color AXIS_Y_COLOR = new Color(0x80FF80);
    private static final Color AXIS_Z_COLOR = new Color(0xC0C0FF);
    private static final Color AXIS_T_COLOR = new Color(0xFFFF00);
    private int dimX = 1000;
    private int dimY = 1000;
    private double scale = 1.0;
    private double rotationXYInDegree = 0.0;
    private double rotationYZInDegree = 0.0;
    private double rotationZTInDegree = 0.0;
    private double rotationTXInDegree = 0.0;
    private double rotationXZInDegree = 0.0;
    private double rotationYTInDegree = 0.0;
    private Color color = Color.CYAN;
    private Color backgroundColor = Color.WHITE;
    private boolean edgesOnly = true;
    private boolean upwardAxisY = true;
    private boolean animate = false;
    private int animationDelay = 50;
    private Orthonormal4DBasis currentBasis = Orthonormal4DBasis.DEFAULT;
    private SNumbers currentSegments = null;
    private double currentRadius = Double.NaN;
    private Color currentColor = null;

    public Draw4DSpherePolyhedron() {
        this.addInputNumbers(INPUT_SEGMENTS);
        this.setDefaultOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_DRAWN_INFO);
    }

    public int getDimX() {
        return this.dimX;
    }

    public void setDimX(int dimX) {
        this.dimX = Draw4DSpherePolyhedron.positive((int)dimX);
    }

    public int getDimY() {
        return this.dimY;
    }

    public void setDimY(int dimY) {
        this.dimY = Draw4DSpherePolyhedron.positive((int)dimY);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getRotationXYInDegree() {
        return this.rotationXYInDegree;
    }

    public void setRotationXYInDegree(double rotationXYInDegree) {
        this.rotationXYInDegree = rotationXYInDegree;
    }

    public double getRotationYZInDegree() {
        return this.rotationYZInDegree;
    }

    public void setRotationYZInDegree(double rotationYZInDegree) {
        this.rotationYZInDegree = rotationYZInDegree;
    }

    public double getRotationZTInDegree() {
        return this.rotationZTInDegree;
    }

    public void setRotationZTInDegree(double rotationZTInDegree) {
        this.rotationZTInDegree = rotationZTInDegree;
    }

    public double getRotationTXInDegree() {
        return this.rotationTXInDegree;
    }

    public void setRotationTXInDegree(double rotationTXInDegree) {
        this.rotationTXInDegree = rotationTXInDegree;
    }

    public double getRotationXZInDegree() {
        return this.rotationXZInDegree;
    }

    public void setRotationXZInDegree(double rotationXZInDegree) {
        this.rotationXZInDegree = rotationXZInDegree;
    }

    public double getRotationYTInDegree() {
        return this.rotationYTInDegree;
    }

    public void setRotationYTInDegree(double rotationYTInDegree) {
        this.rotationYTInDegree = rotationYTInDegree;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = (Color)Draw4DSpherePolyhedron.nonNull((Object)color);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = (Color)Draw4DSpherePolyhedron.nonNull((Object)backgroundColor);
    }

    public boolean isEdgesOnly() {
        return this.edgesOnly;
    }

    public void setEdgesOnly(boolean edgesOnly) {
        this.edgesOnly = edgesOnly;
    }

    public boolean isUpwardAxisY() {
        return this.upwardAxisY;
    }

    public void setUpwardAxisY(boolean upwardAxisY) {
        this.upwardAxisY = upwardAxisY;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    public void process() {
        SNumbers segments = this.getInputNumbers(INPUT_SEGMENTS, true);
        if (!this.animate) {
            this.currentBasis = Orthonormal4DBasis.DEFAULT;
        }
        if (!this.animate || this.currentColor == null) {
            this.currentColor = this.color;
        }
        this.currentBasis = this.currentBasis.rotateIJ(Math.toRadians(this.rotationXYInDegree));
        this.currentBasis = this.currentBasis.rotateJK(Math.toRadians(this.rotationYZInDegree));
        this.currentBasis = this.currentBasis.rotateKL(Math.toRadians(this.rotationZTInDegree));
        this.currentBasis = this.currentBasis.rotateLI(Math.toRadians(this.rotationTXInDegree));
        this.currentBasis = this.currentBasis.rotateIK(Math.toRadians(this.rotationXZInDegree));
        this.currentBasis = this.currentBasis.rotateJL(Math.toRadians(this.rotationYTInDegree));
        int x0 = this.dimX / 2;
        int y0 = this.dimY / 2;
        SScalar inputRadiusScalar = this.getInputScalar(INPUT_RADIUS, true);
        long t1 = Draw4DSpherePolyhedron.debugTime();
        if (!this.animate || Double.isNaN(this.currentRadius) || this.currentSegments == null) {
            this.currentRadius = inputRadiusScalar.isInitialized() ? inputRadiusScalar.toDouble() : 0.0;
            this.currentSegments = segments;
        }
        double generatrixSphereRadius = this.currentRadius;
        ArrayList<Generatrix> generatrixes = new ArrayList<Generatrix>();
        generatrixes.add(GeneratrixSphere.newSphere(this.scale * generatrixSphereRadius));
        if (this.currentSegments != null && this.currentSegments.isInitialized()) {
            this.currentSegments.requireBlockLength(4, INPUT_SEGMENTS);
            int n = this.currentSegments.n();
            for (int k = 0; k < n; ++k) {
                double x = this.currentSegments.getValue(k, 0);
                double y = this.currentSegments.getValue(k, 1);
                double z = this.currentSegments.getValue(k, 2);
                double t = this.currentSegments.getValue(k, 3);
                double projectionX = this.scale * this.currentBasis.x(x, y, z, t);
                double projectionY = this.scale * this.currentBasis.y(x, y, z, t);
                double projectionZ = this.scale * this.currentBasis.z(x, y, z, t);
                generatrixes.add(GeneratrixSegment.newSegment(projectionX, projectionY, projectionZ));
            }
            t1 = Draw4DSpherePolyhedron.debugTime();
        }
        GeneratrixSet drawnGeneratrixSet = GeneratrixSet.newInstance(generatrixes);
        SpherePolyhedron drawnSpherePolyhedron = SpherePolyhedron.newInstance(x0, y0, 0.0, drawnGeneratrixSet);
        long t2 = Draw4DSpherePolyhedron.debugTime();
        SpherePolyhedraDrawer drawer = SpherePolyhedraDrawer.newSimpleInstance(this.dimX, this.dimY, DrawingColor.of(this.backgroundColor));
        this.drawAxes(x0, y0, drawer);
        long t3 = Draw4DSpherePolyhedron.debugTime();
        drawer.setColor(DrawingColor.of(this.currentColor));
        drawer.setEdgesOnly(this.edgesOnly);
        drawer.drawSpherePolyhedron(drawnSpherePolyhedron);
        long t4 = Draw4DSpherePolyhedron.debugTime();
        MultiMatrix2D drawnResult = MultiMatrix.of2DRGBA(drawer.rgbMatrices(this.upwardAxisY));
        long t5 = Draw4DSpherePolyhedron.debugTime();
        if (LOGGABLE_DEBUG) {
            Draw4DSpherePolyhedron.logDebug((String)String.format(Locale.US, "Drawing %s: %.3f ms = %.3f building sphere-polyhedron, %.3f preparing scene, %.3f drawing, %.3f returning image", drawnSpherePolyhedron, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        }
        this.setEndProcessingTimeStamp();
        this.getMat().setTo((MultiMatrix)drawnResult);
        this.getScalar(OUTPUT_DRAWN_INFO).setTo(drawnSpherePolyhedron.toDetailedString());
        if (this.animate) {
            try {
                Thread.sleep(this.animationDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void drawAxes(int x0, int y0, SpherePolyhedraDrawer drawer) {
        double d = Math.max(this.dimX, this.dimY);
        drawer.setColor(DrawingColor.BLACK);
        drawer.setAlternateColor(DrawingColor.of(AXIS_X_COLOR));
        drawer.drawGradientLine((double)x0 + this.currentBasis.x(-d, 0.0, 0.0, 0.0), (double)y0 + this.currentBasis.y(-d, 0.0, 0.0, 0.0), this.currentBasis.z(-d, 0.0, 0.0, 0.0), (double)x0 + this.currentBasis.x(d, 0.0, 0.0, 0.0), (double)y0 + this.currentBasis.y(d, 0.0, 0.0, 0.0), this.currentBasis.z(d, 0.0, 0.0, 0.0));
        drawer.setAlternateColor(DrawingColor.of(AXIS_Y_COLOR));
        drawer.drawGradientLine((double)x0 + this.currentBasis.x(0.0, -d, 0.0, 0.0), (double)y0 + this.currentBasis.y(0.0, -d, 0.0, 0.0), this.currentBasis.z(0.0, -d, 0.0, 0.0), (double)x0 + this.currentBasis.x(0.0, d, 0.0, 0.0), (double)y0 + this.currentBasis.y(0.0, d, 0.0, 0.0), this.currentBasis.z(0.0, d, 0.0, 0.0));
        drawer.setAlternateColor(DrawingColor.of(AXIS_Z_COLOR));
        drawer.drawGradientLine((double)x0 + this.currentBasis.x(0.0, 0.0, -d, 0.0), (double)y0 + this.currentBasis.y(0.0, 0.0, -d, 0.0), this.currentBasis.z(0.0, 0.0, -d, 0.0), (double)x0 + this.currentBasis.x(0.0, 0.0, d, 0.0), (double)y0 + this.currentBasis.y(0.0, 0.0, d, 0.0), this.currentBasis.z(0.0, 0.0, d, 0.0));
        drawer.setAlternateColor(DrawingColor.of(AXIS_T_COLOR));
        drawer.drawGradientLine((double)x0 + this.currentBasis.x(0.0, 0.0, 0.0, -d), (double)y0 + this.currentBasis.y(0.0, 0.0, 0.0, -d), this.currentBasis.z(0.0, 0.0, 0.0, -d), (double)x0 + this.currentBasis.x(0.0, 0.0, 0.0, d), (double)y0 + this.currentBasis.y(0.0, 0.0, 0.0, d), this.currentBasis.z(0.0, 0.0, 0.0, d));
    }
}

