/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.drawing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.model3d.spherepolyhedra.SpherePolyhedraTools;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.drawing.DrawingColor;
import net.algart.model3d.spherepolyhedra.drawing.SpherePolyhedraDrawer;
import net.algart.model3d.spherepolyhedra.objects.Generatrix;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class DrawSpherePolyhedron
extends Executor
implements ReadOnlyExecutionInput {
    public static final String INPUT_SEGMENTS = "segments";
    public static final String INPUT_RADIUS = "radius";
    public static final String OUTPUT_GENERATRIX_SET = "generatrix_set";
    public static final String OUTPUT_INFO = "info";
    public static final String OUTPUT_DRAWN_INFO = "drawn_info";
    private static final Color AXIS_X_COLOR = new Color(0xFF8080);
    private static final Color AXIS_Y_COLOR = new Color(0x80FF80);
    private static final Color AXIS_Z_COLOR = new Color(0xC0C0FF);
    private int dimX = 1000;
    private int dimY = 1000;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double centerZ = 0.0;
    private double radius = 1.0;
    private double scale = 1.0;
    private double rotationAroundXInDegree = 0.0;
    private double rotationAroundYInDegree = 0.0;
    private double rotationAroundZInDegree = 0.0;
    private double sectionZ = Double.POSITIVE_INFINITY;
    private boolean dissectedObjectsVisible = true;
    private Color color = Color.CYAN;
    private Color backgroundColor = Color.WHITE;
    private boolean upwardAxisY = true;
    private boolean animate = false;
    private int animationDelay = 50;
    private Orthonormal3DBasis currentBasis = Orthonormal3DBasis.DEFAULT;
    private GeneratrixSet currentGeneratrixSet = null;
    private Color currentColor = null;

    public DrawSpherePolyhedron() {
        this.addInputNumbers(INPUT_SEGMENTS);
        this.setDefaultOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputNumbers(OUTPUT_GENERATRIX_SET);
        this.addOutputScalar(OUTPUT_INFO);
        this.addOutputScalar(OUTPUT_DRAWN_INFO);
    }

    public int getDimX() {
        return this.dimX;
    }

    public void setDimX(int dimX) {
        this.dimX = DrawSpherePolyhedron.positive((int)dimX);
    }

    public int getDimY() {
        return this.dimY;
    }

    public void setDimY(int dimY) {
        this.dimY = DrawSpherePolyhedron.positive((int)dimY);
    }

    public double getCenterX() {
        return this.centerX;
    }

    public DrawSpherePolyhedron setCenterX(double centerX) {
        this.centerX = centerX;
        return this;
    }

    public double getCenterY() {
        return this.centerY;
    }

    public DrawSpherePolyhedron setCenterY(double centerY) {
        this.centerY = centerY;
        return this;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public DrawSpherePolyhedron setCenterZ(double centerZ) {
        this.centerZ = centerZ;
        return this;
    }

    public double getRadius() {
        return this.radius;
    }

    public DrawSpherePolyhedron setRadius(double radius) {
        this.radius = DrawSpherePolyhedron.nonNegative((double)radius);
        return this;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getRotationAroundXInDegree() {
        return this.rotationAroundXInDegree;
    }

    public void setRotationAroundXInDegree(double rotationAroundXInDegree) {
        this.rotationAroundXInDegree = rotationAroundXInDegree;
    }

    public double getRotationAroundYInDegree() {
        return this.rotationAroundYInDegree;
    }

    public void setRotationAroundYInDegree(double rotationAroundYInDegree) {
        this.rotationAroundYInDegree = rotationAroundYInDegree;
    }

    public double getRotationAroundZInDegree() {
        return this.rotationAroundZInDegree;
    }

    public void setRotationAroundZInDegree(double rotationAroundZInDegree) {
        this.rotationAroundZInDegree = rotationAroundZInDegree;
    }

    public double getSectionZ() {
        return this.sectionZ;
    }

    public void setSectionZ(double sectionZ) {
        this.sectionZ = sectionZ;
    }

    public void setSectionZ(String sectionZ) {
        this.setSectionZ(DrawSpherePolyhedron.doubleOrPositiveInfinity((String)sectionZ));
    }

    public boolean isDissectedObjectsVisible() {
        return this.dissectedObjectsVisible;
    }

    public void setDissectedObjectsVisible(boolean dissectedObjectsVisible) {
        this.dissectedObjectsVisible = dissectedObjectsVisible;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = (Color)DrawSpherePolyhedron.nonNull((Object)color);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = (Color)DrawSpherePolyhedron.nonNull((Object)backgroundColor);
    }

    public boolean isUpwardAxisY() {
        return this.upwardAxisY;
    }

    public void setUpwardAxisY(boolean upwardAxisY) {
        this.upwardAxisY = upwardAxisY;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    public void process() {
        SNumbers segments = this.getInputNumbers(INPUT_SEGMENTS, true);
        if (!this.animate) {
            this.currentBasis = Orthonormal3DBasis.DEFAULT;
        }
        if (!this.animate || this.currentColor == null) {
            this.currentColor = this.color;
        }
        this.currentBasis = this.currentBasis.rotateJK(Math.toRadians(this.rotationAroundXInDegree));
        this.currentBasis = this.currentBasis.rotateKI(Math.toRadians(this.rotationAroundYInDegree));
        this.currentBasis = this.currentBasis.rotateIJ(Math.toRadians(this.rotationAroundZInDegree));
        int x0 = this.dimX / 2;
        int y0 = this.dimY / 2;
        SScalar inputRadiusScalar = this.getInputScalar(INPUT_RADIUS, true);
        double generatrixSphereRadius = inputRadiusScalar.isInitialized() ? inputRadiusScalar.toDouble() : this.radius;
        long t1 = System.nanoTime();
        if (!this.animate || this.currentGeneratrixSet == null) {
            ArrayList<Generatrix> generatrices = new ArrayList<Generatrix>();
            generatrices.add(GeneratrixSphere.newSphere(generatrixSphereRadius));
            if (segments != null && segments.isInitialized()) {
                segments.requireBlockLength(3, INPUT_SEGMENTS);
                int n = segments.n();
                for (int k = 0; k < n; ++k) {
                    double x = segments.getValue(k, 0);
                    double y = segments.getValue(k, 1);
                    double z = segments.getValue(k, 2);
                    generatrices.add(GeneratrixSegment.newSegment(x, y, z));
                }
                t1 = System.nanoTime();
                this.currentGeneratrixSet = GeneratrixSet.newInstance(generatrices);
            }
        }
        SpherePolyhedron spherePolyhedron = SpherePolyhedron.newInstance(this.centerX, this.centerY, this.centerZ, this.currentGeneratrixSet);
        SpherePolyhedron drawnSpherePolyhedron = SpherePolyhedraDrawer.newSpherePolyhedron(x0, y0, this.currentBasis, this.scale, this.centerX, this.centerY, this.centerZ, this.currentGeneratrixSet, 0L);
        long t2 = System.nanoTime();
        SpherePolyhedraDrawer drawer = SpherePolyhedraDrawer.newSimpleInstance(this.dimX, this.dimY, DrawingColor.of(this.backgroundColor));
        DrawSpherePolyhedron.drawAxes(drawer, this.dimX, this.dimY, x0, y0, this.currentBasis);
        long t3 = System.nanoTime();
        drawer.setSectionZ(this.scale * this.sectionZ);
        drawer.setDissectedObjectsVisible(this.dissectedObjectsVisible);
        drawer.setColor(DrawingColor.of(this.currentColor));
        drawer.drawSpherePolyhedron(drawnSpherePolyhedron);
        long t4 = System.nanoTime();
        MultiMatrix2D drawnResult = MultiMatrix.of2DRGBA(drawer.rgbMatrices(this.upwardAxisY));
        long t5 = System.nanoTime();
        if (LOGGABLE_DEBUG) {
            DrawSpherePolyhedron.logDebug((String)String.format(Locale.US, "Drawing %s: %.3f ms = %.3f building sphere-polyhedron, %.3f preparing scene, %.3f drawing, %.3f returning image", spherePolyhedron, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        }
        this.setEndProcessingTimeStamp();
        this.getMat().setTo((MultiMatrix)drawnResult);
        SpherePolyhedraTools.serializeGeneratrixSet(this, this.currentGeneratrixSet, OUTPUT_GENERATRIX_SET);
        this.getScalar(OUTPUT_INFO).setTo(spherePolyhedron.toDetailedString());
        this.getScalar(OUTPUT_DRAWN_INFO).setTo(drawnSpherePolyhedron.toDetailedString());
        if (this.animate) {
            try {
                Thread.sleep(this.animationDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static void drawAxes(SpherePolyhedraDrawer drawer, int dimX, int dimY, int x0, int y0, Orthonormal3DBasis basis) {
        double d = Math.max(dimX, dimY);
        drawer.setColor(DrawingColor.BLACK);
        drawer.setAlternateColor(DrawingColor.of(AXIS_X_COLOR));
        drawer.drawGradientLine((double)x0 + basis.x(-d, 0.0, 0.0), (double)y0 + basis.y(-d, 0.0, 0.0), basis.z(-d, 0.0, 0.0), (double)x0 + basis.x(d, 0.0, 0.0), (double)y0 + basis.y(d, 0.0, 0.0), basis.z(d, 0.0, 0.0));
        drawer.setAlternateColor(DrawingColor.of(AXIS_Y_COLOR));
        drawer.drawGradientLine((double)x0 + basis.x(0.0, -d, 0.0), (double)y0 + basis.y(0.0, -d, 0.0), basis.z(0.0, -d, 0.0), (double)x0 + basis.x(0.0, d, 0.0), (double)y0 + basis.y(0.0, d, 0.0), basis.z(0.0, d, 0.0));
        drawer.setAlternateColor(DrawingColor.of(AXIS_Z_COLOR));
        drawer.drawGradientLine((double)x0 + basis.x(0.0, 0.0, -d), (double)y0 + basis.y(0.0, 0.0, -d), basis.z(0.0, 0.0, -d), (double)x0 + basis.x(0.0, 0.0, d), (double)y0 + basis.y(0.0, 0.0, d), basis.z(0.0, 0.0, d));
    }
}

