/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.objects;

import java.util.ArrayList;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.model3d.spherepolyhedra.SpherePolyhedraTools;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraExecutor;
import net.algart.model3d.spherepolyhedra.objects.Generatrix;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;

public final class CreateGeneratrixSet
extends SpherePolyhedraExecutor
implements ReadOnlyExecutionInput {
    public static final String INPUT_SEGMENTS = "segments";
    public static final String INPUT_RADIUS = "radius";
    private double radius = 1.0;

    public CreateGeneratrixSet() {
        this.addInputNumbers(INPUT_SEGMENTS);
        this.setDefaultOutputNumbers("generatrix_set");
    }

    public double getRadius() {
        return this.radius;
    }

    public CreateGeneratrixSet setRadius(double radius) {
        this.radius = radius;
        return this;
    }

    public void process() {
        SNumbers segments = this.getInputNumbers(INPUT_SEGMENTS, true);
        SScalar inputRadiusScalar = this.getInputScalar(INPUT_RADIUS, true);
        double generatrixSphereRadius = inputRadiusScalar.isInitialized() ? inputRadiusScalar.toDouble() : this.radius;
        ArrayList<Generatrix> generatrices = new ArrayList<Generatrix>();
        generatrices.add(GeneratrixSphere.newSphere(generatrixSphereRadius));
        if (segments != null && segments.isInitialized()) {
            segments.requireBlockLength(3, INPUT_SEGMENTS);
            int n = segments.n();
            for (int k = 0; k < n; ++k) {
                double x = segments.getValue(k, 0);
                double y = segments.getValue(k, 1);
                double z = segments.getValue(k, 2);
                generatrices.add(GeneratrixSegment.newSegment(x, y, z));
            }
        }
        GeneratrixSet generatrixSet = GeneratrixSet.newInstance(generatrices);
        SpherePolyhedraTools.serializeGeneratrixSet(this, generatrixSet, "generatrix_set");
    }
}

