/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.objects;

import java.awt.Color;
import java.util.Random;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraExecutor;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class CreateRandomSpherePolyhedron
extends SpherePolyhedraExecutor {
    public static final String OUTPUT_SEGMENTS = "segments";
    public static final String OUTPUT_RADIUS = "radius";
    public static final String OUTPUT_COLOR = "color";
    private Long randSeed = null;

    public Long getRandSeed() {
        return this.randSeed;
    }

    public void setRandSeed(Long randSeed) {
        this.randSeed = randSeed;
    }

    public void setRandSeed(String randSeed) {
        this.setRandSeed(CreateRandomSpherePolyhedron.longOrNull((String)randSeed));
    }

    public CreateRandomSpherePolyhedron() {
        this.setDefaultInputScalar("kind_set");
        this.setDefaultOutputScalar("kind_set");
        this.addOutputNumbers(OUTPUT_SEGMENTS);
        this.addOutputScalar(OUTPUT_RADIUS);
        this.addOutputScalar(OUTPUT_COLOR);
    }

    public void process() {
        SpherePolyhedronKindSet kindSet = this.deserializeKindSetAndProbabilities();
        CreateRandomSpherePolyhedron.logDebug(() -> "Loading sphere-polyhedron kind set: " + String.valueOf(kindSet));
        Random random = this.randSeed == null ? new Random() : new Random(this.randSeed);
        SpherePolyhedronKind kind = kindSet.nextKind(random);
        SpherePolyhedrion spherePolyhedrion = kind.newSpherePolyhedrion(random);
        if (spherePolyhedrion.numberOfElements() > 1) {
            throw new IllegalArgumentException("Cannot create union of several sphere-polyhedra");
        }
        GeneratrixSet generatrixSet = spherePolyhedrion.element(0).generatrixSet();
        this.getNumbers(OUTPUT_SEGMENTS).setTo(generatrixSet.allGeneratrixSegmentsXYZ(), 3);
        this.getScalar(OUTPUT_RADIUS).setTo(generatrixSet.generatrixSphereRadius());
        this.getScalar(OUTPUT_COLOR).setTo(Jsons.toString((Color)kind.getColor()));
        this.serializeKindSet(kindSet);
    }
}

