/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.drawing;

import java.awt.Color;
import net.algart.math.Range;

public final class DrawingColor {
    private static final Range RANGE_01 = Range.valueOf((double)0.0, (double)1.0);
    private static final double INV_255 = 0.00392156862745098;
    public static final DrawingColor BLACK = new DrawingColor(0.0, 0.0, 0.0);
    public static final DrawingColor WHITE = new DrawingColor(1.0, 1.0, 1.0);
    private double r255;
    private double g255;
    private double b255;
    private byte byteR;
    private byte byteG;
    private byte byteB;

    private DrawingColor(double r, double g, double b) {
        this.setAll(r, g, b);
    }

    private DrawingColor(int rgb) {
        this.setPackedRGB(rgb);
    }

    DrawingColor(DrawingColor that) {
        this.setTo(that);
    }

    public static DrawingColor of(double r, double g, double b) {
        return new DrawingColor(r, g, b);
    }

    public static DrawingColor ofPackedRGB(int color) {
        return new DrawingColor(color);
    }

    public static DrawingColor of(Color color) {
        return DrawingColor.ofPackedRGB(color.getRGB());
    }

    public double r() {
        return this.r255 * 0.00392156862745098;
    }

    public double g() {
        return this.g255 * 0.00392156862745098;
    }

    public double b() {
        return this.b255 * 0.00392156862745098;
    }

    public double r255() {
        return this.r255;
    }

    public double g255() {
        return this.g255;
    }

    public double b255() {
        return this.b255;
    }

    public byte byteR() {
        return this.byteR;
    }

    public byte byteG() {
        return this.byteG;
    }

    public byte byteB() {
        return this.byteB;
    }

    public int toIntColor() {
        return (this.byteR & 0xFF) << 16 | (this.byteG & 0xFF) << 8 | this.byteB & 0xFF;
    }

    public Color toColor() {
        return new Color(this.toIntColor());
    }

    public String toString() {
        return "Color [r=" + this.r() + ",g=" + this.g() + ",b=" + this.b() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DrawingColor that = (DrawingColor)o;
        return Double.compare(that.r255, this.r255) == 0 && Double.compare(that.g255, this.g255) == 0 && Double.compare(that.b255, this.b255) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.r255);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.g255);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b255);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    void setTo(DrawingColor color) {
        this.r255 = color.r255;
        this.g255 = color.g255;
        this.b255 = color.b255;
        this.byteR = color.byteR;
        this.byteG = color.byteG;
        this.byteB = color.byteB;
    }

    void setPackedRGB(int color) {
        int r = color >>> 16 & 0xFF;
        int g = color >>> 8 & 0xFF;
        int b = color & 0xFF;
        this.byteR = (byte)r;
        this.byteG = (byte)g;
        this.byteB = (byte)b;
        this.r255 = r;
        this.g255 = g;
        this.b255 = b;
    }

    private void setAll(double r, double g, double b) {
        this.r255 = 255.0 * RANGE_01.cut(r);
        this.g255 = 255.0 * RANGE_01.cut(g);
        this.b255 = 255.0 * RANGE_01.cut(b);
        this.byteR = (byte)this.r255;
        this.byteG = (byte)this.g255;
        this.byteB = (byte)this.b255;
    }
}

