/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.geometries;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Objects;
import java.util.Random;
import net.algart.json.Jsons;
import net.algart.math.Range;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.geometries.PreferredVerticalRayPosition;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class VerticalRectangularBox
extends SpherePolyhedraPackingGeometry {
    private static final double MINIMAL_DISTANCE_FROM_WALL_FOR_PACKING = 1.0E-4;
    private static final double MINIMAL_DISTANCE_MULT = 0.9999;
    private static final double MINIMAL_BOX_SIDE = 9.999999999999999E-19;
    private double centerI = 0.0;
    private double centerJ = 0.0;
    private double bottomK = 0.0;
    private double sizeI = 10.0;
    private double sizeJ = 10.0;
    private double sizeK = 10.0;
    private boolean allowOverflow = true;
    private double ix = 1.0;
    private double iy = 0.0;
    private double iz = 0.0;
    private double jx = 0.0;
    private double jy = 1.0;
    private double jz = 0.0;
    private double kx = 0.0;
    private double ky = 0.0;
    private double kz = 1.0;
    private long leftWallKindId = 0L;
    private long rightWallKindId = 0L;
    private long frontWallKindId = 0L;
    private long rearWallKindId = 0L;
    private long bottomKindId = 0L;
    private PreferredVerticalRayPosition preferred = new PreferredVerticalRayPosition();

    public double getCenterI() {
        return this.centerI;
    }

    public VerticalRectangularBox setCenterI(double centerI) {
        this.centerI = centerI;
        return this;
    }

    public double getCenterJ() {
        return this.centerJ;
    }

    public VerticalRectangularBox setCenterJ(double centerJ) {
        this.centerJ = centerJ;
        return this;
    }

    public double getBottomK() {
        return this.bottomK;
    }

    public VerticalRectangularBox setBottomK(double bottomK) {
        this.bottomK = bottomK;
        return this;
    }

    public double getSizeI() {
        return this.sizeI;
    }

    public VerticalRectangularBox setSizeI(double sizeI) {
        this.sizeI = VerticalRectangularBox.greaterThan(sizeI, 9.999999999999999E-19, "sizeI");
        this.clearCache();
        return this;
    }

    public double getSizeJ() {
        return this.sizeJ;
    }

    public VerticalRectangularBox setSizeJ(double sizeJ) {
        this.sizeJ = VerticalRectangularBox.greaterThan(sizeJ, 9.999999999999999E-19, "sizeJ");
        this.clearCache();
        return this;
    }

    public double getSizeK() {
        return this.sizeK;
    }

    public VerticalRectangularBox setSizeK(double sizeK) {
        this.sizeK = VerticalRectangularBox.greaterThan(sizeK, 9.999999999999999E-19, "sizeK");
        this.clearCache();
        return this;
    }

    public boolean isAllowOverflow() {
        return this.allowOverflow;
    }

    public VerticalRectangularBox setAllowOverflow(boolean allowOverflow) {
        this.allowOverflow = allowOverflow;
        return this;
    }

    public VerticalRectangularBox setOrientation(Orthonormal3DBasis basis) {
        Objects.requireNonNull(basis, "Null basis");
        this.ix = basis.ix();
        this.iy = basis.iy();
        this.iz = basis.iz();
        this.jx = basis.jx();
        this.jy = basis.jy();
        this.jz = basis.jz();
        this.kx = basis.kx();
        this.ky = basis.ky();
        this.kz = basis.kz();
        return this;
    }

    public double getIx() {
        return this.ix;
    }

    public double getIy() {
        return this.iy;
    }

    public double getIz() {
        return this.iz;
    }

    public double getJx() {
        return this.jx;
    }

    public double getJy() {
        return this.jy;
    }

    public double getJz() {
        return this.jz;
    }

    public double getKx() {
        return this.kx;
    }

    public double getKy() {
        return this.ky;
    }

    public double getKz() {
        return this.kz;
    }

    public long getLeftWallKindId() {
        return this.leftWallKindId;
    }

    public VerticalRectangularBox setLeftWallKindId(long leftWallKindId) {
        this.leftWallKindId = VerticalRectangularBox.nonPositive(leftWallKindId, "leftWallKindId");
        return this;
    }

    public long getRightWallKindId() {
        return this.rightWallKindId;
    }

    public VerticalRectangularBox setRightWallKindId(long rightWallKindId) {
        this.rightWallKindId = VerticalRectangularBox.nonPositive(rightWallKindId, "rightWallKindId");
        return this;
    }

    public long getFrontWallKindId() {
        return this.frontWallKindId;
    }

    public VerticalRectangularBox setFrontWallKindId(long frontWallKindId) {
        this.frontWallKindId = VerticalRectangularBox.nonPositive(frontWallKindId, "frontWallKindId");
        return this;
    }

    public long getRearWallKindId() {
        return this.rearWallKindId;
    }

    public VerticalRectangularBox setRearWallKindId(long rearWallKindId) {
        this.rearWallKindId = VerticalRectangularBox.nonPositive(rearWallKindId, "rearWallKindId");
        return this;
    }

    public long getBottomKindId() {
        return this.bottomKindId;
    }

    public VerticalRectangularBox setBottomKindId(long bottomKindId) {
        this.bottomKindId = VerticalRectangularBox.nonPositive(bottomKindId, "bottomKindId");
        return this;
    }

    public PreferredVerticalRayPosition getPreferred() {
        return this.preferred;
    }

    public void setPreferred(PreferredVerticalRayPosition preferred) {
        this.preferred = Objects.requireNonNull(preferred, "Null preferred");
    }

    public double x(double i, double j, double k) {
        return i * this.ix + j * this.jx + k * this.kx;
    }

    public double y(double i, double j, double k) {
        return i * this.iy + j * this.jy + k * this.ky;
    }

    public double z(double i, double j, double k) {
        return i * this.iz + j * this.jz + k * this.kz;
    }

    public double kProjection(double x, double y, double z) {
        return x * this.kx + y * this.ky + z * this.kz;
    }

    @Override
    public boolean canBePackedAfterParallelShift(SpherePolyhedrion objectToPack) {
        return new MinMaxInfo(this, objectToPack).canBePacked();
    }

    @Override
    public boolean isPositionAllowed(SpherePolyhedrion newlyPackedObject) {
        double correction = 1.0E-7 * (this.maxInitialSpherePolyhedraContainingSphereRadius() + newlyPackedObject.maxContainingSphereRadius());
        double halfI = 0.5 * this.sizeI + correction;
        double halfJ = 0.5 * this.sizeJ + correction;
        Range rangeI = newlyPackedObject.rangeAlongDirection(this.ix, this.iy, this.iz);
        Range rangeJ = newlyPackedObject.rangeAlongDirection(this.jx, this.jy, this.jz);
        Range rangeK = newlyPackedObject.rangeAlongDirection(this.kx, this.ky, this.kz);
        return rangeI.min() >= this.centerI - halfI && rangeI.max() <= this.centerI + halfI && rangeJ.min() >= this.centerJ - halfJ && rangeJ.max() <= this.centerJ + halfJ && rangeK.min() >= this.bottomK - correction && (this.allowOverflow || rangeK.max() <= this.bottomK + this.sizeK);
    }

    @Override
    public boolean randomPackingDirection(StraightLine3D result, SpherePolyhedrion objectToPack, Random random) {
        MinMaxInfo info = new MinMaxInfo(this, objectToPack);
        if (!info.canBePacked()) {
            return false;
        }
        double i = info.minI + random.nextDouble() * (info.maxI - info.minI);
        double j = info.minJ + random.nextDouble() * (info.maxJ - info.minJ);
        result.setStart(this.x(i, j, this.bottomK), this.y(i, j, this.bottomK), this.z(i, j, this.bottomK));
        result.setDirection(this.kx, this.ky, this.kz);
        return true;
    }

    @Override
    public void buildInitialSpherePolyhedra(SpherePolyhedra spherePolyhedra) {
        spherePolyhedra.clear();
        Orthonormal3DBasis basis = Orthonormal3DBasis.newBasis((double)this.ix, (double)this.iy, (double)this.iz, (double)this.jx, (double)this.jy, (double)this.jz, (boolean)true);
        double halfI = 0.5 * this.sizeI;
        double halfJ = 0.5 * this.sizeJ;
        double halfK = 0.5 * this.sizeK;
        GeneratrixSet bottom = GeneratrixSet.newInstance(GeneratrixSegment.newSegment(halfI, 0.0, 0.0), GeneratrixSegment.newSegment(0.0, halfJ, 0.0)).rotate(basis);
        spherePolyhedra.add(SpherePolyhedron.newInstance(this.x(this.centerI, this.centerJ, this.bottomK), this.y(this.centerI, this.centerJ, this.bottomK), this.z(this.centerI, this.centerJ, this.bottomK), bottom, this.bottomKindId));
        GeneratrixSet frontRear = GeneratrixSet.newInstance(GeneratrixSegment.newSegment(halfI, 0.0, 0.0), GeneratrixSegment.newSegment(0.0, 0.0, halfK)).rotate(basis);
        spherePolyhedra.add(SpherePolyhedron.newInstance(this.x(this.centerI, this.centerJ - halfJ, this.bottomK + halfK), this.y(this.centerI, this.centerJ - halfJ, this.bottomK + halfK), this.z(this.centerI, this.centerJ - halfJ, this.bottomK + halfK), frontRear, this.frontWallKindId));
        spherePolyhedra.add(SpherePolyhedron.newInstance(this.x(this.centerI, this.centerJ + halfJ, this.bottomK + halfK), this.y(this.centerI, this.centerJ + halfJ, this.bottomK + halfK), this.z(this.centerI, this.centerJ + halfJ, this.bottomK + halfK), frontRear, this.rearWallKindId));
        GeneratrixSet leftRight = GeneratrixSet.newInstance(GeneratrixSegment.newSegment(0.0, halfJ, 0.0), GeneratrixSegment.newSegment(0.0, 0.0, halfK)).rotate(basis);
        spherePolyhedra.add(SpherePolyhedron.newInstance(this.x(this.centerI - halfI, this.centerJ, this.bottomK + halfK), this.y(this.centerI - halfI, this.centerJ, this.bottomK + halfK), this.z(this.centerI - halfI, this.centerJ, this.bottomK + halfK), leftRight, this.leftWallKindId));
        spherePolyhedra.add(SpherePolyhedron.newInstance(this.x(this.centerI + halfI, this.centerJ, this.bottomK + halfK), this.y(this.centerI + halfI, this.centerJ, this.bottomK + halfK), this.z(this.centerI + halfI, this.centerJ, this.bottomK + halfK), leftRight, this.rightWallKindId));
    }

    @Override
    public int numberOfInitialSpherePolyhedra() {
        return 5;
    }

    @Override
    public int numberOfInitialSpherePolyhedrions() {
        return 5;
    }

    @Override
    public int comparePositions(double thisX, double thisY, double thisZ, double thatX, double thatY, double thatZ) {
        return Double.compare(this.kProjection(thisX, thisY, thisZ), this.kProjection(thatX, thatY, thatZ));
    }

    @Override
    public double minimizedDistance(double x, double y, double z) {
        return this.kProjection(x, y, z);
    }

    @Override
    public boolean isMinimizedDistanceSupported() {
        return true;
    }

    @Override
    public SpherePolyhedrion packFirst(SpherePolyhedrion objectToPack) {
        return null;
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        builder.add("centerI", this.centerI);
        builder.add("centerJ", this.centerJ);
        builder.add("bottomK", this.bottomK);
        builder.add("sizeI", this.sizeI);
        builder.add("sizeJ", this.sizeJ);
        builder.add("sizeK", this.sizeK);
        builder.add("allowOverflow", this.allowOverflow);
        builder.add("ix", this.ix);
        builder.add("iy", this.iy);
        builder.add("iz", this.iz);
        builder.add("jx", this.jx);
        builder.add("jy", this.jy);
        builder.add("jz", this.jz);
        builder.add("kx", this.kx);
        builder.add("ky", this.ky);
        builder.add("kz", this.kz);
        if (this.leftWallKindId != 0L) {
            builder.add("leftWallKindId", SpherePolyhedronKind.idToFriendlyString(this.leftWallKindId));
        }
        if (this.rightWallKindId != 0L) {
            builder.add("rightWallKindId", SpherePolyhedronKind.idToFriendlyString(this.rightWallKindId));
        }
        if (this.frontWallKindId != 0L) {
            builder.add("frontWallKindId", SpherePolyhedronKind.idToFriendlyString(this.frontWallKindId));
        }
        if (this.rearWallKindId != 0L) {
            builder.add("rearWallKindId", SpherePolyhedronKind.idToFriendlyString(this.rearWallKindId));
        }
        if (this.bottomKindId != 0L) {
            builder.add("bottomKindId", SpherePolyhedronKind.idToFriendlyString(this.bottomKindId));
        }
        builder.add("preferred", (JsonValue)this.preferred.toJson());
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        this.setCenterI(Jsons.getDouble((JsonObject)json, (String)"centerI", (double)0.0));
        this.setCenterJ(Jsons.getDouble((JsonObject)json, (String)"centerJ", (double)0.0));
        this.setBottomK(Jsons.getDouble((JsonObject)json, (String)"bottomK", (double)0.0));
        this.setSizeI(Jsons.reqDouble((JsonObject)json, (String)"sizeI"));
        this.setSizeJ(Jsons.reqDouble((JsonObject)json, (String)"sizeJ"));
        this.setSizeK(Jsons.reqDouble((JsonObject)json, (String)"sizeK"));
        this.setAllowOverflow(json.getBoolean("allowOverflow", true));
        this.setOrientation(Orthonormal3DBasis.newBasis((double)Jsons.getDouble((JsonObject)json, (String)"ix", (double)1.0), (double)Jsons.getDouble((JsonObject)json, (String)"iy", (double)0.0), (double)Jsons.getDouble((JsonObject)json, (String)"iz", (double)0.0), (double)Jsons.getDouble((JsonObject)json, (String)"jx", (double)0.0), (double)Jsons.getDouble((JsonObject)json, (String)"jy", (double)1.0), (double)Jsons.getDouble((JsonObject)json, (String)"jz", (double)0.0), (boolean)true));
        if (json.containsKey((Object)"leftWallKindId")) {
            this.setLeftWallKindId(VerticalRectangularBox.getSystemKindId(json, "leftWallKindId"));
        }
        if (json.containsKey((Object)"rightWallKindId")) {
            this.setRightWallKindId(VerticalRectangularBox.getSystemKindId(json, "rightWallKindId"));
        }
        if (json.containsKey((Object)"frontWallKindId")) {
            this.setFrontWallKindId(VerticalRectangularBox.getSystemKindId(json, "frontWallKindId"));
        }
        if (json.containsKey((Object)"rearWallKindId")) {
            this.setRearWallKindId(VerticalRectangularBox.getSystemKindId(json, "rearWallKindId"));
        }
        if (json.containsKey((Object)"bottomKindId")) {
            this.setBottomKindId(VerticalRectangularBox.getSystemKindId(json, "bottomKindId"));
        }
        this.setPreferred(new PreferredVerticalRayPosition().setToJson(json.getJsonObject("preferred")));
    }

    private static long getSystemKindId(JsonObject json, String name) {
        String friendlyId = Jsons.reqString((JsonObject)json, (String)name);
        long id = SpherePolyhedronKind.friendlyStringToId(friendlyId);
        if (id > 0L) {
            throw new JsonException("Invalid JSON: id \"" + name + "\"=\"" + friendlyId + "\" is not a system id and is not allowed here <<<" + String.valueOf(json) + ">>>");
        }
        return id;
    }

    private class MinMaxInfo {
        private double minI;
        private double maxI;
        private double minJ;
        private double maxJ;

        MinMaxInfo(VerticalRectangularBox verticalRectangularBox, SpherePolyhedrion objectToPack) {
            Range rangeI = objectToPack.rangeAlongDirection(verticalRectangularBox.ix, verticalRectangularBox.iy, verticalRectangularBox.iz);
            Range rangeJ = objectToPack.rangeAlongDirection(verticalRectangularBox.jx, verticalRectangularBox.jy, verticalRectangularBox.jz);
            this.minI = verticalRectangularBox.centerI - 0.49995 * verticalRectangularBox.sizeI - rangeI.min();
            this.maxI = verticalRectangularBox.centerI + 0.49995 * verticalRectangularBox.sizeI - rangeI.max();
            this.minJ = verticalRectangularBox.centerJ - 0.49995 * verticalRectangularBox.sizeJ - rangeJ.min();
            this.maxJ = verticalRectangularBox.centerJ + 0.49995 * verticalRectangularBox.sizeJ - rangeJ.max();
            if (verticalRectangularBox.preferred.hasX()) {
                this.minI = Math.max(this.minI, verticalRectangularBox.preferred.getI() - verticalRectangularBox.preferred.getDi());
                this.maxI = Math.min(this.maxI, verticalRectangularBox.preferred.getI() + verticalRectangularBox.preferred.getDi());
            }
            if (verticalRectangularBox.preferred.hasY()) {
                this.minJ = Math.max(this.minJ, verticalRectangularBox.preferred.getJ() - verticalRectangularBox.preferred.getDj());
                this.maxJ = Math.min(this.minJ, verticalRectangularBox.preferred.getJ() + verticalRectangularBox.preferred.getDj());
            }
        }

        boolean canBePacked() {
            return this.minI <= this.maxI && this.minJ <= this.maxJ;
        }
    }
}

