/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.RandomSizeDistribution;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;

public abstract class KindWithRandomDistribution
extends SpherePolyhedronKind {
    private RandomSizeDistribution distribution = RandomSizeDistribution.NORMAL;

    public RandomSizeDistribution getDistribution() {
        return this.distribution;
    }

    public KindWithRandomDistribution setDistribution(RandomSizeDistribution distribution) {
        this.distribution = Objects.requireNonNull(distribution);
        return this;
    }

    protected final double nextPositive(Random random, double average, double delta) {
        return this.distribution.nextPositive(random, average, delta);
    }

    protected final double nextNonNegative(Random random, double average, double delta) {
        return this.distribution.nextNonNegative(random, average, delta);
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        builder.add("distribution", this.distribution.name());
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        String s = json.getString("distribution", RandomSizeDistribution.NORMAL.name());
        RandomSizeDistribution distribution = RandomSizeDistribution.ofOrNull(s);
        Jsons.requireNonNull((Object)((Object)distribution), (JsonObject)json, (String)"distribution", (String)("unknown (\"" + s + "\", " + Arrays.toString((Object[])RandomSizeDistribution.values()) + " allowed)"), null);
        this.setDistribution(distribution);
    }
}

