/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import net.algart.json.Jsons;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.kinds.KindWithDirectionsAndTwoSizesAndRadius;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class SphereCrossKind
extends KindWithDirectionsAndTwoSizesAndRadius {
    double rb = Double.NaN;
    double drb = 0.0;
    double h = 0.0;
    double dh = 0.0;
    ShiftMode mode = ShiftMode.RELATIVE;
    boolean inRange = true;

    public double getRb() {
        return this.rb;
    }

    public SphereCrossKind setRb(double rb) {
        this.rb = SphereCrossKind.positive(rb, "rb");
        return this;
    }

    public double getDrb() {
        return this.drb;
    }

    public SphereCrossKind setDrb(double drb) {
        this.drb = SphereCrossKind.nonNegative(drb, "drb");
        return this;
    }

    public double getH() {
        return this.h;
    }

    public SphereCrossKind setH(double h) {
        this.h = h;
        return this;
    }

    public double getDh() {
        return this.dh;
    }

    public SphereCrossKind setDh(double dh) {
        this.dh = SphereCrossKind.nonNegative(dh, "dh");
        return this;
    }

    public ShiftMode getMode() {
        return this.mode;
    }

    public SphereCrossKind setMode(ShiftMode mode) {
        this.mode = Objects.requireNonNull(mode, "Null mode");
        return this;
    }

    public boolean isInRange() {
        return this.inRange;
    }

    public SphereCrossKind setInRange(boolean inRange) {
        this.inRange = inRange;
        return this;
    }

    @Override
    public SpherePolyhedrion newSpherePolyhedrion(Random random) {
        Objects.requireNonNull(random, "Null random generator");
        Orthonormal3DBasis basis = this.directions.newRandomBasisForTwoDirections(random);
        GeneratrixSphere sphereA = GeneratrixSphere.newSphere(this.nextPositive(random, this.r, this.dr));
        GeneratrixSegment segmentA = GeneratrixSegment.newSegmentAlongI(basis, this.nextNonNegative(random, this.a, this.da));
        SpherePolyhedron sphereCylinderA = GeneratrixSet.newInstance(sphereA, segmentA).toSpherePolyhedron(0.0, 0.0, 0.0, this.getId());
        GeneratrixSphere sphereB = GeneratrixSphere.newSphere(Double.isNaN(this.rb) ? sphereA.r() : this.nextPositive(random, this.rb, this.drb));
        GeneratrixSegment segmentB = GeneratrixSegment.newSegmentAlongJ(basis, this.nextNonNegative(random, this.b, this.db));
        double h = this.mode.position(this.getDistribution().next(random, this.h, this.dh), segmentA.halfLength(), sphereB.r(), sphereA.r(), this.inRange);
        SpherePolyhedron sphereCylinderB = GeneratrixSet.newInstance(sphereB, segmentB).toSpherePolyhedron(h * basis.ix(), h * basis.iy(), h * basis.iz(), this.getId());
        return SpherePolyhedrion.unionOf(sphereCylinderA, sphereCylinderB);
    }

    @Override
    protected void toJsonImplementation(JsonObjectBuilder builder) {
        super.toJsonImplementation(builder);
        if (!Double.isNaN(this.rb)) {
            builder.add("rb", this.rb);
            builder.add("drb", this.drb);
        }
        builder.add("h", this.h);
        builder.add("dh", this.dh);
        builder.add("mode", this.mode.name());
        builder.add("in-range", this.inRange);
    }

    @Override
    protected void fromJsonImplementation(JsonObject json) {
        super.fromJsonImplementation(json);
        this.setRb(Jsons.getDouble((JsonObject)json, (String)"rb", (double)Double.NaN));
        this.setDrb(Jsons.getDouble((JsonObject)json, (String)"drb", (double)0.0));
        this.setH(Jsons.getDouble((JsonObject)json, (String)"h", (double)0.0));
        this.setDh(Jsons.getDouble((JsonObject)json, (String)"dh", (double)0.0));
        String modeName = json.getString("mode", ShiftMode.RELATIVE.name());
        ShiftMode mode = ShiftMode.ofOrNull(modeName);
        Jsons.requireNonNull((Object)((Object)mode), (JsonObject)json, (String)"mode", (String)("unknown (\"" + modeName + "\", " + Arrays.toString((Object[])ShiftMode.values()) + " allowed)"), null);
        this.setMode(mode);
        this.setInRange(json.getBoolean("in-range", true));
    }

    public static enum ShiftMode {
        RAW{

            @Override
            double position(double h, double halfA, double ra, double rb, boolean inRange) {
                return 1.cut(h, halfA, inRange);
            }
        }
        ,
        RELATIVE{

            @Override
            double position(double h, double halfA, double ra, double rb, boolean inRange) {
                return 2.cut(h, 1.0, inRange) * halfA;
            }
        }
        ,
        RELATIVE_LONGER{

            @Override
            double position(double h, double halfA, double ra, double rb, boolean inRange) {
                return 3.cut(h, 1.0, inRange) * (halfA + ra + rb);
            }
        };


        public static ShiftMode ofOrNull(String name) {
            Objects.requireNonNull(name, "Null name");
            for (ShiftMode value : ShiftMode.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }

        abstract double position(double var1, double var3, double var5, double var7, boolean var9);

        static double cut(double v, double max, boolean inRange) {
            return !inRange ? v : (v > max ? max : (v < -max ? -max : v));
        }
    }
}

