/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds.restrictions;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourIndexRequirement;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourKindSetProhibition;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.NeighbourKindSetRequirement;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;

public abstract class SpherePolyhedraNeighbourhoodPackingRestriction
implements PackingRestriction {
    public static final String RESTRICTION_JSON_PROPERTY = "restriction";
    private static final Map<String, Class<? extends SpherePolyhedraNeighbourhoodPackingRestriction>> KNOWN_RESTRICTIONS = Collections.synchronizedMap(new LinkedHashMap());
    private String restrictionName = null;

    public static <T extends SpherePolyhedraNeighbourhoodPackingRestriction> T newInstance(Class<T> restrictionClass) {
        Objects.requireNonNull(restrictionClass, "Null kind class");
        try {
            return (T)((SpherePolyhedraNeighbourhoodPackingRestriction)restrictionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JsonException("Cannot create restriction for " + String.valueOf(restrictionClass), (Throwable)e);
        }
    }

    public static SpherePolyhedraNeighbourhoodPackingRestriction of(JsonObject json) {
        String restrictionName = Jsons.reqString((JsonObject)json, (String)RESTRICTION_JSON_PROPERTY);
        Class<? extends SpherePolyhedraNeighbourhoodPackingRestriction> restrictionClass = KNOWN_RESTRICTIONS.get(restrictionName);
        Jsons.requireNonNull(restrictionClass, (JsonObject)json, (String)RESTRICTION_JSON_PROPERTY, (String)("unknown \"" + restrictionName + "\""), null);
        SpherePolyhedraNeighbourhoodPackingRestriction restriction = SpherePolyhedraNeighbourhoodPackingRestriction.newInstance(restrictionClass);
        restriction.fromJsonImplementation(json);
        return restriction;
    }

    public final JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.toJsonImplementation(builder);
        return builder.build();
    }

    public final String toJsonString() {
        return Jsons.toPrettyString((JsonObject)this.toJson());
    }

    public void setToJson(JsonObject json) {
        Objects.requireNonNull(json, "Null json");
        this.fromJsonImplementation(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String restrictionName() {
        Map<String, Class<? extends SpherePolyhedraNeighbourhoodPackingRestriction>> map = KNOWN_RESTRICTIONS;
        synchronized (map) {
            if (this.restrictionName != null) {
                return this.restrictionName;
            }
            for (Map.Entry<String, Class<? extends SpherePolyhedraNeighbourhoodPackingRestriction>> entry : KNOWN_RESTRICTIONS.entrySet()) {
                if (!this.getClass().equals(entry.getValue())) continue;
                this.restrictionName = entry.getKey();
                return this.restrictionName;
            }
        }
        throw new IllegalStateException(String.valueOf(this.getClass()) + " has no registered restriction name: you must register it by registerRestriction method");
    }

    public String toString() {
        return this.restrictionName();
    }

    protected void toJsonImplementation(JsonObjectBuilder builder) {
        builder.add(RESTRICTION_JSON_PROPERTY, this.restrictionName());
    }

    protected void fromJsonImplementation(JsonObject json) {
    }

    PackingRestriction optimize() {
        return this;
    }

    private static void registerRestriction(String simpleName, Class<? extends SpherePolyhedraNeighbourhoodPackingRestriction> restrictionClass) {
        Objects.requireNonNull(simpleName, "Null simple name");
        Objects.requireNonNull(restrictionClass, "Null restriction class");
        KNOWN_RESTRICTIONS.put(simpleName, restrictionClass);
    }

    static {
        for (StandardClass standardClass : StandardClass.values()) {
            SpherePolyhedraNeighbourhoodPackingRestriction.registerRestriction(standardClass.simpleName, standardClass.restrictionClass);
        }
    }

    public static enum StandardClass {
        NEIGHBOUR_INDEX_REQUIREMENT("require-index", NeighbourIndexRequirement.class),
        NEIGHBOUR_KIND_SET_REQUIREMENT("require-kinds", NeighbourKindSetRequirement.class),
        NEIGHBOUR_KIND_SET_PROHIBITION("prohibit-kinds", NeighbourKindSetProhibition.class);

        private final String simpleName;
        private final Class<? extends SpherePolyhedraNeighbourhoodPackingRestriction> restrictionClass;

        private StandardClass(String simpleName, Class<? extends SpherePolyhedraNeighbourhoodPackingRestriction> restrictionClass) {
            this.simpleName = simpleName;
            this.restrictionClass = restrictionClass;
        }
    }
}

