/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds.restrictions;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.SpherePolyhedraNeighbourhoodPackingRestriction;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class SpherePolyhedraNeighbourhoodPackingRestrictionSet
implements PackingRestriction {
    private List<SpherePolyhedraNeighbourhoodPackingRestriction> restrictions = new ArrayList<SpherePolyhedraNeighbourhoodPackingRestriction>();
    private List<PackingRestriction> optimized = new ArrayList<PackingRestriction>();

    public static SpherePolyhedraNeighbourhoodPackingRestrictionSet of(Collection<SpherePolyhedraNeighbourhoodPackingRestriction> restrictions) {
        return new SpherePolyhedraNeighbourhoodPackingRestrictionSet().setRestrictions(restrictions);
    }

    public Collection<SpherePolyhedraNeighbourhoodPackingRestriction> getRestrictions() {
        return new ArrayList<SpherePolyhedraNeighbourhoodPackingRestriction>(this.restrictions);
    }

    public SpherePolyhedraNeighbourhoodPackingRestrictionSet setRestrictions(Collection<SpherePolyhedraNeighbourhoodPackingRestriction> restrictions) {
        Objects.requireNonNull(restrictions, "Null restrictions collection");
        this.restrictions = new ArrayList<SpherePolyhedraNeighbourhoodPackingRestriction>(restrictions);
        this.optimized.clear();
        for (SpherePolyhedraNeighbourhoodPackingRestriction restriction : restrictions) {
            this.optimized.add(restriction.optimize());
        }
        return this;
    }

    public int numberOfRestrictions() {
        return this.restrictions.size();
    }

    @Override
    public boolean allowFirstNeighbour(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex, long neighbourKindId) {
        for (PackingRestriction restriction : this.optimized) {
            if (restriction.allowFirstNeighbour(indexOfNewlyPackedObject, newlyPackedObject, neighbourIndex, neighbourKindId)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean allowAllNeighbours(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex1, long neighbourKindId1, int neighbourIndex2, long neighbourKindId2, int neighbourIndex3, long neighbourKindId3) {
        for (PackingRestriction restriction : this.optimized) {
            if (restriction.allowAllNeighbours(indexOfNewlyPackedObject, newlyPackedObject, neighbourIndex1, neighbourKindId1, neighbourIndex2, neighbourKindId2, neighbourIndex3, neighbourKindId3)) continue;
            return false;
        }
        return true;
    }

    public JsonArray toJsonArray() {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (SpherePolyhedraNeighbourhoodPackingRestriction restriction : this.restrictions) {
            arrayBuilder.add((JsonValue)restriction.toJson());
        }
        return arrayBuilder.build();
    }

    public SpherePolyhedraNeighbourhoodPackingRestrictionSet setToJson(JsonArray restrictionsJsons) {
        return this.setToJson(Jsons.toJsonObjects((JsonArray)restrictionsJsons));
    }

    public SpherePolyhedraNeighbourhoodPackingRestrictionSet setToJson(List<JsonObject> restrictionsJsons) {
        Objects.requireNonNull(restrictionsJsons, "Null restrictionsJsons");
        this.setRestrictions(restrictionsJsons.stream().map(SpherePolyhedraNeighbourhoodPackingRestriction::of).collect(Collectors.toList()));
        return this;
    }

    public String toString() {
        return "restrictions: " + String.valueOf(this.optimized);
    }
}

