/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Objects;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatablePFixedArray;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.objects.SimpleIntSet;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedronDistanceMetric;

class DistanceMetricFinder {
    private static final boolean SELF_CHECK_LIST_AND_ALL = DistanceMetricFinder.getBooleanProperty("net.algart.model3d.spherepolyhedra.objects.DistanceMetricFinder.SELF_CHECK", false);
    private final SpherePolyhedronDistanceMetric metric;
    private final UpdatablePFixedArray voxelArray;
    private final UpdatablePArray voxelDistancesArray;
    final SimpleIntSet indexes = new SimpleIntSet();
    private final SpherePolyhedron workSpherePolyhedron = new SpherePolyhedron();
    private SpherePolyhedra spherePolyhedra = null;
    private int[] randomSpherePolyhedraIndexes = null;
    private int[] voxelValues = null;
    private StraightLine3D straight = null;
    private int voxelNearestIndex;
    private double voxelMinDistance;

    private DistanceMetricFinder(SpherePolyhedronDistanceMetric metric, UpdatablePFixedArray voxelArray, UpdatablePArray voxelDistancesArray) {
        this.metric = Objects.requireNonNull(metric);
        this.voxelArray = Objects.requireNonNull(voxelArray);
        this.voxelDistancesArray = voxelDistancesArray;
    }

    public static DistanceMetricFinder newInstance(SpherePolyhedronDistanceMetric metric, UpdatablePFixedArray resultIndexesArray, UpdatablePArray resultDistancesArray) {
        return new DistanceMetricFinder(metric, resultIndexesArray, resultDistancesArray);
    }

    public void setSpherePolyhedra(SpherePolyhedra spherePolyhedra) {
        this.spherePolyhedra = Objects.requireNonNull(spherePolyhedra);
    }

    public void setRandomSpherePolyhedraIndexes(int[] randomSpherePolyhedraIndexes) {
        this.randomSpherePolyhedraIndexes = Objects.requireNonNull(randomSpherePolyhedraIndexes);
    }

    public void setVoxelValues(int[] voxelValues) {
        this.voxelValues = Objects.requireNonNull(voxelValues);
    }

    public void setStraight(StraightLine3D straight) {
        this.straight = Objects.requireNonNull(straight);
    }

    public void clear() {
        this.indexes.clear();
    }

    public void addIndex(int value) {
        this.indexes.add(value);
    }

    public void removeIndex(int value) {
        this.indexes.remove(value);
    }

    public void findNearestForVoxelSegment(long p, int numberOfVoxels, double startT, double stepT) {
        assert (numberOfVoxels >= 0);
        boolean useDistance = this.voxelDistancesArray != null;
        boolean checkAll = useDistance && this.indexes.size == 0;
        int j = 0;
        while (j < numberOfVoxels) {
            double t = startT + (double)j * stepT;
            double x = this.straight.x(t);
            double y = this.straight.y(t);
            double z = this.straight.z(t);
            if (checkAll) {
                this.findNearestIndexFromAll(x, y, z);
            } else {
                this.findNearestFromList(x, y, z);
                if (SELF_CHECK_LIST_AND_ALL) {
                    int listNearestIndex = this.voxelNearestIndex;
                    double listMinDistance = this.voxelMinDistance;
                    this.findNearestIndexFromAll(x, y, z);
                    if (Math.abs(this.voxelMinDistance - listMinDistance) > 0.001) {
                        this.findNearestFromList(x, y, z);
                        this.findNearestIndexFromAll(x, y, z);
                        throw new AssertionError((Object)("Probably the list does not contain all necessary objects: in the list min distance = " + listMinDistance + " for index " + listNearestIndex + ", but among all objects min distance = " + this.voxelMinDistance + " for index " + this.voxelNearestIndex + "\n  straight: " + String.valueOf(this.straight) + "\n  list: " + String.valueOf(this.indexes) + "\n  startT = " + startT + ", t = " + t + ", (x,y,z) = (" + x + "," + y + "," + z + "), point #" + j + "/" + numberOfVoxels));
                    }
                }
            }
            if (this.voxelNearestIndex >= 0) {
                this.voxelArray.setInt(p, this.voxelValues[this.voxelNearestIndex]);
                if (useDistance) {
                    this.voxelDistancesArray.setDouble(p, this.voxelMinDistance);
                }
            } else if (useDistance) {
                this.voxelDistancesArray.setDouble(p, Double.NaN);
            }
            ++j;
            ++p;
        }
    }

    private void findNearestFromList(double x, double y, double z) {
        boolean distanceToContainingSphereCanBeGreater = this.metric.distanceToContainingSphereCanBeGreater();
        int nearestIndex = -1;
        double minDistance = Double.POSITIVE_INFINITY;
        int n = this.indexes.size;
        for (int k = 0; k < n; ++k) {
            double distance;
            double centerZ;
            double centerY;
            double centerX;
            double containingDistance;
            int index = this.indexes.values[k];
            double r = this.spherePolyhedra.containingSphereRadius(index);
            int i = 4 * index;
            if ((containingDistance = this.metric.distanceToSphere(centerX = this.spherePolyhedra.xyzr[i++], centerY = this.spherePolyhedra.xyzr[i++], centerZ = this.spherePolyhedra.xyzr[i], r, x, y, z)) > minDistance && !distanceToContainingSphereCanBeGreater) continue;
            if (this.spherePolyhedra.isSphere(index)) {
                distance = containingDistance;
            } else {
                double lowerEstimate;
                if (distanceToContainingSphereCanBeGreater && k > 0 && (lowerEstimate = this.metric.distanceLowerEstimate(centerX, centerY, centerZ, r, x, y, z)) > minDistance) continue;
                this.spherePolyhedra.getSpherePolyhedron(this.workSpherePolyhedron, index);
                distance = this.metric.distance(this.workSpherePolyhedron, x, y, z);
            }
            if (!(distance < minDistance) && (distance != minDistance || index <= nearestIndex)) continue;
            nearestIndex = index;
            minDistance = distance;
        }
        this.voxelNearestIndex = nearestIndex;
        this.voxelMinDistance = minDistance;
    }

    private void findNearestIndexFromAll(double x, double y, double z) {
        boolean distanceToContainingSphereCanBeGreater = this.metric.distanceToContainingSphereCanBeGreater();
        int nearestIndex = -1;
        double minDistance = Double.POSITIVE_INFINITY;
        int n = this.spherePolyhedra.numberOfSpherePolyhedra();
        for (int k = 0; k < n; ++k) {
            double distance;
            double centerZ;
            double centerY;
            double centerX;
            double containingDistance;
            int index = this.randomSpherePolyhedraIndexes[k];
            if (this.voxelValues[index] < 0) continue;
            double r = this.spherePolyhedra.containingSphereRadius(index);
            int i = 4 * index;
            if ((containingDistance = this.metric.distanceToSphere(centerX = this.spherePolyhedra.xyzr[i++], centerY = this.spherePolyhedra.xyzr[i++], centerZ = this.spherePolyhedra.xyzr[i], r, x, y, z)) > minDistance && !distanceToContainingSphereCanBeGreater) continue;
            if (this.spherePolyhedra.isSphere(index)) {
                distance = containingDistance;
            } else {
                double lowerEstimate;
                if (distanceToContainingSphereCanBeGreater && nearestIndex != -1 && (lowerEstimate = this.metric.distanceLowerEstimate(centerX, centerY, centerZ, r, x, y, z)) > minDistance) continue;
                this.spherePolyhedra.getSpherePolyhedron(this.workSpherePolyhedron, index);
                distance = this.metric.distance(this.workSpherePolyhedron, x, y, z);
            }
            if (!(distance < minDistance) && (distance != minDistance || index <= nearestIndex)) continue;
            nearestIndex = index;
            minDistance = distance;
        }
        this.voxelNearestIndex = nearestIndex;
        this.voxelMinDistance = minDistance;
    }

    private static boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        try {
            if (defaultValue) {
                return !"false".equalsIgnoreCase(System.getProperty(propertyName));
            }
            return Boolean.getBoolean(propertyName);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

