/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import net.algart.arrays.JArrays;
import net.algart.arrays.MutableDoubleArray;
import net.algart.math.MutableInt128;
import net.algart.math.geometry.Collinearity;
import net.algart.math.geometry.CollinearityException;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.objects.Generatrix;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSegment;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedron;

public final class GeneratrixSet {
    public static final int MAX_NUMBER_OF_GENERATRIX_SEGMENTS = 1024;
    public static final int MANTISSA_PRECISION = 25;
    public static final double MAX_ALLOWED_GENERATRIX_SIZE_RELATION = 524288.0;
    private static final int SERIALIZED_XYZ_OFFSET = 3;
    private static final int SERIALIZED_NUMBER_OF_SEGMENTS_MASK = 4095;
    private static final int SERIALIZED_NUMBER_OF_SEGMENTS_CONTINUATION_FLAG = Integer.MIN_VALUE;
    private static final double MIN_RELATION_OF_MAX_INTEGER_AND_MAX_SEGMENT_LENGTH = 1.2;
    private static final int MIN_ALLOWED_SCALE_FACTOR = GeneratrixSet.minNotLessPowerOfTwoExponent(1.0E-20) - 40;
    private static final int MAX_ALLOWED_SCALE_FACTOR = GeneratrixSet.minNotLessPowerOfTwoExponent(1.0E20) + 10;
    private static final int MAX_NUMBER_OF_GENERATRIX_SEGMENTS_TO_CALCULATE_CONTAINING_RADIUS_SIMPLY = 12;
    private static final double MAX_ALLOWED_GENERATRIX_SIZE_RELATION_INV = 1.9073486328125E-6;
    private static final double MAX_ALLOWED_GENERATRIX_SIZE_RELATION_FOR_SWITCHING_TO_DEFAULT_ADDING_INV = 2.86102294921875E-6;
    public static final GeneratrixSet ZERO = new GeneratrixSet().immutable();
    private double radius = 0.0;
    int scaleFactor = 0;
    double scale = 1.0;
    int numberOfGeneratrixSegments = 0;
    int[] intXYZ = JArrays.EMPTY_INTS;
    int xyzLength = 0;
    double[] segmentHalfLengths = JArrays.EMPTY_DOUBLES;
    private double maxSegmentHalfLength = 0.0;
    private long minVertexX = 0L;
    private long maxVertexX = 0L;
    private long minVertexY = 0L;
    private long maxVertexY = 0L;
    private long minVertexZ = 0L;
    private long maxVertexZ = 0L;
    private boolean immutable = false;
    private volatile double containingSphereRadius = Double.NaN;
    boolean containingSphereRadiusCalculated = false;

    GeneratrixSet() {
    }

    public static GeneratrixSet newSphere(double radius) {
        GeneratrixSet result = new GeneratrixSet();
        result.setToSphere(radius);
        result.immutable();
        return result;
    }

    public static GeneratrixSet newInstance(Generatrix ... generatrices) {
        return GeneratrixSet.newInstance(Arrays.asList(generatrices));
    }

    public static GeneratrixSet newInstance(Collection<? extends Generatrix> generatrices) {
        GeneratrixSet result = new GeneratrixSet();
        result.setTo(generatrices);
        result.immutable();
        return result;
    }

    public static GeneratrixSet deserialize(SerializedForm serialized) {
        Objects.requireNonNull(serialized, "Null serialized form");
        return GeneratrixSet.deserialize(null, serialized.radius, serialized.data, 0).immutable();
    }

    static GeneratrixSet deserialize(GeneratrixSet result, double radius, int[] serialized, int offset) {
        Objects.requireNonNull(serialized, "Null serialized array");
        GeneratrixSet.checkSerializedData(serialized, offset, false);
        int numberOfSegments = GeneratrixSet.deserializeNumberOfSegmens(serialized, offset);
        int scaleFactor = serialized[offset + 1];
        int intRadius = serialized[offset + 2];
        if (Double.isNaN(radius)) {
            radius = GeneratrixSet.radius(scaleFactor, intRadius);
        }
        GeneratrixSphere.checkRadius(radius, false);
        if (result == null) {
            result = new GeneratrixSet();
        }
        if (numberOfSegments == 0) {
            result.setToSphereOnly(radius, scaleFactor);
        } else {
            result.setTo(radius, scaleFactor, serialized, offset + 3, numberOfSegments, false);
        }
        return result;
    }

    static int deserializeNumberOfSegmens(int[] serialized, int offset) {
        return serialized[offset] & 0xFFF;
    }

    static boolean deserializeContinuationFlag(int[] serialized, int offset) {
        return (serialized[offset] & Integer.MIN_VALUE) != 0;
    }

    static double deserializeRadius(int[] serialized, int offset) {
        int scaleFactor = serialized[offset + 1];
        int intRadius = serialized[offset + 2];
        return GeneratrixSet.radius(scaleFactor, intRadius);
    }

    public SerializedForm serialize() {
        return this.serialize(null);
    }

    public SerializedForm serialize(SerializedForm serialized) {
        if (serialized == null) {
            serialized = new SerializedForm();
        }
        return serialized.setRadius(this.radius).setData(this.serializeData(null, 0, false));
    }

    int[] serializeData(int[] result, int offset, boolean continuationFlag) {
        if (result == null) {
            result = new int[SerializedForm.dataLength(this)];
            offset = 0;
        }
        result[offset] = this.numberOfGeneratrixSegments | (continuationFlag ? Integer.MIN_VALUE : 0);
        result[offset + 1] = this.scaleFactor;
        result[offset + 2] = this.intRadius();
        System.arraycopy(this.intXYZ, 0, result, offset + 3, 3 * this.numberOfGeneratrixSegments);
        return result;
    }

    public boolean isZero() {
        return this.radius == 0.0 && this.numberOfGeneratrixSegments == 0;
    }

    public boolean isSphere() {
        return this.numberOfGeneratrixSegments == 0;
    }

    public double generatrixSphereRadius() {
        return this.radius;
    }

    public int numberOfGeneratrixSegments() {
        return this.numberOfGeneratrixSegments;
    }

    public double generatrixSegmentX(int k) {
        this.checkSegmentIndex(k);
        return (double)this.intXYZ[3 * k] * this.scale;
    }

    public double generatrixSegmentY(int k) {
        this.checkSegmentIndex(k);
        return (double)this.intXYZ[3 * k + 1] * this.scale;
    }

    public double generatrixSegmentZ(int k) {
        this.checkSegmentIndex(k);
        return (double)this.intXYZ[3 * k + 2] * this.scale;
    }

    public double generatrixSegmentHalfLength(int k) {
        this.checkSegmentIndex(k);
        return this.segmentHalfLengths[k];
    }

    public double[] allGeneratrixSegmentsXYZ() {
        double[] result = new double[this.xyzLength];
        int k = 0;
        int disp = 0;
        while (k < this.numberOfGeneratrixSegments) {
            result[disp] = this.generatrixSegmentX(k);
            result[disp + 1] = this.generatrixSegmentY(k);
            result[disp + 2] = this.generatrixSegmentZ(k);
            ++k;
            disp += 3;
        }
        return result;
    }

    public double maxGeneratrixSegmentHalfLength() {
        return this.maxSegmentHalfLength;
    }

    public double minX() {
        return (double)this.minVertexX * this.scale - this.radius;
    }

    public double maxX() {
        return (double)this.maxVertexX * this.scale + this.radius;
    }

    public double minY() {
        return (double)this.minVertexY * this.scale - this.radius;
    }

    public double maxY() {
        return (double)this.maxVertexY * this.scale + this.radius;
    }

    public double minZ() {
        return (double)this.minVertexZ * this.scale - this.radius;
    }

    public double maxZ() {
        return (double)this.maxVertexZ * this.scale + this.radius;
    }

    public double containingSphereRadius() {
        return this.containingSphereRadius(null);
    }

    public GeneratrixSet minkowskiSum(GeneratrixSet added) {
        Objects.requireNonNull(added, "Null added generatrix set");
        if (added.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return added;
        }
        return new Builder().addGeneratrixSet(this).addGeneratrixSet(added).build(null).immutable();
    }

    public GeneratrixSet minkowskiSumWithSymmetric() {
        GeneratrixSet result = new GeneratrixSet();
        result.setTo(this);
        result.minkowskiAddSymmetric();
        return result;
    }

    public GeneratrixSet rotate(Orthonormal3DBasis rotationBasis) {
        Objects.requireNonNull(rotationBasis, "Null basis");
        Builder builder = new Builder();
        builder.addSphere(this.generatrixSphereRadius(), true);
        for (int l = 0; l < this.numberOfGeneratrixSegments; ++l) {
            double i = this.generatrixSegmentX(l);
            double j = this.generatrixSegmentY(l);
            double k = this.generatrixSegmentZ(l);
            builder.addSegment(rotationBasis.x(i, j, k), rotationBasis.y(i, j, k), rotationBasis.z(i, j, k), true);
        }
        return builder.build(null).immutable();
    }

    public GeneratrixSet rotateAndScale(Orthonormal3DBasis rotationBasis, double scale) {
        Objects.requireNonNull(rotationBasis, "Null basis");
        Builder builder = new Builder();
        builder.addSphere(this.generatrixSphereRadius() * scale, true);
        for (int l = 0; l < this.numberOfGeneratrixSegments; ++l) {
            double i = this.generatrixSegmentX(l);
            double j = this.generatrixSegmentY(l);
            double k = this.generatrixSegmentZ(l);
            builder.addSegment(scale * rotationBasis.x(i, j, k), scale * rotationBasis.y(i, j, k), scale * rotationBasis.z(i, j, k), true);
        }
        return builder.build(null).immutable();
    }

    public GeneratrixSet symmetry() {
        return this;
    }

    public SpherePolyhedron toSpherePolyhedron() {
        return SpherePolyhedron.newInstance(this);
    }

    public SpherePolyhedron toSpherePolyhedron(long kindId) {
        return SpherePolyhedron.newInstance(this, kindId);
    }

    public SpherePolyhedron toSpherePolyhedron(double centerX, double centerY, double centerZ) {
        return SpherePolyhedron.newInstance(centerX, centerY, centerZ, this);
    }

    public SpherePolyhedron toSpherePolyhedron(double centerX, double centerY, double centerZ, long kindId) {
        return SpherePolyhedron.newInstance(centerX, centerY, centerZ, this, kindId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.numberOfGeneratrixSegments + " segments ");
        for (int k = 0; k < this.numberOfGeneratrixSegments; ++k) {
            sb.append("(").append(this.generatrixSegmentX(k)).append(", ").append(this.generatrixSegmentY(k)).append(", ").append(this.generatrixSegmentZ(k)).append(") + ");
        }
        return sb.append("sphere r=").append(this.generatrixSphereRadius()).append(" (scale ").append(this.scale).append(", max segment half-length ").append(this.maxSegmentHalfLength).append(")").toString();
    }

    public boolean equalsGeometrically(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratrixSet that = (GeneratrixSet)o;
        if (this.numberOfGeneratrixSegments != that.numberOfGeneratrixSegments || this.radius != that.radius) {
            return false;
        }
        for (int k = 0; k < this.xyzLength; ++k) {
            if ((double)this.intXYZ[k] * this.scale == (double)that.intXYZ[k] * that.scale) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratrixSet that = (GeneratrixSet)o;
        if (Double.compare(that.radius, this.radius) != 0 || this.scaleFactor != that.scaleFactor || this.numberOfGeneratrixSegments != that.numberOfGeneratrixSegments) {
            return false;
        }
        for (int k = 0; k < this.xyzLength; ++k) {
            if (this.intXYZ[k] == that.intXYZ[k]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.radius, this.scaleFactor, this.numberOfGeneratrixSegments);
        int max = 3 * this.numberOfGeneratrixSegments;
        for (int k = 0; k < max; ++k) {
            result = 31 * result + this.intXYZ[k];
        }
        return result;
    }

    double containingSphereRadius(SpherePolyhedron workMemory) {
        if (this.isSphere()) {
            return this.radius;
        }
        if (!this.containingSphereRadiusCalculated) {
            this.containingSphereRadius = GeneratrixSet.containingSphereRadius(this.intXYZ, 0, this.numberOfGeneratrixSegments, this.scale, workMemory) + this.radius;
            this.containingSphereRadiusCalculated = true;
        }
        return this.containingSphereRadius;
    }

    void setToSphere(double radius) {
        GeneratrixSphere.checkRadius(radius, false);
        if (this.immutable) {
            throw new AssertionError((Object)"This object is immutable! setToSphere() must not be called!");
        }
        int scaleFactor = GeneratrixSet.minNotLessPowerOfTwoExponent(radius * 1.2) - 25;
        this.setToSphereOnly(radius, scaleFactor);
    }

    void setTo(GeneratrixSet other) {
        Objects.requireNonNull(other, "Null other");
        if (this.immutable) {
            throw new AssertionError((Object)"This object is immutable! setTo(other) must not be called!");
        }
        this.ensureCapacity(other.numberOfGeneratrixSegments);
        this.radius = other.radius;
        this.scaleFactor = other.scaleFactor;
        this.scale = other.scale;
        this.numberOfGeneratrixSegments = other.numberOfGeneratrixSegments;
        this.xyzLength = other.xyzLength;
        System.arraycopy(other.intXYZ, 0, this.intXYZ, 0, this.xyzLength);
        System.arraycopy(other.segmentHalfLengths, 0, this.segmentHalfLengths, 0, this.numberOfGeneratrixSegments);
        this.maxSegmentHalfLength = other.maxSegmentHalfLength;
        this.minVertexX = other.minVertexX;
        this.maxVertexX = other.maxVertexX;
        this.minVertexY = other.minVertexY;
        this.maxVertexY = other.maxVertexY;
        this.minVertexZ = other.minVertexZ;
        this.maxVertexZ = other.maxVertexZ;
        this.containingSphereRadius = other.containingSphereRadius;
        this.containingSphereRadiusCalculated = other.containingSphereRadiusCalculated;
    }

    void setTo(Collection<? extends Generatrix> generatrices) {
        Objects.requireNonNull(generatrices, "Null generatrices");
        Builder builder = new Builder();
        for (Generatrix generatrix : generatrices) {
            Objects.requireNonNull(generatrix, "Null element among generatrices");
            generatrix.add(builder);
        }
        builder.build(this);
    }

    void compactForExternalUsage() {
        assert (this.xyzLength == 3 * this.numberOfGeneratrixSegments);
        assert (this.intXYZ.length == 3 * this.segmentHalfLengths.length);
        if (this.segmentHalfLengths.length > this.numberOfGeneratrixSegments) {
            this.intXYZ = Arrays.copyOf(this.intXYZ, 3 * this.numberOfGeneratrixSegments);
            this.segmentHalfLengths = Arrays.copyOf(this.segmentHalfLengths, this.numberOfGeneratrixSegments);
        }
        this.immutable();
    }

    void setToSymmetry() {
    }

    void minkowskiAdd(GeneratrixSet added) {
        int k;
        int z;
        int y;
        int x;
        Objects.requireNonNull(added, "Null added generatrix set");
        if (this.immutable) {
            throw new AssertionError((Object)"This object is immutable! minkowskiAdd(other) must not be called!");
        }
        if (added.isZero()) {
            return;
        }
        if (this.isZero()) {
            this.setTo(added);
            return;
        }
        GeneratrixSet a = this.scaleFactor >= added.scaleFactor ? this : added;
        GeneratrixSet b = this.scaleFactor >= added.scaleFactor ? added : this;
        this.ensureCapacity(this.numberOfGeneratrixSegments + Math.max(added.numberOfGeneratrixSegments, b.numberOfGeneratrixSegments));
        int shift = a.scaleFactor - b.scaleFactor;
        double newMaxSegmentHalfLength = a.maxGeneratrixSegmentHalfLength();
        int k2 = 0;
        int dispK = 0;
        while (k2 < b.numberOfGeneratrixSegments) {
            double halfLength;
            x = (int)MutableInt128.shiftRightRounding((long)b.intXYZ[dispK], (int)shift);
            y = (int)MutableInt128.shiftRightRounding((long)b.intXYZ[dispK + 1], (int)shift);
            z = (int)MutableInt128.shiftRightRounding((long)b.intXYZ[dispK + 2], (int)shift);
            this.intXYZ[this.xyzLength + dispK] = x;
            this.intXYZ[this.xyzLength + dispK + 1] = y;
            this.intXYZ[this.xyzLength + dispK + 2] = z;
            this.segmentHalfLengths[this.numberOfGeneratrixSegments + k2] = halfLength = Math.sqrt(Orthonormal3DBasis.lengthSquareInteger((long)x, (long)y, (long)z)) * a.scale;
            if (halfLength > newMaxSegmentHalfLength) {
                newMaxSegmentHalfLength = halfLength;
            }
            for (int dispI = 0; dispI < a.xyzLength; dispI += 3) {
                int otherX = a.intXYZ[dispI];
                int otherY = a.intXYZ[dispI + 1];
                int otherZ = a.intXYZ[dispI + 2];
                if (!Collinearity.collinear((int)x, (int)y, (int)z, (int)otherX, (int)otherY, (int)otherZ)) continue;
                this.minkowskiAddSimple(added);
                return;
            }
            ++k2;
            dispK += 3;
        }
        if (shift > 0) {
            int maxDisp = this.xyzLength + b.xyzLength;
            for (int dispK2 = this.xyzLength; dispK2 < maxDisp; dispK2 += 3) {
                x = this.intXYZ[dispK2];
                y = this.intXYZ[dispK2 + 1];
                z = this.intXYZ[dispK2 + 2];
                for (int dispI = this.xyzLength; dispI < maxDisp; dispI += 3) {
                    int otherX = this.intXYZ[dispI];
                    int otherY = this.intXYZ[dispI + 1];
                    int otherZ = this.intXYZ[dispI + 2];
                    if (!Collinearity.collinear((int)x, (int)y, (int)z, (int)otherX, (int)otherY, (int)otherZ)) continue;
                    this.minkowskiAddSimple(added);
                    return;
                }
            }
        }
        double newMaxHalfLengthOrRadius = StrictMath.max(this.radius + added.radius, newMaxSegmentHalfLength);
        double newMinAllowedForSwitchingToDefaultAdding = newMaxHalfLengthOrRadius * 2.86102294921875E-6;
        for (k = 0; k < a.numberOfGeneratrixSegments; ++k) {
            if (!(a.segmentHalfLengths[k] < newMinAllowedForSwitchingToDefaultAdding)) continue;
            this.minkowskiAddSimple(added);
            return;
        }
        for (k = 0; k < b.numberOfGeneratrixSegments; ++k) {
            if (!(this.segmentHalfLengths[this.numberOfGeneratrixSegments + k] < newMinAllowedForSwitchingToDefaultAdding)) continue;
            this.minkowskiAddSimple(added);
            return;
        }
        double newMinAllowed = newMaxHalfLengthOrRadius * 1.9073486328125E-6;
        this.radius += added.radius;
        if (this.radius < newMinAllowed) {
            this.radius = 0.0;
        }
        if (this.scaleFactor < added.scaleFactor) {
            System.arraycopy(this.intXYZ, this.xyzLength, this.intXYZ, 0, this.xyzLength);
            System.arraycopy(this.segmentHalfLengths, this.numberOfGeneratrixSegments, this.segmentHalfLengths, 0, this.numberOfGeneratrixSegments);
            System.arraycopy(added.intXYZ, 0, this.intXYZ, this.xyzLength, added.xyzLength);
            System.arraycopy(added.segmentHalfLengths, 0, this.segmentHalfLengths, this.numberOfGeneratrixSegments, added.numberOfGeneratrixSegments);
        }
        this.maxSegmentHalfLength = newMaxSegmentHalfLength;
        this.scaleFactor = a.scaleFactor;
        this.scale = a.scale;
        this.numberOfGeneratrixSegments += added.numberOfGeneratrixSegments;
        this.xyzLength += added.xyzLength;
        this.containingSphereRadiusCalculated = false;
        if (shift > 0) {
            this.calculateMinMaxVertex();
        } else {
            this.minVertexX += added.minVertexX;
            this.maxVertexX += added.maxVertexX;
            this.minVertexY += added.minVertexY;
            this.maxVertexY += added.maxVertexY;
            this.minVertexZ += added.minVertexZ;
            this.maxVertexZ += added.maxVertexZ;
        }
    }

    void minkowskiAddSymmetric() {
        int k;
        if (this.immutable) {
            throw new AssertionError((Object)"This object is immutable! minkowskiDouble() must not be called!");
        }
        GeneratrixSphere.checkRadius(2.0 * this.radius, true);
        GeneratrixSet.checkScaleFactor(this.scaleFactor + 1);
        double newMaxHalfLengthOrRadius = StrictMath.max(2.0 * this.radius, 2.0 * this.maxSegmentHalfLength);
        double newMinAllowedForSwitchingToDefaultAdding = newMaxHalfLengthOrRadius * 2.86102294921875E-6;
        for (k = 0; k < this.numberOfGeneratrixSegments; ++k) {
            if (!(this.segmentHalfLengths[k] < newMinAllowedForSwitchingToDefaultAdding)) continue;
            this.minkowskiAddSimple(this);
            return;
        }
        this.radius *= 2.0;
        ++this.scaleFactor;
        this.scale *= 2.0;
        if (this.isZero()) {
            this.scaleFactor = 0;
        }
        k = 0;
        while (k < this.numberOfGeneratrixSegments) {
            int n = k++;
            this.segmentHalfLengths[n] = this.segmentHalfLengths[n] * 2.0;
        }
        this.maxSegmentHalfLength *= 2.0;
        this.containingSphereRadius *= 2.0;
    }

    private void minkowskiAddSimple(GeneratrixSet other) {
        new Builder().addGeneratrixSet(this).addGeneratrixSet(other).build(this);
    }

    GeneratrixSet immutable() {
        this.immutable = true;
        return this;
    }

    void checkSegmentIndex(int k) {
        if (k < 0 || k >= this.numberOfGeneratrixSegments) {
            throw new IndexOutOfBoundsException("Segment index " + k + " is out of range 0.." + (this.numberOfGeneratrixSegments - 1));
        }
    }

    static double containingSphereRadiusForSerialized(double radius, int[] serialized, int offset, SpherePolyhedron workMemory) {
        int numberOfSegments = GeneratrixSet.deserializeNumberOfSegmens(serialized, offset);
        GeneratrixSet.checkNumberOfSegments(numberOfSegments);
        if (numberOfSegments == 0) {
            return radius;
        }
        int scaleFactor = serialized[offset + 1];
        return radius + GeneratrixSet.containingSphereRadius(serialized, offset + 3, numberOfSegments, StrictMath.scalb(1.0, scaleFactor), workMemory);
    }

    static int checkSerializedData(int[] serialized, int offset, boolean quickCheck) {
        if (offset + 3 > serialized.length) {
            throw new IndexOutOfBoundsException("Index out of bounds in serialized segments: " + offset + " + 3 > " + serialized.length + " (it must contain at least 3 elements after the offset)");
        }
        int numberOfSegments = GeneratrixSet.deserializeNumberOfSegmens(serialized, offset);
        GeneratrixSet.checkNumberOfSegments(numberOfSegments);
        long newOffset = (long)offset + 3L + 3L * (long)numberOfSegments;
        if (newOffset > (long)serialized.length) {
            throw new IndexOutOfBoundsException("Index out of bounds in serialized segments: " + offset + " + 3 + 3 * " + numberOfSegments + " > " + serialized.length + " (it must contain 3 numbers and also the components of " + numberOfSegments + " segments after the offest)");
        }
        if (quickCheck) {
            return (int)newOffset;
        }
        GeneratrixSet.checkScaleFactor(serialized[offset + 1]);
        GeneratrixSet.checkIntRadius(serialized[offset + 2]);
        if (numberOfSegments == 0) {
            return offset + 3;
        }
        offset += 3;
        int k = 0;
        while (k < numberOfSegments) {
            int x = serialized[offset];
            int y = serialized[offset + 1];
            int z = serialized[offset + 2];
            if (x == 0 && y == 0 && z == 0) {
                throw new IllegalArgumentException("Segment #" + k + " is zero (it's prohibited) in the serialized array of segments starting from the offset " + offset);
            }
            if (Math.abs(x) >>> 25 != 0 || Math.abs(y) >>> 25 != 0 || Math.abs(z) >>> 25 != 0) {
                throw new IllegalArgumentException("Segment #" + k + " is represented as integer with >25 bits: " + x + ", " + y + ", " + z + " (it's prohibited) in the serialized array of segments starting from the offset " + offset);
            }
            for (int dispI = offset + 2; dispI < offset; dispI += 3) {
                int otherX = serialized[dispI];
                int otherY = serialized[dispI + 1];
                int otherZ = serialized[dispI + 2];
                if (!Collinearity.collinear((int)x, (int)y, (int)z, (int)otherX, (int)otherY, (int)otherZ)) continue;
                throw new CollinearityException("Segments #" + k + " and #" + dispI / 3 + " are collinear in the serialized array of segments starting from the offset " + offset);
            }
            ++k;
            offset += 3;
        }
        return offset;
    }

    private GeneratrixSet setToSphereOnly(double radius, int scaleFactor) {
        return this.setTo(radius, scaleFactor, JArrays.EMPTY_INTS, 0, 0, false);
    }

    private GeneratrixSet setTo(double radius, int scaleFactor, int[] intXYZ, int offset, int numberOfGeneratrixSegments, boolean checkAssertion) {
        if (this.immutable) {
            throw new AssertionError((Object)"This object is immutable! setTo() must not be called!");
        }
        GeneratrixSet.checkNumberOfSegments(numberOfGeneratrixSegments);
        this.ensureCapacity(numberOfGeneratrixSegments);
        GeneratrixSphere.checkRadius(radius, true);
        this.containingSphereRadius = Double.NaN;
        this.containingSphereRadiusCalculated = false;
        this.radius = radius;
        this.numberOfGeneratrixSegments = numberOfGeneratrixSegments;
        this.xyzLength = 3 * numberOfGeneratrixSegments;
        if (this.isZero()) {
            scaleFactor = 0;
        }
        this.scaleFactor = scaleFactor;
        this.scale = StrictMath.scalb(1.0, scaleFactor);
        System.arraycopy(intXYZ, offset, this.intXYZ, 0, this.xyzLength);
        if (checkAssertion) {
            for (int dispK = 0; dispK < this.xyzLength; dispK += 3) {
                int x = this.intXYZ[dispK];
                int y = this.intXYZ[dispK + 1];
                int z = this.intXYZ[dispK + 2];
                if (Math.abs(x) >>> 25 != 0 || Math.abs(y) >>> 25 != 0 || Math.abs(z) >>> 25 != 0) {
                    throw new AssertionError((Object)("Segment #" + dispK / 3 + " is represented as integer with >25 bits: " + x + ", " + y + ", " + z + " (it's prohibited)"));
                }
                for (int dispI = 0; dispI < dispK; dispI += 3) {
                    int otherX = this.intXYZ[dispI];
                    int otherY = this.intXYZ[dispI + 1];
                    int otherZ = this.intXYZ[dispI + 2];
                    if (Collinearity.collinear((int)x, (int)y, (int)z, (int)otherX, (int)otherY, (int)otherZ)) {
                        throw new AssertionError((Object)("Segments #" + dispK / 3 + " and #" + dispI / 3 + " are collinear"));
                    }
                }
            }
        }
        double maxSegmentHalfLength = 0.0;
        int k = 0;
        int disp = 0;
        while (k < numberOfGeneratrixSegments) {
            double segmentHalfLength;
            int x = this.intXYZ[disp];
            int y = this.intXYZ[disp + 1];
            int z = this.intXYZ[disp + 2];
            this.segmentHalfLengths[k] = segmentHalfLength = Math.sqrt(Orthonormal3DBasis.lengthSquareInteger((long)x, (long)y, (long)z)) * this.scale;
            if (segmentHalfLength > maxSegmentHalfLength) {
                maxSegmentHalfLength = segmentHalfLength;
            }
            ++k;
            disp += 3;
        }
        this.maxSegmentHalfLength = maxSegmentHalfLength;
        this.calculateMinMaxVertex();
        return this;
    }

    private void calculateMinMaxVertex() {
        long sumAbsX = 0L;
        long sumAbsY = 0L;
        long sumAbsZ = 0L;
        for (int disp = 0; disp < this.xyzLength; disp += 3) {
            int x = this.intXYZ[disp];
            int y = this.intXYZ[disp + 1];
            int z = this.intXYZ[disp + 2];
            sumAbsX += Math.abs((long)x);
            sumAbsY += Math.abs((long)y);
            sumAbsZ += Math.abs((long)z);
        }
        this.minVertexX = -sumAbsX;
        this.maxVertexX = sumAbsX;
        this.minVertexY = -sumAbsY;
        this.maxVertexY = sumAbsY;
        this.minVertexZ = -sumAbsZ;
        this.maxVertexZ = sumAbsZ;
    }

    private void ensureCapacity(int newNumberOfGeneratrixSegments) {
        assert (this.xyzLength == 3 * this.numberOfGeneratrixSegments);
        assert (this.intXYZ.length == 3 * this.segmentHalfLengths.length);
        if (this.segmentHalfLengths.length < newNumberOfGeneratrixSegments) {
            this.intXYZ = Arrays.copyOf(this.intXYZ, 3 * newNumberOfGeneratrixSegments);
            this.segmentHalfLengths = Arrays.copyOf(this.segmentHalfLengths, newNumberOfGeneratrixSegments);
        }
    }

    private int intRadius() {
        return (int)StrictMath.rint(StrictMath.scalb(this.radius, -this.scaleFactor));
    }

    private GeneratrixSet checkIntRadiusAssertion(int intRadius) {
        if (this.intRadius() != intRadius) {
            throw new AssertionError((Object)("intRadius() = " + this.intRadius() + " != " + intRadius + " (radius=" + this.radius + ", scaleFactor=" + this.scaleFactor + ")"));
        }
        return this;
    }

    private static double radius(int scaleFactor, int intRadius) {
        return StrictMath.scalb((double)intRadius, scaleFactor);
    }

    private static void checkNumberOfSegments(int numberOfSegments) {
        if (numberOfSegments < 0) {
            throw new IllegalArgumentException("Negative number of segments " + numberOfSegments);
        }
        if (numberOfSegments > 1024) {
            throw new IllegalArgumentException("Number of segments " + numberOfSegments + " if too large");
        }
    }

    private static void checkScaleFactor(int scaleFactor) {
        if (scaleFactor < MIN_ALLOWED_SCALE_FACTOR) {
            throw new IllegalArgumentException("Too low scale factor: < " + MIN_ALLOWED_SCALE_FACTOR);
        }
        if (scaleFactor > MAX_ALLOWED_SCALE_FACTOR) {
            throw new IllegalArgumentException("Too high scale factor: > " + MAX_ALLOWED_SCALE_FACTOR);
        }
    }

    private static void checkIntRadius(int intRadius) {
        if (intRadius < 0) {
            throw new IllegalArgumentException("Negative integer-coded radius in serialized form: " + intRadius);
        }
    }

    private static int dataLength(int numberOfSegments) {
        return 3 + 3 * numberOfSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double containingSphereRadius(int[] xyz, int offset, int numberOfSegments, double scale, SpherePolyhedron workMemory) {
        if (numberOfSegments < 0) {
            throw new IllegalArgumentException("Negative number of segment");
        }
        if (offset + 3 * numberOfSegments > xyz.length) {
            throw new IndexOutOfBoundsException("Index out of bounds in xyz array of segments: " + offset + " + 3 * " + numberOfSegments + " > " + xyz.length);
        }
        switch (numberOfSegments) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return scale * Math.sqrt(Orthonormal3DBasis.lengthSquareInteger((long)xyz[offset], (long)xyz[offset + 1], (long)xyz[offset + 2]));
            }
            case 2: {
                double x1 = xyz[offset];
                double y1 = xyz[offset + 1];
                double z1 = xyz[offset + 2];
                double x2 = xyz[offset + 3];
                double y2 = xyz[offset + 4];
                double z2 = xyz[offset + 5];
                return scale * Math.sqrt(Math.max(Orthonormal3DBasis.lengthSquare((double)(x1 + x2), (double)(y1 + y2), (double)(z1 + z2)), Orthonormal3DBasis.lengthSquare((double)(x1 - x2), (double)(y1 - y2), (double)(z1 - z2))));
            }
            case 3: {
                double x1 = xyz[offset];
                double y1 = xyz[offset + 1];
                double z1 = xyz[offset + 2];
                double x2 = xyz[offset + 3];
                double y2 = xyz[offset + 4];
                double z2 = xyz[offset + 5];
                double x3 = xyz[offset + 6];
                double y3 = xyz[offset + 7];
                double z3 = xyz[offset + 8];
                return scale * Math.sqrt(Math.max(Math.max(Orthonormal3DBasis.lengthSquare((double)(x1 + x2 + x3), (double)(y1 + y2 + y3), (double)(z1 + z2 + z3)), Orthonormal3DBasis.lengthSquare((double)(x1 - x2 + x3), (double)(y1 - y2 + y3), (double)(z1 - z2 + z3))), Math.max(Orthonormal3DBasis.lengthSquare((double)(x1 + x2 - x3), (double)(y1 + y2 - y3), (double)(z1 + z2 - z3)), Orthonormal3DBasis.lengthSquare((double)(x1 - x2 - x3), (double)(y1 - y2 - y3), (double)(z1 - z2 - z3)))));
            }
        }
        if (numberOfSegments <= 12) {
            double x1 = xyz[offset];
            double y1 = xyz[offset + 1];
            double z1 = xyz[offset + 2];
            return scale * Math.sqrt(GeneratrixSet.maxDistanceSqr(x1, y1, z1, xyz, offset + 3, numberOfSegments - 1));
        }
        GeneratrixSet generatrixSet = new GeneratrixSet().setTo(0.0, 0, xyz, offset, numberOfSegments, true);
        if (workMemory == null) {
            workMemory = new SpherePolyhedron();
        }
        SpherePolyhedron spherePolyhedron = workMemory;
        synchronized (spherePolyhedron) {
            workMemory.setGeneratrixSet(generatrixSet);
            return scale * workMemory.containingSphereRadius();
        }
    }

    private static double maxDistanceSqr(double sumX, double sumY, double sumZ, int[] xyz, int offset, int numberOfSegments) {
        double maxDistanceSqr2;
        if (numberOfSegments == 0) {
            return Orthonormal3DBasis.lengthSquare((double)sumX, (double)sumY, (double)sumZ);
        }
        double x = xyz[offset];
        double y = xyz[offset + 1];
        double z = xyz[offset + 2];
        double maxDistanceSqr1 = GeneratrixSet.maxDistanceSqr(sumX + x, sumY + y, sumZ + z, xyz, offset + 3, numberOfSegments - 1);
        return maxDistanceSqr1 > (maxDistanceSqr2 = GeneratrixSet.maxDistanceSqr(sumX - x, sumY - y, sumZ - z, xyz, offset + 3, numberOfSegments - 1)) ? maxDistanceSqr1 : maxDistanceSqr2;
    }

    private static int minNotLessPowerOfTwoExponent(double nonNegativeValue) {
        if (nonNegativeValue < 0.0) {
            throw new AssertionError((Object)"Argument must be non-negative");
        }
        if (nonNegativeValue == 0.0) {
            return 0;
        }
        assert (!Double.isNaN(nonNegativeValue));
        assert (!Double.isInfinite(nonNegativeValue));
        double x = 1.0;
        int result = 0;
        while (x * 0.5 >= nonNegativeValue) {
            x *= 0.5;
            --result;
        }
        while (x < nonNegativeValue) {
            x *= 2.0;
            ++result;
        }
        assert (StrictMath.scalb(1.0, result) == x);
        return result;
    }

    public static final class SerializedForm {
        public static final int DATA_BLOCK_LENGTH = 3;
        private double radius = Double.NaN;
        private int[] data = JArrays.EMPTY_INTS;

        public double getRadius() {
            return this.radius;
        }

        public SerializedForm setRadius(double radius) {
            this.radius = radius;
            return this;
        }

        public int[] getData() {
            return this.data;
        }

        public SerializedForm setData(int[] data) {
            this.data = Objects.requireNonNull(data);
            return this;
        }

        public String toString() {
            return "serialized generatrix set: " + this.radius + ", " + Arrays.toString(this.data);
        }

        public static int dataLength(GeneratrixSet generatrixSet) {
            return GeneratrixSet.dataLength(generatrixSet.numberOfGeneratrixSegments);
        }
    }

    static class Builder {
        private double sphereRadius = 0.0;
        private boolean closed = false;
        private final MutableDoubleArray segmentsX = net.algart.arrays.Arrays.SMM.newEmptyDoubleArray();
        private final MutableDoubleArray segmentsY = net.algart.arrays.Arrays.SMM.newEmptyDoubleArray();
        private final MutableDoubleArray segmentsZ = net.algart.arrays.Arrays.SMM.newEmptyDoubleArray();

        Builder() {
        }

        public Builder addGeneratrixSet(GeneratrixSet generatrixSet) {
            this.addSphere(generatrixSet.generatrixSphereRadius(), true);
            for (int k = 0; k < generatrixSet.numberOfGeneratrixSegments; ++k) {
                this.addSegment(generatrixSet.generatrixSegmentX(k), generatrixSet.generatrixSegmentY(k), generatrixSet.generatrixSegmentZ(k), true);
            }
            return this;
        }

        public GeneratrixSet build(GeneratrixSet result) {
            if (result == null) {
                result = new GeneratrixSet();
            }
            this.closed = true;
            assert (this.segmentsX.length() < 0x2AAAAAAAL) : "Check for MAX_NUMBER_OF_GENERATRIX_SEGMENTS was not performed!";
            double[] doubleX = this.segmentsX.toJavaArray();
            double[] doubleY = this.segmentsY.toJavaArray();
            double[] doubleZ = this.segmentsZ.toJavaArray();
            int n = doubleX.length;
            int[] intXYZ = new int[3 * n];
            boolean[] removed = new boolean[n];
            while (true) {
                double maxHalfLengthOrRadius = StrictMath.max(this.sphereRadius, Builder.maxHalfLength(doubleX, doubleY, doubleZ, n));
                int scaleFactor = GeneratrixSet.minNotLessPowerOfTwoExponent(maxHalfLengthOrRadius * 1.2) - 25;
                double scale = StrictMath.scalb(1.0, scaleFactor);
                double scaleInv = 1.0 / scale;
                if (n == 0) {
                    int intRadius = (int)StrictMath.rint(this.sphereRadius * scaleInv);
                    return result.setToSphereOnly(this.sphereRadius, scaleFactor).checkIntRadiusAssertion(intRadius);
                }
                Builder.roundDoubles(intXYZ, doubleX, doubleY, doubleZ, scaleFactor, n);
                JArrays.fillBooleanArray((boolean[])removed, (int)0, (int)n, (boolean)false);
                int k = 0;
                int dispK = 0;
                while (k < n) {
                    int x = intXYZ[dispK];
                    int y = intXYZ[dispK + 1];
                    int z = intXYZ[dispK + 2];
                    if (x == 0 && y == 0 && z == 0) {
                        removed[k] = true;
                    } else {
                        int i = 0;
                        int dispI = 0;
                        while (i < k) {
                            int otherZ;
                            int otherY;
                            int otherX;
                            if (!removed[i] && Collinearity.collinear((int)x, (int)y, (int)z, (int)(otherX = intXYZ[dispI]), (int)(otherY = intXYZ[dispI + 1]), (int)(otherZ = intXYZ[dispI + 2]))) {
                                if (Collinearity.alsoCodirectional((long)x, (long)y, (long)z, (long)otherX, (long)otherY, (long)otherZ)) {
                                    int n2 = i;
                                    doubleX[n2] = doubleX[n2] + doubleX[k];
                                    int n3 = i;
                                    doubleY[n3] = doubleY[n3] + doubleY[k];
                                    int n4 = i;
                                    doubleZ[n4] = doubleZ[n4] + doubleZ[k];
                                } else {
                                    int n5 = i;
                                    doubleX[n5] = doubleX[n5] - doubleX[k];
                                    int n6 = i;
                                    doubleY[n6] = doubleY[n6] - doubleY[k];
                                    int n7 = i;
                                    doubleZ[n7] = doubleZ[n7] - doubleZ[k];
                                }
                                removed[k] = true;
                                break;
                            }
                            ++i;
                            dispI += 3;
                        }
                    }
                    ++k;
                    dispK += 3;
                }
                int count = 0;
                for (int k2 = 0; k2 < n; ++k2) {
                    if (removed[k2]) continue;
                    doubleX[count] = doubleX[k2];
                    doubleY[count] = doubleY[k2];
                    doubleZ[count] = doubleZ[k2];
                    ++count;
                }
                boolean collinearFound = count < n;
                n = count;
                if (collinearFound) continue;
                maxHalfLengthOrRadius = StrictMath.max(this.sphereRadius, Builder.maxHalfLength(doubleX, doubleY, doubleZ, n));
                double minAllowed = maxHalfLengthOrRadius * 1.9073486328125E-6;
                if (this.sphereRadius < minAllowed) {
                    this.sphereRadius = 0.0;
                }
                count = 0;
                for (int k3 = 0; k3 < n; ++k3) {
                    if (!(Orthonormal3DBasis.length((double)doubleX[k3], (double)doubleY[k3], (double)doubleZ[k3]) >= minAllowed)) continue;
                    doubleX[count] = doubleX[k3];
                    doubleY[count] = doubleY[k3];
                    doubleZ[count] = doubleZ[k3];
                    ++count;
                }
                if (count == n) {
                    int intRadius = (int)StrictMath.rint(this.sphereRadius * scaleInv);
                    return result.setTo(this.sphereRadius, scaleFactor, intXYZ, 0, n, true).checkIntRadiusAssertion(intRadius);
                }
                n = count;
            }
        }

        void addSphere(double radius, boolean weakenedCheck) {
            this.checkClosed();
            GeneratrixSphere.checkRadius(radius, weakenedCheck);
            if (radius < 1.0E-20) {
                return;
            }
            this.sphereRadius += radius;
        }

        void addSegment(double x, double y, double z, boolean weakenedCheck) {
            this.checkClosed();
            if (this.segmentsX.length() >= 1024L) {
                throw new IllegalStateException("Cannot add more than 1024 generatrix segments");
            }
            GeneratrixSegment.checkSegment(x, y, z, weakenedCheck);
            if (x * x + y * y + z * z < 1.0E-40) {
                return;
            }
            this.segmentsX.pushDouble(x);
            this.segmentsY.pushDouble(y);
            this.segmentsZ.pushDouble(z);
        }

        private void checkClosed() {
            if (this.closed) {
                throw new AssertionError((Object)"Builder cannot be used after build");
            }
        }

        private static double maxHalfLength(double[] x, double[] y, double[] z, int n) {
            double maxHalfLength = 0.0;
            for (int k = 0; k < n; ++k) {
                double halfLength = Orthonormal3DBasis.length((double)x[k], (double)y[k], (double)z[k]);
                if (!(halfLength > maxHalfLength)) continue;
                maxHalfLength = halfLength;
            }
            return maxHalfLength;
        }

        private static void roundDoubles(int[] resultXYZ, double[] valuesX, double[] valuesY, double[] valuesZ, int scaleFactor, int n) {
            int k = 0;
            int disp = 0;
            while (k < n) {
                resultXYZ[disp] = (int)StrictMath.rint(StrictMath.scalb(valuesX[k], -scaleFactor));
                resultXYZ[disp + 1] = (int)StrictMath.rint(StrictMath.scalb(valuesY[k], -scaleFactor));
                resultXYZ[disp + 2] = (int)StrictMath.rint(StrictMath.scalb(valuesZ[k], -scaleFactor));
                valuesX[k] = StrictMath.scalb((double)resultXYZ[disp], scaleFactor);
                valuesY[k] = StrictMath.scalb((double)resultXYZ[disp + 1], scaleFactor);
                valuesZ[k] = StrictMath.scalb((double)resultXYZ[disp + 2], scaleFactor);
                ++k;
                disp += 3;
            }
        }
    }
}

