/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

class Polynom {
    public static final int MAXPOWER = 16;
    public int N = 0;
    public double[] A = new double[17];
    public double rootTol = 0.0;
    public double factorTol = 0.0;
    public double valueTol = 0.0;
    public static double machEps = 1.0E-12;
    public static double machEpsSqrt = Math.sqrt(machEps);
    private double polyRootDist = 0.0;
    private double polyFactorEps = 0.0;
    private double polyValueEps = 0.0;
    private static final double OneThird = 0.3333333333333333;
    private static final double PIThird = 1.0471975511965976;

    public Polynom() {
        this.A[0] = 0.0;
    }

    public void polynomInit() {
        this.polyRootDist = this.rootTol * machEpsSqrt;
        this.polyFactorEps = this.factorTol * machEps;
        this.polyValueEps = this.valueTol * machEpsSqrt;
    }

    public void poly0(double f0) {
        this.A[0] = f0;
        this.N = 0;
    }

    public void poly1(double f0, double f1) {
        this.A[0] = f0;
        this.A[1] = f1;
        this.N = 1;
    }

    public void poly2(double f0, double f1, double f2) {
        this.A[0] = f0;
        this.A[1] = f1;
        this.A[2] = f2;
        this.N = 2;
    }

    public void poly3(double f0, double f1, double f2, double f3) {
        this.A[0] = f0;
        this.A[1] = f1;
        this.A[2] = f2;
        this.A[3] = f3;
        this.N = 3;
    }

    public void poly4(double f0, double f1, double f2, double f3, double f4) {
        this.A[0] = f0;
        this.A[1] = f1;
        this.A[2] = f2;
        this.A[3] = f3;
        this.A[4] = f4;
        this.N = 4;
    }

    public void copyTo(Polynom dest) {
        dest.N = this.N;
        System.arraycopy(this.A, 0, dest.A, 0, this.N + 1);
    }

    public double value(double x) {
        double result = this.A[this.N];
        for (int i = this.N - 1; i >= 0; --i) {
            result = result * x + this.A[i];
        }
        return result;
    }

    public void sum(Polynom p1, Polynom p2) {
        if (p1.N >= p2.N) {
            for (int i = 0; i <= p2.N; ++i) {
                this.A[i] = p1.A[i] + p2.A[i];
            }
            System.arraycopy(p1.A, p2.N + 1, this.A, p2.N + 1, p1.N - p2.N);
            this.N = p1.N;
        } else {
            for (int i = 0; i <= p1.N; ++i) {
                this.A[i] = p1.A[i] + p2.A[i];
            }
            System.arraycopy(p2.A, p1.N + 1, this.A, p1.N + 1, p2.N - p1.N);
            this.N = p2.N;
        }
    }

    public void diff(Polynom p1, Polynom p2) {
        if (p1.N >= p2.N) {
            for (int i = 0; i <= p2.N; ++i) {
                this.A[i] = p1.A[i] - p2.A[i];
            }
            System.arraycopy(p1.A, p2.N + 1, this.A, p2.N + 1, p1.N - p2.N);
            this.N = p1.N;
        } else {
            int i;
            for (i = 0; i <= p1.N; ++i) {
                this.A[i] = p1.A[i] - p2.A[i];
            }
            for (i = p1.N + 1; i <= p2.N; ++i) {
                this.A[i] = -p2.A[i];
            }
            this.N = p2.N;
        }
    }

    public void prod(Polynom p1, Polynom p2) {
        int i;
        this.N = p1.N + p2.N;
        for (i = 0; i <= this.N; ++i) {
            this.A[i] = 0.0;
        }
        for (i = 0; i <= p1.N; ++i) {
            double mul = p1.A[i];
            int power = i;
            for (int j = 0; j <= p2.N; ++j) {
                int n = power++;
                this.A[n] = this.A[n] + mul * p2.A[j];
            }
        }
    }

    public void prod(Polynom p1, double p2) {
        this.N = p1.N;
        for (int i = 0; i <= p1.N; ++i) {
            this.A[i] = p1.A[i] * p2;
        }
    }

    public void divRoot(Polynom p, double root) {
        if (p.N == 0) {
            return;
        }
        this.N = p.N - 1;
        this.A[this.N] = p.A[p.N];
        for (int i = this.N - 1; i >= 0; --i) {
            this.A[i] = p.A[i + 1] + root * this.A[i + 1];
        }
    }

    public void normalize() {
        double scale = 1.0 / this.A[this.N];
        int i = 0;
        while (i < this.N) {
            int n = i++;
            this.A[n] = this.A[n] * scale;
        }
        this.A[this.N] = 1.0;
    }

    public int rootsP2(double a, double b, double[] roots, int ofs) {
        double d;
        double scale = Math.max(Math.abs(a *= 0.5), Math.sqrt(Math.abs(b)));
        if (scale == 0.0) {
            roots[ofs] = 0.0;
            return 1;
        }
        if ((d = (a /= scale) * a - (b = b / scale / scale)) < 0.0) {
            return 0;
        }
        if (d == 0.0) {
            roots[ofs] = -a * scale;
            return 1;
        }
        d = Math.sqrt(d);
        if (a < 0.0) {
            roots[ofs + 1] = (d -= a) * scale;
            roots[ofs] = b / d * scale;
        } else {
            d = -d - a;
            roots[ofs] = d * scale;
            roots[ofs + 1] = b / d * scale;
        }
        return 2;
    }

    private double cubeRoot(double v) {
        if (v > 0.0) {
            return Math.pow(v, 0.3333333333333333);
        }
        if (v == 0.0) {
            return 0.0;
        }
        return -Math.pow(-v, 0.3333333333333333);
    }

    public int rootsP3(double a, double b, double c, double[] roots, int ofs) {
        double tmp;
        double a3 = a * 0.3333333333333333;
        double p = b * 0.3333333333333333 - a3 * a3;
        double q = (a3 * b - c) * 0.5 - a3 * a3 * a3;
        double scale = Math.max(Math.sqrt(Math.abs(p)), this.cubeRoot(Math.abs(q)));
        if (scale == 0.0) {
            roots[ofs] = -a3;
            return 1;
        }
        p = p / scale / scale;
        q = q / scale / scale / scale;
        if (p == 0.0) {
            roots[ofs] = this.cubeRoot(q * 2.0) * scale - a3;
            return 1;
        }
        if (q == 0.0) {
            if (p < 0.0) {
                p = Math.sqrt(-p * 3.0) * scale;
                roots[ofs] = -p - a3;
                roots[ofs + 1] = -a3;
                roots[ofs + 2] = p - a3;
                return 3;
            }
            roots[ofs] = -a3;
            return 1;
        }
        double qq = p * p * p + q * q;
        if (Math.abs(qq) <= 1.0E-12) {
            q = this.cubeRoot(q) * scale;
            if (qq > 0.0) {
                roots[ofs] = -q - a3;
                roots[ofs + 1] = 2.0 * q - a3;
            } else {
                roots[ofs] = 2.0 * q - a3;
                roots[ofs + 1] = -q - a3;
            }
            return 2;
        }
        if (qq > 0.0) {
            qq = Math.sqrt(qq);
            roots[ofs] = (this.cubeRoot(q + qq) + this.cubeRoot(q - qq)) * scale - a3;
            return 1;
        }
        double tga = Math.sqrt(-qq) / q;
        double alpha = Math.atan(tga);
        if (alpha < 0.0) {
            alpha = Math.PI + alpha;
        }
        p = 2.0 * Math.sqrt(-p) * scale;
        double r1 = p * Math.cos(alpha *= 0.3333333333333333) - a3;
        double r2 = -p * Math.cos(alpha + 1.0471975511965976) - a3;
        double r3 = -p * Math.cos(alpha - 1.0471975511965976) - a3;
        if (r1 > r2) {
            tmp = r1;
            r1 = r2;
            r2 = tmp;
        }
        if (r2 > r3) {
            tmp = r2;
            r2 = r3;
            r3 = tmp;
        }
        if (r1 > r2) {
            tmp = r1;
            r1 = r2;
            r2 = tmp;
        }
        roots[ofs] = r1;
        roots[ofs + 1] = r2;
        roots[ofs + 2] = r3;
        return 3;
    }

    public int rootsP4(double a, double b, double c, double d, double[] roots, int ofs) {
        this.rootsP3(-b, a * c - 4.0 * d, 4.0 * b * d - a * a * d - c * c, roots, ofs);
        double cr1 = roots[ofs];
        double a2 = a * 0.5;
        double ra = a2 * a2 - b + cr1;
        double rc = cr1 * cr1 * 0.25 - d;
        if (ra < -this.polyRootDist || rc < -this.polyRootDist) {
            return 0;
        }
        ra = ra < 0.0 ? 0.0 : Math.sqrt(ra);
        double d2 = rc = rc < 0.0 ? 0.0 : Math.sqrt(rc);
        if (a2 * cr1 - c < 0.0) {
            rc = -rc;
        }
        switch (this.rootsP2(a2 - ra, cr1 * 0.5 - rc, roots, ofs)) {
            case 0: {
                return this.rootsP2(a2 + ra, cr1 * 0.5 + rc, roots, ofs);
            }
            case 1: {
                double tmp;
                double rt1 = roots[ofs];
                int result = 1 + this.rootsP2(a2 + ra, cr1 * 0.5 + rc, roots, ofs);
                if (result == 1) {
                    return 1;
                }
                double rt2 = roots[ofs];
                double rt3 = roots[ofs + 1];
                if (result > 1 && Math.abs(rt1 - rt2) <= this.polyRootDist && --result > 1) {
                    rt2 = rt3;
                }
                if (result > 2 && Math.abs(rt1 - rt3) <= this.polyRootDist) {
                    --result;
                }
                if (result > 1 && rt1 > rt2) {
                    tmp = rt1;
                    rt1 = rt2;
                    rt2 = tmp;
                }
                if (result > 2 && rt2 > rt3) {
                    tmp = rt2;
                    rt2 = rt3;
                    rt3 = tmp;
                }
                roots[ofs] = rt1;
                if (result > 1) {
                    roots[ofs + 1] = rt2;
                }
                if (result > 2) {
                    roots[ofs + 2] = rt3;
                }
                return result;
            }
            case 2: {
                double tmp;
                double rt1 = roots[ofs];
                double rt2 = roots[ofs + 1];
                int result = 2 + this.rootsP2(a2 + ra, cr1 * 0.5 + rc, roots, ofs);
                if (result == 2) {
                    return 2;
                }
                double rt3 = roots[ofs];
                double rt4 = roots[ofs + 1];
                if (result > 2 && (Math.abs(rt1 - rt3) <= this.polyRootDist || Math.abs(rt2 - rt3) <= this.polyRootDist) && --result > 2) {
                    if (Math.abs(rt1 - rt4) <= this.polyRootDist || Math.abs(rt2 - rt4) <= this.polyRootDist) {
                        --result;
                    } else {
                        rt3 = rt4;
                    }
                }
                if (result > 3 && (Math.abs(rt1 - rt4) <= this.polyRootDist || Math.abs(rt2 - rt4) <= this.polyRootDist)) {
                    --result;
                }
                if (result > 2 && rt2 > rt3) {
                    tmp = rt2;
                    rt2 = rt3;
                    rt3 = tmp;
                    if (rt1 > rt2) {
                        tmp = rt1;
                        rt1 = rt2;
                        rt2 = tmp;
                    }
                }
                if (result > 3 && rt3 > rt4) {
                    tmp = rt3;
                    rt3 = rt4;
                    rt4 = tmp;
                    if (rt2 > rt3) {
                        tmp = rt2;
                        rt2 = rt3;
                        rt3 = tmp;
                    }
                }
                roots[ofs] = rt1;
                roots[ofs + 1] = rt2;
                if (result > 2) {
                    roots[ofs + 2] = rt3;
                }
                if (result > 3) {
                    roots[ofs + 3] = rt4;
                }
                return result;
            }
        }
        return 0;
    }

    public double zeroIn(double ax, double bx, double tol, double eps) {
        double d;
        double a = ax;
        double b = bx;
        double c = a;
        double fa = this.value(a);
        double fb = this.value(b);
        double fc = fa;
        double e = d = b - a;
        boolean f1 = false;
        while (true) {
            if (f1) {
                c = a;
                fc = fa;
                e = d = b - a;
            }
            if (Math.abs(fc) < Math.abs(fb)) {
                a = b;
                fa = fb;
                b = c;
                fb = fc;
                c = a;
                fc = fa;
            }
            double tol1 = 2.0 * eps * Math.abs(b) + 0.5 * tol;
            double xm = 0.5 * (c - b);
            if (Math.abs(xm) <= tol1 || fb == 0.0) break;
            if (Math.abs(e) >= tol1 && Math.abs(fa) >= Math.abs(fb)) {
                double q;
                double p;
                if (a == c) {
                    s = fb / fa;
                    p = 2.0 * xm * s;
                    q = 1.0 - s;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    s = fb / fa;
                    p = s * (2.0 * xm * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                }
                if (2.0 * (p = Math.abs(p)) < 3.0 * xm * q - Math.abs(tol1 * q) && p < Math.abs(0.5 * e * q)) {
                    e = d;
                    d = p / q;
                } else {
                    e = d = xm;
                }
            } else {
                e = d = xm;
            }
            a = b;
            fa = fb;
            b = Math.abs(d) > tol1 ? (b += d) : (xm >= 0.0 ? (b += tol1) : (b -= tol1));
            fb = this.value(b);
            f1 = fb * (fc / Math.abs(fc)) > 0.0;
        }
        return b;
    }

    public double rootRightBound() {
        int k;
        for (k = this.N - 1; this.A[k] >= 0.0 && k > 0; --k) {
        }
        if (k > 0) {
            double q = 0.0;
            for (int i = 0; i <= k; ++i) {
                if (!(this.A[i] < q)) continue;
                q = this.A[i];
            }
            return 1.0 + Math.pow(-q, 1.0 / (double)(this.N - k));
        }
        return 1.0;
    }

    public double rootLeftBound() {
        int istart;
        int i;
        for (i = istart = 1 - (this.N & 1); i < this.N; i += 2) {
            this.A[i] = -this.A[i];
        }
        double result = -this.rootRightBound();
        for (i = istart; i < this.N; i += 2) {
            this.A[i] = -this.A[i];
        }
        return result;
    }

    public int reduction() {
        while (Math.abs(this.A[this.N]) <= this.polyFactorEps && this.N > 0) {
            --this.N;
        }
        if (this.N == 0) {
            return 0;
        }
        int result = 0;
        for (int i = 0; i < this.N && Math.abs(this.A[i]) <= this.polyFactorEps; ++i) {
            ++result;
        }
        if (result == 0) {
            return 0;
        }
        System.arraycopy(this.A, result, this.A, 0, this.N - result + 1);
        this.N -= result;
        return result;
    }

    public boolean checkDegeneracy() {
        for (int i = 0; i <= this.N; ++i) {
            if (!(Math.abs(this.A[i]) > this.polyFactorEps)) continue;
            return false;
        }
        return true;
    }

    public void derivative(Polynom dest) {
        if (this.N == 0) {
            return;
        }
        dest.N = this.N - 1;
        dest.A[this.N - 1] = this.A[this.N];
        double rN = 1.0 / (double)this.N;
        int i = 0;
        int j = 1;
        while (i < this.N - 1) {
            dest.A[i] = this.A[j] * (double)j * rN;
            ++i;
            ++j;
        }
    }

    private int sparseRoots(int nroots, double[] roots) {
        if (nroots > 1) {
            for (int i = 1; i < nroots; ++i) {
                if (!(Math.abs(roots[i - 1] - roots[i]) <= this.polyRootDist)) continue;
                System.arraycopy(roots, i + 1, roots, i, --nroots - i);
            }
        }
        return nroots;
    }

    public int findRoots(Polynom[] d, double[] roots) {
        int i;
        switch (this.N) {
            case 0: {
                return 0;
            }
            case 1: {
                roots[0] = -this.A[0];
                return 1;
            }
            case 2: {
                return this.rootsP2(this.A[1], this.A[0], roots, 0);
            }
            case 3: {
                int nr = this.rootsP3(this.A[2], this.A[1], this.A[0], roots, 0);
                return this.sparseRoots(nr, roots);
            }
            case 4: {
                int nr = this.rootsP4(this.A[3], this.A[2], this.A[1], this.A[0], roots, 0);
                return this.sparseRoots(nr, roots);
            }
        }
        double proot = 0.0;
        double bx = 0.0;
        boolean ra = false;
        boolean rb = false;
        this.copyTo(d[this.N - 4]);
        for (i = this.N - 5; i >= 0; --i) {
            d[i + 1].derivative(d[i]);
        }
        int nr1 = this.rootsP4(d[0].A[3], d[0].A[2], d[0].A[1], d[0].A[0], roots, 0);
        nr1 = this.sparseRoots(nr1, roots);
        for (i = 1; i <= this.N - 4; ++i) {
            int r2;
            double ax = d[i].rootLeftBound();
            double cx = d[i].rootRightBound();
            if (nr1 == 0) {
                r1 = 0;
                r2 = -1;
            } else {
                r1 = 0;
                while (!(roots[r1] > ax) && ++r1 != nr1) {
                }
                r2 = nr1 - 1;
                while (!(roots[r2] < cx) && --r2 != 0) {
                }
            }
            int nr2 = 0;
            double fa = d[i].value(ax);
            ra = Math.abs(fa) <= this.polyValueEps;
            for (int k = r1; k <= r2 + 1; ++k) {
                bx = k < r2 + 1 ? roots[k] : cx;
                double fb = d[i].value(bx);
                boolean bl = rb = Math.abs(fb) <= this.polyValueEps;
                if (ra) {
                    if (nr2 == 0 || Math.abs(proot - ax) > this.polyRootDist) {
                        roots[nr2] = ax;
                        proot = ax;
                        ++nr2;
                    }
                } else if (!rb && (fa < 0.0 && fb > 0.0 || fa > 0.0 && fb < 0.0)) {
                    ax = d[i].zeroIn(ax, bx, this.polyRootDist, machEps);
                    if (nr2 == 0 || Math.abs(proot - ax) > this.polyRootDist) {
                        roots[nr2] = ax;
                        proot = ax;
                        ++nr2;
                    }
                }
                ax = bx;
                fa = fb;
                ra = rb;
            }
            if (rb) {
                roots[nr2] = bx;
            }
            nr1 = ++nr2;
        }
        return nr1;
    }
}

