/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.algart.arrays.TooLargeArrayException;
import net.algart.executors.api.data.SNumbers;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;

public final class SerializedSpherePolyhedra {
    public static final String ENTRY_FOLDER = "spherepolyhedra";
    public static final String XYZR_ENTRY = "xyzr.dat";
    public static final String XYZ_ENTRY = "xyz.dat";
    public static final String GENERATRIX_SETS_ENTRY = "generatrix_sets.dat";
    public static final String KINDS_ENTRY = "kinds.dat";
    public static final String KIND_SET_ENTRY = "kind_set.json";
    public static final String PACKING_GEOMETRY_ENTRY = "packing_geometry.json";
    public static final int XYZR_BLOCK_LENGTH = 4;
    private static final int RECOMMENDED_SERIALIZED_BLOCK_LENGTH = 3;
    double[] xyzr = null;
    double[] xyz = null;
    int[] serializedGeneratrixSets = null;
    long[] kindIds = null;

    public double[] getXyzr() {
        return this.xyzr;
    }

    public SerializedSpherePolyhedra setXyzr(double[] xyzr) {
        if (xyzr != null && xyzr.length % 4 != 0) {
            throw new IllegalArgumentException("xyzr array must contain 4*n elements, but its length is " + xyzr.length);
        }
        this.xyzr = xyzr;
        return this;
    }

    public SerializedSpherePolyhedra setXyz(double[] xyz) {
        if (xyz != null && xyz.length % 3 != 0) {
            throw new IllegalArgumentException("xyzr array must contain 4*n elements, but its length is " + xyz.length);
        }
        this.xyz = xyz;
        return this;
    }

    public SerializedSpherePolyhedra setCoordinates(double[] coordinates, int numbersPerElement) {
        if (coordinates == null) {
            return this.setXyzr(null).setXyz(null);
        }
        if (numbersPerElement == 4) {
            return this.setXyzr(coordinates).setXyz(null);
        }
        if (numbersPerElement == 3) {
            return this.setXyz(coordinates).setXyzr(null);
        }
        throw new IllegalArgumentException("Only XYZR (4 numbers per element) or XYZ (3 numbers per element) serialized forms are allowed, but " + numbersPerElement + " numbers per element passed");
    }

    public int[] getSerializedGeneratrixSets() {
        return this.serializedGeneratrixSets;
    }

    public SerializedSpherePolyhedra setSerializedGeneratrixSets(int[] serializedGeneratrixSets) {
        SerializedSpherePolyhedra.checkSerializedGeneratrixSets(serializedGeneratrixSets);
        this.serializedGeneratrixSets = serializedGeneratrixSets;
        return this;
    }

    public long[] getKindIds() {
        return this.kindIds;
    }

    public SerializedSpherePolyhedra setKindIds(long[] kindIds) {
        this.kindIds = kindIds;
        return this;
    }

    public int serializedGeneratrixSetsBlockLength() {
        return 3;
    }

    public int numberOfSpherePolyhedra() {
        int n;
        if (this.xyzr != null) {
            n = this.xyzr.length / 4;
            if (this.xyzr.length != 4 * n) {
                throw new IllegalArgumentException("xyzr array must contain 4*n elements, but its length is " + this.xyzr.length);
            }
        } else if (this.xyz != null) {
            n = this.xyz.length / 3;
            if (this.xyz.length != 3 * n) {
                throw new IllegalArgumentException("xyz array must contain 3*n elements, but its length is " + this.xyz.length);
            }
        } else {
            n = 0;
        }
        if (n > 0x1FFFFEFF) {
            throw new TooLargeArrayException("Too large serialized array of " + n + " sphere-polyhedra");
        }
        return n;
    }

    public int numberOfObjects() {
        int n = this.numberOfSpherePolyhedra();
        int generatrixSetsLength = this.serializedGeneratrixSets != null && this.serializedGeneratrixSets.length > 0 ? this.serializedGeneratrixSets.length : 0;
        int numberOfObjects = 0;
        int offset = 3;
        for (int k = 0; k < n; ++k) {
            if (offset >= generatrixSetsLength) {
                numberOfObjects += n - k;
                break;
            }
            int newOffset = GeneratrixSet.checkSerializedData(this.serializedGeneratrixSets, offset, true);
            if (!GeneratrixSet.deserializeContinuationFlag(this.serializedGeneratrixSets, offset)) {
                ++numberOfObjects;
            }
            offset = newOffset;
        }
        return numberOfObjects;
    }

    public void checkIntegrity() {
        SerializedSpherePolyhedra.checkSerializedGeneratrixSets(this.serializedGeneratrixSets);
        this.numberOfSpherePolyhedra();
    }

    public void write(Path file, String optionalKindSetJson, String optionalPackingGeometryJson) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(file.toFile()));){
            zip.setMethod(8);
            zip.setLevel(1);
            if (this.xyzr != null) {
                SerializedSpherePolyhedra.addToZip(zip, XYZR_ENTRY, SNumbers.doublesToBytes((double[])this.xyzr));
            } else if (this.xyz != null) {
                SerializedSpherePolyhedra.addToZip(zip, XYZ_ENTRY, SNumbers.doublesToBytes((double[])this.xyz));
            }
            if (this.serializedGeneratrixSets != null) {
                SerializedSpherePolyhedra.addToZip(zip, GENERATRIX_SETS_ENTRY, SNumbers.intsToBytes((int[])this.serializedGeneratrixSets));
            }
            if (this.kindIds != null) {
                SerializedSpherePolyhedra.addToZip(zip, KINDS_ENTRY, SNumbers.longsToBytes((long[])this.kindIds));
            }
            if (optionalKindSetJson != null) {
                SerializedSpherePolyhedra.addToZip(zip, KIND_SET_ENTRY, optionalKindSetJson.getBytes(StandardCharsets.UTF_8));
            }
            if (optionalPackingGeometryJson != null) {
                SerializedSpherePolyhedra.addToZip(zip, PACKING_GEOMETRY_ENTRY, optionalPackingGeometryJson.getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    public static SerializedSpherePolyhedra read(Path file) throws IOException {
        return SerializedSpherePolyhedra.read(new FileInputStream(file.toFile()), null, null);
    }

    public static SerializedSpherePolyhedra read(Path file, AtomicReference<String> optionalKindSetJson, AtomicReference<String> optionalPackingGeometryJson) throws IOException {
        return SerializedSpherePolyhedra.read(new FileInputStream(file.toFile()), optionalKindSetJson, optionalPackingGeometryJson);
    }

    public static SerializedSpherePolyhedra read(InputStream stream, AtomicReference<String> optionalKindSetJson, AtomicReference<String> optionalPackingGeometryJson) throws IOException {
        SerializedSpherePolyhedra result = new SerializedSpherePolyhedra();
        try (ZipInputStream zip = new ZipInputStream(stream);){
            ZipEntry zipEntry = zip.getNextEntry();
            while (zipEntry != null) {
                String name = zipEntry.getName();
                if (name.endsWith(XYZR_ENTRY)) {
                    result.setCoordinates(SNumbers.bytesToDoubles((byte[])SerializedSpherePolyhedra.readFully(zip)), 4);
                } else if (name.endsWith(XYZ_ENTRY)) {
                    result.setCoordinates(SNumbers.bytesToDoubles((byte[])SerializedSpherePolyhedra.readFully(zip)), 3);
                } else if (name.endsWith(GENERATRIX_SETS_ENTRY)) {
                    result.setSerializedGeneratrixSets(SNumbers.bytesToInts((byte[])SerializedSpherePolyhedra.readFully(zip)));
                } else if (name.endsWith(KINDS_ENTRY)) {
                    result.setKindIds(SNumbers.bytesToLongs((byte[])SerializedSpherePolyhedra.readFully(zip)));
                } else if (name.endsWith(KIND_SET_ENTRY)) {
                    if (optionalKindSetJson != null) {
                        optionalKindSetJson.set(new String(SerializedSpherePolyhedra.readFully(zip), StandardCharsets.UTF_8));
                    }
                } else if (name.endsWith(PACKING_GEOMETRY_ENTRY) && optionalPackingGeometryJson != null) {
                    optionalPackingGeometryJson.set(new String(SerializedSpherePolyhedra.readFully(zip), StandardCharsets.UTF_8));
                }
                zipEntry = zip.getNextEntry();
            }
        }
        if (result.getXyzr() == null) {
            throw new IOException("Invalid format: ZIP archive does not contain xyzr.dat or xyz.dat file");
        }
        return result;
    }

    public static void checkSerializedGeneratrixSets(int[] serializedGeneratrixSets) {
        if (serializedGeneratrixSets != null && serializedGeneratrixSets.length > 0) {
            if (serializedGeneratrixSets[0] != 1397961008) {
                throw new IllegalArgumentException("Unsupported version of serialized generatrix sets array: signature 0x" + Integer.toHexString(serializedGeneratrixSets[0]) + " instead of 0x" + Integer.toHexString(1397961008));
            }
            if (serializedGeneratrixSets.length % 3 != 0) {
                throw new IllegalArgumentException("Serialized generatrix sets array must contain 3*k elements, but its length is " + serializedGeneratrixSets.length);
            }
        }
    }

    private static void addToZip(ZipOutputStream zipOutputStream, String fileName, byte[] data) throws IOException {
        ZipEntry zipEntry = new ZipEntry("spherepolyhedra/" + fileName);
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.write(data);
        zipOutputStream.closeEntry();
    }

    private static byte[] readFully(InputStream inputStream) throws IOException {
        int len;
        byte[] buffer = new byte[32768];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
        while ((len = inputStream.read(buffer, 0, buffer.length)) > -1) {
            byteArrayOutputStream.write(buffer, 0, len);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

