/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Arrays;
import net.algart.arrays.TooLargeArrayException;

class SimpleIntSet {
    int[] values = new int[16];
    int size = 0;

    SimpleIntSet() {
    }

    public int[] values() {
        return this.values;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void add(int value) {
        for (int k = 0; k < this.size; ++k) {
            if (this.values[k] != value) continue;
            return;
        }
        this.ensureCapacity((long)this.size + 1L);
        this.values[this.size++] = value;
    }

    public boolean remove(int value) {
        for (int k = 0; k < this.size; ++k) {
            if (this.values[k] != value) continue;
            --this.size;
            if (k < this.size) {
                System.arraycopy(this.values, k + 1, this.values, k, this.size - k);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "simple set of " + this.size + " integers: " + Arrays.toString(Arrays.copyOf(this.values, this.size));
    }

    private void ensureCapacity(long newNumberOfValues) {
        if (newNumberOfValues > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large array required");
        }
        assert (newNumberOfValues == (long)((int)newNumberOfValues));
        if (newNumberOfValues > (long)this.values.length) {
            int newLength = Math.max(16, Math.max((int)newNumberOfValues, (int)Math.min(Integer.MAX_VALUE, (long)(2.0 * (double)this.values.length))));
            this.values = Arrays.copyOf(this.values, newLength);
        }
    }
}

