/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import net.algart.math.geometry.StraightLine3D;

public final class SpherePolyhedraIntersection {
    private SurfaceType surfaceType = null;
    private double t = Double.NaN;
    private double x = Double.NaN;
    private double y = Double.NaN;
    private double z = Double.NaN;
    private double cosine = Double.NaN;
    private int surfaceElementIndex = -1;

    SpherePolyhedraIntersection() {
    }

    public SurfaceType surfaceType() {
        assert (this.exists());
        return this.surfaceType;
    }

    public double t() {
        return this.t;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double cosine() {
        assert (this.exists());
        return this.cosine;
    }

    public int surfaceElementIndex() {
        return this.surfaceElementIndex;
    }

    public String toString() {
        return this.exists() ? "point at straight " + (String)(Double.isNaN(this.x) ? "(unknown coordinates) " : "(" + this.x + ", " + this.y + ", " + this.z + ") ") + "of " + String.valueOf((Object)this.surfaceType) + (String)(this.surfaceElementIndex >= 0 ? " #" + this.surfaceElementIndex : "") + ", t=" + this.t + ", cosine=" + this.cosine : "no point";
    }

    boolean exists() {
        return this.surfaceType != null;
    }

    boolean surelyExists() {
        return this.exists() && this.surfaceType != SurfaceType.STRAIGHT_ALMOST_FACET && this.surfaceType != SurfaceType.STRAIGHT_ALMOST_CYLINDER;
    }

    void setTo(SpherePolyhedraIntersection source) {
        assert (source.exists());
        this.surfaceType = source.surfaceType;
        this.t = source.t;
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        this.cosine = source.cosine;
        this.surfaceElementIndex = source.surfaceElementIndex;
    }

    void minIfExists(SpherePolyhedraIntersection source) {
        if (source.exists() && source.t <= this.t) {
            this.setTo(source);
        }
    }

    void maxIfExists(SpherePolyhedraIntersection source) {
        if (source.exists() && source.t >= this.t) {
            this.setTo(source);
        }
    }

    void setAll(SurfaceType surfaceType, double t, double cosine, int surfaceElementIndex) {
        assert (surfaceType != null);
        this.surfaceType = surfaceType;
        this.t = t;
        this.cosine = cosine;
        this.surfaceElementIndex = surfaceElementIndex;
    }

    void setT(SurfaceType surfaceType, double t) {
        this.surfaceType = surfaceType;
        this.t = t;
    }

    void setCosine(double cosine) {
        this.cosine = cosine;
    }

    void setOthers(double cosine, int surfaceElementIndex) {
        this.cosine = cosine;
        this.surfaceElementIndex = surfaceElementIndex;
    }

    void setXYZ(StraightLine3D straight) {
        assert (straight != null);
        this.x = straight.x(this.t);
        this.y = straight.y(this.t);
        this.z = straight.z(this.t);
    }

    void shiftAlongStraight(double shift, StraightLine3D straight) {
        this.t += shift;
        this.setXYZ(straight);
    }

    void setNegativeInvinify() {
        this.t = Double.NEGATIVE_INFINITY;
        this.remove();
    }

    void setPositiveInvinify() {
        this.t = Double.POSITIVE_INFINITY;
        this.remove();
    }

    void setCommonXYZ(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.surfaceType = SurfaceType.COMMON_INTERSECTION;
    }

    void remove() {
        this.surfaceType = null;
    }

    public static enum SurfaceType {
        STRAIGHT_FACET,
        STRAIGHT_ALMOST_FACET,
        STRAIGHT_CYLINDER,
        STRAIGHT_SPHERE,
        STRAIGHT_CYLINDER_BASE,
        STRAIGHT_ALMOST_CYLINDER,
        COMMON_INTERSECTION;

    }
}

