/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Objects;
import java.util.Random;
import net.algart.arrays.JArrays;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.objects.DistanceMetricFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraStraightIntersectionsFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraVoxelBuilder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedronDistanceMetric;

public final class SpherePolyhedraOverlappingVoxelBuilder
extends SpherePolyhedraVoxelBuilder {
    private final SpherePolyhedronDistanceMetric metric;
    private final DistanceMetricFinder[] threadDistanceMetricFinders;
    private double maxDistanceToObjects = Double.POSITIVE_INFINITY;
    private int[] randomSpherePolyhedraIndexes = null;

    SpherePolyhedraOverlappingVoxelBuilder(SpherePolyhedra spherePolyhedra, Class<?> elementType, int dimX, int dimY, int dimZ, SpherePolyhedraVoxelBuilder.BuildingDistancesMode distanceMode, SpherePolyhedronDistanceMetric metric) {
        super(spherePolyhedra, elementType, dimX, dimY, dimZ, distanceMode);
        this.metric = Objects.requireNonNull(metric, "Mull distance metric");
        this.threadDistanceMetricFinders = new DistanceMetricFinder[this.numberOfThreads];
        for (int t = 0; t < this.numberOfThreads; ++t) {
            this.threadDistanceMetricFinders[t] = DistanceMetricFinder.newInstance(metric, this.voxelArray, this.voxelDistancesArray);
        }
    }

    public double getMaxDistanceToObjects() {
        return this.maxDistanceToObjects;
    }

    public SpherePolyhedraOverlappingVoxelBuilder setMaxDistanceToObjects(double maxDistanceToObjects) {
        if (maxDistanceToObjects < 0.0) {
            throw new IllegalArgumentException("Negative maxDistanceToObjects = " + maxDistanceToObjects);
        }
        this.maxDistanceToObjects = maxDistanceToObjects;
        return this;
    }

    @Override
    void preprocess() {
        this.randomSpherePolyhedraIndexes = new int[this.spherePolyhedra.numberOfSpherePolyhedra()];
        JArrays.fillIntProgression((int[])this.randomSpherePolyhedraIndexes, (int)0, (int)1);
        Random random = new Random(157L);
        SpherePolyhedraOverlappingVoxelBuilder.shuffle(this.randomSpherePolyhedraIndexes, random);
        for (int t = 0; t < this.numberOfThreads; ++t) {
            DistanceMetricFinder metricFinder = this.threadDistanceMetricFinders[t];
            metricFinder.setSpherePolyhedra(this.spherePolyhedra);
            metricFinder.setRandomSpherePolyhedraIndexes(this.randomSpherePolyhedraIndexes);
            metricFinder.setVoxelValues(this.spherePolyhedraVoxelValues);
        }
    }

    @Override
    void processStraight(int straightIndex, int threadIndex) {
        double x = Double.NaN;
        double lastX = 0.0;
        try {
            SpherePolyhedraStraightIntersectionsFinder intersectionsFinder = this.threadIntersectionsFinders[threadIndex];
            DistanceMetricFinder metricFinder = this.threadDistanceMetricFinders[threadIndex];
            long startPosition = (long)straightIndex * (long)this.dimX;
            assert (startPosition <= Integer.MAX_VALUE);
            int voxelZ = straightIndex / this.dimY;
            int voxelY = straightIndex % this.dimY;
            StraightLine3D straight = this.getSraightAlongVoxelX(0, voxelY, voxelZ);
            boolean dilateObjects = this.distancesMode.analyzeOutsideObjects() && this.maxDistanceToObjects != 0.0 && this.maxDistanceToObjects != Double.POSITIVE_INFINITY;
            SpherePolyhedraStraightIntersectionsFinder.ObjectsDilator dilatingGeneratrixRadius = dilateObjects ? generatrixSphereRadius -> this.metric.radiusIncrementToReduceDistance(generatrixSphereRadius, this.maxDistanceToObjects) : null;
            intersectionsFinder.setDilator(dilatingGeneratrixRadius);
            intersectionsFinder.findAllIntersections(straight, index -> this.spherePolyhedraVoxelValues[index] >= 0);
            intersectionsFinder.sortByTAndEntryFlag();
            double stepT = 1.0 / this.scaleX;
            double lastT = 0.0;
            metricFinder.setStraight(straight);
            metricFinder.clear();
            int n = intersectionsFinder.numberOfPoints();
            for (int k = 0; k < n; ++k) {
                boolean openingBracket = intersectionsFinder.entryFlags[k];
                double t = intersectionsFinder.t[k];
                int spherePolyhedronIndex = intersectionsFinder.spherePolyhedronIndexes[k];
                x = t * this.scaleX;
                this.fillOverlapped(startPosition, lastX, x, lastT, stepT, metricFinder);
                if (openingBracket) {
                    metricFinder.addIndex(spherePolyhedronIndex);
                } else {
                    metricFinder.removeIndex(spherePolyhedronIndex);
                }
                assert (metricFinder.indexes.size >= 0) : "Entry and exit points are not balanced";
                assert (k == 0 || t >= lastT) : "Entry and exit points are not correctly sorted";
                lastT = t;
                lastX = x;
                if (x >= (double)this.dimX + 0.001) break;
            }
            if (this.distancesMode.analyzeOutsideObjects()) {
                this.fillOverlapped(startPosition, lastX, this.dimX - 1, lastT, stepT, metricFinder);
            }
        }
        catch (AssertionError e) {
            throw new AssertionError("Assertion error while processing straight #" + straightIndex + " (y=" + straightIndex % this.dimY + ", z=" + straightIndex / this.dimY + ") in thread #" + threadIndex + ", x = " + x + ", lastX = " + lastX, (Throwable)((Object)e));
        }
    }

    private void fillOverlapped(long startPosition, double x1, double x2, double t1, double stepT, DistanceMetricFinder metricFinder) {
        int i1 = (int)Math.ceil(x1);
        int i2 = (int)Math.floor(x2);
        if (i2 < 0 || i1 >= this.dimX) {
            return;
        }
        if (metricFinder.indexes.size == 0 && !this.needToAnalyzeOutside()) {
            return;
        }
        if (metricFinder.indexes.size == 1 && this.voxelDistancesArray == null) {
            int spherePolyhedronIndex = metricFinder.indexes.values[0];
            int voxelValue = this.spherePolyhedraVoxelValues[spherePolyhedronIndex];
            this.fill(startPosition, i1, i2, voxelValue);
            return;
        }
        if (i1 < 0) {
            i1 = 0;
        }
        if (i2 > this.dimX - 1) {
            i2 = this.dimX - 1;
        }
        if (i1 <= i2) {
            metricFinder.findNearestForVoxelSegment(startPosition + (long)i1, i2 - i1 + 1, t1 + ((double)i1 - x1) * stepT, stepT);
        }
    }

    private boolean needToAnalyzeOutside() {
        return this.distancesMode == SpherePolyhedraVoxelBuilder.BuildingDistancesMode.ALL_MATRIX || this.distancesMode == SpherePolyhedraVoxelBuilder.BuildingDistancesMode.ALL_MATRIX_UNTIL_MAX_DISTANCE && this.maxDistanceToObjects == Double.POSITIVE_INFINITY;
    }

    private static void shuffle(int[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            SpherePolyhedraOverlappingVoxelBuilder.swap(array, i - 1, random.nextInt(i));
        }
    }

    private static void swap(int[] array, int i, int j) {
        int temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }
}

