/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import java.util.Locale;
import java.util.Objects;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSet;
import net.algart.model3d.spherepolyhedra.objects.KernelPolyhedron;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersection;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersectionsList;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraIntersectionsTools;

public final class SpherePolyhedron
extends KernelPolyhedron
implements Cloneable {
    public static final SpherePolyhedron ZERO = SpherePolyhedron.newInstance(0.0, 0.0, 0.0, GeneratrixSet.ZERO);
    public static final double SURFACE_EPSILON = 1.0E-7;
    private static final int MINIMAL_NUMBER_OF_TEMPORARY_POINTS_FOR_INTERSECTION_WITH_STRAIGHT = 5;
    private static final double POINT_NEAR_FACET_SIDE_EPSILON = 1.0E-9;
    private static final double POINT_NEAR_PLANE_EPSILON = 1.0E-9;
    private static final double ALMOST_CYLINDER_INTERSECTION_EPSILON = 1.0E-9;
    private static final boolean USE_EPSILONS_FOR_INTERSECTION_WITH_FACETS = true;
    private static final boolean USE_CYLINDER_COORDINATE_SYSTEM = true;
    private static final boolean DEBUG_INTERSECTION_STRAIGHT_FACET_PRECISION = false;
    private static final boolean DEBUG_INTERSECTION_STRAIGHT_CYLINDER_INSIDE = false;
    private double centerX = 0.0;
    private double centerY = 0.0;
    private double centerZ = 0.0;
    private long kindId;
    private RectangularArea containingParallelepiped = null;

    SpherePolyhedron() {
    }

    public static SpherePolyhedron newInstance(double centerX, double centerY, double centerZ, GeneratrixSet generatrixSet, long kindId) {
        SpherePolyhedron result = new SpherePolyhedron();
        result.setGeneratrixSet(generatrixSet);
        result.setCenter(centerX, centerY, centerZ);
        result.setKindId(kindId);
        result.compactForExternalUsage();
        return result;
    }

    public static SpherePolyhedron newInstance(double centerX, double centerY, double centerZ, GeneratrixSet generatrixSet) {
        return SpherePolyhedron.newInstance(centerX, centerY, centerZ, generatrixSet, 0L);
    }

    public static SpherePolyhedron newInstance(GeneratrixSet generatrixSet, long kindId) {
        return SpherePolyhedron.newInstance(0.0, 0.0, 0.0, generatrixSet, kindId);
    }

    public static SpherePolyhedron newInstance(GeneratrixSet generatrixSet) {
        return SpherePolyhedron.newInstance(0.0, 0.0, 0.0, generatrixSet, 0L);
    }

    public double centerX() {
        return this.centerX;
    }

    public double centerY() {
        return this.centerY;
    }

    public double centerZ() {
        return this.centerZ;
    }

    public GeneratrixSet generatrixSet() {
        return this.generatrixSet;
    }

    public double generatrixSphereRadius() {
        return this.generatrixRadius;
    }

    public double generatrixSphereRadiusSquare() {
        return this.generatrixRadiusSquare;
    }

    public long kindId() {
        return this.kindId;
    }

    public boolean isZero() {
        return this.centerX == 0.0 && this.centerY == 0.0 && this.centerZ == 0.0 && this.generatrixSet.isZero();
    }

    public boolean isSphere() {
        return this.numberOfVertices == 1;
    }

    public int numberOfGeneratrixSegments() {
        return this.generatrixSet.numberOfGeneratrixSegments;
    }

    public int numberOfVertices() {
        return this.numberOfVertices;
    }

    public int numberOfEdges() {
        return this.numberOfEdges;
    }

    public int numberOfFacets() {
        return this.numberOfFacets;
    }

    public int numberOfExactlyDegeneratedEdges() {
        return this.numberOfExactlyDegeneratedEdges;
    }

    public int numberOfExactlyDegeneratedVertices() {
        return this.numberOfExactlyDegeneratedVertices;
    }

    public int numberOfAlmostDegeneratedEdges() {
        return this.numberOfAlmostDegeneratedEdges;
    }

    public int numberOfAlmostDegeneratedVertices() {
        return this.numberOfAlmostDegeneratedVertices;
    }

    public boolean isExactlyDegenerated3Dimensional() {
        return this.isExactlyDegenerated(true);
    }

    public boolean isExactlyDegenerated(boolean skipLessThan3Dimensional) {
        if (this.generatrixSet.numberOfGeneratrixSegments < 3 && skipLessThan3Dimensional) {
            return false;
        }
        int numberOfActualEdges = this.numberOfEdges - this.numberOfExactlyDegeneratedEdges;
        int numberOfActualVertices = this.numberOfVertices - this.numberOfExactlyDegeneratedVertices;
        return numberOfActualEdges <= numberOfActualVertices;
    }

    public double vertexX(int vertexIndex) {
        return this.centerX + this.kernelVertexX(vertexIndex);
    }

    public double vertexY(int vertexIndex) {
        return this.centerY + this.kernelVertexY(vertexIndex);
    }

    public double vertexZ(int vertexIndex) {
        return this.centerZ + this.kernelVertexZ(vertexIndex);
    }

    public double kernelVertexX(int vertexIndex) {
        return (double)this.verticesXYZ[3 * vertexIndex] * this.generatrixSet.scale;
    }

    public double kernelVertexY(int vertexIndex) {
        return (double)this.verticesXYZ[3 * vertexIndex + 1] * this.generatrixSet.scale;
    }

    public double kernelVertexZ(int vertexIndex) {
        return (double)this.verticesXYZ[3 * vertexIndex + 2] * this.generatrixSet.scale;
    }

    public boolean isVertexAlmostDegenerated(int vertexIndex) {
        return (this.degeneratedVertices[vertexIndex] & 2) != 0;
    }

    public boolean isVertexExactlyDegenerated(int vertexIndex) {
        return (this.degeneratedVertices[vertexIndex] & 1) != 0;
    }

    public int edgeGeneratrixSegmentIndex(int edgeIndex) {
        return this.edgesGeneratrixSegmentIndexes[edgeIndex];
    }

    public int edgeVertex1Index(int edgeIndex) {
        return this.edgesVertices[2 * edgeIndex];
    }

    public int edgeVertex2Index(int edgeIndex) {
        return this.edgesVertices[2 * edgeIndex + 1];
    }

    public int edgeVertex1IndexAlongGeneratrix(int edgeIndex) {
        return this.edgesVertices[this.edgesOrderedAlongGeneratrix[edgeIndex] ? 2 * edgeIndex : 2 * edgeIndex + 1];
    }

    public int edgeVertex2IndexAlongGeneratrix(int edgeIndex) {
        return this.edgesVertices[this.edgesOrderedAlongGeneratrix[edgeIndex] ? 2 * edgeIndex + 1 : 2 * edgeIndex];
    }

    public int edgeFacet1Index(int edgeIndex) {
        return this.edgesFacets[2 * edgeIndex];
    }

    public int edgeFacet2Index(int edgeIndex) {
        return this.edgesFacets[2 * edgeIndex + 1];
    }

    public boolean isEdgeAlmostDegenerated(int edgeIndex) {
        return (this.degeneratedEdges[edgeIndex] & 2) != 0;
    }

    public boolean isEdgeExactlyDegenerated(int edgeIndex) {
        return (this.degeneratedEdges[edgeIndex] & 1) != 0;
    }

    public int facetVertexIndex(int facetIndex, int vertexOfFacetIndex) {
        if (vertexOfFacetIndex < 0 || vertexOfFacetIndex > 3) {
            throw new IllegalArgumentException("vertexOfFacetIndex must be in range 0..3");
        }
        return this.facetsVertices[4 * facetIndex + vertexOfFacetIndex];
    }

    public int facetEdgeIndex(int facetIndex, int sideOfFacetIndex) {
        if (sideOfFacetIndex < 0 || sideOfFacetIndex > 3) {
            throw new IllegalArgumentException("sideOfFacetIndex must be in range 0..3");
        }
        return this.facetsEdges[4 * facetIndex + sideOfFacetIndex];
    }

    public long facetExactNormalX(int facetIndex) {
        return this.facetsNormals[3 * facetIndex];
    }

    public long facetExactNormalY(int facetIndex) {
        return this.facetsNormals[3 * facetIndex + 1];
    }

    public long facetExactNormalZ(int facetIndex) {
        return this.facetsNormals[3 * facetIndex + 2];
    }

    public double facetNormalX(int facetIndex) {
        return this.facetsEquations[4 * facetIndex];
    }

    public double facetNormalY(int facetIndex) {
        return this.facetsEquations[4 * facetIndex + 1];
    }

    public double facetNormalZ(int facetIndex) {
        return this.facetsEquations[4 * facetIndex + 2];
    }

    public double facetEquationD(int facetIndex) {
        return this.facetsEquations[4 * facetIndex + 3];
    }

    public double facetArea(int facetIndex) {
        return this.facetsAreas[facetIndex];
    }

    public double generatrixSegmentIX(int generatrixSegmentIndex) {
        this.generatrixSet.checkSegmentIndex(generatrixSegmentIndex);
        return this.generatrixSegmentsIJK[9 * generatrixSegmentIndex];
    }

    public double generatrixSegmentIY(int generatrixSegmentIndex) {
        this.generatrixSet.checkSegmentIndex(generatrixSegmentIndex);
        return this.generatrixSegmentsIJK[9 * generatrixSegmentIndex + 1];
    }

    public double generatrixSegmentIZ(int generatrixSegmentIndex) {
        this.generatrixSet.checkSegmentIndex(generatrixSegmentIndex);
        return this.generatrixSegmentsIJK[9 * generatrixSegmentIndex + 2];
    }

    public double containingSphereRadius() {
        return this.containingSphereRadius;
    }

    public double containingSphereRadiusSquare() {
        return this.containingSphereRadius * this.containingSphereRadius;
    }

    public RectangularArea containingParallelepiped() {
        if (this.containingParallelepiped == null) {
            this.containingParallelepiped = RectangularArea.valueOf((double)this.minX(), (double)this.minY(), (double)this.minZ(), (double)this.maxX(), (double)this.maxY(), (double)this.maxZ());
        }
        return this.containingParallelepiped;
    }

    public double minCenteredX() {
        return this.minCenteredX;
    }

    public double maxCenteredX() {
        return this.maxCenteredX;
    }

    public double minCenteredY() {
        return this.minCenteredY;
    }

    public double maxCenteredY() {
        return this.maxCenteredY;
    }

    public double minCenteredZ() {
        return this.minCenteredZ;
    }

    public double maxCenteredZ() {
        return this.maxCenteredZ;
    }

    public double minX() {
        return this.minCenteredX + this.centerX;
    }

    public double maxX() {
        return this.maxCenteredX + this.centerX;
    }

    public double minY() {
        return this.minCenteredY + this.centerY;
    }

    public double maxY() {
        return this.maxCenteredY + this.centerY;
    }

    public double minZ() {
        return this.minCenteredZ + this.centerZ;
    }

    public double maxZ() {
        return this.maxCenteredZ + this.centerZ;
    }

    public double sizeX() {
        return this.maxCenteredX - this.minCenteredX;
    }

    public double sizeY() {
        return this.maxCenteredY - this.minCenteredY;
    }

    public double sizeZ() {
        return this.maxCenteredZ - this.minCenteredZ;
    }

    public Range rangeAlongDirection(double dx, double dy, double dz) {
        Range range = this.rangeCenteredAlongDirection(dx, dy, dz);
        double centerT = this.centerX * dx + this.centerY * dy + this.centerZ * dz;
        return Range.valueOf((double)(range.min() + centerT), (double)(range.max() + centerT));
    }

    public double summaryLengthOfEdges() {
        return this.summaryLengthOfEdges;
    }

    public double kernelSurfaceArea() {
        return this.kernelSurfaceArea;
    }

    public double surfaceArea() {
        return (2.0 * this.generatrixRadius + this.summaryLengthOfGeneratrixSegments) * 2.0 * Math.PI * this.generatrixRadius + this.kernelSurfaceArea;
    }

    public double kernelVolume() {
        return this.kernelVolume;
    }

    public double volume() {
        return ((1.3333333333333333 * this.generatrixRadius + this.summaryLengthOfGeneratrixSegments) * Math.PI * this.generatrixRadius + this.kernelSurfaceArea) * this.generatrixRadius + this.kernelVolume;
    }

    public boolean containsPoint(double x, double y, double z, boolean essentiallyInside, double characteristicSize) {
        return this.insideStatus(x, y, z, characteristicSize, essentiallyInside) != -1L;
    }

    public boolean isPointEssentiallyInside(double x, double y, double z, double characteristicSize) {
        return this.containsPoint(x, y, z, true, characteristicSize);
    }

    public boolean isPointEssentiallyOutside(double x, double y, double z, double characteristicSize) {
        return !this.containsPoint(x, y, z, false, characteristicSize);
    }

    public double distanceToCenterSquare(double x, double y, double z) {
        return (x -= this.centerX) * x + (y -= this.centerY) * y + (z -= this.centerZ) * z;
    }

    public double distanceToCenter(double x, double y, double z) {
        return Math.sqrt(this.distanceToCenterSquare(x, y, z));
    }

    public double distanceToKernelSquare(double x, double y, double z) {
        return this.distanceToKernel(x, y, z, true);
    }

    public double distanceToKernel(double x, double y, double z) {
        return this.distanceToKernel(x, y, z, false);
    }

    public SpherePolyhedron moveTo(double newCenterX, double newCenterY, double newCenterZ) {
        SpherePolyhedron result = this.cloneIt();
        result.setCenter(newCenterX, newCenterY, newCenterZ);
        result.containingParallelepiped = null;
        return result;
    }

    public SpherePolyhedron symmetry() {
        if (this.centerX == 0.0 && this.centerY == 0.0 && this.centerZ == 0.0) {
            return this;
        }
        return SpherePolyhedron.newInstance(-this.centerX, -this.centerY, -this.centerZ, this.generatrixSet.symmetry(), this.kindId);
    }

    public SpherePolyhedron minkowskiSum(SpherePolyhedron added) {
        if (added.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return added;
        }
        return SpherePolyhedron.newInstance(this.centerX + added.centerX, this.centerY + added.centerY, this.centerZ + added.centerZ, this.generatrixSet.minkowskiSum(added.generatrixSet));
    }

    public SpherePolyhedraIntersectionsList intersectionWithStraight(StraightLine3D straight) {
        SpherePolyhedraIntersectionsList result = new SpherePolyhedraIntersectionsList();
        this.intersectionWithStraight(result, straight);
        result.compactForExternalUsage();
        return result;
    }

    public boolean addIntersectionsWithStraight(SpherePolyhedraIntersectionsList result, StraightLine3D straight) {
        Objects.requireNonNull(straight, "Null straight");
        Objects.requireNonNull(result, "Null result points list");
        result.allocateAfterEnd(5);
        SpherePolyhedraIntersection entry = result.getUnchecked(result.n);
        SpherePolyhedraIntersection exit = result.getUnchecked(result.n + 1);
        SpherePolyhedraIntersection workA = result.getUnchecked(result.n + 2);
        SpherePolyhedraIntersection workB = result.getUnchecked(result.n + 3);
        SpherePolyhedraIntersection centerAtStraight = result.getUnchecked(result.n + 4);
        entry.remove();
        exit.remove();
        centerAtStraight.setT(null, straight.pointProjection(this.centerX, this.centerY, this.centerZ));
        centerAtStraight.setXYZ(straight);
        double distanceToStraight = Orthonormal3DBasis.length((double)(this.centerX - centerAtStraight.x()), (double)(this.centerY - centerAtStraight.y()), (double)(this.centerZ - centerAtStraight.z()));
        double secondCathetusSqr = (this.containingSphereRadius + distanceToStraight) * (this.containingSphereRadius - distanceToStraight);
        if (secondCathetusSqr < 0.0) {
            return false;
        }
        if (this.isSphere()) {
            double secondCathetus = Math.sqrt(secondCathetusSqr);
            entry.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_SPHERE, centerAtStraight.t() - secondCathetus, -secondCathetus * this.generatrixRadiusInv, 0);
            exit.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_SPHERE, centerAtStraight.t() + secondCathetus, secondCathetus * this.generatrixRadiusInv, 0);
            entry.setXYZ(straight);
            exit.setXYZ(straight);
            result.increaseSize(2);
            return true;
        }
        boolean foundBoth = this.intersectionOfAnyFacetWithStraightTolerant(straight, centerAtStraight, entry, exit, workA);
        if (!foundBoth) {
            int k;
            assert (!entry.exists() || !exit.exists());
            if (this.generatrixRadius == 0.0) {
                return false;
            }
            boolean sureIntersection = entry.exists() || exit.exists();
            int sureEntryFacet = entry.exists() ? entry.surfaceElementIndex() : -1;
            int sureExitFacet = exit.exists() ? exit.surfaceElementIndex() : -1;
            for (k = 0; k < this.numberOfVertices; ++k) {
                if (this.isVertexExactlyDegenerated(k) || !this.intersectionOfSphereWithStraight(k, straight, centerAtStraight, workA, workB)) continue;
                sureIntersection = true;
                entry.minIfExists(workA);
                exit.maxIfExists(workB);
            }
            for (k = 0; k < this.numberOfEdges; ++k) {
                if (this.isEdgeExactlyDegenerated(k)) continue;
                int f1 = this.edgeFacet1Index(k);
                int f2 = this.edgeFacet2Index(k);
                boolean checkAlmost = this.numberOfFacets > 0 && f1 != sureEntryFacet && f1 != sureExitFacet && f2 != sureEntryFacet && f2 != sureExitFacet;
                this.intersectionOfCylinderWithStraight(k, straight, centerAtStraight, workA, workB, checkAlmost);
                sureIntersection |= workA.surelyExists() || workB.surelyExists();
                entry.minIfExists(workA);
                exit.maxIfExists(workB);
            }
            if (!sureIntersection) {
                entry.remove();
                exit.remove();
            }
            boolean bl = foundBoth = entry.exists() && exit.exists();
        }
        if (foundBoth) {
            entry.shiftAlongStraight(centerAtStraight.t(), straight);
            exit.shiftAlongStraight(centerAtStraight.t(), straight);
            result.increaseSize(2);
        }
        return foundBoth;
    }

    public void addIntersectionsWithTwoOthers(SpherePolyhedraIntersectionsList result, SpherePolyhedron spherePolyhedron1, SpherePolyhedron spherePolyhedron2) {
        SpherePolyhedraIntersectionsTools.addIntersectionsOf3SpherePolyhedra(result, this, spherePolyhedron1, spherePolyhedron2);
    }

    public String toString() {
        return "sphere-polyhedron" + (this.isExactlyDegenerated3Dimensional() ? " (degenerated)" : "") + " at (" + this.centerX + ", " + this.centerY + ", " + this.centerZ + "): " + this.numberOfVertices + " vertices" + (String)(this.numberOfAlmostDegeneratedVertices == 0 ? "" : " (" + this.numberOfAlmostDegeneratedVertices + " almost degenerated)") + (String)(this.numberOfExactlyDegeneratedVertices == 0 ? "" : " (" + this.numberOfExactlyDegeneratedVertices + " exactly degenerated)") + ", " + this.numberOfEdges + " edges" + (String)(this.numberOfAlmostDegeneratedEdges == 0 ? "" : " (" + this.numberOfAlmostDegeneratedEdges + " almost degenerated)") + (String)(this.numberOfExactlyDegeneratedEdges == 0 ? "" : " (" + this.numberOfExactlyDegeneratedEdges + " exactly degenerated)") + ", " + this.numberOfFacets + " facets; generatrix set: " + String.valueOf(this.generatrixSet) + "; containing sphere R=" + this.containingSphereRadius + ", containing parallelepiped " + (this.maxCenteredX - this.minCenteredX) + " x " + (this.maxCenteredY - this.minCenteredY) + " x " + (this.maxCenteredZ - this.minCenteredZ) + ", surface area " + this.surfaceArea() + ", volume " + this.volume();
    }

    public String toDetailedString() {
        int k;
        StringBuilder sb = new StringBuilder();
        sb.append("Sphere-polyhedron").append(this.isExactlyDegenerated3Dimensional() ? " (degenerated)" : "");
        sb.append("\n\n");
        sb.append(String.format("Center: (x, y, z) = (%s, %s, %s)\n", this.centerX, this.centerY, this.centerZ));
        int numberOfGeneratrixSegments = this.generatrixSet.numberOfGeneratrixSegments();
        sb.append("Generatrix set: ").append(numberOfGeneratrixSegments).append(" segments\n");
        for (k = 0; k < numberOfGeneratrixSegments; ++k) {
            sb.append(String.format(Locale.US, "  Segment #%d: (x, y, z) = (%s, %s, %s), length %s, unit vector (%s, %s, %s)\n", k, this.generatrixSet.generatrixSegmentX(k), this.generatrixSet.generatrixSegmentY(k), this.generatrixSet.generatrixSegmentZ(k), 2.0 * this.generatrixSet.generatrixSegmentHalfLength(k), this.generatrixSegmentIX(k), this.generatrixSegmentIY(k), this.generatrixSegmentIZ(k)));
        }
        sb.append(String.format("  Sphere: r = %s\n", this.generatrixRadius));
        sb.append(String.format("  [Scale: %s = 2^%s]\n", this.generatrixSet.scale, this.generatrixSet.scaleFactor));
        sb.append("\n");
        sb.append("Number of vertices: ").append(this.numberOfVertices).append(" (").append(this.numberOfAlmostDegeneratedVertices).append(" almost|exactly degenerated)").append(" (").append(this.numberOfExactlyDegeneratedVertices).append(" exactly degenerated)\n");
        sb.append("Number of edges: ").append(this.numberOfEdges).append(" (").append(this.numberOfAlmostDegeneratedEdges).append(" almost|exactly degenerated)").append(" (").append(this.numberOfExactlyDegeneratedEdges).append(" exactly degenerated)\n");
        sb.append("Number of facets: ").append(this.numberOfFacets).append("\n");
        sb.append("Summary length of generatrix segments: ").append(this.summaryLengthOfGeneratrixSegments).append("\n");
        sb.append("Summary length of edges: ").append(this.summaryLengthOfEdges).append("\n");
        sb.append("Surface area: ").append(this.surfaceArea()).append(", kernel surface area: ").append(this.kernelSurfaceArea).append("\n");
        sb.append("Volume: ").append(this.volume()).append(", kernel volume: ").append(this.kernelVolume).append("\n");
        sb.append("Containing sphere: R=").append(this.containingSphereRadius()).append("\n");
        sb.append("Containing parallelepiped: ").append(this.containingParallelepiped()).append("\n");
        sb.append("\n");
        sb.append(this.numberOfVertices).append(" vertices:\n");
        for (k = 0; k < this.numberOfVertices; ++k) {
            sb.append(String.format("  #%d: (x, y, z) = (%s, %s, %s) = center + (%s, %s, %s)%s%s\n", k, this.vertexX(k), this.vertexY(k), this.vertexZ(k), this.kernelVertexX(k), this.kernelVertexY(k), this.kernelVertexZ(k), this.isVertexAlmostDegenerated(k) ? " (degenerated)" : "", this.isVertexExactlyDegenerated(k) ? " (exactly)" : ""));
        }
        sb.append("\n");
        sb.append(this.numberOfEdges).append(" edges").append(this.numberOfEdges > 0 ? ":\n" : "\n");
        for (k = 0; k < this.numberOfEdges; ++k) {
            int v1 = this.edgeVertex1Index(k);
            int v2 = this.edgeVertex2Index(k);
            int f1 = this.edgeFacet1Index(k);
            int f2 = this.edgeFacet2Index(k);
            double cosine = f1 < 0 && f2 < 0 ? Double.NaN : this.facetNormalX(f1) * this.facetNormalX(f2) + this.facetNormalY(f1) * this.facetNormalY(f2) + this.facetNormalZ(f1) * this.facetNormalZ(f2);
            sb.append(String.format("  #%d: generatrix segment %d, vertices %d and %d (%d->%d along generatrix), %s (cosine %s), length %s, center + (%s, %s, %s)-(%s, %s, %s)%s%s\n", k, this.edgeGeneratrixSegmentIndex(k), v1, v2, this.edgeVertex1IndexAlongGeneratrix(k), this.edgeVertex2IndexAlongGeneratrix(k), f1 < 0 && f2 < 0 ? "no facets" : "facets " + f1 + " and " + f2, cosine, 2.0 * this.generatrixSet.generatrixSegmentHalfLength(this.edgeGeneratrixSegmentIndex(k)), this.kernelVertexX(v1), this.kernelVertexY(v1), this.kernelVertexZ(v1), this.kernelVertexX(v2), this.kernelVertexY(v2), this.kernelVertexZ(v2), this.isEdgeAlmostDegenerated(k) ? " (degenerated)" : "", this.isEdgeExactlyDegenerated(k) ? " (exactly)" : ""));
        }
        sb.append("\n");
        sb.append(this.numberOfFacets).append(" facets").append(this.numberOfFacets > 0 ? ":\n" : "\n");
        for (k = 0; k < this.numberOfFacets; ++k) {
            sb.append(String.format("  #%d: %d-[%d]-%d-[%d]-%d-[%d]-%d-[%d]-%d, area %s, %s*x + %s*y + %s*z <= %s\n", k, this.facetVertexIndex(k, 0), this.facetEdgeIndex(k, 0), this.facetVertexIndex(k, 1), this.facetEdgeIndex(k, 1), this.facetVertexIndex(k, 2), this.facetEdgeIndex(k, 2), this.facetVertexIndex(k, 3), this.facetEdgeIndex(k, 3), this.facetVertexIndex(k, 0), this.facetArea(k), this.facetNormalX(k), this.facetNormalY(k), this.facetNormalZ(k), this.facetEquationD(k)));
        }
        return sb.toString();
    }

    SpherePolyhedron setCenter(double centerX, double centerY, double centerZ) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.containingParallelepiped = null;
        return this;
    }

    SpherePolyhedron setZeroCenter() {
        return this.setCenter(0.0, 0.0, 0.0);
    }

    @Override
    SpherePolyhedron setGeneratrixSet(GeneratrixSet generatrixSet) {
        super.setGeneratrixSet(generatrixSet);
        this.containingParallelepiped = null;
        return this;
    }

    SpherePolyhedron setKindId(long kindId) {
        this.kindId = kindId;
        return this;
    }

    SpherePolyhedron setTo(SpherePolyhedron other) {
        Objects.requireNonNull(other, "Null other sphere-polyhedron");
        super.setTo(other);
        this.centerX = other.centerX;
        this.centerY = other.centerY;
        this.centerZ = other.centerZ;
        this.kindId = other.kindId;
        this.containingParallelepiped = other.containingParallelepiped;
        return this;
    }

    void setToSymmetry() {
        this.generatrixSet.setToSymmetry();
        this.centerX = -this.centerX;
        this.centerY = -this.centerY;
        this.centerZ = -this.centerZ;
        this.containingParallelepiped = null;
    }

    void minkowskiAdd(SpherePolyhedron added) {
        Objects.requireNonNull(added, "Null added sphere-polyhedron");
        if (added.isZero()) {
            return;
        }
        if (this.isZero()) {
            this.setTo(added);
            return;
        }
        this.generatrixSet.minkowskiAdd(added.generatrixSet);
        this.centerX += added.centerX;
        this.centerY += added.centerY;
        this.centerZ += added.centerZ;
        this.rebuild();
    }

    void minkowskiAddSymmetric() {
        this.generatrixSet.minkowskiAddSymmetric();
        this.centerX = 0.0;
        this.centerY = 0.0;
        this.centerZ = 0.0;
        this.rebuild();
    }

    double distanceToKernel(double x, double y, double z, boolean square) {
        x -= this.centerX;
        y -= this.centerY;
        z -= this.centerZ;
        if (this.isSphere()) {
            double distanceSquare = x * x + y * y + z * z;
            return square ? distanceSquare : Math.sqrt(distanceSquare);
        }
        double epsilon = this.containingSphereRadius * 1.0E-9;
        double minDistance = Double.POSITIVE_INFINITY;
        boolean outsideKernel = this.numberOfFacets == 0;
        boolean inSomePrism = false;
        boolean inSomePrismOutsideKernel = false;
        for (int k = 0; k < this.numberOfFacets; ++k) {
            double normalX = this.facetNormalX(k);
            double normalY = this.facetNormalY(k);
            double normalZ = this.facetNormalZ(k);
            double d = this.facetEquationD(k);
            double distance = x * normalX + y * normalY + z * normalZ - d;
            InPrismKind inPrismKind = this.inPerpendicularPrism(k, x, y, z);
            boolean inPrism = inPrismKind == InPrismKind.SURE;
            inSomePrism |= inPrism;
            if (!(distance >= -epsilon)) continue;
            if (inPrism) {
                inSomePrismOutsideKernel = true;
                if (distance < minDistance) {
                    minDistance = distance;
                }
            }
            outsideKernel = true;
        }
        if (!outsideKernel && inSomePrism) {
            return 0.0;
        }
        if (inSomePrismOutsideKernel) {
            return square ? minDistance * minDistance : minDistance;
        }
        assert (minDistance == Double.POSITIVE_INFINITY);
        double minDistanceSquare = Double.POSITIVE_INFINITY;
        int i = 0;
        int m = 3 * this.numberOfVertices;
        while (i < m) {
            int n = i++;
            int n2 = i++;
            int n3 = i++;
            double distanceSquare = Orthonormal3DBasis.lengthSquare((double)(x - (double)this.verticesXYZ[n] * this.generatrixSet.scale), (double)(y - (double)this.verticesXYZ[n2] * this.generatrixSet.scale), (double)(z - (double)this.verticesXYZ[n3] * this.generatrixSet.scale));
            if (!(distanceSquare < minDistanceSquare)) continue;
            minDistanceSquare = distanceSquare;
        }
        for (int k = 0; k < this.numberOfEdges; ++k) {
            double distanceSquare;
            double halfHeight;
            double cz;
            double vz;
            double cy;
            double vy;
            int v1 = 3 * this.edgesVertices[2 * k];
            int v2 = 3 * this.edgesVertices[2 * k + 1];
            double unscaledX1 = this.verticesXYZ[v1];
            double unscaledY1 = this.verticesXYZ[v1 + 1];
            double unscaledZ1 = this.verticesXYZ[v1 + 2];
            double unscaledX2 = this.verticesXYZ[v2];
            double unscaledY2 = this.verticesXYZ[v2 + 1];
            double unscaledZ2 = this.verticesXYZ[v2 + 2];
            double middleX = 0.5 * (unscaledX1 + unscaledX2) * this.generatrixSet.scale;
            double middleY = 0.5 * (unscaledY1 + unscaledY2) * this.generatrixSet.scale;
            double middleZ = 0.5 * (unscaledZ1 + unscaledZ2) * this.generatrixSet.scale;
            double vx = x - middleX;
            int segmentIndex = this.edgeGeneratrixSegmentIndex(k);
            int dispIJK = 9 * segmentIndex;
            double cx = this.generatrixSegmentsIJK[dispIJK];
            double u = vx * cx + (vy = y - middleY) * (cy = this.generatrixSegmentsIJK[dispIJK + 1]) + (vz = z - middleZ) * (cz = this.generatrixSegmentsIJK[dispIJK + 2]);
            if (!(u >= -(halfHeight = this.generatrixSet.segmentHalfLengths[segmentIndex])) || !(u <= halfHeight) || !((distanceSquare = Orthonormal3DBasis.lengthSquare((double)(vx - u * cx), (double)(vy - u * cy), (double)(vz - u * cz))) < minDistanceSquare)) continue;
            minDistanceSquare = distanceSquare;
        }
        return square ? minDistanceSquare : Math.sqrt(minDistanceSquare);
    }

    long insideStatus(double x, double y, double z, double characteristicSize, boolean essentiallyInside) {
        if (characteristicSize < 0.0) {
            throw new IllegalArgumentException("Negative characteristic size = " + characteristicSize);
        }
        double radiusCorrection = characteristicSize * (essentiallyInside ? -1.0E-7 : 1.0E-7);
        x -= this.centerX;
        y -= this.centerY;
        z -= this.centerZ;
        double correctedRadius = this.generatrixRadius + radiusCorrection;
        if (this.isSphere()) {
            if (correctedRadius <= 0.0) {
                return -1L;
            }
            return Orthonormal3DBasis.lengthSquare((double)x, (double)y, (double)z) <= correctedRadius * correctedRadius ? InsideKind.SINGLE_SPHERE.code : -1L;
        }
        boolean outsideKernel = this.numberOfFacets == 0;
        boolean inSomePrism = false;
        int somePrismOutsideKernelIndex = -1;
        for (int k = 0; k < this.numberOfFacets; ++k) {
            double normalX = this.facetNormalX(k);
            double normalY = this.facetNormalY(k);
            double normalZ = this.facetNormalZ(k);
            double d = this.facetEquationD(k) + radiusCorrection;
            double distance = x * normalX + y * normalY + z * normalZ - d;
            InPrismKind inPrismKind = this.inPerpendicularPrism(k, x, y, z);
            boolean inPrism = inPrismKind.inside(essentiallyInside);
            inSomePrism |= inPrism;
            if (distance > this.generatrixRadius) {
                return -1L;
            }
            if (!(distance > 0.0)) continue;
            if (inPrism) {
                somePrismOutsideKernelIndex = k;
            }
            outsideKernel = true;
        }
        if (!outsideKernel && inSomePrism) {
            return InsideKind.KERNEL.code;
        }
        if (somePrismOutsideKernelIndex != -1) {
            return (long)somePrismOutsideKernelIndex | InsideKind.FACET_PRISM.code;
        }
        if (correctedRadius <= 0.0) {
            return -1L;
        }
        double correctedRadiusSquare = correctedRadius * correctedRadius;
        int k = 0;
        int i = 0;
        while (k < this.numberOfVertices) {
            if (!this.isVertexExactlyDegenerated(k) && Orthonormal3DBasis.lengthSquare((double)(x - (double)this.verticesXYZ[i] * this.generatrixSet.scale), (double)(y - (double)this.verticesXYZ[i + 1] * this.generatrixSet.scale), (double)(z - (double)this.verticesXYZ[i + 2] * this.generatrixSet.scale)) < correctedRadiusSquare) {
                return (long)k | InsideKind.VERTEX_SPHERE.code;
            }
            ++k;
            i += 3;
        }
        for (k = 0; k < this.numberOfEdges; ++k) {
            double halfHeight;
            double cz;
            double vz;
            double cy;
            double vy;
            if (this.isEdgeExactlyDegenerated(k)) continue;
            int v1 = 3 * this.edgesVertices[2 * k];
            int v2 = 3 * this.edgesVertices[2 * k + 1];
            double unscaledX1 = this.verticesXYZ[v1];
            double unscaledY1 = this.verticesXYZ[v1 + 1];
            double unscaledZ1 = this.verticesXYZ[v1 + 2];
            double unscaledX2 = this.verticesXYZ[v2];
            double unscaledY2 = this.verticesXYZ[v2 + 1];
            double unscaledZ2 = this.verticesXYZ[v2 + 2];
            double middleX = 0.5 * (unscaledX1 + unscaledX2) * this.generatrixSet.scale;
            double middleY = 0.5 * (unscaledY1 + unscaledY2) * this.generatrixSet.scale;
            double middleZ = 0.5 * (unscaledZ1 + unscaledZ2) * this.generatrixSet.scale;
            double vx = x - middleX;
            int segmentIndex = this.edgeGeneratrixSegmentIndex(k);
            int dispIJK = 9 * segmentIndex;
            double cx = this.generatrixSegmentsIJK[dispIJK];
            double u = vx * cx + (vy = y - middleY) * (cy = this.generatrixSegmentsIJK[dispIJK + 1]) + (vz = z - middleZ) * (cz = this.generatrixSegmentsIJK[dispIJK + 2]);
            if (!(u >= -(halfHeight = this.generatrixSet.segmentHalfLengths[segmentIndex])) || !(u <= halfHeight) || !(Orthonormal3DBasis.lengthSquare((double)(vx - u * cx), (double)(vy - u * cy), (double)(vz - u * cz)) < correctedRadiusSquare)) continue;
            return (long)k | InsideKind.EDGE_CYLINDER.code;
        }
        return -1L;
    }

    boolean intersectionWithStraight(SpherePolyhedraIntersectionsList points, StraightLine3D straight) {
        points.clear();
        boolean result = this.addIntersectionsWithStraight(points, straight);
        if (result) {
            SpherePolyhedraIntersection entry = points.get(0);
            SpherePolyhedraIntersection exit = points.get(1);
            assert (entry != null && exit != null);
            assert (entry.exists() && exit.exists());
            if (entry.t() > exit.t()) {
                throw new AssertionError((Object)("Incorrect implementation of addIntersectionsWithStraight: entry point " + String.valueOf(entry) + " after exit point " + String.valueOf(exit)));
            }
        }
        return result;
    }

    static boolean intersectionOfSphereWithStraight(double x, double y, double z, double r, double rInv, StraightLine3D straight, SpherePolyhedraIntersection result1, SpherePolyhedraIntersection result2) {
        double m;
        double q;
        double discriminant;
        double p = straight.vectorProjection(x -= straight.x0(), y -= straight.y0(), z -= straight.z0());
        if ((discriminant = p * p - (q = ((m = Orthonormal3DBasis.length((double)x, (double)y, (double)z)) + r) * (m - r))) < 0.0) {
            result1.remove();
            result2.remove();
            return false;
        }
        double sqrt = Math.sqrt(discriminant);
        result1.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_SPHERE, p - sqrt, -sqrt * rInv, -1);
        result2.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_SPHERE, p + sqrt, sqrt * rInv, -1);
        result1.setXYZ(straight);
        result2.setXYZ(straight);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean intersectionOfAnyFacetWithStraightTolerant(StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection entry, SpherePolyhedraIntersection exit, SpherePolyhedraIntersection work) {
        entry.setNegativeInvinify();
        exit.setPositiveInvinify();
        block4: for (int k = 0; k < this.numberOfFacets; ++k) {
            InPrismKind intersectionKind = this.intersectionOfFacetWithStraight(k, straight, centerAtStraight, work);
            switch (intersectionKind.ordinal()) {
                case 0: {
                    if (work.cosine() < 0.0) {
                        entry.setTo(work);
                        if (!exit.surelyExists()) break;
                        break block4;
                    }
                    exit.setTo(work);
                    if (!entry.surelyExists()) break;
                    break block4;
                }
                case 1: {
                    if (work.cosine() < 0.0) {
                        if (entry.surelyExists()) break;
                        entry.maxIfExists(work);
                        break;
                    }
                    if (exit.surelyExists()) break;
                    exit.minIfExists(work);
                }
            }
        }
        if (entry.t() > exit.t()) {
            entry.remove();
            exit.remove();
            return false;
        }
        if (entry.surelyExists() && exit.surelyExists()) {
            return true;
        }
        if (this.generatrixRadius == 0.0 && entry.exists() && exit.exists()) {
            return true;
        }
        if (!entry.surelyExists()) {
            entry.remove();
            entry.setPositiveInvinify();
        }
        if (!exit.surelyExists()) {
            exit.remove();
            exit.setNegativeInvinify();
        }
        return false;
    }

    private boolean intersectionOfAnyFacetWithStraightStrict(StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection entry, SpherePolyhedraIntersection exit, SpherePolyhedraIntersection work) {
        entry.setPositiveInvinify();
        exit.setNegativeInvinify();
        for (int k = 0; k < this.numberOfFacets; ++k) {
            if (this.intersectionOfFacetWithStraight(k, straight, centerAtStraight, work) != InPrismKind.SURE) continue;
            if (work.cosine() < 0.0) {
                entry.setTo(work);
                if (!exit.exists()) continue;
                return true;
            }
            exit.setTo(work);
            if (!entry.exists()) continue;
            return true;
        }
        return false;
    }

    private boolean intersectionOfSphereWithStraight(int vertexIndex, StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection result1, SpherePolyhedraIntersection result2) {
        double x = this.vertexX(vertexIndex);
        double y = this.vertexY(vertexIndex);
        double z = this.vertexZ(vertexIndex);
        return SpherePolyhedraIntersectionsTools.intersectionOfSphereWithStraight(vertexIndex, x, y, z, this.generatrixRadius, this.generatrixRadiusInv, straight, centerAtStraight, result1, result2);
    }

    void intersectionOfCylinderWithStraight(int edgeIndex, StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection result1, SpherePolyhedraIntersection result2, boolean checkAlmost) {
        this.intersectionOfCylinderWithStraightInCylinderCoordinates(edgeIndex, straight, centerAtStraight, result1, result2, checkAlmost);
    }

    private void intersectionOfCylinderWithStraightInCylinderCoordinates(int edgeIndex, StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection result1, SpherePolyhedraIntersection result2, boolean checkAlmost) {
        boolean u2High;
        SpherePolyhedraIntersection.SurfaceType lateralSurfaceType;
        double u1;
        double u2;
        double t1;
        double t2;
        result1.remove();
        result2.remove();
        int v1 = this.edgesVertices[2 * edgeIndex];
        int v2 = this.edgesVertices[2 * edgeIndex + 1];
        double middleX = this.centerX + 0.5 * (this.kernelVertexX(v1) + this.kernelVertexX(v2));
        double middleY = this.centerY + 0.5 * (this.kernelVertexY(v1) + this.kernelVertexY(v2));
        double middleZ = this.centerZ + 0.5 * (this.kernelVertexZ(v1) + this.kernelVertexZ(v2));
        int segmentIndex = this.edgesGeneratrixSegmentIndexes[edgeIndex];
        double almostRadius = this.generatrixRadius + (checkAlmost ? 1.0E-9 * this.containingSphereRadius : 0.0);
        int dispIJK = 9 * segmentIndex;
        double x0 = centerAtStraight.x() - middleX;
        double y0 = centerAtStraight.y() - middleY;
        double z0 = centerAtStraight.z() - middleZ;
        double halfHeight = this.generatrixSet.segmentHalfLengths[segmentIndex];
        double ix = this.generatrixSegmentsIJK[dispIJK];
        double iy = this.generatrixSegmentsIJK[dispIJK + 1];
        double iz = this.generatrixSegmentsIJK[dispIJK + 2];
        double jx = this.generatrixSegmentsIJK[dispIJK + 3];
        double jy = this.generatrixSegmentsIJK[dispIJK + 4];
        double jz = this.generatrixSegmentsIJK[dispIJK + 5];
        double kx = this.generatrixSegmentsIJK[dispIJK + 6];
        double ky = this.generatrixSegmentsIJK[dispIJK + 7];
        double kz = this.generatrixSegmentsIJK[dispIJK + 8];
        double di = straight.vectorProjection(ix, iy, iz);
        double dj = straight.vectorProjection(jx, jy, jz);
        double dk = straight.vectorProjection(kx, ky, kz);
        double i0 = x0 * ix + y0 * iy + z0 * iz;
        double j0 = x0 * jx + y0 * jy + z0 * jz;
        double k0 = x0 * kx + y0 * ky + z0 * kz;
        double a = (1.0 - di) * (1.0 + di);
        if (a <= 0.25) {
            a = dj * dj + dk * dk;
        }
        double p = dj * j0 + dk * k0;
        double pSqr = p * p;
        double m = Math.sqrt(j0 * j0 + k0 * k0);
        if (a <= 9.999999999999998E-15) {
            if (m <= this.generatrixRadius) {
                double t12 = di > 0.0 ? -halfHeight - i0 : halfHeight + i0;
                double t22 = di > 0.0 ? halfHeight - i0 : i0 - halfHeight;
                double cosine = 0.0;
                result1.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, t12, 0.0, edgeIndex);
                result2.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, t22, 0.0, edgeIndex);
            }
            return;
        }
        double q = (m + almostRadius) * (m - almostRadius);
        double discriminant = pSqr - a * q;
        if (discriminant < 0.0) {
            return;
        }
        if (checkAlmost) {
            q = (m + this.generatrixRadius) * (m - this.generatrixRadius);
            discriminant = pSqr - a * q;
        }
        if (discriminant < 0.0) {
            t1 = t2 = -p / a;
            u1 = u2 = i0 + t1 * di;
            lateralSurfaceType = SpherePolyhedraIntersection.SurfaceType.STRAIGHT_ALMOST_CYLINDER;
        } else {
            double sqrt = Math.sqrt(discriminant);
            t1 = (-p - sqrt) / a;
            t2 = (-p + sqrt) / a;
            u1 = i0 + t1 * di;
            u2 = i0 + t2 * di;
            lateralSurfaceType = SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER;
        }
        boolean perpendicular = di <= 1.0E-7 && di >= -1.0E-7;
        boolean u1Low = u1 < -halfHeight;
        boolean u2Low = u2 < -halfHeight;
        boolean u1High = u1 > halfHeight;
        boolean bl = u2High = u2 > halfHeight;
        if (u1 < u2) {
            if (u2Low || u1High) {
                return;
            }
            if (u1Low) {
                if (!perpendicular) {
                    result1.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (-halfHeight - i0) / di);
                }
            } else {
                result1.setT(lateralSurfaceType, t1);
            }
            if (u2High) {
                if (!perpendicular) {
                    result2.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (halfHeight - i0) / di);
                }
            } else {
                result2.setT(lateralSurfaceType, t2);
            }
        } else {
            assert (u1 >= u2);
            if (u1Low || u2High) {
                return;
            }
            if (u1High) {
                if (!perpendicular) {
                    result1.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (halfHeight - i0) / di);
                }
            } else {
                result1.setT(lateralSurfaceType, t1);
            }
            if (u2Low) {
                if (!perpendicular) {
                    result2.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (-halfHeight - i0) / di);
                }
            } else {
                result2.setT(lateralSurfaceType, t2);
            }
        }
        result1.setOthers(this.generatrixRadius == 0.0 ? 0.0 : this.generatrixRadiusInv * (dj * (j0 + t1 * dj) + dk * (k0 + t1 * dk)), edgeIndex);
        result2.setOthers(this.generatrixRadius == 0.0 ? 0.0 : this.generatrixRadiusInv * (dj * (j0 + t2 * dj) + dk * (k0 + t2 * dk)), edgeIndex);
    }

    private void intersectionOfCylinderWithStraightInSpherePolyhedronCoordinates(int edgeIndex, StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection result1, SpherePolyhedraIntersection result2) {
        boolean u2High;
        result1.remove();
        result2.remove();
        int v1 = this.edgesVertices[2 * edgeIndex];
        int v2 = this.edgesVertices[2 * edgeIndex + 1];
        double middleX = this.centerX + 0.5 * (this.kernelVertexX(v1) + this.kernelVertexX(v2));
        double middleY = this.centerY + 0.5 * (this.kernelVertexY(v1) + this.kernelVertexY(v2));
        double middleZ = this.centerZ + 0.5 * (this.kernelVertexZ(v1) + this.kernelVertexZ(v2));
        double vx = centerAtStraight.x() - middleX;
        double vy = centerAtStraight.y() - middleY;
        double vz = centerAtStraight.z() - middleZ;
        int segmentIndex = this.edgesGeneratrixSegmentIndexes[edgeIndex];
        double halfHeight = this.generatrixSet.segmentHalfLengths[segmentIndex];
        double cx = this.generatrixSegmentIX(segmentIndex);
        double cy = this.generatrixSegmentIY(segmentIndex);
        double cz = this.generatrixSegmentIZ(segmentIndex);
        double dc = straight.vectorProjection(cx, cy, cz);
        double a = (1.0 - dc) * (1.0 + dc);
        double cv = cx * vx + cy * vy + cz * vz;
        double p = dc * cv - straight.vectorProjection(vx, vy, vz);
        double perpendicularX = vx - cv * cx;
        double perpendicularY = vy - cv * cy;
        double perpendicularZ = vz - cv * cz;
        double q = Orthonormal3DBasis.lengthSquare((double)perpendicularX, (double)perpendicularY, (double)perpendicularZ) - this.generatrixRadiusSquare;
        if (a <= 9.999999999999998E-15) {
            if (q <= 0.0) {
                double t1 = dc > 0.0 ? -halfHeight - cv : halfHeight + cv;
                double t2 = dc > 0.0 ? halfHeight - cv : cv - halfHeight;
                double cosine = 0.0;
                result1.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, t1, 0.0, edgeIndex);
                result2.setAll(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, t2, 0.0, edgeIndex);
            }
            return;
        }
        double discriminant = p * p - a * q;
        if (discriminant < 0.0) {
            return;
        }
        boolean perpendicular = dc <= 1.0E-7 && dc >= -1.0E-7;
        double sqrt = Math.sqrt(discriminant);
        double t1 = (p - sqrt) / a;
        double t2 = (p + sqrt) / a;
        double wx1 = t1 * straight.dx() + vx;
        double wy1 = t1 * straight.dy() + vy;
        double wz1 = t1 * straight.dz() + vz;
        double u1 = cx * wx1 + cy * wy1 + cz * wz1;
        double wx2 = t2 * straight.dx() + vx;
        double wy2 = t2 * straight.dy() + vy;
        double wz2 = t2 * straight.dz() + vz;
        double u2 = cx * wx2 + cy * wy2 + cz * wz2;
        boolean u1Low = u1 < -halfHeight;
        boolean u2Low = u2 < -halfHeight;
        boolean u1High = u1 > halfHeight;
        boolean bl = u2High = u2 > halfHeight;
        if (u1 < u2) {
            if (u2Low || u1High) {
                return;
            }
            if (u1Low) {
                if (!perpendicular) {
                    result1.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (-halfHeight - cv) / dc);
                }
            } else {
                result1.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER, t1);
            }
            if (u2High) {
                if (!perpendicular) {
                    result2.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (halfHeight - cv) / dc);
                }
            } else {
                result2.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER, t2);
            }
        } else {
            assert (u1 >= u2);
            if (u1Low || u2High) {
                return;
            }
            if (u1High) {
                if (!perpendicular) {
                    result1.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (halfHeight - cv) / dc);
                }
            } else {
                result1.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER, t1);
            }
            if (u2Low) {
                if (!perpendicular) {
                    result2.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER_BASE, (-halfHeight - cv) / dc);
                }
            } else {
                result2.setT(SpherePolyhedraIntersection.SurfaceType.STRAIGHT_CYLINDER, t2);
            }
        }
        result1.setOthers(this.generatrixRadius == 0.0 ? 0.0 : this.generatrixRadiusInv * straight.vectorProjection(wx1 - cx * u1, wy1 - cy * u1, wz1 - cz * u1), edgeIndex);
        result2.setOthers(this.generatrixRadius == 0.0 ? 0.0 : this.generatrixRadiusInv * straight.vectorProjection(wx2 - cx * u2, wy2 - cy * u2, wz2 - cz * u2), edgeIndex);
    }

    private InPrismKind intersectionOfFacetWithStraight(int facetIndex, StraightLine3D straight, SpherePolyhedraIntersection centerAtStraight, SpherePolyhedraIntersection result) {
        double centeredZ0;
        double centeredY0;
        double b;
        double t;
        int dispF = 4 * facetIndex;
        double normalX = this.facetsEquations[dispF];
        double normalY = this.facetsEquations[dispF + 1];
        double normalZ = this.facetsEquations[dispF + 2];
        double surfacePlaneEquationD = this.facetsEquations[dispF + 3] + this.generatrixRadius;
        double a = straight.vectorProjection(normalX, normalY, normalZ);
        if (a == 0.0) {
            result.remove();
            return InPrismKind.NONE;
        }
        double centeredX0 = centerAtStraight.x() - this.centerX;
        InPrismKind inPrism = this.inPerpendicularPrism(facetIndex, centeredX0 + (t = (b = surfacePlaneEquationD - (normalX * centeredX0 + normalY * (centeredY0 = centerAtStraight.y() - this.centerY) + normalZ * (centeredZ0 = centerAtStraight.z() - this.centerZ))) / a) * straight.dx(), centeredY0 + t * straight.dy(), centeredZ0 + t * straight.dz());
        if (inPrism != InPrismKind.NONE) {
            result.setAll(inPrism == InPrismKind.SURE ? SpherePolyhedraIntersection.SurfaceType.STRAIGHT_FACET : SpherePolyhedraIntersection.SurfaceType.STRAIGHT_ALMOST_FACET, t, a, facetIndex);
        } else {
            result.remove();
        }
        return inPrism;
    }

    private InPrismKind inPerpendicularPrism(int facetIndex, double centeredX, double centeredY, double centeredZ) {
        double daEpsilon;
        int vertexIndex = this.facetVertexIndex(facetIndex, 0);
        centeredX -= this.kernelVertexX(vertexIndex);
        centeredY -= this.kernelVertexY(vertexIndex);
        centeredZ -= this.kernelVertexZ(vertexIndex);
        int dispNormals = 3 * facetIndex;
        double pqn = this.facetsAreas[facetIndex];
        assert (pqn >= 0.0);
        double rpn = centeredX * this.facetsPN[dispNormals] + centeredY * this.facetsPN[dispNormals + 1] + centeredZ * this.facetsPN[dispNormals + 2];
        double rqn = centeredX * this.facetsQN[dispNormals] + centeredY * this.facetsQN[dispNormals + 1] + centeredZ * this.facetsQN[dispNormals + 2];
        if (rpn <= 0.0 && rpn >= -pqn && rqn >= 0.0 && rqn <= pqn) {
            return InPrismKind.SURE;
        }
        double pqnEpsilon = pqn * 1.0E-9;
        if (!(rpn <= pqnEpsilon && rpn >= -pqn - pqnEpsilon && rqn >= -pqnEpsilon && rqn <= pqn + pqnEpsilon)) {
            return InPrismKind.NONE;
        }
        int disp = 4 * facetIndex;
        int abEdge = this.facetsEdges[disp];
        int bcEdge = this.facetsEdges[disp + 1];
        int cdEdge = this.facetsEdges[disp + 2];
        int daEdge = this.facetsEdges[disp + 3];
        double abEpsilon = this.isEdgeAlmostDegenerated(abEdge) ? pqnEpsilon : 0.0;
        double bcEpsilon = this.isEdgeAlmostDegenerated(bcEdge) ? pqnEpsilon : 0.0;
        double cdEpsilon = this.isEdgeAlmostDegenerated(cdEdge) ? pqnEpsilon : 0.0;
        double d = daEpsilon = this.isEdgeAlmostDegenerated(daEdge) ? pqnEpsilon : 0.0;
        if (rpn <= abEpsilon && rpn >= -pqn - cdEpsilon && rqn >= -daEpsilon && rqn <= pqn + bcEpsilon) {
            return InPrismKind.SURE;
        }
        return InPrismKind.ALMOST;
    }

    private SpherePolyhedron cloneIt() {
        try {
            return (SpherePolyhedron)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    private static enum InPrismKind {
        SURE,
        ALMOST,
        NONE;


        boolean inside(boolean essentially) {
            return this == SURE || !essentially && this == ALMOST;
        }
    }

    static enum InsideKind {
        NONE(-1L),
        SINGLE_SPHERE(1L),
        KERNEL(2L),
        FACET_PRISM(3L),
        EDGE_CYLINDER(4L),
        VERTEX_SPHERE(5L);

        private final long code;

        private InsideKind(long codeHigh32) {
            this.code = codeHigh32 << 32;
        }

        static InsideKind ofStatus(long insideStatus) {
            for (InsideKind value : InsideKind.values()) {
                if (value.code != (insideStatus & 0xFFFFFFFF00000000L)) continue;
                return value;
            }
            throw new IllegalArgumentException("Unknown insudeStatus = " + insideStatus + ", high word = " + (insideStatus >>> 32));
        }

        boolean hasIndex() {
            return this != NONE && this != SINGLE_SPHERE && this != KERNEL;
        }

        static int index(long insideStatus) {
            return (int)insideStatus;
        }

        static String insideInfo(long insideStatus) {
            if (insideStatus == -1L) {
                return "outside";
            }
            InsideKind kind = InsideKind.ofStatus(insideStatus);
            return "inside " + String.valueOf((Object)kind) + (String)(kind.hasIndex() ? " #" + InsideKind.index(insideStatus) : "");
        }
    }
}

