/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api.data;

import com.siams.stare.api.data.ValueType;
import com.siams.stare.api.data.setting.Setting;
import com.siams.stare.api.data.worker.Worker;
import java.util.Collections;
import java.util.List;

public class Control {
    public String id = "";
    public String url = "";
    public String path = "";
    public EditionType editionType = EditionType.VALUE;
    public String name = "";
    public ValueType valueType = ValueType.NULL;
    public String caption = "";
    public String hint = "";
    public String description = "";
    public String def = "";
    public List<Item> items = Collections.emptyList();
    public FileDialog dialog = FileDialog.OPEN;
    public boolean multiline = false;
    public int editionRows = -1;
    public boolean isResource = false;
    public boolean isAdvanced = false;

    public String getPropertyUrl(Setting setting) {
        return setting.url + "/property:" + this.name;
    }

    public String getPropertyUrl(Worker worker) {
        return worker.url + "/property:" + this.name;
    }

    public String getPropertyUrl(String baseUrl) {
        return baseUrl + "/property:" + this.name;
    }

    public String toString() {
        return "Control{editionType=" + String.valueOf((Object)this.editionType) + ", name='" + this.name + "'}";
    }

    public static enum EditionType {
        ENUM("enum"),
        RANGE("range"),
        VALUE("value"),
        FILE("file"),
        FILE_TO_SAVE("file_to_save"),
        FOLDER("folder"),
        TEXT("text"),
        COLOR("color");

        private String id;

        private EditionType(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public static EditionType from(String editionType) {
            return EditionType.valueOf(editionType.toUpperCase());
        }
    }

    public static enum FileDialog {
        OPEN(0),
        SAVE(1);

        private int id;

        private FileDialog(int id) {
            this.id = id;
        }

        public static FileDialog from(int id) {
            for (FileDialog item : FileDialog.values()) {
                if (item.id != id) continue;
                return item;
            }
            throw new IllegalArgumentException(String.format("Failed create FileDialog, unsupported id: %d", id));
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "open";
                }
                case 1: {
                    return "save";
                }
            }
            throw new RuntimeException("Unsupported");
        }
    }

    public static class Item {
        public String caption = "";
        public String value = "";
    }
}

