/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.node;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.siams.cv.monitor.model.IIdentifiable;
import com.siams.cv.monitor.model.PortType;
import com.siams.cv.monitor.model.node.ConnectionModel;
import com.siams.cv.monitor.model.node.UIPortModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SmartLinkModel
extends ConnectionModel {
    public static String id = "SmartLinkModel";
    @JsonProperty(value="model_type")
    private UUID modelType;
    @JsonProperty(value="ports")
    private List<UIPortModel> portModels = new ArrayList<UIPortModel>();
    @JsonProperty(value="connected_links_uuids")
    private List<UUID> connectedLinksUuids;

    @JsonCreator
    public SmartLinkModel() {
    }

    @JsonGetter(value="model_type")
    public UUID getModelType() {
        return this.modelType;
    }

    @JsonSetter(value="model_type")
    public void setModelType(UUID modelType) {
        this.modelType = modelType;
    }

    @JsonGetter(value="ports")
    public List<UIPortModel> getPorts() {
        return this.portModels;
    }

    @JsonSetter(value="ports")
    private void setPorts(List<UIPortModel> portModels) {
        this.portModels = portModels;
    }

    @JsonGetter(value="connected_links_uuids")
    public List<UUID> getConnectedLinksUuids() {
        return this.connectedLinksUuids;
    }

    @JsonSetter(value="connected_links_uuids")
    public void setConnectedLinksUuids(List<UUID> connectedLinksUuids) {
        this.connectedLinksUuids = connectedLinksUuids;
    }

    @JsonIgnore
    public List<UIPortModel> getPorts(PortType portType) {
        return this.portModels.stream().filter(portModel -> portModel.getPortType().equals((Object)portType)).collect(Collectors.toList());
    }

    @JsonIgnore
    public Optional<UIPortModel> findPort(IIdentifiable iid) {
        return this.findPort(iid.getUuid());
    }

    @JsonIgnore
    public Optional<UIPortModel> findPort(UUID uuid) {
        return this.portModels.stream().filter(portModel -> portModel.getUuid().equals(uuid)).findFirst();
    }

    @JsonIgnore
    public Optional<UIPortModel> findPort(PortType portType, String name) {
        return this.portModels.stream().filter(portModel -> portModel.getPortType() == portType && portModel.getName().equals(name)).findFirst();
    }

    @JsonIgnore
    public void addLink(UUID linkUuid) {
        this.connectedLinksUuids.add(linkUuid);
    }

    @Override
    public void release() {
    }
}

