/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.viewer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.siams.cv.monitor.model.viewer.BlockViewerModel;
import com.siams.cv.monitor.model.viewer.ViewerKind;
import java.nio.file.Path;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PokeViewerModel
extends BlockViewerModel {
    public static String id = "ImageViewerModel";
    private String projectPath;
    private String imagePath;
    private String contoursPath;
    private String featuresPath;

    @JsonCreator
    public PokeViewerModel() {
        this.kind = ViewerKind.POKE.toString();
        this.initializePaths();
    }

    public PokeViewerModel(UUID blockId) {
        this.kind = ViewerKind.POKE.toString();
        this.setBlockUuid(blockId);
        this.initializePaths();
    }

    private void initializePaths() {
        String tmpDir = System.getProperty("java.io.tmpdir");
        this.projectPath = Path.of(tmpDir, "tmp_poke_project.json").toString();
        this.imagePath = Path.of(tmpDir, "tmp_poke_image.bmp").toString();
        this.contoursPath = Path.of(tmpDir, "tmp_poke_contours.dat").toString();
        this.featuresPath = Path.of(tmpDir, "tmp_poke_features.dat").toString();
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getContoursPath() {
        return this.contoursPath;
    }

    public void setContoursPath(String contoursPath) {
        this.contoursPath = contoursPath;
    }

    public String getFeaturesPath() {
        return this.featuresPath;
    }

    public void setFeaturesPath(String featuresPath) {
        this.featuresPath = featuresPath;
    }
}

