/*
 * Decompiled with CFR 0.152.
 */
package com.siams.cv.monitor.model.viewer;

import java.util.Arrays;
import java.util.Map;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.DataType;
import net.algart.executors.api.data.SMat;

public enum ViewerKind {
    UNKNOWN("Unknown"),
    PLAIN_TEXT("Plain text"),
    TABLE("Table"),
    TEXT_EDITOR("Text editor"),
    IMAGE("Image"),
    BOUNDARIES("Boundaries"),
    MASK("Mask"),
    CROP("Crop"),
    CHART("Chart"),
    SPHEREPOLYHEDRA("Spherepolyhedra"),
    COMPARE("Image compare"),
    VOXEL("Voxel"),
    POKE("Poke&Look"),
    TRIANGULATION("Triangulation"),
    DEFAULT("Default");

    private final String name;

    private ViewerKind(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static ViewerKind from(String name, Data data) {
        return Arrays.stream(ViewerKind.values()).filter(kind -> kind != DEFAULT && kind.name.equalsIgnoreCase(name)).findFirst().orElseGet(() -> ViewerKind.from(data));
    }

    public static ViewerKind from(Data data) {
        if (data == null) {
            return UNKNOWN;
        }
        return switch (data.type()) {
            default -> throw new MatchException(null, null);
            case DataType.MAT -> {
                SMat sMat = (SMat)data;
                int dimCount = sMat.getDimCount();
                if (dimCount == 3) {
                    yield VOXEL;
                }
                if (dimCount == 2) {
                    if (sMat.getDepth() == SMat.Depth.BIT) {
                        yield MASK;
                    }
                    if (sMat.getDepth() == SMat.Depth.F32 && sMat.getNumberOfChannels() == 1) {
                        yield BOUNDARIES;
                    }
                    yield IMAGE;
                }
                yield UNKNOWN;
            }
            case DataType.NUMBERS -> TABLE;
            case DataType.SCALAR -> PLAIN_TEXT;
        };
    }

    public static ViewerKind from(String name, Map<String, Data> requiredData) {
        return Arrays.stream(ViewerKind.values()).filter(kind -> kind != DEFAULT && kind.name.equalsIgnoreCase(name)).findFirst().or(() -> requiredData.keySet().stream().filter(key -> !key.equals("default")).map(requiredData::get).map(ViewerKind::from).findFirst()).orElseGet(() -> ViewerKind.from((Data)requiredData.get("default")));
    }

    public static ViewerKind from(String name) {
        return Arrays.stream(ViewerKind.values()).filter(kind -> kind.name.equals(name)).findFirst().orElse(UNKNOWN);
    }
}

