/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataCharBuffer;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.MutableCharArray;
import net.algart.arrays.SizeMismatchException;
import net.algart.arrays.UnallowedMutationError;
import net.algart.arrays.UpdatableCharArray;

public abstract class AbstractCharArray
extends AbstractArray
implements CharArray {
    final boolean underlyingArraysAreParallel;

    protected AbstractCharArray(long initialCapacity, long initialLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        super(initialCapacity, initialLength, underlyingArrays);
        if (initialLength < 0L) {
            throw new IllegalArgumentException("Negative initialLength argument");
        }
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initialCapacity argument");
        }
        if (initialLength > initialCapacity) {
            throw new IllegalArgumentException("initialCapacity argument must not be less than initialLength");
        }
        Objects.requireNonNull(underlyingArrays, "Null underlyingArrays argument");
        this.underlyingArraysAreParallel = underlyingArraysAreParallel;
        long len = -1L;
        for (int k = 0; k < underlyingArrays.length; ++k) {
            Objects.requireNonNull(underlyingArrays[k], "Null underlyingArrays[" + k + "] argument");
            if (!underlyingArraysAreParallel) continue;
            if (k == 0) {
                len = underlyingArrays[k].length();
                continue;
            }
            if (underlyingArrays[k].length() == len) continue;
            throw new SizeMismatchException("underlyingArrays[" + k + "].length() and underlyingArrays[0].length() mismatch");
        }
    }

    protected AbstractCharArray(long initialCapacityAndLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        this(initialCapacityAndLength, initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
    }

    @Override
    public Class<?> elementType() {
        return Character.TYPE;
    }

    @Override
    public Class<? extends CharArray> type() {
        return CharArray.class;
    }

    @Override
    public Class<? extends UpdatableCharArray> updatableType() {
        return UpdatableCharArray.class;
    }

    @Override
    public Class<? extends MutableCharArray> mutableType() {
        return MutableCharArray.class;
    }

    @Override
    public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        char[] a = (char[])destArray;
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw this.rangeException(arrayPos);
        }
        if (arrayPos > this.length - (long)count) {
            throw this.rangeException(arrayPos + (long)count - 1L);
        }
        long arrayPosMax = arrayPos + (long)count;
        while (arrayPos < arrayPosMax) {
            a[destArrayOffset] = this.getChar(arrayPos);
            ++arrayPos;
            ++destArrayOffset;
        }
    }

    @Override
    public void getData(long arrayPos, Object destArray) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (arrayPos < 0L || arrayPos > this.length) {
            throw this.rangeException(arrayPos);
        }
        int count = ((char[])destArray).length;
        if ((long)count > this.length - arrayPos) {
            count = (int)(this.length - arrayPos);
        }
        this.getData(arrayPos, destArray, 0, count);
    }

    @Override
    public Object getElement(long index) {
        return Character.valueOf(this.getChar(index));
    }

    @Override
    public Array subArray(long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        final AbstractCharArray parent = this;
        final long offset = fromIndex;
        return new AbstractCharArray(this, toIndex - fromIndex, this.underlyingArraysAreParallel, this.underlyingArrays){

            @Override
            public char getChar(long index) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                return parent.getChar(offset + index);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, char value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.indexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, char value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.lastIndexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.getData(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, offset + fromIndex, offset + toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public DataCharBuffer buffer(DataBuffer.AccessMode mode, long capacity) {
        return (DataCharBuffer)super.buffer(mode, capacity);
    }

    @Override
    public DataCharBuffer buffer(DataBuffer.AccessMode mode) {
        return (DataCharBuffer)super.buffer(mode);
    }

    @Override
    public DataCharBuffer buffer(long capacity) {
        return (DataCharBuffer)super.buffer(capacity);
    }

    @Override
    public DataCharBuffer buffer() {
        return (DataCharBuffer)super.buffer();
    }

    @Override
    public long bitsPerElement() {
        return 16L;
    }

    @Override
    public double getDouble(long index) {
        return this.getChar(index);
    }

    @Override
    public long indexOf(long lowIndex, long highIndex, double value) {
        return value == (double)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
    }

    @Override
    public long lastIndexOf(long lowIndex, long highIndex, double value) {
        return value == (double)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
    }

    @Override
    public long getLong(long index) {
        return this.getChar(index);
    }

    @Override
    public int getInt(long index) {
        return this.getChar(index);
    }

    @Override
    public long indexOf(long lowIndex, long highIndex, long value) {
        return value == (long)((char)value) ? this.indexOf(lowIndex, highIndex, (char)value) : -1L;
    }

    @Override
    public long lastIndexOf(long lowIndex, long highIndex, long value) {
        return value == (long)((char)value) ? this.lastIndexOf(lowIndex, highIndex, (char)value) : -1L;
    }

    @Override
    public abstract char getChar(long var1);

    @Override
    public long indexOf(long lowIndex, long highIndex, char value) {
        long n = Math.min(this.length(), highIndex);
        for (long k = Math.max(lowIndex, 0L); k < n; ++k) {
            if (this.getChar(k) != value) continue;
            return k;
        }
        return -1L;
    }

    @Override
    public long lastIndexOf(long lowIndex, long highIndex, char value) {
        long k = Math.min(this.length(), highIndex);
        long low = Math.max(lowIndex, 0L);
        while (k > low) {
            if (this.getChar(--k) != value) continue;
            return k;
        }
        return -1L;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public boolean isUnresizable() {
        return true;
    }

    @Override
    public void checkUnallowedMutation() throws UnallowedMutationError {
    }

    @Override
    public CharArray asTrustedImmutable() {
        return this.asImmutable();
    }

    @Override
    public Array asCopyOnNextWrite() {
        return this;
    }

    @Override
    public boolean isCopyOnNextWrite() {
        return false;
    }

    @Override
    public CharArray asImmutable() {
        return this;
    }

    @Override
    public MutableCharArray mutableClone(MemoryModel memoryModel) {
        return (MutableCharArray)super.mutableClone(memoryModel);
    }

    @Override
    public UpdatableCharArray updatableClone(MemoryModel memoryModel) {
        return (UpdatableCharArray)super.updatableClone(memoryModel);
    }

    @Override
    public char[] ja() {
        return (char[])super.ja();
    }

    @Override
    public void loadResources(ArrayContext context) {
        this.loadResources(context, 0L, this.length());
    }

    @Override
    public void flushResources(ArrayContext context, boolean forcePhysicalWriting) {
        this.flushResources(context, 0L, this.length(), forcePhysicalWriting);
    }

    @Override
    public void freeResources(ArrayContext context, boolean forcePhysicalWriting) {
        this.freeResources(context, 0L, this.length(), forcePhysicalWriting);
    }

    protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).loadResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length));
            }
        }
    }

    protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).flushResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
            }
        } else {
            super.flushResources(context, forcePhysicalWriting);
        }
    }

    protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        if (this.underlyingArraysAreParallel) {
            for (int k = 0; k < this.underlyingArrays.length; ++k) {
                this.underlyingArrays[k].subArray(fromIndex, toIndex).freeResources(context == null ? null : context.part(k, k + 1, this.underlyingArrays.length), forcePhysicalWriting);
            }
        } else {
            super.freeResources(context, forcePhysicalWriting);
        }
    }

    @Override
    public String toString() {
        return "immutable AlgART array char[" + this.length + "]" + (String)(this.underlyingArrays.length == 0 ? "" : " based on " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : ""));
    }

    @Override
    Object javaArrayInternal() {
        return null;
    }

    @Override
    int javaArrayOffsetInternal() {
        return 0;
    }

    @Override
    public double minPossibleValue(double valueForFloatingPoint) {
        return this.minPossibleValue();
    }

    @Override
    public double maxPossibleValue(double valueForFloatingPoint) {
        return this.maxPossibleValue();
    }

    @Override
    public long minPossibleValue() {
        return 0L;
    }

    @Override
    public long maxPossibleValue() {
        return 65535L;
    }
}

