/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractLongArray;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableLongArray;

public abstract class AbstractUpdatableLongArray
extends AbstractLongArray
implements UpdatableLongArray {
    protected AbstractUpdatableLongArray(long initialCapacity, long initialLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        super(initialCapacity, initialLength, underlyingArraysAreParallel, underlyingArrays);
    }

    protected AbstractUpdatableLongArray(long initialCapacityAndLength, boolean underlyingArraysAreParallel, Array ... underlyingArrays) {
        this(initialCapacityAndLength, initialCapacityAndLength, underlyingArraysAreParallel, underlyingArrays);
    }

    @Override
    public UpdatableLongArray subArray(long fromIndex, long toIndex) {
        this.checkSubArrayArguments(fromIndex, toIndex);
        final AbstractUpdatableLongArray parent = this;
        final long offset = fromIndex;
        return new AbstractUpdatableLongArray(this, toIndex - fromIndex, this.underlyingArraysAreParallel, this.underlyingArrays){

            @Override
            public long getLong(long index) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                return parent.getLong(offset + index);
            }

            @Override
            public void setLong(long index, long value) {
                if (index < 0L || index >= this.length) {
                    throw this.rangeException(index);
                }
                parent.setLong(offset + index, value);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, long value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.indexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, long value) {
                if (lowIndex < 0L) {
                    lowIndex = 0L;
                }
                if (highIndex > this.length) {
                    highIndex = this.length;
                }
                if (highIndex <= lowIndex) {
                    return -1L;
                }
                long result = parent.lastIndexOf(offset + lowIndex, offset + highIndex, value);
                return result == -1L ? -1L : result - offset;
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.getData(offset + arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
                if (count < 0) {
                    throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
                }
                if (arrayPos < 0L) {
                    throw this.rangeException(arrayPos);
                }
                if (arrayPos > this.length - (long)count) {
                    throw this.rangeException(arrayPos + (long)count - 1L);
                }
                parent.setData(offset + arrayPos, srcArray, srcArrayOffset, count);
                return this;
            }

            @Override
            public UpdatableLongArray fill(long position, long count, long value) {
                this.checkSubArrArguments(position, count);
                parent.fill(offset + position, count, value);
                return this;
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, offset + fromIndex, offset + toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, offset + fromIndex, offset + toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableLongArray subArr(long position, long count) {
        return this.subArray(position, position + count);
    }

    @Override
    public void setDouble(long index, double value) {
        this.setLong(index, (long)value);
    }

    @Override
    public void setInt(long index, int value) {
        this.setLong(index, value);
    }

    @Override
    public abstract void setLong(long var1, long var3);

    @Override
    public final UpdatableLongArray fill(double value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableLongArray fill(long position, long count, double value) {
        return this.fill(position, count, (long)value);
    }

    @Override
    public final UpdatableLongArray fill(long value) {
        return this.fill(0L, this.length(), value);
    }

    @Override
    public UpdatableLongArray fill(long position, long count, long value) {
        UpdatableLongArray a = position == 0L && count == this.length() ? this : this.subArr(position, count);
        a.copy(Arrays.nLongCopies(count, value));
        return this;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public LongArray asImmutable() {
        final AbstractUpdatableLongArray parent = this;
        return new AbstractLongArray(this, this.length, false, this.underlyingArrays){

            @Override
            public long getLong(long index) {
                return parent.getLong(index);
            }

            @Override
            public long indexOf(long lowIndex, long highIndex, long value) {
                return parent.indexOf(lowIndex, highIndex, value);
            }

            @Override
            public long lastIndexOf(long lowIndex, long highIndex, long value) {
                return parent.lastIndexOf(lowIndex, highIndex, value);
            }

            @Override
            public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
                parent.getData(arrayPos, destArray, destArrayOffset, count);
            }

            @Override
            public void getData(long arrayPos, Object destArray) {
                parent.getData(arrayPos, destArray);
            }

            @Override
            public boolean isLazy() {
                return parent.isLazy();
            }

            @Override
            protected void loadResources(ArrayContext context, long fromIndex, long toIndex) {
                parent.loadResources(context, fromIndex, toIndex);
            }

            @Override
            protected void flushResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.flushResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }

            @Override
            protected void freeResources(ArrayContext context, long fromIndex, long toIndex, boolean forcePhysicalWriting) {
                parent.freeResources(context, fromIndex, toIndex, forcePhysicalWriting);
            }
        };
    }

    @Override
    public UpdatableArray shallowClone() {
        return (UpdatableArray)super.shallowClone();
    }

    @Override
    public void setElement(long index, Object value) {
        this.setLong(index, (Long)value);
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        long[] a = (long[])srcArray;
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw this.rangeException(arrayPos);
        }
        if (arrayPos > this.length - (long)count) {
            throw this.rangeException(arrayPos + (long)count - 1L);
        }
        long arrayPosMax = arrayPos + (long)count;
        while (arrayPos < arrayPosMax) {
            this.setLong(arrayPos, a[srcArrayOffset]);
            ++arrayPos;
            ++srcArrayOffset;
        }
        return this;
    }

    @Override
    public UpdatableArray setData(long arrayPos, Object srcArray) {
        Objects.requireNonNull(srcArray, "Null srcArray argument");
        if (arrayPos < 0L || arrayPos > this.length) {
            throw this.rangeException(arrayPos);
        }
        int count = ((long[])srcArray).length;
        if ((long)count > this.length - arrayPos) {
            count = (int)(this.length - arrayPos);
        }
        this.setData(arrayPos, srcArray, 0, count);
        return this;
    }

    @Override
    public void copy(long destIndex, long srcIndex) {
        this.setLong(destIndex, this.getLong(srcIndex));
    }

    @Override
    public void copy(long destIndex, long srcIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of copied elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        if (srcIndex <= destIndex && srcIndex + count > destIndex) {
            srcIndex += count;
            destIndex += count;
            for (long k = 0L; k < count; ++k) {
                this.copy(--destIndex, --srcIndex);
            }
        } else {
            for (long k = 0L; k < count; ++k) {
                this.copy(destIndex++, srcIndex++);
            }
        }
    }

    @Override
    public void swap(long firstIndex, long secondIndex) {
        long temp = this.getLong(firstIndex);
        this.setLong(firstIndex, this.getLong(secondIndex));
        this.setLong(secondIndex, temp);
    }

    @Override
    public void swap(long firstIndex, long secondIndex, long count) {
        if (count < 0L) {
            throw new IndexOutOfBoundsException("Negative number of swapped elements (count = " + count + ") in " + String.valueOf(this.getClass()));
        }
        for (long k = 0L; k < count; ++k) {
            this.swap(firstIndex++, secondIndex++);
        }
    }

    @Override
    public UpdatableArray copy(Array src) {
        AbstractUpdatableLongArray.defaultCopy(this, src);
        return this;
    }

    @Override
    public UpdatableArray swap(UpdatableArray another) {
        AbstractUpdatableLongArray.defaultSwap(this, another);
        return this;
    }

    @Override
    public void setNonNew() {
        this.setNewStatus(false);
    }

    @Override
    public UpdatableArray asCopyOnNextWrite() {
        return this.updatableClone(Arrays.SMM);
    }

    @Override
    public UpdatableLongArray asUnresizable() {
        return this;
    }

    @Override
    public String toString() {
        return "unresizable AlgART array long[" + this.length + "]" + (String)(this.underlyingArrays.length == 0 ? "" : " based on " + this.underlyingArrays.length + " underlying array" + (this.underlyingArrays.length > 1 ? "s" : ""));
    }
}

