/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import net.algart.arrays.MemoryModel;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableArray;

public class ArrayPool {
    private final MemoryModel memoryModel;
    private final Class<?> elementType;
    private final long arrayLength;
    private final List<Reference<UpdatableArray>> freeArrays = new LinkedList<Reference<UpdatableArray>>();
    private final ReentrantLock lock = new ReentrantLock();

    private ArrayPool(MemoryModel memoryModel, Class<?> elementType, long arrayLength) {
        Objects.requireNonNull(memoryModel, "Null memoryModel argument");
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (arrayLength < 0L) {
            throw new IllegalArgumentException("Negative arrayLength");
        }
        this.memoryModel = memoryModel;
        this.elementType = elementType;
        this.arrayLength = arrayLength;
    }

    public static ArrayPool getInstance(MemoryModel memoryModel, Class<?> elementType, long arrayLength) {
        return new ArrayPool(memoryModel, elementType, arrayLength);
    }

    public MemoryModel memoryModel() {
        return this.memoryModel;
    }

    public Class<?> elementType() {
        return this.elementType;
    }

    public long arrayLength() {
        return this.arrayLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatableArray requestArray() {
        this.lock.lock();
        try {
            Iterator<Reference<UpdatableArray>> iterator = this.freeArrays.iterator();
            while (iterator.hasNext()) {
                Reference<UpdatableArray> ref = iterator.next();
                UpdatableArray array = ref.get();
                iterator.remove();
                if (array == null) continue;
                UpdatableArray updatableArray = array;
                return updatableArray;
            }
            UpdatableArray updatableArray = this.newArray();
            return updatableArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void releaseArray(UpdatableArray array) {
        if (array == null) {
            return;
        }
        if (array.elementType() != this.elementType) {
            throw new IllegalArgumentException("The type of array elements does not match this AlgART array pool");
        }
        if (array.length() != this.arrayLength) {
            throw new IllegalArgumentException("The array length does not match this AlgART array pool");
        }
        this.lock.lock();
        try {
            Reference ref = SimpleMemoryModel.isSimpleArray(array) ? new SoftReference<UpdatableArray>(array) : new WeakReference<UpdatableArray>(array);
            this.freeArrays.add(ref);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "AlgART array pool for storing " + this.elementType.getCanonicalName() + "[" + this.arrayLength + "] (" + this.freeArrays.size() + " arrays in the cache)";
    }

    private UpdatableArray newArray() {
        return this.memoryModel.newUnresizableArray(this.elementType, this.arrayLength);
    }
}

