/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.BufferArraysImpl;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.math.functions.LinearFunc;

class ArraysLinearGetDataOp {
    static final int LINEAR_BUFFER_LENGTH = 16384;
    private static final boolean OPTIMIZE_LINEAR_FOR_JARRAYS = true;
    private static final boolean OPTIMIZE_LINEAR_FOR_JBUFFERS = InternalUtils.SERVER_OPTIMIZATION;
    static final JArrayPool BOOLEAN_BUFFERS = JArrayPool.getInstance(Boolean.TYPE, 16384);
    static final JArrayPool CHAR_BUFFERS = JArrayPool.getInstance(Character.TYPE, 16384);
    static final JArrayPool BYTE_BUFFERS = JArrayPool.getInstance(Byte.TYPE, 16384);
    static final JArrayPool SHORT_BUFFERS = JArrayPool.getInstance(Short.TYPE, 16384);
    static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, 16384);
    static final JArrayPool LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 16384);
    static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 16384);
    static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 16384);
    private final boolean truncateOverflows;
    private final PArray[] x;
    private final long length;
    private final double a0;
    private final double b;
    private final double[] a;
    private final boolean isNonweightedSum;
    private final boolean isCast;
    private final Object[] jaOrDStor;
    private final long[] saShift;
    private final long[] subArrayOffset;
    private final int[] srcElementTypeCode;
    private final int destElementTypeCode;
    private final boolean intBufferForSum;

    ArraysLinearGetDataOp(boolean truncateOverflows, PArray[] x, LinearFunc lf, int destElementTypeCode) {
        int k;
        Objects.requireNonNull(lf, "Null lf argument");
        if (lf.n() == 0) {
            throw new AssertionError((Object)("No coefficients in the specified function " + String.valueOf(lf)));
        }
        this.truncateOverflows = truncateOverflows;
        this.x = new PArray[lf.n()];
        System.arraycopy(x, 0, this.x, 0, this.x.length);
        this.length = this.x[0].length();
        for (PArray xk : this.x) {
            if (xk.length() != this.length) {
                throw new AssertionError((Object)"Different x[] lengths");
            }
        }
        this.a0 = lf.a(0);
        this.a = lf.a();
        if (this.a.length != lf.n()) {
            throw new AssertionError((Object)"Illegal implementation of LinearFunc: n()!=a().length");
        }
        this.isNonweightedSum = this.a.length > 1 && this.a0 != 0.0 && lf.isNonweighted();
        double bTemp = lf.b();
        if (this.isNonweightedSum) {
            for (k = 0; k < this.a.length; ++k) {
                this.a[k] = 1.0;
            }
            bTemp /= this.a0;
        }
        this.b = bTemp;
        this.isCast = !this.isNonweightedSum && this.a0 == 1.0 && this.b == 0.0;
        this.jaOrDStor = new Object[this.x.length];
        this.subArrayOffset = new long[this.x.length];
        this.saShift = new long[this.x.length];
        for (k = 0; k < this.x.length; ++k) {
            Array array = this.x[k];
            if (Arrays.isShifted(array)) {
                this.saShift[k] = Arrays.getShift(array);
                array = Arrays.getUnderlyingArrays(array)[0];
            }
            this.jaOrDStor[k] = array instanceof BitArray ? (Object)Arrays.longJavaArrayInternal((BitArray)array) : Arrays.javaArrayInternal(array);
            if (this.jaOrDStor[k] != null) {
                this.subArrayOffset[k] = array instanceof BitArray ? Arrays.longJavaArrayOffsetInternal((BitArray)array) : (long)Arrays.javaArrayOffsetInternal(array);
            }
            if (!OPTIMIZE_LINEAR_FOR_JBUFFERS || this.jaOrDStor[k] != null || !(array instanceof BufferArraysImpl.AbstractBufferArray) || array instanceof BitArray) continue;
            this.jaOrDStor[k] = ((BufferArraysImpl.AbstractBufferArray)array).storage;
            this.subArrayOffset[k] = ((BufferArraysImpl.AbstractBufferArray)array).offset;
        }
        this.srcElementTypeCode = new int[this.a.length];
        boolean only16BitsOrLess = true;
        for (int k2 = 0; k2 < this.x.length; ++k2) {
            if (this.x[k2] instanceof BitArray) {
                this.srcElementTypeCode[k2] = 1;
                continue;
            }
            if (this.x[k2] instanceof CharArray) {
                this.srcElementTypeCode[k2] = 2;
                continue;
            }
            if (this.x[k2] instanceof ByteArray) {
                this.srcElementTypeCode[k2] = 3;
                continue;
            }
            if (this.x[k2] instanceof ShortArray) {
                this.srcElementTypeCode[k2] = 4;
                continue;
            }
            if (this.x[k2] instanceof IntArray) {
                this.srcElementTypeCode[k2] = 5;
                only16BitsOrLess = false;
                continue;
            }
            if (this.x[k2] instanceof LongArray) {
                this.srcElementTypeCode[k2] = 6;
                only16BitsOrLess = false;
                continue;
            }
            if (this.x[k2] instanceof FloatArray) {
                this.srcElementTypeCode[k2] = 7;
                only16BitsOrLess = false;
                continue;
            }
            if (this.x[k2] instanceof DoubleArray) {
                this.srcElementTypeCode[k2] = 8;
                only16BitsOrLess = false;
                continue;
            }
            throw new AssertionError((Object)("Illegal PArray type: " + String.valueOf(this.x[k2].getClass())));
        }
        this.destElementTypeCode = destElementTypeCode;
        this.intBufferForSum = this.isNonweightedSum && only16BitsOrLess && this.a.length < Short.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
        Objects.requireNonNull(destArray, "Null destArray argument");
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
        }
        if (arrayPos < 0L) {
            throw AbstractArray.rangeException(arrayPos, this.x[0].length(), this.x[0].getClass());
        }
        if (arrayPos > this.x[0].length() - (long)count) {
            throw AbstractArray.rangeException(arrayPos + (long)count - 1L, this.x[0].length(), this.x[0].getClass());
        }
        while (count > 0) {
            len = Math.min(count, 16384);
            intBuf = null;
            doubleBuf = null;
            try {
                if (this.intBufferForSum) {
                    intBuf = (int[])ArraysLinearGetDataOp.INT_BUFFERS.requestArray();
                } else {
                    doubleBuf = (double[])ArraysLinearGetDataOp.DOUBLE_BUFFERS.requestArray();
                    if (this.isNonweightedSum) {
                        JArrays.fillDoubleArray(doubleBuf, 0, len, this.b);
                    }
                }
                block48: for (k = 0; k < this.x.length; ++k) {
                    p = arrayPos;
                    optimizeJBuffer = this.jaOrDStor[k] instanceof DataStorage;
                    v0 = optimizeJArray = optimizeJBuffer == false && this.jaOrDStor[k] != null;
                    if ((optimizeJArray || optimizeJBuffer) && (p -= this.saShift[k]) < 0L && (p += this.length) >= this.length - (long)len) {
                        optimizeJBuffer = false;
                        optimizeJArray = false;
                    }
                    switch (this.srcElementTypeCode[k]) {
                        case 1: {
                            if (k > 0 && optimizeJArray && this.isNonweightedSum && intBuf != null) {
                                src /* !! */  = (boolean[])((long[])this.jaOrDStor[k]);
                                srcOffset = p + this.subArrayOffset[k];
                                PackedBitArrays.addBitsToInts(intBuf, 0, (long[])src /* !! */ , srcOffset, len);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])ArraysLinearGetDataOp.BOOLEAN_BUFFERS.requestArray();
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        if (k == 0) {
                                            for (j = 0; j < len; ++j) {
                                                intBuf[j] = src /* !! */ [j] != false ? 1 : 0;
                                            }
                                            continue block48;
                                        }
                                        for (j = 0; j < len; ++j) {
                                            if (!src /* !! */ [j]) continue;
                                            v1 = j;
                                            intBuf[v1] = intBuf[v1] + 1;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        if (!src /* !! */ [j]) continue;
                                        v2 = j;
                                        doubleBuf[v2] = doubleBuf[v2] + 1.0;
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = src /* !! */ [j] != false ? this.a[0] + this.b : this.b;
                                    }
                                    continue block48;
                                }
                                for (j = 0; j < len; ++j) {
                                    if (!src /* !! */ [j]) continue;
                                    v3 = j;
                                    doubleBuf[v3] = doubleBuf[v3] + this.a[k];
                                }
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.BOOLEAN_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        case 2: {
                            if (k > 0 && optimizeJBuffer) {
                                storage = (DataStorage)this.jaOrDStor[k];
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        storage.addData(p + this.subArrayOffset[k], intBuf, 0, len);
                                        continue block48;
                                    }
                                    storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, 1.0);
                                    continue block48;
                                }
                                storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, this.a[k]);
                                continue block48;
                            }
                            if (k > 0 && optimizeJArray) {
                                src /* !! */  = (boolean[])((char[])this.jaOrDStor[k]);
                                srcOffset = (int)(p + this.subArrayOffset[k]);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        JArrays.addCharArray(intBuf, 0, (char[])src /* !! */ , srcOffset, len);
                                        continue block48;
                                    }
                                    JArrays.addCharArray(doubleBuf, 0, (char[])src /* !! */ , srcOffset, len, 1.0);
                                    continue block48;
                                }
                                JArrays.addCharArray(doubleBuf, 0, (char[])src /* !! */ , srcOffset, len, this.a[k]);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])((char[])ArraysLinearGetDataOp.CHAR_BUFFERS.requestArray());
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        if (k == 0) {
                                            for (j = 0; j < len; ++j) {
                                                intBuf[j] = src /* !! */ [j];
                                            }
                                            continue block48;
                                        }
                                        JArrays.addCharArray(intBuf, 0, (char[])src /* !! */ , 0, len);
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        v4 = j;
                                        doubleBuf[v4] = doubleBuf[v4] + (double)src /* !! */ [j];
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    if (this.isCast) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j];
                                        }
                                        continue block48;
                                    }
                                    if (this.a0 == 1.0) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j] + this.b;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = this.a0 * (double)src /* !! */ [j] + this.b;
                                    }
                                    continue block48;
                                }
                                JArrays.addCharArray(doubleBuf, 0, (char[])src /* !! */ , 0, len, this.a[k]);
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.CHAR_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        case 3: {
                            if (k > 0 && optimizeJBuffer) {
                                storage = (DataStorage)this.jaOrDStor[k];
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        storage.addData(p + this.subArrayOffset[k], intBuf, 0, len);
                                        continue block48;
                                    }
                                    storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, 1.0);
                                    continue block48;
                                }
                                storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, this.a[k]);
                                continue block48;
                            }
                            if (k > 0 && optimizeJArray) {
                                src /* !! */  = (boolean[])((byte[])this.jaOrDStor[k]);
                                srcOffset = (int)(p + this.subArrayOffset[k]);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        JArrays.addByteArray(intBuf, 0, (byte[])src /* !! */ , srcOffset, len);
                                        continue block48;
                                    }
                                    JArrays.addByteArray(doubleBuf, 0, (byte[])src /* !! */ , srcOffset, len, 1.0);
                                    continue block48;
                                }
                                JArrays.addByteArray(doubleBuf, 0, (byte[])src /* !! */ , srcOffset, len, this.a[k]);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])((byte[])ArraysLinearGetDataOp.BYTE_BUFFERS.requestArray());
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        if (k == 0) {
                                            for (j = 0; j < len; ++j) {
                                                intBuf[j] = src /* !! */ [j] & 255;
                                            }
                                            continue block48;
                                        }
                                        JArrays.addByteArray(intBuf, 0, (byte[])src /* !! */ , 0, len);
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        v5 = j;
                                        doubleBuf[v5] = doubleBuf[v5] + (double)(src /* !! */ [j] & 255);
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    if (this.isCast) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = src /* !! */ [j] & 255;
                                        }
                                        continue block48;
                                    }
                                    if (this.a0 == 1.0) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)(src /* !! */ [j] & 255) + this.b;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = this.a0 * (double)(src /* !! */ [j] & 255) + this.b;
                                    }
                                    continue block48;
                                }
                                JArrays.addByteArray(doubleBuf, 0, (byte[])src /* !! */ , 0, len, this.a[k]);
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.BYTE_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        case 4: {
                            if (k > 0 && optimizeJBuffer) {
                                storage = (DataStorage)this.jaOrDStor[k];
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        storage.addData(p + this.subArrayOffset[k], intBuf, 0, len);
                                        continue block48;
                                    }
                                    storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, 1.0);
                                    continue block48;
                                }
                                storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, this.a[k]);
                                continue block48;
                            }
                            if (k > 0 && optimizeJArray) {
                                src /* !! */  = (boolean[])((short[])this.jaOrDStor[k]);
                                srcOffset = (int)(p + this.subArrayOffset[k]);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        JArrays.addShortArray(intBuf, 0, (short[])src /* !! */ , srcOffset, len);
                                        continue block48;
                                    }
                                    JArrays.addShortArray(doubleBuf, 0, (short[])src /* !! */ , srcOffset, len, 1.0);
                                    continue block48;
                                }
                                JArrays.addShortArray(doubleBuf, 0, (short[])src /* !! */ , srcOffset, len, this.a[k]);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])((short[])ArraysLinearGetDataOp.SHORT_BUFFERS.requestArray());
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        if (k == 0) {
                                            for (j = 0; j < len; ++j) {
                                                intBuf[j] = src /* !! */ [j] & 65535;
                                            }
                                            continue block48;
                                        }
                                        JArrays.addShortArray(intBuf, 0, (short[])src /* !! */ , 0, len);
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        v6 = j;
                                        doubleBuf[v6] = doubleBuf[v6] + (double)(src /* !! */ [j] & 65535);
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    if (this.isCast) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = src /* !! */ [j] & 65535;
                                        }
                                        continue block48;
                                    }
                                    if (this.a0 == 1.0) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)(src /* !! */ [j] & 65535) + this.b;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = this.a0 * (double)(src /* !! */ [j] & 65535) + this.b;
                                    }
                                    continue block48;
                                }
                                JArrays.addShortArray(doubleBuf, 0, (short[])src /* !! */ , 0, len, this.a[k]);
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.SHORT_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        case 5: {
                            if (k > 0 && optimizeJBuffer) {
                                storage = (DataStorage)this.jaOrDStor[k];
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, 1.0);
                                    continue block48;
                                }
                                storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, this.a[k]);
                                continue block48;
                            }
                            if (k > 0 && optimizeJArray) {
                                src /* !! */  = (boolean[])((int[])this.jaOrDStor[k]);
                                srcOffset = (int)(p + this.subArrayOffset[k]);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    JArrays.addIntArray(doubleBuf, 0, (int[])src /* !! */ , srcOffset, len, 1.0);
                                    continue block48;
                                }
                                JArrays.addIntArray(doubleBuf, 0, (int[])src /* !! */ , srcOffset, len, this.a[k]);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])((int[])ArraysLinearGetDataOp.INT_BUFFERS.requestArray());
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    for (j = 0; j < len; ++j) {
                                        v7 = j;
                                        doubleBuf[v7] = doubleBuf[v7] + (double)src /* !! */ [j];
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    if (this.isCast) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j];
                                        }
                                        continue block48;
                                    }
                                    if (this.a0 == 1.0) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j] + this.b;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = this.a0 * (double)src /* !! */ [j] + this.b;
                                    }
                                    continue block48;
                                }
                                JArrays.addIntArray(doubleBuf, 0, (int[])src /* !! */ , 0, len, this.a[k]);
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.INT_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        case 6: {
                            if (k > 0 && optimizeJBuffer) {
                                storage = (DataStorage)this.jaOrDStor[k];
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, 1.0);
                                    continue block48;
                                }
                                storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, this.a[k]);
                                continue block48;
                            }
                            if (k > 0 && optimizeJArray) {
                                src /* !! */  = (boolean[])((long[])this.jaOrDStor[k]);
                                srcOffset = (int)(p + this.subArrayOffset[k]);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    JArrays.addLongArray(doubleBuf, 0, (long[])src /* !! */ , srcOffset, len, 1.0);
                                    continue block48;
                                }
                                JArrays.addLongArray(doubleBuf, 0, (long[])src /* !! */ , srcOffset, len, this.a[k]);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])((long[])ArraysLinearGetDataOp.LONG_BUFFERS.requestArray());
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    for (j = 0; j < len; ++j) {
                                        v8 = j;
                                        doubleBuf[v8] = doubleBuf[v8] + (double)src /* !! */ [j];
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    if (this.isCast) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j];
                                        }
                                        continue block48;
                                    }
                                    if (this.a0 == 1.0) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j] + this.b;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = this.a0 * (double)src /* !! */ [j] + this.b;
                                    }
                                    continue block48;
                                }
                                JArrays.addLongArray(doubleBuf, 0, (long[])src /* !! */ , 0, len, this.a[k]);
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.LONG_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        case 7: {
                            if (k > 0 && optimizeJBuffer) {
                                storage = (DataStorage)this.jaOrDStor[k];
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, 1.0);
                                    continue block48;
                                }
                                storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, this.a[k]);
                                continue block48;
                            }
                            if (k > 0 && optimizeJArray) {
                                src /* !! */  = (boolean[])((float[])this.jaOrDStor[k]);
                                srcOffset = (int)(p + this.subArrayOffset[k]);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    JArrays.addFloatArray(doubleBuf, 0, (float[])src /* !! */ , srcOffset, len, 1.0);
                                    continue block48;
                                }
                                JArrays.addFloatArray(doubleBuf, 0, (float[])src /* !! */ , srcOffset, len, this.a[k]);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])((float[])ArraysLinearGetDataOp.FLOAT_BUFFERS.requestArray());
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    for (j = 0; j < len; ++j) {
                                        v9 = j;
                                        doubleBuf[v9] = doubleBuf[v9] + (double)src /* !! */ [j];
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    if (this.isCast) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j];
                                        }
                                        continue block48;
                                    }
                                    if (this.a0 == 1.0) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j] + this.b;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = this.a0 * (double)src /* !! */ [j] + this.b;
                                    }
                                    continue block48;
                                }
                                JArrays.addFloatArray(doubleBuf, 0, (float[])src /* !! */ , 0, len, this.a[k]);
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.FLOAT_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        case 8: {
                            if (k > 0 && optimizeJBuffer) {
                                storage = (DataStorage)this.jaOrDStor[k];
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, 1.0);
                                    continue block48;
                                }
                                storage.addData(p + this.subArrayOffset[k], doubleBuf, 0, len, this.a[k]);
                                continue block48;
                            }
                            if (k > 0 && optimizeJArray) {
                                src /* !! */  = (boolean[])((double[])this.jaOrDStor[k]);
                                srcOffset = (int)(p + this.subArrayOffset[k]);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    JArrays.addDoubleArray(doubleBuf, 0, (double[])src /* !! */ , srcOffset, len, 1.0);
                                    continue block48;
                                }
                                JArrays.addDoubleArray(doubleBuf, 0, (double[])src /* !! */ , srcOffset, len, this.a[k]);
                                continue block48;
                            }
                            src /* !! */  = (boolean[])((double[])ArraysLinearGetDataOp.DOUBLE_BUFFERS.requestArray());
                            try {
                                this.x[k].getData(arrayPos, src /* !! */ , 0, len);
                                if (this.isNonweightedSum) {
                                    if (intBuf != null) {
                                        throw new AssertionError((Object)"Illegal intBuf usage");
                                    }
                                    for (j = 0; j < len; ++j) {
                                        v10 = j;
                                        doubleBuf[v10] = doubleBuf[v10] + src /* !! */ [j];
                                    }
                                    continue block48;
                                }
                                if (k == 0) {
                                    if (this.isCast) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = (double)src /* !! */ [j];
                                        }
                                        continue block48;
                                    }
                                    if (this.a0 == 1.0) {
                                        for (j = 0; j < len; ++j) {
                                            doubleBuf[j] = src /* !! */ [j] + this.b;
                                        }
                                        continue block48;
                                    }
                                    for (j = 0; j < len; ++j) {
                                        doubleBuf[j] = this.a0 * src /* !! */ [j] + this.b;
                                    }
                                    continue block48;
                                }
                                JArrays.addDoubleArray(doubleBuf, 0, (double[])src /* !! */ , 0, len, this.a[k]);
                                continue block48;
                            }
                            finally {
                                ArraysLinearGetDataOp.DOUBLE_BUFFERS.releaseArray(src /* !! */ );
                            }
                        }
                        default: {
                            throw new AssertionError((Object)("Illegal srcElementTypeCode[" + k + "]"));
                        }
                    }
                }
                switch (this.destElementTypeCode) {
                    case 1: {
                        dest /* !! */  = (boolean[])destArray;
                        if (intBuf != null) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (double)intBuf[j] + this.b != 0.0;
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = doubleBuf[j] != 0.0;
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 2: {
                        dest /* !! */  = (boolean[])((char[])destArray);
                        if (this.truncateOverflows) {
                            if (intBuf != null) {
                                if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                    throw new AssertionError();
                                }
                                j = 0;
                                while (j < len) {
                                    v = (int)(((double)intBuf[j] + this.b) * this.a0);
                                    dest /* !! */ [destArrayOffset] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else if (this.isNonweightedSum && this.a0 != 1.0) {
                                j = 0;
                                while (j < len) {
                                    v = (int)(doubleBuf[j] * this.a0);
                                    dest /* !! */ [destArrayOffset] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    v = (int)doubleBuf[j];
                                    dest /* !! */ [destArrayOffset] = (char)(v < 0 ? 0 : (char)(v > 65535 ? 65535 : (char)v));
                                    ++j;
                                    ++destArrayOffset;
                                }
                            }
                        } else if (intBuf != null) {
                            if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                throw new AssertionError();
                            }
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (char)(((double)intBuf[j] + this.b) * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (this.isNonweightedSum && this.a0 != 1.0) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (char)(doubleBuf[j] * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (char)doubleBuf[j];
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 3: {
                        dest /* !! */  = (boolean[])((byte[])destArray);
                        if (this.truncateOverflows) {
                            if (intBuf != null) {
                                if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                    throw new AssertionError();
                                }
                                if (this.b == 0.0 && this.a0 == 1.0) {
                                    j = 0;
                                    while (j < len) {
                                        v = intBuf[j];
                                        dest /* !! */ [destArrayOffset] = (byte)(v < 0 ? 0 : (byte)(v > 255 ? -1 : (byte)v));
                                        ++j;
                                        ++destArrayOffset;
                                    }
                                } else {
                                    j = 0;
                                    while (j < len) {
                                        v = (int)(((double)intBuf[j] + this.b) * this.a0);
                                        dest /* !! */ [destArrayOffset] = (byte)(v < 0 ? 0 : (byte)(v > 255 ? -1 : (byte)v));
                                        ++j;
                                        ++destArrayOffset;
                                    }
                                }
                            } else if (this.isNonweightedSum && this.a0 != 1.0) {
                                j = 0;
                                while (j < len) {
                                    v = (int)(doubleBuf[j] * this.a0);
                                    dest /* !! */ [destArrayOffset] = (byte)(v < 0 ? 0 : (byte)(v > 255 ? -1 : (byte)v));
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    v = (int)doubleBuf[j];
                                    dest /* !! */ [destArrayOffset] = (byte)(v < 0 ? 0 : (byte)(v > 255 ? -1 : (byte)v));
                                    ++j;
                                    ++destArrayOffset;
                                }
                            }
                        } else if (intBuf != null) {
                            if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                throw new AssertionError();
                            }
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (byte)(((double)intBuf[j] + this.b) * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (this.isNonweightedSum && this.a0 != 1.0) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (byte)(doubleBuf[j] * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (byte)doubleBuf[j];
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 4: {
                        dest /* !! */  = (boolean[])((short[])destArray);
                        if (this.truncateOverflows) {
                            if (intBuf != null) {
                                if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                    throw new AssertionError();
                                }
                                if (this.b == 0.0 && this.a0 == 1.0) {
                                    j = 0;
                                    while (j < len) {
                                        v = intBuf[j];
                                        dest /* !! */ [destArrayOffset] = (short)(v < 0 ? 0 : (short)(v > 65535 ? -1 : (short)v));
                                        ++j;
                                        ++destArrayOffset;
                                    }
                                } else {
                                    j = 0;
                                    while (j < len) {
                                        v = (int)(((double)intBuf[j] + this.b) * this.a0);
                                        dest /* !! */ [destArrayOffset] = (short)(v < 0 ? 0 : (short)(v > 65535 ? -1 : (short)v));
                                        ++j;
                                        ++destArrayOffset;
                                    }
                                }
                            } else if (this.isNonweightedSum && this.a0 != 1.0) {
                                j = 0;
                                while (j < len) {
                                    v = (int)(doubleBuf[j] * this.a0);
                                    dest /* !! */ [destArrayOffset] = (short)(v < 0 ? 0 : (short)(v > 65535 ? -1 : (short)v));
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    v = (int)doubleBuf[j];
                                    dest /* !! */ [destArrayOffset] = (short)(v < 0 ? 0 : (short)(v > 65535 ? -1 : (short)v));
                                    ++j;
                                    ++destArrayOffset;
                                }
                            }
                        } else if (intBuf != null) {
                            if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                throw new AssertionError();
                            }
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (short)(((double)intBuf[j] + this.b) * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (this.isNonweightedSum && this.a0 != 1.0) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (short)(doubleBuf[j] * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (short)doubleBuf[j];
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 5: {
                        dest /* !! */  = (boolean[])((int[])destArray);
                        if (this.truncateOverflows) {
                            if (intBuf != null) {
                                if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                    throw new AssertionError();
                                }
                                if (this.b == 0.0 && this.a0 == 1.0) {
                                    System.arraycopy(intBuf, 0, dest /* !! */ , destArrayOffset, len);
                                    destArrayOffset += len;
                                    ** break;
lbl667:
                                    // 1 sources

                                } else {
                                    j = 0;
                                    while (j < len) {
                                        dest /* !! */ [destArrayOffset] = (int)(((double)intBuf[j] + this.b) * this.a0);
                                        ++j;
                                        ++destArrayOffset;
                                    }
                                }
                            } else if (this.isNonweightedSum && this.a0 != 1.0) {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = (int)(doubleBuf[j] * this.a0);
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = (int)doubleBuf[j];
                                    ++j;
                                    ++destArrayOffset;
                                }
                            }
                        } else if (intBuf != null) {
                            if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                throw new AssertionError();
                            }
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (int)(((double)intBuf[j] + this.b) * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else if (this.isNonweightedSum && this.a0 != 1.0) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (int)(doubleBuf[j] * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (int)doubleBuf[j];
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 6: {
                        dest /* !! */  = (boolean[])((long[])destArray);
                        if (intBuf != null) {
                            if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                throw new AssertionError();
                            }
                            if (this.b == 0.0 && this.a0 == 1.0) {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = intBuf[j];
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = (long)(((double)intBuf[j] + this.b) * this.a0);
                                    ++j;
                                    ++destArrayOffset;
                                }
                            }
                        } else if (this.isNonweightedSum && this.a0 != 1.0) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (long)(doubleBuf[j] * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (long)doubleBuf[j];
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 7: {
                        dest /* !! */  = (boolean[])((float[])destArray);
                        if (intBuf != null) {
                            if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                throw new AssertionError();
                            }
                            if (this.b == 0.0 && this.a0 == 1.0) {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = intBuf[j];
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = (float)(((double)intBuf[j] + this.b) * this.a0);
                                    ++j;
                                    ++destArrayOffset;
                                }
                            }
                        } else if (this.isNonweightedSum && this.a0 != 1.0) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (float)(doubleBuf[j] * this.a0);
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = (float)doubleBuf[j];
                                ++j;
                                ++destArrayOffset;
                            }
                        }
                        break;
                    }
                    case 8: {
                        dest /* !! */  = (boolean[])((double[])destArray);
                        if (intBuf != null) {
                            if (!ArraysLinearGetDataOp.$assertionsDisabled && !this.isNonweightedSum) {
                                throw new AssertionError();
                            }
                            if (this.b == 0.0 && this.a0 == 1.0) {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = intBuf[j];
                                    ++j;
                                    ++destArrayOffset;
                                }
                            } else {
                                j = 0;
                                while (j < len) {
                                    dest /* !! */ [destArrayOffset] = ((double)intBuf[j] + this.b) * this.a0;
                                    ++j;
                                    ++destArrayOffset;
                                }
                            }
                        } else if (this.isNonweightedSum && this.a0 != 1.0) {
                            j = 0;
                            while (j < len) {
                                dest /* !! */ [destArrayOffset] = doubleBuf[j] * this.a0;
                                ++j;
                                ++destArrayOffset;
                            }
                        } else {
                            System.arraycopy(doubleBuf, 0, dest /* !! */ , destArrayOffset, len);
                            destArrayOffset += len;
                            ** break;
                        }
lbl816:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Illegal destElementTypeCode");
                    }
                }
            }
            finally {
                if (this.intBufferForSum) {
                    ArraysLinearGetDataOp.INT_BUFFERS.releaseArray(intBuf);
                } else {
                    ArraysLinearGetDataOp.DOUBLE_BUFFERS.releaseArray(doubleBuf);
                }
            }
            arrayPos += (long)len;
            count -= len;
        }
    }
}

