/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import net.algart.arrays.AbstractArray;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysFuncImpl;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataByteBuffer;
import net.algart.arrays.DataCharBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DataIntBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrices;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.ThreadPoolFactory;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatablePArray;
import net.algart.arrays.UpdatableShortArray;
import net.algart.math.functions.ApertureFilterOperator;
import net.algart.math.functions.ConstantFunc;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearOperator;

class ArraysMatrixResizer {
    private static final int MAX_OPTIMIZED_APERTURE_SIZE = 0x100000;
    final int n;
    final long[] scales;
    final int scalesProduct;
    final int numberOfConsecutive;
    final int firstJump;
    final int step;
    final int blockSize;
    final boolean doAveraging;
    final int[] apertureOffsets;
    final double averagingMultiplier;

    private ArraysMatrixResizer(long[] resultingDimensions, long[] sourceDimensions, long[] scales, int scalesProduct, boolean doAveraging) {
        int m;
        this.n = scales.length;
        assert (resultingDimensions.length == this.n);
        assert (sourceDimensions.length == this.n);
        long sourceSize = Arrays.longMul(sourceDimensions);
        assert (sourceSize > 0L);
        assert (sourceSize <= Integer.MAX_VALUE) : "source matrix must be less than 2^31 elements";
        this.scales = scales;
        this.scalesProduct = scalesProduct;
        int dimMul = 1;
        for (m = 0; m < this.n && scales[m] == 1L; ++m) {
            assert (resultingDimensions[m] == sourceDimensions[m]);
            dimMul *= (int)resultingDimensions[m];
        }
        this.numberOfConsecutive = dimMul;
        this.firstJump = m == this.n ? 0 : ((int)scales[m] - 1) * dimMul;
        this.step = this.firstJump + dimMul;
        this.blockSize = m == this.n ? dimMul : dimMul * (int)resultingDimensions[m];
        this.doAveraging = doAveraging;
        if (doAveraging) {
            this.apertureOffsets = new int[scalesProduct];
            Matrix<IntArray> apertureEnumerator = Matrices.matrix(Arrays.nIntCopies(scalesProduct, 157), scales);
            Matrix<IntArray> sourceEnumerator = Matrices.matrix(Arrays.nIntCopies(sourceSize, 157), sourceDimensions);
            long[] coordinatesInAperture = new long[this.n];
            for (int i = 0; i < scalesProduct; ++i) {
                apertureEnumerator.coordinates(i, coordinatesInAperture);
                this.apertureOffsets[i] = (int)sourceEnumerator.index(coordinatesInAperture);
            }
        } else {
            this.apertureOffsets = null;
        }
        this.averagingMultiplier = 1.0 / (double)scalesProduct;
    }

    public static Matrix<PArray> asResized(Matrices.ResizingMethod resizingMethod, Matrix<? extends PArray> matrix, long[] newDim, double[] scales) {
        Objects.requireNonNull(resizingMethod, "Null resizingMethod argument");
        Objects.requireNonNull(matrix, "Null matrix argument");
        int n = matrix.dimCount();
        if (newDim.length != n) {
            throw new IllegalArgumentException("Illegal number of newDim[] elements: " + newDim.length + " instead of " + n);
        }
        if (scales != null && scales.length != n) {
            throw new IllegalArgumentException("Illegal number of scales[] elements: " + scales.length + " instead of " + n);
        }
        if (matrix.isEmpty()) {
            return Matrices.asCoordFuncMatrix(ConstantFunc.getInstance(0.0), matrix.type(PArray.class), newDim);
        }
        double[] diagonal = new double[n];
        boolean trivialScales = true;
        for (int k = 0; k < n; ++k) {
            long dOld = matrix.dim(k);
            long dNew = newDim[k];
            double mult = (double)dOld / (double)dNew;
            diagonal[k] = scales == null ? mult : 1.0 / scales[k];
            trivialScales &= diagonal[k] == mult;
        }
        Func interpolation = trivialScales ? Matrices.asInterpolationFunc(matrix, resizingMethod.interpolationMethod, false) : Matrices.asInterpolationFunc(matrix, resizingMethod.interpolationMethod, 0.0);
        LinearOperator resizing = LinearOperator.getDiagonalInstance(diagonal);
        Func transformed = resizing.apply(interpolation);
        if (resizingMethod.averaging()) {
            boolean doAverage = false;
            long[] apertureDim = new long[diagonal.length];
            for (int k = 0; k < n; ++k) {
                doAverage |= diagonal[k] >= 1.5;
                apertureDim[k] = Math.max(1L, Math.min(1000000L, Math.round(diagonal[k])));
            }
            if (doAverage && !ApertureFilterOperator.tooLargeAperture(apertureDim)) {
                Func averagingFunc = null;
                if (resizingMethod instanceof Matrices.ResizingMethod.Averaging) {
                    averagingFunc = ((Matrices.ResizingMethod.Averaging)resizingMethod).getAveragingFunc(apertureDim);
                }
                transformed = averagingFunc == null ? ApertureFilterOperator.getAveragingInstance(apertureDim).apply(transformed) : ApertureFilterOperator.getInstance(averagingFunc, apertureDim).apply(transformed);
            }
        }
        Matrix<PArray> result = Matrices.asCoordFuncMatrix(transformed, matrix.type(PArray.class), newDim);
        if (trivialScales && result.array() instanceof ArraysFuncImpl.OptimizationHelperInfo) {
            ((ArraysFuncImpl.OptimizationHelperInfo)((Object)result.array())).setOptimizationHelperInfo(resizingMethod);
        }
        return result;
    }

    public static void resize(ArrayContext context, Matrices.ResizingMethod resizingMethod, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> src) {
        if (ArraysMatrixResizer.tryToResizeWithOptimization(context, resizingMethod, result, src)) {
            return;
        }
        Matrix<PArray> lazy = ArraysMatrixResizer.asResized(resizingMethod, src, result.dimensions(), null);
        Matrices.copy(context, result, lazy, 0, false);
    }

    public static boolean tryToResizeWithOptimization(ArrayContext context, Matrices.ResizingMethod resizingMethod, Matrix<? extends UpdatablePArray> result, Matrix<? extends PArray> src) {
        Objects.requireNonNull(resizingMethod, "Null resizingMethod argument");
        Objects.requireNonNull(result, "Null result matrix");
        Objects.requireNonNull(src, "Null source matrix");
        int n = src.dimCount();
        if (result.dimCount() != n) {
            throw new IllegalArgumentException("The source and result matrices have different number of dimensions: the source src is " + String.valueOf(src) + ", the result is " + String.valueOf(result));
        }
        AbstractArray.checkCopyArguments(result.array(), src.array());
        if (result.isEmpty()) {
            return true;
        }
        if (result.dimEquals(src)) {
            Matrices.copy(context, result, src, 0, false);
            return true;
        }
        if (src.size() > Integer.MAX_VALUE) {
            return false;
        }
        ArraysMatrixResizer resizer = ArraysMatrixResizer.getInstance(resizingMethod, result.elementType(), result.dimensions(), src.dimensions());
        return resizer != null && resizer.compressDirectAccessible(context, result, src);
    }

    public static ArraysMatrixResizer getInstance(Matrices.ResizingMethod resizingMethod, Class<?> elementType, long[] resultingDimensions, long[] sourceDimensions) {
        long[] scales = ArraysMatrixResizer.getScalesIfCanBeOptimizedForDirectAccessibleResult(resizingMethod, elementType, resultingDimensions, sourceDimensions);
        if (scales == null) {
            return null;
        }
        boolean doAveraging = resizingMethod == Matrices.ResizingMethod.AVERAGING || resizingMethod == Matrices.ResizingMethod.POLYLINEAR_AVERAGING;
        long scalesProduct = 1L;
        for (long scale : scales) {
            scalesProduct *= scale;
        }
        assert (scalesProduct == (long)((int)scalesProduct));
        boolean powerOfTwo = (scalesProduct & scalesProduct - 1L) == 0L;
        return powerOfTwo && doAveraging ? new ResizerForPowerOfTwo(resultingDimensions, sourceDimensions, scales, (int)scalesProduct) : new ArraysMatrixResizer(resultingDimensions, sourceDimensions, scales, (int)scalesProduct, doAveraging);
    }

    public static long[] getScalesIfCanBeOptimizedForDirectAccessibleResult(Matrices.ResizingMethod resizingMethod, Class<?> elementType, long[] resultingDimensions, long[] sourceDimensions) {
        Objects.requireNonNull(resizingMethod, "Null resizingMethod argument");
        if (sourceDimensions.length != resultingDimensions.length) {
            throw new IllegalArgumentException("Different lengths of resultingDimensions and sourceDimensions");
        }
        if (resizingMethod != Matrices.ResizingMethod.AVERAGING && resizingMethod != Matrices.ResizingMethod.POLYLINEAR_AVERAGING && resizingMethod != Matrices.ResizingMethod.SIMPLE && resizingMethod != Matrices.ResizingMethod.POLYLINEAR_INTERPOLATION) {
            return null;
        }
        if (elementType == Boolean.TYPE) {
            return null;
        }
        long[] scales = new long[sourceDimensions.length];
        long scalesProduct = 1L;
        for (int k = 0; k < scales.length; ++k) {
            long newDim = resultingDimensions[k];
            long oldDim = sourceDimensions[k];
            if (newDim < 0L) {
                throw new IllegalArgumentException("Negative resultingDimensions[" + k + "]");
            }
            if (oldDim < 0L) {
                throw new IllegalArgumentException("Negative sourceDimensions[" + k + "]");
            }
            if (newDim == 0L || oldDim == 0L || newDim > oldDim) {
                return null;
            }
            scales[k] = oldDim / newDim;
            if (oldDim != scales[k] * newDim) {
                return null;
            }
            if (scales[k] > Integer.MAX_VALUE) {
                return null;
            }
            if ((scalesProduct *= scales[k]) <= 0x100000L) continue;
            return null;
        }
        return scales;
    }

    boolean compressDirectAccessible(final ArrayContext context, final Matrix<? extends UpdatablePArray> result, final Matrix<? extends PArray> src) {
        DirectAccessible da;
        final UpdatablePArray r = result.array();
        final PArray a = src.array();
        assert (r.length() <= a.length());
        assert (r.elementType() == a.elementType());
        assert (!(a instanceof BitArray)) : String.valueOf(this.getClass()) + " must not be instantiated for boolean elements";
        if (!(a instanceof DirectAccessible) || !(da = (DirectAccessible)((Object)a)).hasJavaArray()) {
            return false;
        }
        final int jaOfs = da.javaArrayOffset();
        assert (r.length() <= Integer.MAX_VALUE);
        ThreadPoolFactory threadPoolFactory = Arrays.getThreadPoolFactory(context);
        int numberOfTasks = threadPoolFactory.recommendedNumberOfTasks(r);
        final AtomicLong readyElements = new AtomicLong(0L);
        Runnable[] tasks = new Runnable[numberOfTasks];
        for (int taskIndex = 0; taskIndex < numberOfTasks; ++taskIndex) {
            final int from = (int)((long)taskIndex * r.length() / (long)numberOfTasks);
            final int to = (int)((long)(taskIndex + 1) * r.length() / (long)numberOfTasks);
            if (taskIndex == numberOfTasks - 1) assert ((long)to == r.length());
            tasks[taskIndex] = new Runnable(){
                final long[] work;
                long progressCount;
                long lastProgressCount;
                {
                    this.work = new long[ArraysMatrixResizer.this.n];
                    this.progressCount = 0L;
                    this.lastProgressCount = 0L;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block101: {
                        int fromRem = from % ArraysMatrixResizer.this.blockSize;
                        int startCount = Math.min(ArraysMatrixResizer.this.blockSize - fromRem, to - from);
                        DataBuffer resultBuffer = Arrays.bufferInternal(r, DataBuffer.AccessMode.READ_WRITE, AbstractArray.defaultBufferCapacity(r), true);
                        Arrays.enableCaching(resultBuffer);
                        try {
                            int jumpingRem = from % ArraysMatrixResizer.this.numberOfConsecutive;
                            if (a instanceof CharArray) {
                                assert (r instanceof UpdatableCharArray);
                                char[] ja = (char[])da.javaArray();
                                DataCharBuffer buf = (DataCharBuffer)resultBuffer;
                                int p = from;
                                while (p < to) {
                                    int len;
                                    int srcOfs = this.apertureInitialPosition(p) + jaOfs;
                                    for (int count = p == from ? startCount : Math.min(ArraysMatrixResizer.this.blockSize, to - p); count > 0; count -= len) {
                                        len = buf.map(p, count, false).cnt();
                                        char[] data = buf.data();
                                        if (ArraysMatrixResizer.this.doAveraging) {
                                            if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                                j = buf.from();
                                                jMax = j + len;
                                                while (j < jMax) {
                                                    data[j] = ArraysMatrixResizer.this.averageChar(ja, srcOfs);
                                                    ++j;
                                                    srcOfs += ArraysMatrixResizer.this.step;
                                                }
                                            } else {
                                                jMax = j + len;
                                                for (j = buf.from(); j < jMax; ++j) {
                                                    data[j] = ArraysMatrixResizer.this.averageChar(ja, srcOfs);
                                                    ++srcOfs;
                                                    if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                    srcOfs += ArraysMatrixResizer.this.firstJump;
                                                    jumpingRem = 0;
                                                }
                                            }
                                        } else if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                            j = buf.from();
                                            jMax = j + len;
                                            while (j < jMax) {
                                                data[j] = ja[srcOfs];
                                                ++j;
                                                srcOfs += ArraysMatrixResizer.this.step;
                                            }
                                        } else {
                                            jMax = j + len;
                                            for (j = buf.from(); j < jMax; ++j) {
                                                data[j] = ja[srcOfs];
                                                ++srcOfs;
                                                if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                srcOfs += ArraysMatrixResizer.this.firstJump;
                                                jumpingRem = 0;
                                            }
                                        }
                                        buf.force();
                                        this.updateProgress(len);
                                        p += len;
                                    }
                                }
                                break block101;
                            }
                            if (a instanceof ByteArray) {
                                assert (r instanceof UpdatableByteArray);
                                byte[] ja = (byte[])da.javaArray();
                                DataByteBuffer buf = (DataByteBuffer)resultBuffer;
                                int p = from;
                                while (p < to) {
                                    int len;
                                    int srcOfs = this.apertureInitialPosition(p) + jaOfs;
                                    for (int count = p == from ? startCount : Math.min(ArraysMatrixResizer.this.blockSize, to - p); count > 0; count -= len) {
                                        len = buf.map(p, count, false).cnt();
                                        byte[] data = buf.data();
                                        if (ArraysMatrixResizer.this.doAveraging) {
                                            if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                                j = buf.from();
                                                jMax = j + len;
                                                while (j < jMax) {
                                                    data[j] = ArraysMatrixResizer.this.averageByte(ja, srcOfs);
                                                    ++j;
                                                    srcOfs += ArraysMatrixResizer.this.step;
                                                }
                                            } else {
                                                jMax = j + len;
                                                for (j = buf.from(); j < jMax; ++j) {
                                                    data[j] = ArraysMatrixResizer.this.averageByte(ja, srcOfs);
                                                    ++srcOfs;
                                                    if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                    srcOfs += ArraysMatrixResizer.this.firstJump;
                                                    jumpingRem = 0;
                                                }
                                            }
                                        } else if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                            j = buf.from();
                                            jMax = j + len;
                                            while (j < jMax) {
                                                data[j] = ja[srcOfs];
                                                ++j;
                                                srcOfs += ArraysMatrixResizer.this.step;
                                            }
                                        } else {
                                            jMax = j + len;
                                            for (j = buf.from(); j < jMax; ++j) {
                                                data[j] = ja[srcOfs];
                                                ++srcOfs;
                                                if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                srcOfs += ArraysMatrixResizer.this.firstJump;
                                                jumpingRem = 0;
                                            }
                                        }
                                        buf.force();
                                        this.updateProgress(len);
                                        p += len;
                                    }
                                }
                                break block101;
                            }
                            if (a instanceof ShortArray) {
                                assert (r instanceof UpdatableShortArray);
                                short[] ja = (short[])da.javaArray();
                                DataShortBuffer buf = (DataShortBuffer)resultBuffer;
                                int p = from;
                                while (p < to) {
                                    int len;
                                    int srcOfs = this.apertureInitialPosition(p) + jaOfs;
                                    for (int count = p == from ? startCount : Math.min(ArraysMatrixResizer.this.blockSize, to - p); count > 0; count -= len) {
                                        len = buf.map(p, count, false).cnt();
                                        short[] data = buf.data();
                                        if (ArraysMatrixResizer.this.doAveraging) {
                                            if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                                j = buf.from();
                                                jMax = j + len;
                                                while (j < jMax) {
                                                    data[j] = ArraysMatrixResizer.this.averageShort(ja, srcOfs);
                                                    ++j;
                                                    srcOfs += ArraysMatrixResizer.this.step;
                                                }
                                            } else {
                                                jMax = j + len;
                                                for (j = buf.from(); j < jMax; ++j) {
                                                    data[j] = ArraysMatrixResizer.this.averageShort(ja, srcOfs);
                                                    ++srcOfs;
                                                    if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                    srcOfs += ArraysMatrixResizer.this.firstJump;
                                                    jumpingRem = 0;
                                                }
                                            }
                                        } else if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                            j = buf.from();
                                            jMax = j + len;
                                            while (j < jMax) {
                                                data[j] = ja[srcOfs];
                                                ++j;
                                                srcOfs += ArraysMatrixResizer.this.step;
                                            }
                                        } else {
                                            jMax = j + len;
                                            for (j = buf.from(); j < jMax; ++j) {
                                                data[j] = ja[srcOfs];
                                                ++srcOfs;
                                                if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                srcOfs += ArraysMatrixResizer.this.firstJump;
                                                jumpingRem = 0;
                                            }
                                        }
                                        buf.force();
                                        this.updateProgress(len);
                                        p += len;
                                    }
                                }
                                break block101;
                            }
                            if (a instanceof IntArray) {
                                assert (r instanceof UpdatableIntArray);
                                int[] ja = (int[])da.javaArray();
                                DataIntBuffer buf = (DataIntBuffer)resultBuffer;
                                int p = from;
                                while (p < to) {
                                    int len;
                                    int srcOfs = this.apertureInitialPosition(p) + jaOfs;
                                    for (int count = p == from ? startCount : Math.min(ArraysMatrixResizer.this.blockSize, to - p); count > 0; count -= len) {
                                        len = buf.map(p, count, false).cnt();
                                        int[] data = buf.data();
                                        if (ArraysMatrixResizer.this.doAveraging) {
                                            if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                                j = buf.from();
                                                jMax = j + len;
                                                while (j < jMax) {
                                                    data[j] = ArraysMatrixResizer.this.averageInt(ja, srcOfs);
                                                    ++j;
                                                    srcOfs += ArraysMatrixResizer.this.step;
                                                }
                                            } else {
                                                jMax = j + len;
                                                for (j = buf.from(); j < jMax; ++j) {
                                                    data[j] = ArraysMatrixResizer.this.averageInt(ja, srcOfs);
                                                    ++srcOfs;
                                                    if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                    srcOfs += ArraysMatrixResizer.this.firstJump;
                                                    jumpingRem = 0;
                                                }
                                            }
                                        } else if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                            j = buf.from();
                                            jMax = j + len;
                                            while (j < jMax) {
                                                data[j] = ja[srcOfs];
                                                ++j;
                                                srcOfs += ArraysMatrixResizer.this.step;
                                            }
                                        } else {
                                            jMax = j + len;
                                            for (j = buf.from(); j < jMax; ++j) {
                                                data[j] = ja[srcOfs];
                                                ++srcOfs;
                                                if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                srcOfs += ArraysMatrixResizer.this.firstJump;
                                                jumpingRem = 0;
                                            }
                                        }
                                        buf.force();
                                        this.updateProgress(len);
                                        p += len;
                                    }
                                }
                                break block101;
                            }
                            if (a instanceof LongArray) {
                                assert (r instanceof UpdatableLongArray);
                                long[] ja = (long[])da.javaArray();
                                DataLongBuffer buf = (DataLongBuffer)resultBuffer;
                                int p = from;
                                while (p < to) {
                                    int len;
                                    int srcOfs = this.apertureInitialPosition(p) + jaOfs;
                                    for (int count = p == from ? startCount : Math.min(ArraysMatrixResizer.this.blockSize, to - p); count > 0; count -= len) {
                                        len = buf.map(p, count, false).cnt();
                                        long[] data = buf.data();
                                        if (ArraysMatrixResizer.this.doAveraging) {
                                            if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                                j = buf.from();
                                                jMax = j + len;
                                                while (j < jMax) {
                                                    data[j] = ArraysMatrixResizer.this.averageLong(ja, srcOfs);
                                                    ++j;
                                                    srcOfs += ArraysMatrixResizer.this.step;
                                                }
                                            } else {
                                                jMax = j + len;
                                                for (j = buf.from(); j < jMax; ++j) {
                                                    data[j] = ArraysMatrixResizer.this.averageLong(ja, srcOfs);
                                                    ++srcOfs;
                                                    if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                    srcOfs += ArraysMatrixResizer.this.firstJump;
                                                    jumpingRem = 0;
                                                }
                                            }
                                        } else if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                            j = buf.from();
                                            jMax = j + len;
                                            while (j < jMax) {
                                                data[j] = ja[srcOfs];
                                                ++j;
                                                srcOfs += ArraysMatrixResizer.this.step;
                                            }
                                        } else {
                                            jMax = j + len;
                                            for (j = buf.from(); j < jMax; ++j) {
                                                data[j] = ja[srcOfs];
                                                ++srcOfs;
                                                if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                srcOfs += ArraysMatrixResizer.this.firstJump;
                                                jumpingRem = 0;
                                            }
                                        }
                                        buf.force();
                                        this.updateProgress(len);
                                        p += len;
                                    }
                                }
                                break block101;
                            }
                            if (a instanceof FloatArray) {
                                assert (r instanceof UpdatableFloatArray);
                                float[] ja = (float[])da.javaArray();
                                DataFloatBuffer buf = (DataFloatBuffer)resultBuffer;
                                int p = from;
                                while (p < to) {
                                    int len;
                                    int srcOfs = this.apertureInitialPosition(p) + jaOfs;
                                    for (int count = p == from ? startCount : Math.min(ArraysMatrixResizer.this.blockSize, to - p); count > 0; count -= len) {
                                        len = buf.map(p, count, false).cnt();
                                        float[] data = buf.data();
                                        if (ArraysMatrixResizer.this.doAveraging) {
                                            if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                                j = buf.from();
                                                jMax = j + len;
                                                while (j < jMax) {
                                                    data[j] = ArraysMatrixResizer.this.averageFloat(ja, srcOfs);
                                                    ++j;
                                                    srcOfs += ArraysMatrixResizer.this.step;
                                                }
                                            } else {
                                                jMax = j + len;
                                                for (j = buf.from(); j < jMax; ++j) {
                                                    data[j] = ArraysMatrixResizer.this.averageFloat(ja, srcOfs);
                                                    ++srcOfs;
                                                    if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                    srcOfs += ArraysMatrixResizer.this.firstJump;
                                                    jumpingRem = 0;
                                                }
                                            }
                                        } else if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                            j = buf.from();
                                            jMax = j + len;
                                            while (j < jMax) {
                                                data[j] = ja[srcOfs];
                                                ++j;
                                                srcOfs += ArraysMatrixResizer.this.step;
                                            }
                                        } else {
                                            jMax = j + len;
                                            for (j = buf.from(); j < jMax; ++j) {
                                                data[j] = ja[srcOfs];
                                                ++srcOfs;
                                                if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                srcOfs += ArraysMatrixResizer.this.firstJump;
                                                jumpingRem = 0;
                                            }
                                        }
                                        buf.force();
                                        this.updateProgress(len);
                                        p += len;
                                    }
                                }
                                break block101;
                            }
                            if (a instanceof DoubleArray) {
                                assert (r instanceof UpdatableDoubleArray);
                                double[] ja = (double[])da.javaArray();
                                DataDoubleBuffer buf = (DataDoubleBuffer)resultBuffer;
                                int p = from;
                                while (p < to) {
                                    int len;
                                    int srcOfs = this.apertureInitialPosition(p) + jaOfs;
                                    for (int count = p == from ? startCount : Math.min(ArraysMatrixResizer.this.blockSize, to - p); count > 0; count -= len) {
                                        len = buf.map(p, count, false).cnt();
                                        double[] data = buf.data();
                                        if (ArraysMatrixResizer.this.doAveraging) {
                                            if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                                j = buf.from();
                                                jMax = j + len;
                                                while (j < jMax) {
                                                    data[j] = ArraysMatrixResizer.this.averageDouble(ja, srcOfs);
                                                    ++j;
                                                    srcOfs += ArraysMatrixResizer.this.step;
                                                }
                                            } else {
                                                jMax = j + len;
                                                for (j = buf.from(); j < jMax; ++j) {
                                                    data[j] = ArraysMatrixResizer.this.averageDouble(ja, srcOfs);
                                                    ++srcOfs;
                                                    if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                    srcOfs += ArraysMatrixResizer.this.firstJump;
                                                    jumpingRem = 0;
                                                }
                                            }
                                        } else if (ArraysMatrixResizer.this.numberOfConsecutive == 1) {
                                            j = buf.from();
                                            jMax = j + len;
                                            while (j < jMax) {
                                                data[j] = ja[srcOfs];
                                                ++j;
                                                srcOfs += ArraysMatrixResizer.this.step;
                                            }
                                        } else {
                                            jMax = j + len;
                                            for (j = buf.from(); j < jMax; ++j) {
                                                data[j] = ja[srcOfs];
                                                ++srcOfs;
                                                if (++jumpingRem != ArraysMatrixResizer.this.numberOfConsecutive) continue;
                                                srcOfs += ArraysMatrixResizer.this.firstJump;
                                                jumpingRem = 0;
                                            }
                                        }
                                        buf.force();
                                        this.updateProgress(len);
                                        p += len;
                                    }
                                }
                                break block101;
                            }
                            throw new AssertionError((Object)("Unallowed type of built-in array: " + String.valueOf(a.getClass())));
                        }
                        finally {
                            Arrays.dispose(resultBuffer);
                        }
                    }
                }

                private int apertureInitialPosition(int resultPosition) {
                    result.coordinates(resultPosition, this.work);
                    for (int k = 0; k < ArraysMatrixResizer.this.n; ++k) {
                        int n = k;
                        this.work[n] = this.work[n] * ArraysMatrixResizer.this.scales[k];
                    }
                    return (int)src.index(this.work);
                }

                private void updateProgress(int resultElementsCount) {
                    if (context == null) {
                        return;
                    }
                    this.progressCount += (long)resultElementsCount * (long)ArraysMatrixResizer.this.scalesProduct;
                    long newReadyElements = readyElements.addAndGet((long)resultElementsCount * (long)ArraysMatrixResizer.this.scalesProduct);
                    if (this.progressCount - this.lastProgressCount >= 262144L) {
                        assert (newReadyElements <= src.size());
                        this.lastProgressCount = this.progressCount;
                        context.checkInterruptionAndUpdateProgress(src.elementType(), newReadyElements, src.size());
                    }
                }
            };
        }
        threadPoolFactory.performTasks(tasks);
        return true;
    }

    byte averageByte(byte[] src, int offset) {
        long sum = 0L;
        for (int apertureOffset : this.apertureOffsets) {
            sum += (long)(src[offset + apertureOffset] & 0xFF);
        }
        return (byte)(this.averagingMultiplier * (double)sum);
    }

    short averageShort(short[] src, int offset) {
        long sum = 0L;
        for (int apertureOffset : this.apertureOffsets) {
            sum += (long)(src[offset + apertureOffset] & 0xFFFF);
        }
        return (short)(this.averagingMultiplier * (double)sum);
    }

    char averageChar(char[] src, int offset) {
        long sum = 0L;
        for (int apertureOffset : this.apertureOffsets) {
            sum += (long)src[offset + apertureOffset];
        }
        return (char)(this.averagingMultiplier * (double)sum);
    }

    int averageInt(int[] src, int offset) {
        long sum = 0L;
        for (int apertureOffset : this.apertureOffsets) {
            sum += (long)src[offset + apertureOffset];
        }
        return (int)(this.averagingMultiplier * (double)sum);
    }

    long averageLong(long[] src, int offset) {
        double sum = 0.0;
        for (int apertureOffset : this.apertureOffsets) {
            sum += (double)src[offset + apertureOffset];
        }
        return (long)(this.averagingMultiplier * sum);
    }

    float averageFloat(float[] src, int offset) {
        double sum = 0.0;
        for (int apertureOffset : this.apertureOffsets) {
            sum += (double)src[offset + apertureOffset];
        }
        return (float)(this.averagingMultiplier * sum);
    }

    double averageDouble(double[] src, int offset) {
        double sum = 0.0;
        for (int apertureOffset : this.apertureOffsets) {
            sum += src[offset + apertureOffset];
        }
        return this.averagingMultiplier * sum;
    }

    private static class ResizerForPowerOfTwo
    extends ArraysMatrixResizer {
        private final int scaleProductLog;

        private ResizerForPowerOfTwo(long[] resultingDimensions, long[] sourceDimensions, long[] scales, int scalesProduct) {
            super(resultingDimensions, sourceDimensions, scales, scalesProduct, true);
            this.scaleProductLog = 31 - Integer.numberOfLeadingZeros(scalesProduct);
            assert (scalesProduct == 1 << this.scaleProductLog);
            assert (this.apertureOffsets.length == scalesProduct);
        }

        @Override
        byte averageByte(byte[] src, int offset) {
            int sum = 0;
            for (int apertureOffset : this.apertureOffsets) {
                sum += src[offset + apertureOffset] & 0xFF;
            }
            return (byte)(sum >>> this.scaleProductLog);
        }

        @Override
        short averageShort(short[] src, int offset) {
            long sum = 0L;
            for (int apertureOffset : this.apertureOffsets) {
                sum += (long)(src[offset + apertureOffset] & 0xFFFF);
            }
            return (short)(sum >>> this.scaleProductLog);
        }

        @Override
        char averageChar(char[] src, int offset) {
            long sum = 0L;
            for (int apertureOffset : this.apertureOffsets) {
                sum += (long)src[offset + apertureOffset];
            }
            return (char)(sum >>> this.scaleProductLog);
        }

        @Override
        int averageInt(int[] src, int offset) {
            long sum = 0L;
            for (int apertureOffset : this.apertureOffsets) {
                sum += (long)src[offset + apertureOffset];
            }
            return (int)(sum >>> this.scaleProductLog);
        }
    }
}

