/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.AbstractBitArray;
import net.algart.arrays.AbstractByteArray;
import net.algart.arrays.AbstractCharArray;
import net.algart.arrays.AbstractDoubleArray;
import net.algart.arrays.AbstractFloatArray;
import net.algart.arrays.AbstractIntArray;
import net.algart.arrays.AbstractLongArray;
import net.algart.arrays.AbstractObjectArray;
import net.algart.arrays.AbstractShortArray;
import net.algart.arrays.AbstractUpdatableBitArray;
import net.algart.arrays.AbstractUpdatableByteArray;
import net.algart.arrays.AbstractUpdatableCharArray;
import net.algart.arrays.AbstractUpdatableDoubleArray;
import net.algart.arrays.AbstractUpdatableFloatArray;
import net.algart.arrays.AbstractUpdatableIntArray;
import net.algart.arrays.AbstractUpdatableLongArray;
import net.algart.arrays.AbstractUpdatableObjectArray;
import net.algart.arrays.AbstractUpdatableShortArray;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.ArraysSubMatrixConstantlyContinuedIndexer;
import net.algart.arrays.ArraysSubMatrixCopier;
import net.algart.arrays.ArraysSubMatrixCyclicIndexer;
import net.algart.arrays.ArraysSubMatrixIndexer;
import net.algart.arrays.ArraysSubMatrixMirrorCyclicIndexer;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.JArrays;
import net.algart.arrays.LongArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.ShortArray;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableObjectArray;
import net.algart.arrays.UpdatableShortArray;

class ArraysSubMatrixImpl {
    static final long OUTSIDE_INDEX = -1L;

    ArraysSubMatrixImpl() {
    }

    static long checkBounds(Matrix<?> baseMatrix, long[] position, long[] dimensions, Matrix.ContinuationMode continuationMode) throws IllegalArgumentException, IndexOutOfBoundsException {
        Objects.requireNonNull(baseMatrix, "Null baseMatrix");
        Objects.requireNonNull(position, "Null position[] Java baseArray");
        Objects.requireNonNull(dimensions, "Null dimensions[] Java baseArray");
        if (position.length != baseMatrix.dimCount()) {
            throw new IllegalArgumentException("Illegal number of position[] elements: " + position.length + " instead of " + baseMatrix.dimCount());
        }
        assert (continuationMode != null);
        if (dimensions.length != position.length) {
            throw new IllegalArgumentException("Illegal number of dimensions[] elements: " + dimensions.length + " instead of " + baseMatrix.dimCount());
        }
        for (int k = 0; k < position.length; ++k) {
            if (dimensions[k] < 0L) {
                throw new IndexOutOfBoundsException("Negative submatrix dimension: dimensions[" + k + "] = " + dimensions[k]);
            }
            long d = baseMatrix.dim(k);
            if (continuationMode == Matrix.ContinuationMode.NONE || d == 0L && !continuationMode.isConstant()) {
                if (position[k] < 0L) {
                    throw new IndexOutOfBoundsException("Negative position[" + k + "] = " + position[k] + (String)(continuationMode != Matrix.ContinuationMode.NONE ? ", and this matrix dimension is zero - it is not allowed for " + String.valueOf(continuationMode) : "") + " (start submatrix coordinate in " + String.valueOf(baseMatrix) + ")");
                }
                if (position[k] <= d - dimensions[k]) continue;
                throw new IndexOutOfBoundsException("Too large position[" + k + "] + dimensions[" + k + "] = " + position[k] + " + " + dimensions[k] + " > " + d + (String)(continuationMode != Matrix.ContinuationMode.NONE ? ", and this matrix dimension is zero - it is not allowed for " + String.valueOf(continuationMode) : "") + " (start submatrix coordinate + dimension in " + String.valueOf(baseMatrix) + ")");
            }
            if (position[k] <= Long.MAX_VALUE - dimensions[k]) continue;
            throw new IndexOutOfBoundsException("Too large position[" + k + "] + dimensions[" + k + "] = " + position[k] + " + " + dimensions[k] + " > Long.MAX_VALUE");
        }
        long len = Arrays.longMul(dimensions);
        if (len == Long.MIN_VALUE) {
            throw new IndexOutOfBoundsException("Too large submatrix dimensions dim[0] * dim[1] * ... = " + JArrays.toString(dimensions, " * ", 100) + " > Long.MAX_VALUE");
        }
        return len;
    }

    static boolean isInside(Matrix<?> baseMatrix, long[] position, long[] dimensions) {
        for (int k = 0; k < position.length; ++k) {
            long d = baseMatrix.dim(k);
            if (position[k] >= 0L && position[k] <= d - dimensions[k]) continue;
            return false;
        }
        return true;
    }

    static class SubMatrixUpdatableObjectArray<E>
    extends AbstractUpdatableObjectArray<E>
    implements SubMatrixArray {
        private final Matrix<? extends ObjectArray<E>> baseMatrix;
        private final UpdatableObjectArray<E> baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final E outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableObjectArray(Matrix<? extends UpdatableObjectArray<E>> baseMatrix, long[] position, long[] dimensions, E outsideValue, Matrix.ContinuationMode mode) {
            super(baseMatrix.array().elementType(), ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nObjectCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public E get(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.get(index);
        }

        @Override
        public void set(long index, E value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.set(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, E value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, E value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableObjectArray<E> fill(long position, long count, E value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                Array a;
                Array array = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, (UpdatableArray)a, Arrays.nObjectCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillObjects(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray " + this.elementType().getName() + "[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixObjectArray<E>
    extends AbstractObjectArray<E>
    implements SubMatrixArray {
        private final Matrix<? extends ObjectArray<E>> baseMatrix;
        private final ObjectArray<E> baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final E outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixObjectArray(Matrix<? extends ObjectArray<E>> baseMatrix, long[] position, long[] dimensions, E outsideValue, Matrix.ContinuationMode mode) {
            super(baseMatrix.array().elementType(), ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nObjectCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public E get(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.get(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, E value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, E value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfObject(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray " + this.elementType().getName() + "[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableDoubleArray
    extends AbstractUpdatableDoubleArray
    implements SubMatrixArray {
        private final Matrix<? extends DoubleArray> baseMatrix;
        private final UpdatableDoubleArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final double outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableDoubleArray(Matrix<? extends UpdatableDoubleArray> baseMatrix, long[] position, long[] dimensions, double outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nDoubleCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getDouble(index);
        }

        @Override
        public void setDouble(long index, double value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setDouble(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableDoubleArray fill(long position, long count, double value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableDoubleArray a;
                UpdatableDoubleArray updatableDoubleArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nDoubleCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillDoubles(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray double[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixDoubleArray
    extends AbstractDoubleArray
    implements SubMatrixArray {
        private final Matrix<? extends DoubleArray> baseMatrix;
        private final DoubleArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final double outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixDoubleArray(Matrix<? extends DoubleArray> baseMatrix, long[] position, long[] dimensions, double outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nDoubleCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public double getDouble(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getDouble(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, double value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, double value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfDouble(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray double[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableFloatArray
    extends AbstractUpdatableFloatArray
    implements SubMatrixArray {
        private final Matrix<? extends FloatArray> baseMatrix;
        private final UpdatableFloatArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final float outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableFloatArray(Matrix<? extends UpdatableFloatArray> baseMatrix, long[] position, long[] dimensions, float outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nFloatCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getFloat(index);
        }

        @Override
        public void setFloat(long index, float value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setFloat(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, float value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, float value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableFloatArray fill(long position, long count, float value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableFloatArray a;
                UpdatableFloatArray updatableFloatArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nFloatCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillFloats(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray float[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixFloatArray
    extends AbstractFloatArray
    implements SubMatrixArray {
        private final Matrix<? extends FloatArray> baseMatrix;
        private final FloatArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final float outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixFloatArray(Matrix<? extends FloatArray> baseMatrix, long[] position, long[] dimensions, float outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nFloatCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public float getFloat(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getFloat(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, float value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, float value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfFloat(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray float[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableLongArray
    extends AbstractUpdatableLongArray
    implements SubMatrixArray {
        private final Matrix<? extends LongArray> baseMatrix;
        private final UpdatableLongArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final long outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableLongArray(Matrix<? extends UpdatableLongArray> baseMatrix, long[] position, long[] dimensions, long outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nLongCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getLong(index);
        }

        @Override
        public void setLong(long index, long value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setLong(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableLongArray fill(long position, long count, long value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableLongArray a;
                UpdatableLongArray updatableLongArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nLongCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillLongs(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray long[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixLongArray
    extends AbstractLongArray
    implements SubMatrixArray {
        private final Matrix<? extends LongArray> baseMatrix;
        private final LongArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final long outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixLongArray(Matrix<? extends LongArray> baseMatrix, long[] position, long[] dimensions, long outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nLongCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public long getLong(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getLong(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, long value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, long value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfLong(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray long[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableIntArray
    extends AbstractUpdatableIntArray
    implements SubMatrixArray {
        private final Matrix<? extends IntArray> baseMatrix;
        private final UpdatableIntArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final int outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableIntArray(Matrix<? extends UpdatableIntArray> baseMatrix, long[] position, long[] dimensions, int outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nIntCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getInt(index);
        }

        @Override
        public void setInt(long index, int value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setInt(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, int value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, int value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableIntArray fill(long position, long count, int value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableIntArray a;
                UpdatableIntArray updatableIntArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nIntCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillInts(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray int[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixIntArray
    extends AbstractIntArray
    implements SubMatrixArray {
        private final Matrix<? extends IntArray> baseMatrix;
        private final IntArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final int outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixIntArray(Matrix<? extends IntArray> baseMatrix, long[] position, long[] dimensions, int outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nIntCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public int getInt(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getInt(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, int value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, int value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfInt(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray int[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableShortArray
    extends AbstractUpdatableShortArray
    implements SubMatrixArray {
        private final Matrix<? extends ShortArray> baseMatrix;
        private final UpdatableShortArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final short outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableShortArray(Matrix<? extends UpdatableShortArray> baseMatrix, long[] position, long[] dimensions, short outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nShortCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue & 0xFFFF : this.baseArray.getShort(index);
        }

        @Override
        public void setShort(long index, short value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setShort(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, short value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, short value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableShortArray fill(long position, long count, short value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableShortArray a;
                UpdatableShortArray updatableShortArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nShortCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillShorts(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray short[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixShortArray
    extends AbstractShortArray
    implements SubMatrixArray {
        private final Matrix<? extends ShortArray> baseMatrix;
        private final ShortArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final short outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixShortArray(Matrix<? extends ShortArray> baseMatrix, long[] position, long[] dimensions, short outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nShortCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public int getShort(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue & 0xFFFF : this.baseArray.getShort(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, short value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, short value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfShort(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray short[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableByteArray
    extends AbstractUpdatableByteArray
    implements SubMatrixArray {
        private final Matrix<? extends ByteArray> baseMatrix;
        private final UpdatableByteArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final byte outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableByteArray(Matrix<? extends UpdatableByteArray> baseMatrix, long[] position, long[] dimensions, byte outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nByteCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue & 0xFF : this.baseArray.getByte(index);
        }

        @Override
        public void setByte(long index, byte value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setByte(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, byte value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, byte value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableByteArray fill(long position, long count, byte value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableByteArray a;
                UpdatableByteArray updatableByteArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nByteCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillBytes(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray byte[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixByteArray
    extends AbstractByteArray
    implements SubMatrixArray {
        private final Matrix<? extends ByteArray> baseMatrix;
        private final ByteArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final byte outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixByteArray(Matrix<? extends ByteArray> baseMatrix, long[] position, long[] dimensions, byte outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nByteCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public int getByte(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue & 0xFF : this.baseArray.getByte(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, byte value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, byte value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfByte(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray byte[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableCharArray
    extends AbstractUpdatableCharArray
    implements SubMatrixArray {
        private final Matrix<? extends CharArray> baseMatrix;
        private final UpdatableCharArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final char outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableCharArray(Matrix<? extends UpdatableCharArray> baseMatrix, long[] position, long[] dimensions, char outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nCharCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getChar(index);
        }

        @Override
        public void setChar(long index, char value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setChar(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, char value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, char value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableCharArray fill(long position, long count, char value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableCharArray a;
                UpdatableCharArray updatableCharArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nCharCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillChars(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray char[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixCharArray
    extends AbstractCharArray
    implements SubMatrixArray {
        private final Matrix<? extends CharArray> baseMatrix;
        private final CharArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final char outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixCharArray(Matrix<? extends CharArray> baseMatrix, long[] position, long[] dimensions, char outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nCharCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public char getChar(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getChar(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, char value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, char value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfChar(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray char[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixUpdatableBitArray
    extends AbstractUpdatableBitArray
    implements SubMatrixArray {
        private final Matrix<? extends BitArray> baseMatrix;
        private final UpdatableBitArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final boolean outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixUpdatableBitArray(Matrix<? extends UpdatableBitArray> baseMatrix, long[] position, long[] dimensions, boolean outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nBitCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getBit(index);
        }

        @Override
        public void setBit(long index, boolean value) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            if ((index = this.indexer.translate(index)) != -1L) {
                this.baseArray.setBit(index, value);
            }
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            if (!this.indexer.bitsBlocksImplemented()) {
                super.getBits(arrayPos, destArray, destArrayOffset, count);
                return;
            }
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw SubMatrixUpdatableBitArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - count) {
                throw SubMatrixUpdatableBitArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
            }
            this.indexer.getBits(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public UpdatableArray setData(long arrayPos, Object srcArray, int srcArrayOffset, int count) {
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of stored elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.setData(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public UpdatableBitArray setBits(long arrayPos, long[] srcArray, long srcArrayOffset, long count) {
            if (!this.indexer.bitsBlocksImplemented()) {
                return super.setBits(arrayPos, srcArray, srcArrayOffset, count);
            }
            Objects.requireNonNull(srcArray, "Null srcArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw SubMatrixUpdatableBitArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - count) {
                throw SubMatrixUpdatableBitArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
            }
            this.indexer.setBits(arrayPos, srcArray, srcArrayOffset, count);
            return this;
        }

        @Override
        public long nextQuickPosition(long position) {
            return !this.indexer.bitsBlocksImplemented() || position >= this.length ? -1L : (position < 0L ? 0L : position);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, boolean value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public UpdatableBitArray fill(long position, long count, boolean value) {
            this.checkSubArrArguments(position, count);
            if (this.baseMatrix.isTiled()) {
                UpdatableBitArray a;
                UpdatableBitArray updatableBitArray = a = position == 0L && count == this.length() ? this : this.subArr(position, count);
                if (ArraysSubMatrixCopier.copySubMatrixArray(null, a, Arrays.nBitCopies(count, value))) {
                    return this;
                }
            }
            this.indexer.fillBits(position, count, value);
            return this;
        }

        @Override
        public String toString() {
            return "unresizable AlgART baseArray boolean[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static class SubMatrixBitArray
    extends AbstractBitArray
    implements SubMatrixArray {
        private final Matrix<? extends BitArray> baseMatrix;
        private final BitArray baseArray;
        private final long[] position;
        private final long[] dimensions;
        private final ArraysSubMatrixIndexer indexer;
        private final boolean outsideValue;
        private final Matrix.ContinuationMode continuationMode;

        SubMatrixBitArray(Matrix<? extends BitArray> baseMatrix, long[] position, long[] dimensions, boolean outsideValue, Matrix.ContinuationMode mode) {
            super(ArraysSubMatrixImpl.checkBounds(baseMatrix, position, dimensions, mode), false, baseMatrix.array());
            this.baseMatrix = baseMatrix;
            this.baseArray = baseMatrix.array();
            this.position = (long[])position.clone();
            this.dimensions = (long[])dimensions.clone();
            this.outsideValue = outsideValue;
            this.continuationMode = mode;
            if (mode == Matrix.ContinuationMode.NONE || mode.isConstant() || ArraysSubMatrixImpl.isInside(baseMatrix, position, dimensions)) {
                this.indexer = new ArraysSubMatrixConstantlyContinuedIndexer(baseMatrix, position, dimensions, Arrays.nBitCopies(this.length, this.outsideValue));
            } else if (mode == Matrix.ContinuationMode.CYCLIC || mode == Matrix.ContinuationMode.PSEUDO_CYCLIC) {
                this.indexer = new ArraysSubMatrixCyclicIndexer(baseMatrix, position, dimensions, mode == Matrix.ContinuationMode.PSEUDO_CYCLIC);
            } else if (mode == Matrix.ContinuationMode.MIRROR_CYCLIC) {
                this.indexer = new ArraysSubMatrixMirrorCyclicIndexer(baseMatrix, position, dimensions);
            } else {
                throw new AssertionError((Object)("Unsupported continuation mode: " + String.valueOf(mode)));
            }
        }

        @Override
        public Matrix<? extends Array> baseMatrix() {
            return this.baseMatrix;
        }

        @Override
        public Matrix.ContinuationMode continuationMode() {
            return this.continuationMode;
        }

        @Override
        public long[] from() {
            return (long[])this.position.clone();
        }

        @Override
        public long[] to() {
            long[] result = new long[this.position.length];
            for (int k = 0; k < result.length; ++k) {
                result[k] = this.position[k] + this.dimensions[k];
            }
            return result;
        }

        @Override
        public long[] dimensions() {
            return (long[])this.dimensions.clone();
        }

        @Override
        public boolean isLazy() {
            return this.baseArray.isLazy();
        }

        @Override
        public boolean getBit(long index) {
            if (index < 0L || index >= this.length) {
                throw this.rangeException(index);
            }
            return (index = this.indexer.translate(index)) == -1L ? this.outsideValue : this.baseArray.getBit(index);
        }

        @Override
        public void getData(long arrayPos, Object destArray, int destArrayOffset, int count) {
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw this.rangeException(arrayPos);
            }
            if (arrayPos > this.length - (long)count) {
                throw this.rangeException(arrayPos + (long)count - 1L);
            }
            this.indexer.getData(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public void getBits(long arrayPos, long[] destArray, long destArrayOffset, long count) {
            if (!this.indexer.bitsBlocksImplemented()) {
                super.getBits(arrayPos, destArray, destArrayOffset, count);
                return;
            }
            Objects.requireNonNull(destArray, "Null destArray argument");
            if (count < 0L) {
                throw new IllegalArgumentException("Negative number of loaded elements (" + count + ")");
            }
            if (arrayPos < 0L) {
                throw SubMatrixBitArray.rangeException(arrayPos, this.length, this.getClass());
            }
            if (arrayPos > this.length - count) {
                throw SubMatrixBitArray.rangeException(arrayPos + count - 1L, this.length, this.getClass());
            }
            this.indexer.getBits(arrayPos, destArray, destArrayOffset, count);
        }

        @Override
        public long nextQuickPosition(long position) {
            return !this.indexer.bitsBlocksImplemented() || position >= this.length ? -1L : (position < 0L ? 0L : position);
        }

        @Override
        public long indexOf(long lowIndex, long highIndex, boolean value) {
            return !this.indexer.indexOfImplemented() ? super.indexOf(lowIndex, highIndex, value) : this.indexer.indexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public long lastIndexOf(long lowIndex, long highIndex, boolean value) {
            return !this.indexer.indexOfImplemented() ? super.lastIndexOf(lowIndex, highIndex, value) : this.indexer.lastIndexOfBit(lowIndex, highIndex, value);
        }

        @Override
        public String toString() {
            return "immutable AlgART baseArray boolean[" + this.length + "] containing submatrix of " + String.valueOf(this.baseMatrix);
        }
    }

    static interface SubMatrixArray {
        public Matrix<? extends Array> baseMatrix();

        public Matrix.ContinuationMode continuationMode();

        public long[] from();

        public long[] to();

        public long[] dimensions();
    }
}

