/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import net.algart.arrays.AbstractMemoryModel;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BufferArraysImpl;
import net.algart.arrays.DataStorage;
import net.algart.arrays.DirectDataStorages;
import net.algart.arrays.MutableArray;
import net.algart.arrays.PackedBitBuffers;
import net.algart.arrays.UnsupportedElementTypeException;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;
import net.algart.arrays.UpdatableByteArray;
import net.algart.arrays.UpdatableCharArray;
import net.algart.arrays.UpdatableDoubleArray;
import net.algart.arrays.UpdatableFloatArray;
import net.algart.arrays.UpdatableIntArray;
import net.algart.arrays.UpdatableLongArray;
import net.algart.arrays.UpdatableShortArray;

public class BufferMemoryModel
extends AbstractMemoryModel {
    static final BufferMemoryModel INSTANCE = new BufferMemoryModel();

    private BufferMemoryModel() {
    }

    public static BufferMemoryModel getInstance() {
        return INSTANCE;
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType) {
        return this.newEmptyArray(elementType, 10L);
    }

    @Override
    public MutableArray newEmptyArray(Class<?> elementType, long initialCapacity) {
        return this.newArray(elementType, initialCapacity, 0L);
    }

    @Override
    public MutableArray newArray(Class<?> elementType, long initialLength) {
        return this.newArray(elementType, initialLength, initialLength);
    }

    @Override
    public UpdatableArray newUnresizableArray(Class<?> elementType, long length) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (length < 0L) {
            throw new IllegalArgumentException("Negative array length");
        }
        if (elementType == Boolean.TYPE) {
            DirectDataStorages.DirectBitStorage storage = new DirectDataStorages.DirectBitStorage();
            BufferArraysImpl.UpdatableBufferBitArray result = new BufferArraysImpl.UpdatableBufferBitArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Character.TYPE) {
            DirectDataStorages.DirectCharStorage storage = new DirectDataStorages.DirectCharStorage();
            BufferArraysImpl.UpdatableBufferCharArray result = new BufferArraysImpl.UpdatableBufferCharArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Byte.TYPE) {
            DirectDataStorages.DirectByteStorage storage = new DirectDataStorages.DirectByteStorage();
            BufferArraysImpl.UpdatableBufferByteArray result = new BufferArraysImpl.UpdatableBufferByteArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Short.TYPE) {
            DirectDataStorages.DirectShortStorage storage = new DirectDataStorages.DirectShortStorage();
            BufferArraysImpl.UpdatableBufferShortArray result = new BufferArraysImpl.UpdatableBufferShortArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Integer.TYPE) {
            DirectDataStorages.DirectIntStorage storage = new DirectDataStorages.DirectIntStorage();
            BufferArraysImpl.UpdatableBufferIntArray result = new BufferArraysImpl.UpdatableBufferIntArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Long.TYPE) {
            DirectDataStorages.DirectLongStorage storage = new DirectDataStorages.DirectLongStorage();
            BufferArraysImpl.UpdatableBufferLongArray result = new BufferArraysImpl.UpdatableBufferLongArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Float.TYPE) {
            DirectDataStorages.DirectFloatStorage storage = new DirectDataStorages.DirectFloatStorage();
            BufferArraysImpl.UpdatableBufferFloatArray result = new BufferArraysImpl.UpdatableBufferFloatArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Double.TYPE) {
            DirectDataStorages.DirectDoubleStorage storage = new DirectDataStorages.DirectDoubleStorage();
            BufferArraysImpl.UpdatableBufferDoubleArray result = new BufferArraysImpl.UpdatableBufferDoubleArray((DataStorage)storage, length, length, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        throw new UnsupportedElementTypeException("Only primitive element types are allowed in BufferMemoryModel (passed type: " + String.valueOf(elementType) + ")");
    }

    @Override
    public boolean isElementTypeSupported(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        return elementType.isPrimitive();
    }

    @Override
    public boolean areAllPrimitiveElementTypesSupported() {
        return true;
    }

    @Override
    public boolean areAllElementTypesSupported() {
        return false;
    }

    @Override
    public long maxSupportedLength(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (elementType == Boolean.TYPE) {
            return 17179869120L;
        }
        if (elementType == Character.TYPE) {
            return 0x3FFFFFFFL;
        }
        if (elementType == Byte.TYPE) {
            return Integer.MAX_VALUE;
        }
        if (elementType == Short.TYPE) {
            return 0x3FFFFFFFL;
        }
        if (elementType == Integer.TYPE) {
            return 0x1FFFFFFFL;
        }
        if (elementType == Long.TYPE) {
            return 0xFFFFFFFL;
        }
        if (elementType == Float.TYPE) {
            return 0x1FFFFFFFL;
        }
        if (elementType == Double.TYPE) {
            return 0xFFFFFFFL;
        }
        return -1L;
    }

    @Override
    public boolean isCreatedBy(Array array) {
        return BufferMemoryModel.isBufferArray(array);
    }

    public static boolean isBufferArray(Array array) {
        return array instanceof BufferArraysImpl.AbstractBufferArray && ((BufferArraysImpl.AbstractBufferArray)array).storage instanceof DirectDataStorages.DirectStorage;
    }

    public static ByteBuffer getByteBuffer(Array bufferArray) {
        Objects.requireNonNull(bufferArray, "Null bufferArray argument");
        if (!BufferMemoryModel.isBufferArray(bufferArray)) {
            throw new IllegalArgumentException("The passed argument is not a buffer array");
        }
        ByteBuffer bb = ((DirectDataStorages.DirectStorage)((BufferArraysImpl.AbstractBufferArray)bufferArray).storage).bb;
        ByteOrder o = bb.order();
        return bufferArray.isImmutable() ? bb.asReadOnlyBuffer().order(o) : bb.duplicate().order(o);
    }

    public static long getBufferOffset(Array bufferArray) {
        Objects.requireNonNull(bufferArray, "Null bufferArray argument");
        if (!BufferMemoryModel.isBufferArray(bufferArray)) {
            throw new IllegalArgumentException("The passed argument is not a buffer array");
        }
        return ((BufferArraysImpl.AbstractBufferArray)bufferArray).offset;
    }

    public static UpdatableArray asUpdatableArray(ByteBuffer byteBuffer, Class<?> elementType) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer argument");
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (elementType == Boolean.TYPE) {
            throw new IllegalArgumentException("ByteBuffer cannot be viewed as UpdatableBitArray");
        }
        ByteBuffer bb = byteBuffer.duplicate();
        bb.order(byteBuffer.order());
        bb.rewind();
        if (elementType == Character.TYPE) {
            DirectDataStorages.DirectCharStorage storage = new DirectDataStorages.DirectCharStorage(bb);
            int length = bb.limit() >> 1;
            BufferArraysImpl.UpdatableBufferCharArray result = new BufferArraysImpl.UpdatableBufferCharArray((DataStorage)storage, (long)length, (long)length, 0L, false);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Byte.TYPE) {
            DirectDataStorages.DirectByteStorage storage = new DirectDataStorages.DirectByteStorage(bb);
            int length = bb.limit();
            BufferArraysImpl.UpdatableBufferByteArray result = new BufferArraysImpl.UpdatableBufferByteArray((DataStorage)storage, (long)length, (long)length, 0L, false);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Short.TYPE) {
            DirectDataStorages.DirectShortStorage storage = new DirectDataStorages.DirectShortStorage(bb);
            int length = bb.limit() >> 1;
            BufferArraysImpl.UpdatableBufferShortArray result = new BufferArraysImpl.UpdatableBufferShortArray((DataStorage)storage, (long)length, (long)length, 0L, false);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Integer.TYPE) {
            DirectDataStorages.DirectIntStorage storage = new DirectDataStorages.DirectIntStorage(bb);
            int length = bb.limit() >> 2;
            BufferArraysImpl.UpdatableBufferIntArray result = new BufferArraysImpl.UpdatableBufferIntArray((DataStorage)storage, (long)length, (long)length, 0L, false);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Long.TYPE) {
            DirectDataStorages.DirectLongStorage storage = new DirectDataStorages.DirectLongStorage(bb);
            int length = bb.limit() >> 3;
            BufferArraysImpl.UpdatableBufferLongArray result = new BufferArraysImpl.UpdatableBufferLongArray((DataStorage)storage, (long)length, (long)length, 0L, false);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Float.TYPE) {
            DirectDataStorages.DirectFloatStorage storage = new DirectDataStorages.DirectFloatStorage(bb);
            int length = bb.limit() >> 2;
            BufferArraysImpl.UpdatableBufferFloatArray result = new BufferArraysImpl.UpdatableBufferFloatArray((DataStorage)storage, (long)length, (long)length, 0L, false);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Double.TYPE) {
            DirectDataStorages.DirectDoubleStorage storage = new DirectDataStorages.DirectDoubleStorage(bb);
            int length = bb.limit() >> 3;
            BufferArraysImpl.UpdatableBufferDoubleArray result = new BufferArraysImpl.UpdatableBufferDoubleArray((DataStorage)storage, (long)length, (long)length, 0L, false);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        throw new IllegalArgumentException("Only non-boolean primitive element types are allowed in BufferMemoryModel (passed type: " + String.valueOf(elementType) + ")");
    }

    public static UpdatableBitArray asUpdatableBitArray(ByteBuffer byteBuffer, long length) {
        Objects.requireNonNull(byteBuffer, "Null byteBuffer");
        if (length < 0L) {
            throw new IllegalArgumentException("Negative length");
        }
        long packedLength = PackedBitBuffers.packedLength(length);
        ByteBuffer bb = byteBuffer.duplicate();
        bb.order(byteBuffer.order());
        bb.rewind();
        if (packedLength > (long)(bb.limit() >>> 3)) {
            throw new IllegalArgumentException("Too short byteBuffer long[" + byteBuffer.limit() + "]: it must contain at least " + packedLength + " long elements to store " + length + " bits");
        }
        DirectDataStorages.DirectBitStorage storage = new DirectDataStorages.DirectBitStorage(bb);
        BufferArraysImpl.UpdatableBufferBitArray result = new BufferArraysImpl.UpdatableBufferBitArray((DataStorage)storage, length, length, 0L, false);
        BufferArraysImpl.forgetOnDeallocation(result);
        return result;
    }

    public static UpdatableCharArray asUpdatableCharArray(ByteBuffer byteBuffer) {
        return (UpdatableCharArray)BufferMemoryModel.asUpdatableArray(byteBuffer, Character.TYPE);
    }

    public static UpdatableByteArray asUpdatableByteArray(ByteBuffer byteBuffer) {
        return (UpdatableByteArray)BufferMemoryModel.asUpdatableArray(byteBuffer, Byte.TYPE);
    }

    public static UpdatableShortArray asUpdatableShortArray(ByteBuffer byteBuffer) {
        return (UpdatableShortArray)BufferMemoryModel.asUpdatableArray(byteBuffer, Short.TYPE);
    }

    public static UpdatableIntArray asUpdatableIntArray(ByteBuffer byteBuffer) {
        return (UpdatableIntArray)BufferMemoryModel.asUpdatableArray(byteBuffer, Integer.TYPE);
    }

    public static UpdatableLongArray asUpdatableLongArray(ByteBuffer byteBuffer) {
        return (UpdatableLongArray)BufferMemoryModel.asUpdatableArray(byteBuffer, Long.TYPE);
    }

    public static UpdatableFloatArray asUpdatableFloatArray(ByteBuffer byteBuffer) {
        return (UpdatableFloatArray)BufferMemoryModel.asUpdatableArray(byteBuffer, Float.TYPE);
    }

    public static UpdatableDoubleArray asUpdatableDoubleArray(ByteBuffer byteBuffer) {
        return (UpdatableDoubleArray)BufferMemoryModel.asUpdatableArray(byteBuffer, Double.TYPE);
    }

    public String toString() {
        return "Buffer memory model";
    }

    private MutableArray newArray(Class<?> elementType, long initialCapacity, long initialLength) {
        Arrays.checkElementTypeForNullAndVoid(elementType);
        if (initialLength < 0L) {
            throw new IllegalArgumentException("Negative initial length");
        }
        if (initialCapacity < 0L) {
            throw new IllegalArgumentException("Negative initial capacity");
        }
        if (elementType == Boolean.TYPE) {
            DirectDataStorages.DirectBitStorage storage = new DirectDataStorages.DirectBitStorage();
            BufferArraysImpl.MutableBufferBitArray result = new BufferArraysImpl.MutableBufferBitArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Character.TYPE) {
            DirectDataStorages.DirectCharStorage storage = new DirectDataStorages.DirectCharStorage();
            BufferArraysImpl.MutableBufferCharArray result = new BufferArraysImpl.MutableBufferCharArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Byte.TYPE) {
            DirectDataStorages.DirectByteStorage storage = new DirectDataStorages.DirectByteStorage();
            BufferArraysImpl.MutableBufferByteArray result = new BufferArraysImpl.MutableBufferByteArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Short.TYPE) {
            DirectDataStorages.DirectShortStorage storage = new DirectDataStorages.DirectShortStorage();
            BufferArraysImpl.MutableBufferShortArray result = new BufferArraysImpl.MutableBufferShortArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Integer.TYPE) {
            DirectDataStorages.DirectIntStorage storage = new DirectDataStorages.DirectIntStorage();
            BufferArraysImpl.MutableBufferIntArray result = new BufferArraysImpl.MutableBufferIntArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Long.TYPE) {
            DirectDataStorages.DirectLongStorage storage = new DirectDataStorages.DirectLongStorage();
            BufferArraysImpl.MutableBufferLongArray result = new BufferArraysImpl.MutableBufferLongArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Float.TYPE) {
            DirectDataStorages.DirectFloatStorage storage = new DirectDataStorages.DirectFloatStorage();
            BufferArraysImpl.MutableBufferFloatArray result = new BufferArraysImpl.MutableBufferFloatArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        if (elementType == Double.TYPE) {
            DirectDataStorages.DirectDoubleStorage storage = new DirectDataStorages.DirectDoubleStorage();
            BufferArraysImpl.MutableBufferDoubleArray result = new BufferArraysImpl.MutableBufferDoubleArray((DataStorage)storage, initialCapacity, initialLength, 0L, true);
            BufferArraysImpl.forgetOnDeallocation(result);
            return result;
        }
        throw new UnsupportedElementTypeException("Only primitive element types are allowed in BufferMemoryModel (passed type: " + String.valueOf(elementType) + ")");
    }
}

