/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.ByteArray;
import net.algart.arrays.CharArray;
import net.algart.arrays.DataBitBuffer;
import net.algart.arrays.DataBuffer;
import net.algart.arrays.DataBufferIndexOverflowException;
import net.algart.arrays.DataByteBuffer;
import net.algart.arrays.DataCharBuffer;
import net.algart.arrays.DataDoubleBuffer;
import net.algart.arrays.DataFloatBuffer;
import net.algart.arrays.DataIntBuffer;
import net.algart.arrays.DataLongBuffer;
import net.algart.arrays.DataObjectBuffer;
import net.algart.arrays.DataShortBuffer;
import net.algart.arrays.DirectAccessible;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.IntArray;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.JArrayPool;
import net.algart.arrays.LongArray;
import net.algart.arrays.ObjectArray;
import net.algart.arrays.PackedBitArrays;
import net.algart.arrays.ShortArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.UpdatableArray;
import net.algart.arrays.UpdatableBitArray;

class DataBuffersImpl {
    static final int BITS_GAP = 256;
    static final int MAX_BUFFER_SIZE = 65536;
    static final JArrayPool BIT_BUFFERS = JArrayPool.getInstance(Long.TYPE, 8197);
    static final JArrayPool CHAR_BUFFERS = JArrayPool.getInstance(Character.TYPE, 32768);
    static final JArrayPool BYTE_BUFFERS = JArrayPool.getInstance(Byte.TYPE, 65536);
    static final JArrayPool SHORT_BUFFERS = JArrayPool.getInstance(Short.TYPE, 32768);
    static final JArrayPool INT_BUFFERS = JArrayPool.getInstance(Integer.TYPE, 16384);
    static final JArrayPool LONG_BUFFERS = JArrayPool.getInstance(Long.TYPE, 16384);
    static final JArrayPool FLOAT_BUFFERS = JArrayPool.getInstance(Float.TYPE, 16384);
    static final JArrayPool DOUBLE_BUFFERS = JArrayPool.getInstance(Double.TYPE, 16384);

    DataBuffersImpl() {
    }

    static class ArrayObjectBuffer<E>
    extends ArrayBuffer
    implements DataObjectBuffer<E> {
        ArrayObjectBuffer(ObjectArray<E> array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataObjectBuffer<E> map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataObjectBuffer<E> mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataObjectBuffer<E> force() {
            super.force();
            return this;
        }

        @Override
        public E[] data() {
            return (Object[])InternalUtils.cast(super.data());
        }
    }

    static class ArrayDoubleBuffer
    extends ArrayBuffer
    implements DataDoubleBuffer {
        ArrayDoubleBuffer(DoubleArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataDoubleBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataDoubleBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataDoubleBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataDoubleBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataDoubleBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataDoubleBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataDoubleBuffer force() {
            super.force();
            return this;
        }

        @Override
        public double[] data() {
            return (double[])super.data();
        }
    }

    static class ArrayFloatBuffer
    extends ArrayBuffer
    implements DataFloatBuffer {
        ArrayFloatBuffer(FloatArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataFloatBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataFloatBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataFloatBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataFloatBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataFloatBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataFloatBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataFloatBuffer force() {
            super.force();
            return this;
        }

        @Override
        public float[] data() {
            return (float[])super.data();
        }
    }

    static class ArrayLongBuffer
    extends ArrayBuffer
    implements DataLongBuffer {
        ArrayLongBuffer(LongArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataLongBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataLongBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataLongBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataLongBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataLongBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataLongBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataLongBuffer force() {
            super.force();
            return this;
        }

        @Override
        public long[] data() {
            return (long[])super.data();
        }
    }

    static class ArrayIntBuffer
    extends ArrayBuffer
    implements DataIntBuffer {
        ArrayIntBuffer(IntArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataIntBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataIntBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataIntBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataIntBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataIntBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataIntBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataIntBuffer force() {
            super.force();
            return this;
        }

        @Override
        public int[] data() {
            return (int[])super.data();
        }
    }

    static class ArrayShortBuffer
    extends ArrayBuffer
    implements DataShortBuffer {
        ArrayShortBuffer(ShortArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataShortBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataShortBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataShortBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataShortBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataShortBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataShortBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataShortBuffer force() {
            super.force();
            return this;
        }

        @Override
        public short[] data() {
            return (short[])super.data();
        }
    }

    static class ArrayByteBuffer
    extends ArrayBuffer
    implements DataByteBuffer {
        ArrayByteBuffer(ByteArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataByteBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataByteBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataByteBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataByteBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataByteBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataByteBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataByteBuffer force() {
            super.force();
            return this;
        }

        @Override
        public byte[] data() {
            return (byte[])super.data();
        }
    }

    static class ArrayCharBuffer
    extends ArrayBuffer
    implements DataCharBuffer {
        ArrayCharBuffer(CharArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataCharBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataCharBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataCharBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataCharBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataCharBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataCharBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataCharBuffer force() {
            super.force();
            return this;
        }

        @Override
        public char[] data() {
            return (char[])super.data();
        }
    }

    static class ArrayBitBuffer
    extends ArrayBuffer
    implements DataBitBuffer {
        ArrayBitBuffer(BitArray array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            super(array, mode, capacity, trusted);
        }

        @Override
        public DataBitBuffer map(long position) {
            super.map(position);
            return this;
        }

        @Override
        public DataBitBuffer map(long position, boolean readData) {
            super.map(position, readData);
            return this;
        }

        @Override
        public DataBitBuffer mapNext() {
            super.mapNext();
            return this;
        }

        @Override
        public DataBitBuffer mapNext(boolean readData) {
            super.mapNext(readData);
            return this;
        }

        @Override
        public DataBitBuffer map(long position, long maxCount) {
            super.map(position, maxCount);
            return this;
        }

        @Override
        public DataBitBuffer map(long position, long maxCount, boolean readData) {
            super.map(position, maxCount, readData);
            return this;
        }

        @Override
        public DataBitBuffer force() {
            super.force();
            return this;
        }

        @Override
        public long[] data() {
            return (long[])super.data();
        }

        @Override
        public int from() {
            if (this.from > Integer.MAX_VALUE) {
                throw new DataBufferIndexOverflowException("Cannot cast big fromIndex=" + this.from + " to int value");
            }
            return (int)this.from;
        }

        @Override
        public int to() {
            if (this.to > Integer.MAX_VALUE) {
                throw new DataBufferIndexOverflowException("Cannot cast big toIndex=" + this.to + " to int value");
            }
            return (int)this.to;
        }

        @Override
        public int cnt() {
            if (this.count > Integer.MAX_VALUE) {
                throw new DataBufferIndexOverflowException("Cannot cast big count=" + this.to + " to int value");
            }
            return (int)this.count;
        }
    }

    static class ArrayBuffer
    implements DataBuffer {
        Object data = null;
        private final Array array;
        private final boolean isNCopies;
        private final boolean isDirect;
        private final JArrayPool bufferPool;
        private final DataBuffer.AccessMode mode;
        private final long capacity;
        private final int javaArrayLength;
        private long position = 0L;
        private boolean initialized;
        private boolean disposed;
        long from = 0L;
        long to = 0L;
        long count = 0L;
        boolean caching = false;

        ArrayBuffer(Array array, DataBuffer.AccessMode mode, long capacity, boolean trusted) {
            Objects.requireNonNull(array, "Null array argument");
            Objects.requireNonNull(mode, "Null mode argument");
            long maxCap = SimpleMemoryModel.maxSupportedLengthImpl(array.elementType());
            if (array instanceof BitArray) {
                maxCap -= 256L;
            }
            if (capacity <= 0L || capacity > maxCap) {
                throw new IllegalArgumentException("Illegal capacity=" + capacity + ": it must be in range 1.." + maxCap);
            }
            if (capacity > array.length()) {
                capacity = (int)array.length();
            }
            if (!(array instanceof UpdatableArray) && mode != DataBuffer.AccessMode.READ) {
                throw new IllegalArgumentException(String.valueOf((Object)mode) + " is allowed for UpdatableArray only");
            }
            this.array = array;
            this.mode = mode;
            this.capacity = capacity;
            this.isNCopies = Arrays.isNCopies(array);
            if (array instanceof BitArray) {
                long[] ja = null;
                if (mode != DataBuffer.AccessMode.PRIVATE && (trusted || !array.isImmutable() && !array.isCopyOnNextWrite())) {
                    ja = Arrays.longJavaArrayInternal((BitArray)array);
                }
                boolean bl = this.isDirect = ja != null;
                if (this.isDirect) {
                    this.bufferPool = null;
                    this.data = ja;
                    this.javaArrayLength = -1;
                } else {
                    long packedLen = PackedBitArrays.packedLength(capacity + 256L);
                    this.javaArrayLength = (int)packedLen;
                    assert (packedLen == (long)this.javaArrayLength);
                    this.bufferPool = packedLen <= (long)BIT_BUFFERS.arrayLength() ? BIT_BUFFERS : null;
                }
            } else {
                assert (capacity == (long)((int)capacity));
                Object ja = null;
                if (mode != DataBuffer.AccessMode.PRIVATE) {
                    if (trusted) {
                        ja = Arrays.javaArrayInternal(array);
                    } else if (array instanceof DirectAccessible && ((DirectAccessible)((Object)array)).hasJavaArray() && !array.isCopyOnNextWrite()) {
                        ja = ((DirectAccessible)((Object)array)).javaArray();
                    }
                }
                boolean bl = this.isDirect = ja != null;
                if (this.isDirect) {
                    this.bufferPool = null;
                    this.data = ja;
                    this.javaArrayLength = -1;
                } else {
                    JArrayPool pool = array instanceof CharArray ? CHAR_BUFFERS : (array instanceof ByteArray ? BYTE_BUFFERS : (array instanceof ShortArray ? SHORT_BUFFERS : (array instanceof IntArray ? INT_BUFFERS : (array instanceof LongArray ? LONG_BUFFERS : (array instanceof FloatArray ? FLOAT_BUFFERS : (array instanceof DoubleArray ? DOUBLE_BUFFERS : null))))));
                    this.javaArrayLength = (int)capacity;
                    assert (capacity == (long)this.javaArrayLength);
                    this.bufferPool = pool != null && this.javaArrayLength <= pool.arrayLength() ? pool : null;
                }
            }
            this.initialized = false;
            assert (this.count >= 0L);
            assert (this.count <= this.capacity);
            assert (this.capacity <= array.length());
        }

        @Override
        public DataBuffer.AccessMode mode() {
            return this.mode;
        }

        @Override
        public Object data() {
            if (this.disposed) {
                throw new IllegalStateException("The data buffer is disposed");
            }
            return this.initialized ? this.data : null;
        }

        @Override
        public DataBuffer map(long position) {
            return this.map(position, this.capacity, true);
        }

        @Override
        public DataBuffer map(long position, boolean readData) {
            return this.map(position, this.capacity, readData);
        }

        @Override
        public DataBuffer mapNext() {
            return this.map(this.position + this.count, this.capacity, true);
        }

        @Override
        public DataBuffer mapNext(boolean readData) {
            return this.map(this.position + this.count, this.capacity, readData);
        }

        @Override
        public DataBuffer map(long position, long maxCount) {
            return this.map(position, maxCount, true);
        }

        @Override
        public DataBuffer map(long position, long maxCount, boolean readData) {
            if (this.disposed) {
                throw new IllegalStateException("The data buffer is disposed");
            }
            if (position < 0L) {
                throw new IndexOutOfBoundsException("Negative position argument");
            }
            if (maxCount < 0L) {
                throw new IllegalArgumentException("Negative maxCount argument");
            }
            long len = this.array.length();
            if (position > len) {
                throw new IndexOutOfBoundsException("Illegal position argument (" + position + "): it's greater than array length");
            }
            this.allocateData();
            this.position = position;
            this.count = Math.min(maxCount, Math.min(this.capacity, len - position));
            if (!this.isNCopies) {
                if (this.array instanceof BitArray) {
                    if (this.isDirect) {
                        this.from = position + Arrays.longJavaArrayOffsetInternal((BitArray)this.array);
                    } else {
                        this.from = Arrays.goodStartOffsetInArrayOfLongs((BitArray)this.array, position, 256);
                        if (readData && this.count > 0L) {
                            ((BitArray)this.array).getBits(position, (long[])this.data, this.from, this.count);
                        }
                    }
                } else if (this.isDirect) {
                    this.from = position + (long)Arrays.javaArrayOffsetInternal(this.array);
                } else {
                    assert (this.from == 0L);
                    assert (this.count == (long)((int)this.count));
                    if (readData && this.count > 0L) {
                        this.array.getData(position, this.data, 0, (int)this.count);
                    }
                }
            }
            this.to = this.from + this.count;
            this.initialized = true;
            assert (this.count >= (long)(position == len || maxCount == 0L ? 0 : 1));
            assert (this.count <= this.capacity);
            assert (this.count <= len - position);
            assert (this.from >= 0L);
            return this;
        }

        @Override
        public DataBuffer force() {
            return this.force(this.from, this.to);
        }

        @Override
        public DataBuffer force(long fromIndex, long toIndex) {
            if (this.disposed) {
                throw new IllegalStateException("The data buffer is disposed");
            }
            if (this.mode == DataBuffer.AccessMode.READ) {
                throw new IllegalStateException("Cannot force read-only data buffer");
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("Illegal force range: fromIndex = " + fromIndex + " > toIndex = " + toIndex);
            }
            if (fromIndex < this.from || toIndex > this.to) {
                throw new IllegalArgumentException("Illegal force range " + fromIndex + ".." + toIndex + ": it must be inside the current actual array range " + this.from + ".." + this.to);
            }
            if (this.mode != DataBuffer.AccessMode.PRIVATE && this.count > 0L && !this.isNCopies && !this.isDirect) {
                if (this.array instanceof UpdatableBitArray) {
                    ((UpdatableBitArray)this.array).setBits(this.position, (long[])this.data, fromIndex, toIndex - fromIndex);
                } else {
                    assert (fromIndex == (long)((int)fromIndex));
                    assert (toIndex == (long)((int)toIndex));
                    ((UpdatableArray)this.array).setData(this.position, this.data, (int)fromIndex, (int)toIndex);
                }
            }
            return this;
        }

        void dispose() {
            if (this.disposed) {
                throw new IllegalStateException("The data buffer is already disposed");
            }
            if (this.caching && this.bufferPool != null) {
                this.bufferPool.releaseArray(this.data);
            }
            this.disposed = true;
        }

        @Override
        public long position() {
            return this.position;
        }

        @Override
        public long capacity() {
            return this.capacity;
        }

        @Override
        public long fromIndex() {
            return this.from;
        }

        @Override
        public long toIndex() {
            return this.to;
        }

        @Override
        public long count() {
            return this.count;
        }

        @Override
        public boolean hasData() {
            return this.count != 0L;
        }

        @Override
        public boolean isDirect() {
            return this.isDirect;
        }

        @Override
        public int from() {
            return (int)this.from;
        }

        @Override
        public int to() {
            return (int)this.to;
        }

        @Override
        public int cnt() {
            return (int)this.count;
        }

        public String toString() {
            assert (this.count == this.to - this.from);
            return "data " + (this.initialized ? "" : "non-initialized ") + "buffer [" + (this.isDirect ? "direct; " : "indirect; ") + "mode=" + String.valueOf((Object)this.mode) + ", capacity=" + this.capacity + ", position=" + this.position + ", actual range " + this.from + ".." + this.to + "] for " + String.valueOf(this.array);
        }

        private void allocateData() {
            if (this.data != null) {
                return;
            }
            this.data = this.caching && this.bufferPool != null ? this.bufferPool.requestArray() : (this.array instanceof BitArray ? (Object)new long[this.javaArrayLength] : this.array.newJavaArray(this.javaArrayLength));
            if (this.isNCopies) {
                this.count = this.to = this.capacity;
                if (this.array instanceof BitArray) {
                    ((BitArray)this.array).getBits(0L, (long[])this.data, 0L, this.capacity);
                } else {
                    this.array.getData(0L, this.data);
                }
            }
        }
    }
}

