/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.algart.arrays.Array;
import net.algart.arrays.ArrayContext;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.MappedDataStorages;
import net.algart.arrays.MemoryModel;

abstract class DataStorage {
    static boolean DO_LAZY_INIT = InternalUtils.getBooleanProperty("net.algart.arrays.DataStorage.doLazyInit", true);
    static byte ZERO_INIT_FILLER = 0;
    static final int BYTES_PER_BYTE_LOG = 0;
    static final int BYTES_PER_CHAR_LOG = 1;
    static final int BYTES_PER_SHORT_LOG = 1;
    static final int BYTES_PER_INT_LOG = 2;
    static final int BYTES_PER_LONG_LOG = 3;
    static final int BYTES_PER_FLOAT_LOG = 2;
    static final int BYTES_PER_DOUBLE_LOG = 3;
    static final Boolean booleanZero = false;
    static final Character charZero = Character.valueOf('\u0000');
    static final Byte byteZero = 0;
    static final Short shortZero = 0;
    static final Integer intZero = 0;
    static final Long longZero = 0L;
    static final Float floatZero = Float.valueOf(0.0f);
    static final Double doubleZero = 0.0;

    DataStorage() {
    }

    static long maxSupportedLengthImpl(Class<?> elementType) {
        Objects.requireNonNull(elementType, "Null elementType argument");
        if (elementType == Boolean.TYPE || elementType == Byte.TYPE) {
            return Long.MAX_VALUE;
        }
        if (elementType == Character.TYPE) {
            return 0x3FFFFFFFFFFFFFFFL;
        }
        if (elementType == Short.TYPE) {
            return 0x3FFFFFFFFFFFFFFFL;
        }
        if (elementType == Integer.TYPE) {
            return 0x1FFFFFFFFFFFFFFFL;
        }
        if (elementType == Long.TYPE) {
            return 0xFFFFFFFFFFFFFFFL;
        }
        if (elementType == Float.TYPE) {
            return 0x1FFFFFFFFFFFFFFFL;
        }
        if (elementType == Double.TYPE) {
            return 0xFFFFFFFFFFFFFFFL;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeAllResources() {
        HashSet<MappedDataStorages.MappedStorage> all;
        Set<MappedDataStorages.MappedStorage> set = MappedDataStorages.allNonFinalizedMappedStorages;
        synchronized (set) {
            all = new HashSet<MappedDataStorages.MappedStorage>(MappedDataStorages.allNonFinalizedMappedStorages);
        }
        for (DataStorage dataStorage : all) {
            dataStorage.freeResources(null, false);
        }
    }

    abstract MemoryModel newCompatibleMemoryModel();

    abstract DataStorage newCompatibleEmptyStorage(boolean var1);

    abstract int bytesPerBufferElementLog();

    abstract ByteOrder byteOrder();

    abstract void allocate(long var1, boolean var3);

    abstract DataStorage changeCapacity(long var1, long var3, long var5);

    void setBitNoSync(long index, boolean value) {
        this.setBit(index, value);
    }

    long getBits64(long arrayPos, int count) {
        throw new UnsupportedOperationException("It is not a bit storage");
    }

    void setBits64(long arrayPos, long bits, int count) {
        throw new UnsupportedOperationException("It is not a bit storage");
    }

    void setBits64NoSync(long arrayPos, long bits, int count) {
        this.setBits64(arrayPos, bits, count);
    }

    boolean getBit(long index) {
        throw new UnsupportedOperationException("It is not a bit storage");
    }

    void setBit(long index, boolean value) {
        throw new UnsupportedOperationException("It is not a bit storage");
    }

    long indexOfBit(long lowIndex, long highIndex, boolean value) {
        throw new UnsupportedOperationException("It is not a bit storage");
    }

    long lastIndexOfBit(long lowIndex, long highIndex, boolean value) {
        throw new UnsupportedOperationException("It is not a bit storage");
    }

    char getChar(long index) {
        throw new UnsupportedOperationException("It is not a char storage");
    }

    void setChar(long index, char value) {
        throw new UnsupportedOperationException("It is not a char storage");
    }

    long indexOfChar(long lowIndex, long highIndex, char value) {
        throw new UnsupportedOperationException("It is not a char storage");
    }

    long lastIndexOfChar(long lowIndex, long highIndex, char value) {
        throw new UnsupportedOperationException("It is not a char storage");
    }

    byte getByte(long index) {
        throw new UnsupportedOperationException("It is not a byte storage");
    }

    void setByte(long index, byte value) {
        throw new UnsupportedOperationException("It is not a byte storage");
    }

    long indexOfByte(long lowIndex, long highIndex, byte value) {
        throw new UnsupportedOperationException("It is not a byte storage");
    }

    long lastIndexOfByte(long lowIndex, long highIndex, byte value) {
        throw new UnsupportedOperationException("It is not a byte storage");
    }

    short getShort(long index) {
        throw new UnsupportedOperationException("It is not a short storage");
    }

    void setShort(long index, short value) {
        throw new UnsupportedOperationException("It is not a short storage");
    }

    long indexOfShort(long lowIndex, long highIndex, short value) {
        throw new UnsupportedOperationException("It is not a short storage");
    }

    long lastIndexOfShort(long lowIndex, long highIndex, short value) {
        throw new UnsupportedOperationException("It is not a short storage");
    }

    int getInt(long index) {
        throw new UnsupportedOperationException("It is not a int storage");
    }

    void setInt(long index, int value) {
        throw new UnsupportedOperationException("It is not a int storage");
    }

    long indexOfInt(long lowIndex, long highIndex, int value) {
        throw new UnsupportedOperationException("It is not a int storage");
    }

    long lastIndexOfInt(long lowIndex, long highIndex, int value) {
        throw new UnsupportedOperationException("It is not a int storage");
    }

    long getLong(long index) {
        throw new UnsupportedOperationException("It is not a long storage");
    }

    void setLong(long index, long value) {
        throw new UnsupportedOperationException("It is not a long storage");
    }

    long indexOfLong(long lowIndex, long highIndex, long value) {
        throw new UnsupportedOperationException("It is not a long storage");
    }

    long lastIndexOfLong(long lowIndex, long highIndex, long value) {
        throw new UnsupportedOperationException("It is not a long storage");
    }

    float getFloat(long index) {
        throw new UnsupportedOperationException("It is not a float storage");
    }

    void setFloat(long index, float value) {
        throw new UnsupportedOperationException("It is not a float storage");
    }

    long indexOfFloat(long lowIndex, long highIndex, float value) {
        throw new UnsupportedOperationException("It is not a float storage");
    }

    long lastIndexOfFloat(long lowIndex, long highIndex, float value) {
        throw new UnsupportedOperationException("It is not a float storage");
    }

    double getDouble(long index) {
        throw new UnsupportedOperationException("It is not a double storage");
    }

    void setDouble(long index, double value) {
        throw new UnsupportedOperationException("It is not a double storage");
    }

    long indexOfDouble(long lowIndex, long highIndex, double value) {
        throw new UnsupportedOperationException("It is not a double storage");
    }

    long lastIndexOfDouble(long lowIndex, long highIndex, double value) {
        throw new UnsupportedOperationException("It is not a double storage");
    }

    abstract void copy(long var1, long var3);

    abstract void swap(long var1, long var3);

    abstract void getData(long var1, Object var3, int var4, int var5);

    abstract void setData(long var1, Object var3, int var4, int var5);

    abstract void fillData(long var1, long var3, Object var5);

    abstract void clearData(long var1, long var3);

    abstract boolean copy(DataStorage var1, long var2, long var4, long var6);

    abstract boolean swap(DataStorage var1, long var2, long var4, long var6);

    abstract void minData(long var1, Object var3, int var4, int var5);

    abstract void maxData(long var1, Object var3, int var4, int var5);

    abstract void addData(long var1, int[] var3, int var4, int var5);

    abstract void addData(long var1, double[] var3, int var4, int var5, double var6);

    abstract void subtractData(long var1, Object var3, int var4, int var5, boolean var6);

    abstract void absDiffData(long var1, Object var3, int var4, int var5, boolean var6);

    void attachArray(Array a) {
    }

    void forgetArray(int arrayIdentityHashCode) {
    }

    void actualizeLazyFilling(ArrayContext context, long fromIndex, long toIndex) {
    }

    void loadResources(long fromIndex, long toIndex) {
    }

    void flushResources(long fromIndex, long toIndex, boolean forcePhysicalWriting) {
    }

    void freeResources(Array a, boolean forcePhysicalWriting) {
    }

    void dispose() {
    }
}

