/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.util.Objects;
import net.algart.arrays.JArrays;

public abstract class Histogram {
    static final boolean DEBUG_MODE = false;
    final int length;
    int currentIValue = 0;
    double currentValue = 0.0;
    double currentPreciseRank = Double.NaN;

    Histogram(int length) {
        this.length = length;
    }

    public static Histogram newLongHistogram(int histogramLength, int ... bitLevelsOfPyramid) {
        if (histogramLength < 0) {
            throw new IllegalArgumentException("Negative histogramLength");
        }
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        return bitLevelsOfPyramid.length == 0 ? new Long1LevelHistogram(new long[histogramLength], bitLevelsOfPyramid, true) : new LongHistogram(new long[histogramLength], bitLevelsOfPyramid, true);
    }

    public static Histogram newLongHistogram(long[] histogram, int ... bitLevelsOfPyramid) {
        Objects.requireNonNull(histogram, "Null histogram argument");
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        return bitLevelsOfPyramid.length == 0 ? new Long1LevelHistogram((long[])histogram.clone(), bitLevelsOfPyramid, false) : new LongHistogram((long[])histogram.clone(), bitLevelsOfPyramid, false);
    }

    public static Histogram newIntHistogram(int histogramLength, int ... bitLevelsOfPyramid) {
        if (histogramLength < 0) {
            throw new IllegalArgumentException("Negative histogramLength");
        }
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        return bitLevelsOfPyramid.length == 0 ? new Int1LevelHistogram(new int[histogramLength], bitLevelsOfPyramid, true) : new IntHistogram(new int[histogramLength], bitLevelsOfPyramid, true);
    }

    public static Histogram newIntHistogram(int[] histogram, int ... bitLevelsOfPyramid) {
        Objects.requireNonNull(histogram, "Null histogram argument");
        Objects.requireNonNull(bitLevelsOfPyramid, "Null bitLevelsOfPyramid argument");
        return bitLevelsOfPyramid.length == 0 ? new Int1LevelHistogram((int[])histogram.clone(), bitLevelsOfPyramid, false) : new IntHistogram((int[])histogram.clone(), bitLevelsOfPyramid, false);
    }

    public final int length() {
        return this.length;
    }

    public abstract long total();

    public abstract long bar(int var1);

    public abstract long[] bars();

    public abstract void include(int var1);

    public abstract void exclude(int var1);

    public abstract void include(int ... var1);

    public abstract void exclude(int ... var1);

    public abstract long currentIRank();

    public final double currentRank() {
        long r;
        long total = this.total();
        if (total == 0L) {
            return 0.0;
        }
        boolean shifted = this.currentValue < (double)this.currentIValue;
        int v = shifted ? this.currentIValue - 1 : this.currentIValue;
        long b = this.bar(v);
        long l = r = shifted ? this.currentIRank() - b : this.currentIRank();
        if (b == 0L) {
            return r;
        }
        double delta = this.currentValue - (double)v;
        return (double)r + delta * (double)b;
    }

    public final double currentPreciseRank() {
        double v1;
        long total;
        if (!Double.isNaN(this.currentPreciseRank)) {
            return this.currentPreciseRank;
        }
        long r = this.currentIRank();
        if (r == (total = this.total())) {
            this.currentPreciseRank = r;
            return this.currentPreciseRank;
        }
        long b = this.bar(this.currentIValue);
        if (r + b == 0L) {
            this.currentPreciseRank = 0.0;
            return 0.0;
        }
        double delta = this.currentValue - (double)this.currentIValue;
        if (b > 0L && delta == 0.0) {
            this.currentPreciseRank = r;
            return this.currentPreciseRank;
        }
        int savedIValue = this.currentIValue;
        double savedValue = this.currentValue;
        if (b > 1L) {
            double indexInBar = delta * (double)b;
            if (indexInBar <= (double)(b - 1L)) {
                this.currentPreciseRank = (double)r + indexInBar;
                return this.currentPreciseRank;
            }
            if (r + b == total) {
                this.currentPreciseRank = (double)r + indexInBar;
                return this.currentPreciseRank;
            }
            v1 = (double)this.currentIValue + (double)(b - 1L) / (double)b;
            this.saveRanks();
        } else {
            if (r + b == total) {
                assert (b == 1L);
                this.currentPreciseRank = (double)r + delta;
                return this.currentPreciseRank;
            }
            this.saveRanks();
            if (b == 1L) {
                v1 = this.currentIValue;
            } else {
                assert (r > 0L);
                assert (b == 0L);
                this.moveToIRank(r - 1L);
                v1 = this.currentValue;
            }
        }
        this.moveToIRank(r + b);
        assert (this.currentValue == (double)this.currentIValue) : "bug: we are not at the left boundary of the bar #" + this.currentIValue + ", we at " + this.currentValue;
        double v2 = this.currentValue;
        this.restoreRanks();
        this.currentIValue = savedIValue;
        this.currentValue = savedValue;
        assert (v1 < v2) : "bug: illegal " + v1 + ".." + v2 + " range";
        assert (v1 <= this.currentValue && this.currentValue <= v2) : "bug: currentValue = " + this.currentValue + " is not in " + v1 + ".." + v2 + " range";
        this.currentPreciseRank = (double)(r + b - 1L) + (this.currentValue - v1) / (v2 - v1);
        return this.currentPreciseRank;
    }

    public final int currentIValue() {
        return this.currentIValue;
    }

    public final double currentValue() {
        return this.currentValue;
    }

    public final boolean outsideNonZeroPart() {
        long r = this.currentIRank();
        return r == this.total() || r == 0L && this.bar(this.currentIValue) == 0L;
    }

    public final boolean leftFromNonZeroPart() {
        return this.currentIRank() == 0L && this.bar(this.currentIValue) == 0L;
    }

    public final boolean leftFromOrAtBoundOfNonZeroPart() {
        return this.currentIRank() == 0L;
    }

    public final boolean rightFromNonZeroPart() {
        return this.currentIRank() == this.total();
    }

    public final boolean rightFromOrAtBoundOfNonZeroPart() {
        return this.currentIRank() + this.bar(this.currentIValue) == this.total();
    }

    public abstract Histogram moveToIRank(long var1);

    public abstract Histogram moveToRank(double var1);

    public Histogram moveToPreciseRank(double rank) {
        long total = this.total();
        long r = (long)rank;
        if ((double)r == rank || total == 0L || r < 0L || r >= total) {
            this.moveToIRank(r);
        } else {
            if (Double.isNaN(rank)) {
                throw new IllegalArgumentException("Illegal rank argument (NaN)");
            }
            this.moveToIRank(r);
            int leftIValue = this.currentIValue;
            long leftIRank = this.currentIRank();
            long indexInBar = r - leftIRank;
            long leftBar = this.bar(this.currentIValue);
            assert (indexInBar >= 0L && indexInBar <= leftBar);
            if (indexInBar < leftBar - 1L || r == total - 1L) {
                this.currentValue = (double)this.currentIValue + (rank - (double)leftIRank) / (double)leftBar;
            } else {
                double weightedMeanStripe;
                double leftValue = this.currentValue;
                this.saveRanks();
                this.moveToIRank(r + 1L);
                int rightIValue = this.currentIValue;
                long rightBar = this.bar(this.currentIValue);
                double rightValue = this.currentValue;
                assert (rightValue == (double)rightIValue);
                double newValue = leftValue + (rank - (double)r) * (rightValue - leftValue);
                assert (leftIValue < rightIValue);
                double leftStripe = leftBar == 1L ? 1.0 : 1.0 / (double)leftBar;
                double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (rank - (double)r) * (1.0 / (double)rightBar - leftStripe);
                assert (weightedMeanStripe >= -0.001);
                double rangeCenter = newValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
                int newIValue = (int)rangeCenter;
                assert (newIValue >= leftIValue && newIValue <= rightIValue) : "bug: " + newIValue + " is not in [" + leftIValue + ".." + rightIValue + "] range";
                if (newIValue == leftIValue) {
                    this.restoreRanks();
                    this.currentIValue = leftIValue;
                } else if (newIValue < rightIValue) {
                    assert (this.bar(newIValue) == 0L) : "bug: non-empty bar at corrected currentIValue";
                    this.moveToIValue(newIValue);
                } else assert (this.currentIValue == rightIValue);
                this.currentValue = newValue;
                assert (this.currentValue >= (double)this.currentIValue - 0.5001);
                assert (this.currentValue < (double)this.currentIValue + 1.0);
            }
            this.currentPreciseRank = rank;
        }
        return this;
    }

    public abstract Histogram moveToIValue(int var1);

    public Histogram moveToValue(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Illegal value argument (NaN)");
        }
        int v = (int)value;
        if (v < 0) {
            v = 0;
            value = 0;
        } else if (v > this.length) {
            v = this.length;
            value = v;
        }
        this.moveToIValue(v);
        this.currentValue = value;
        return this;
    }

    public abstract long shareCount();

    public abstract Histogram nextSharing();

    public abstract Histogram share();

    abstract void saveRanks();

    abstract void restoreRanks();

    abstract void checkIntegrity();

    public static int iValue(long[] histogram, long rank) {
        if (rank < 0L) {
            rank = 0L;
        }
        long acc = 0L;
        int lastNonZero = -1;
        for (int k = 0; k < histogram.length; ++k) {
            long b = histogram[k];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + k + "]=" + b);
            }
            if (b <= 0L) continue;
            lastNonZero = k;
            if (rank >= (acc += b)) continue;
            return k;
        }
        return lastNonZero + 1;
    }

    public static int iValue(int[] histogram, long rank) {
        if (rank < 0L) {
            rank = 0L;
        }
        int acc = 0;
        int lastNonZero = -1;
        for (int k = 0; k < histogram.length; ++k) {
            int b = histogram[k];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + k + "]=" + b);
            }
            if (b <= 0) continue;
            lastNonZero = k;
            if (rank >= (long)(acc += b)) continue;
            return k;
        }
        return lastNonZero + 1;
    }

    public static double value(long[] histogram, double rank) {
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank argument (NaN)");
        }
        if (rank < 0.0) {
            rank = 0.0;
        }
        long r = (long)rank;
        long acc = 0L;
        int lastNonZero = -1;
        for (int k = 0; k < histogram.length; ++k) {
            long b = histogram[k];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + k + "]=" + b);
            }
            if (b <= 0L) continue;
            lastNonZero = k;
            if (r < acc + b) {
                return (double)k + (b == 1L ? rank - (double)acc : (rank - (double)acc) / (double)b);
            }
            acc += b;
        }
        return lastNonZero + 1;
    }

    public static double value(int[] histogram, double rank) {
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank argument (NaN)");
        }
        if (rank < 0.0) {
            rank = 0.0;
        }
        int r = (int)rank;
        int acc = 0;
        int lastNonZero = -1;
        for (int k = 0; k < histogram.length; ++k) {
            int b = histogram[k];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + k + "]=" + b);
            }
            if (b <= 0) continue;
            lastNonZero = k;
            if (r < acc + b) {
                return (double)k + (b == 1 ? rank - (double)acc : (rank - (double)acc) / (double)b);
            }
            acc += b;
        }
        return lastNonZero + 1;
    }

    public static int iPreciseValue(long[] histogram, double rank) {
        double weightedMeanStripe;
        int rightV;
        int leftV;
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank argument (NaN)");
        }
        if (rank < 0.0) {
            rank = 0.0;
        }
        long r = (long)rank;
        assert (r >= 0L);
        long leftBar = 0L;
        long acc = 0L;
        int lastNonZero = -1;
        for (leftV = 0; leftV < histogram.length; ++leftV) {
            leftBar = histogram[leftV];
            if (leftBar < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + leftBar);
            }
            if (leftBar <= 0L) continue;
            lastNonZero = leftV;
            if (r < (acc += leftBar)) break;
        }
        if (leftV >= histogram.length) {
            return lastNonZero + 1;
        }
        assert (leftV == lastNonZero);
        assert (leftBar > 0L);
        assert (r < acc);
        long leftR = acc - leftBar;
        assert (leftR <= r);
        long indexInBar = r - leftR;
        assert (indexInBar < leftBar);
        if (rank == (double)r) {
            return leftV;
        }
        if (indexInBar < leftBar - 1L) {
            return leftV;
        }
        assert (r + 1L == acc);
        double leftValue = leftBar == 1L ? (double)leftV : (double)leftV + (double)indexInBar / (double)leftBar;
        long rightBar = 0L;
        for (rightV = leftV + 1; rightV < histogram.length; ++rightV) {
            rightBar = histogram[rightV];
            if (rightBar < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + rightV + "]=" + rightBar);
            }
            if (rightBar > 0L) break;
        }
        if (rightV >= histogram.length) {
            return leftV;
        }
        double newValue = leftValue + (rank - (double)r) * ((double)rightV - leftValue);
        double leftStripe = leftBar == 1L ? 1.0 : 1.0 / (double)leftBar;
        double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (rank - (double)r) * (1.0 / (double)rightBar - leftStripe);
        assert (weightedMeanStripe >= -0.001);
        double rangeCenter = newValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
        int result = (int)rangeCenter;
        assert (result >= leftV && result <= rightV) : "bug: " + result + " is not in [" + leftV + ".." + rightV + "] range";
        return result;
    }

    public static int iPreciseValue(int[] histogram, double rank) {
        double weightedMeanStripe;
        int rightV;
        int leftV;
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank argument (NaN)");
        }
        if (rank < 0.0) {
            rank = 0.0;
        }
        int r = (int)rank;
        assert (r >= 0);
        int leftBar = 0;
        int acc = 0;
        int lastNonZero = -1;
        for (leftV = 0; leftV < histogram.length; ++leftV) {
            leftBar = histogram[leftV];
            if (leftBar < 0) {
                throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + leftBar);
            }
            if (leftBar <= 0) continue;
            lastNonZero = leftV;
            if (r < (acc += leftBar)) break;
        }
        if (leftV >= histogram.length) {
            return lastNonZero + 1;
        }
        assert (leftV == lastNonZero);
        assert (leftBar > 0);
        assert (r < acc);
        int leftR = acc - leftBar;
        assert (leftR <= r);
        int indexInBar = r - leftR;
        assert (indexInBar < leftBar);
        if (rank == (double)r) {
            return leftV;
        }
        if (indexInBar < leftBar - 1) {
            return leftV;
        }
        assert (r + 1 == acc);
        double leftValue = leftBar == 1 ? (double)leftV : (double)leftV + (double)indexInBar / (double)leftBar;
        int rightBar = 0;
        for (rightV = leftV + 1; rightV < histogram.length; ++rightV) {
            rightBar = histogram[rightV];
            if (rightBar < 0) {
                throw new IllegalArgumentException("Negative histogram[" + rightV + "]=" + rightBar);
            }
            if (rightBar > 0) break;
        }
        if (rightV >= histogram.length) {
            return leftV;
        }
        double newValue = leftValue + (rank - (double)r) * ((double)rightV - leftValue);
        double leftStripe = leftBar == 1 ? 1.0 : 1.0 / (double)leftBar;
        double d = weightedMeanStripe = leftBar == rightBar ? leftStripe : leftStripe + (rank - (double)r) * (1.0 / (double)rightBar - leftStripe);
        assert (weightedMeanStripe >= -0.001);
        double rangeCenter = newValue + 0.5 * Math.max(weightedMeanStripe, 1.0E-10);
        int result = (int)rangeCenter;
        assert (result >= leftV && result <= rightV) : "bug: " + result + " is not in [" + leftV + ".." + rightV + "] range";
        return result;
    }

    public static double preciseValue(long[] histogram, double rank) {
        int leftV;
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank argument (NaN)");
        }
        if (rank < 0.0) {
            rank = 0.0;
        }
        long r = (long)rank;
        assert (r >= 0L);
        long leftBar = 0L;
        long acc = 0L;
        int lastNonZero = -1;
        for (leftV = 0; leftV < histogram.length; ++leftV) {
            leftBar = histogram[leftV];
            if (leftBar < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + leftBar);
            }
            if (leftBar <= 0L) continue;
            lastNonZero = leftV;
            if (r < (acc += leftBar)) break;
        }
        if (leftV >= histogram.length) {
            return lastNonZero + 1;
        }
        assert (leftV == lastNonZero);
        assert (leftBar > 0L);
        assert (r < acc);
        long leftR = acc - leftBar;
        assert (leftR <= r);
        long indexInBar = r - leftR;
        assert (indexInBar < leftBar);
        if (rank == (double)r) {
            return leftBar == 1L ? (double)leftV : (double)leftV + (double)indexInBar / (double)leftBar;
        }
        if (indexInBar < leftBar - 1L) {
            return (double)leftV + (rank - (double)leftR) / (double)leftBar;
        }
        assert (r + 1L == acc);
        int rightV = Histogram.nextNonZero(histogram, leftV + 1);
        if (rightV == -1) {
            return (double)leftV + (rank - (double)leftR) / (double)leftBar;
        }
        double leftValue = leftBar == 1L ? (double)leftV : (double)leftV + (double)indexInBar / (double)leftBar;
        return leftValue + (rank - (double)r) * ((double)rightV - leftValue);
    }

    public static double preciseValue(int[] histogram, double rank) {
        int leftV;
        if (Double.isNaN(rank)) {
            throw new IllegalArgumentException("Illegal rank argument (NaN)");
        }
        if (rank < 0.0) {
            rank = 0.0;
        }
        int r = (int)rank;
        assert (r >= 0);
        int leftBar = 0;
        int acc = 0;
        int lastNonZero = -1;
        for (leftV = 0; leftV < histogram.length; ++leftV) {
            leftBar = histogram[leftV];
            if (leftBar < 0) {
                throw new IllegalArgumentException("Negative histogram[" + leftV + "]=" + leftBar);
            }
            if (leftBar <= 0) continue;
            lastNonZero = leftV;
            if (r < (acc += leftBar)) break;
        }
        if (leftV >= histogram.length) {
            return lastNonZero + 1;
        }
        assert (leftV == lastNonZero);
        assert (leftBar > 0);
        assert (r < acc);
        int leftR = acc - leftBar;
        assert (leftR <= r);
        int indexInBar = r - leftR;
        assert (indexInBar < leftBar);
        if (rank == (double)r) {
            return leftBar == 1 ? (double)leftV : (double)leftV + (double)indexInBar / (double)leftBar;
        }
        if (indexInBar < leftBar - 1) {
            return (double)leftV + (rank - (double)leftR) / (double)leftBar;
        }
        assert (r + 1 == acc);
        int rightV = Histogram.nextNonZero(histogram, leftV + 1);
        if (rightV == -1) {
            return (double)leftV + (rank - (double)leftR) / (double)leftBar;
        }
        double leftValue = leftBar == 1 ? (double)leftV : (double)leftV + (double)indexInBar / (double)leftBar;
        return leftValue + (rank - (double)r) * ((double)rightV - leftValue);
    }

    public static double percentile(long[] histogram, long sumOfColumns, double percentileLevel) {
        if (Double.isNaN(percentileLevel)) {
            throw new IllegalArgumentException("Illegal percentile argument (NaN)");
        }
        if (sumOfColumns < 0L) {
            throw new IllegalArgumentException("Negative sumOfColumns = " + sumOfColumns);
        }
        if (sumOfColumns == 0L) {
            return 0.0;
        }
        return Histogram.preciseValue(histogram, percentileLevel * (double)(sumOfColumns - 1L));
    }

    public static double percentile(int[] histogram, long sumOfColumns, double percentileLevel) {
        if (Double.isNaN(percentileLevel)) {
            throw new IllegalArgumentException("Illegal percentile argument (NaN)");
        }
        if (sumOfColumns < 0L) {
            throw new IllegalArgumentException("Negative sumOfColumns = " + sumOfColumns);
        }
        if (sumOfColumns == 0L) {
            return 0.0;
        }
        return Histogram.preciseValue(histogram, percentileLevel * (double)(sumOfColumns - 1L));
    }

    public static long sumOf(long[] histogram) {
        long result = 0L;
        for (long v : histogram) {
            result += v;
        }
        return result;
    }

    public static int sumOf(int[] histogram) {
        int result = 0;
        for (int v : histogram) {
            result += v;
        }
        return result;
    }

    public static void clear(int[] histogram, int sumOfColumns) {
        int acc = 0;
        for (int k = 0; k < histogram.length && acc < sumOfColumns; acc += histogram[k], ++k) {
            histogram[k] = 0;
        }
        if (acc != sumOfColumns) {
            throw new IllegalArgumentException("Illegal sumOfColumns in clearHistogram method: " + sumOfColumns + " instead of " + acc);
        }
    }

    static int previousNonZero(long[] histogram, int index) {
        while (index >= 0) {
            long b = histogram[index];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + index + "]=" + b);
            }
            if (b > 0L) {
                return index;
            }
            --index;
        }
        return -1;
    }

    static int nextNonZero(long[] histogram, int index) {
        while (index < histogram.length) {
            long b = histogram[index];
            if (b < 0L) {
                throw new IllegalArgumentException("Negative histogram[" + index + "]=" + b);
            }
            if (b > 0L) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    static int previousNonZero(int[] histogram, int index) {
        while (index >= 0) {
            int b = histogram[index];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + index + "]=" + b);
            }
            if (b > 0) {
                return index;
            }
            --index;
        }
        return -1;
    }

    static int nextNonZero(int[] histogram, int index) {
        while (index < histogram.length) {
            int b = histogram[index];
            if (b < 0) {
                throw new IllegalArgumentException("Negative histogram[" + index + "]=" + b);
            }
            if (b > 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    static long[] cloneBars(Object histogram0) {
        if (histogram0 instanceof long[]) {
            return (long[])((long[])histogram0).clone();
        }
        int[] bars = (int[])histogram0;
        long[] result = new long[bars.length];
        for (int k = 0; k < result.length; ++k) {
            result[k] = bars[k];
        }
        return result;
    }

    static class Long1LevelHistogram
    extends Histogram {
        private final long[][] histogram;
        private final long[] histogram0;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private long total;
        private long[] currentIRanks;
        private long[] alternativeIRanks;
        private Long1LevelHistogram nextSharing = this;
        private long shareCount = 1L;

        private Long1LevelHistogram(long[][] histogram, long total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new long[this.m];
            this.alternativeIRanks = new long[this.m];
        }

        Long1LevelHistogram(long[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(Long1LevelHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), histogramIsZeroFilled ? 0L : Long1LevelHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new long[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    long count = 0L;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return Long1LevelHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Long.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Long.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1L;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1L;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            Long1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1L;
            if (this.histogram0[n] < 0L) {
                long b = this.histogram0[value];
                this.histogram0[value] = 0L;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1L;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            Long1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Long.MAX_VALUE - (long)values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Long.MAX_VALUE");
            }
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1L;
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] + 1L;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                    }
                    Long1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1L;
                    if (this.histogram0[n2] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] - 1L;
                    if (this.histogram0[n3] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                    }
                    Long1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public Histogram moveToIRank(long rank) {
            if (this.total == 0L) {
                assert (this.currentIRanks[0] == 0L) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            assert (this.total > 0L);
            if (rank < 0L) {
                rank = 0L;
            } else if (rank > this.total) {
                rank = this.total;
            }
            if (rank == this.total) {
                this.moveToRightmostRank();
            } else if (rank < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                } while (rank < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (rank >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                double frac = (double)(rank - this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        @Override
        public Histogram moveToRank(double rank) {
            long b;
            long r;
            if (Double.isNaN(rank)) {
                throw new IllegalArgumentException("Illegal rank argument (NaN)");
            }
            if (this.total == 0L) {
                assert (this.currentIRanks[0] == 0L) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            this.currentPreciseRank = Double.NaN;
            assert (this.total > 0L);
            if (rank < 0.0) {
                r = 0L;
                rank = 0L;
            } else if (rank > (double)this.total) {
                r = this.total;
                rank = r;
            } else {
                r = (int)rank;
            }
            if (r == this.total) {
                this.moveToRightmostRank();
            } else if (r < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                } while (r < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (r >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                double frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public Histogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                }
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                for (int j = this.currentIValue; j < value; ++j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public Histogram nextSharing() {
            if (this.shareCount == 1L) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Histogram share() {
            long[] lArray = this.histogram0;
            synchronized (this.histogram0) {
                Long1LevelHistogram result = new Long1LevelHistogram(this.histogram, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                Long1LevelHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert ((long)count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                Long1LevelHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "long histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1L ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void restoreRanks() {
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0L || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                long s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = Long1LevelHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(Long1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + Long1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + Long1LevelHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + Long1LevelHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            assert (this.total > 0L);
            assert (this.currentIRanks[0] <= this.total);
            if (this.currentIRanks[0] < this.total) {
                assert (this.currentIRanks[0] < this.total);
                do {
                    long b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    ++this.currentIValue;
                } while (this.currentIRanks[0] < this.total);
                assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                assert (this.histogram0[this.currentIValue - 1] > 0L);
            } else if (this.histogram0[this.currentIValue - 1] == 0L) {
                assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0L);
                --this.currentIValue;
                assert (this.currentIValue > 0);
                assert (this.histogram0[this.currentIValue] == 0L);
                while (this.histogram0[this.currentIValue - 1] == 0L) {
                    --this.currentIValue;
                    assert (this.currentIValue > 0);
                }
            }
        }

        private static long[][] newMultilevelHistogram(long[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            long[][] result = new long[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static long sumOfAndCheck(long[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            long result = 0L;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0L) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0L) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Long.MAX_VALUE");
            }
            return result;
        }
    }

    static class LongHistogram
    extends Histogram {
        private final long[][] histogram;
        private final long[] histogram0;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private long total;
        private long[] currentIRanks;
        private long[] alternativeIRanks;
        private LongHistogram nextSharing = this;
        private long shareCount = 1L;

        private LongHistogram(long[][] histogram, long total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new long[this.m];
            this.alternativeIRanks = new long[this.m];
        }

        LongHistogram(long[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(LongHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), histogramIsZeroFilled ? 0L : LongHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new long[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    long count = 0L;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return LongHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Long.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Long.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1L;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                long[] lArray = this.histogram[k];
                int n2 = v;
                lArray[n2] = lArray[n2] + 1L;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n3 = k;
                this.currentIRanks[n3] = this.currentIRanks[n3] + 1L;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1L;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            LongHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n4 = k;
                    hist.currentIRanks[n4] = hist.currentIRanks[n4] + 1L;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1L;
            if (this.histogram0[n] < 0L) {
                long b = this.histogram0[value];
                this.histogram0[value] = 0L;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                long[] lArray = this.histogram[k];
                int n2 = v;
                lArray[n2] = lArray[n2] - 1L;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n3 = k;
                this.currentIRanks[n3] = this.currentIRanks[n3] - 1L;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1L;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            LongHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n4 = k;
                    hist.currentIRanks[n4] = hist.currentIRanks[n4] - 1L;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Long.MAX_VALUE - (long)values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Long.MAX_VALUE");
            }
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n3 = v;
                        lArray[n3] = lArray[n3] + 1L;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n4 = k;
                            this.currentIRanks[n4] = this.currentIRanks[n4] + 1L;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n5 = k;
                        this.nextSharing.currentIRanks[n5] = this.nextSharing.currentIRanks[n5] + 1L;
                    }
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n6 = value = nArray[i];
                    this.histogram0[n6] = this.histogram0[n6] + 1L;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n7 = v;
                        lArray[n7] = lArray[n7] + 1L;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n8 = k;
                        this.currentIRanks[n8] = this.currentIRanks[n8] + 1L;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1L;
                    }
                    LongHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n9 = k;
                            hist.currentIRanks[n9] = hist.currentIRanks[n9] + 1L;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1L;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2L) {
                long currentIRank1 = this.currentIRanks[0];
                long currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1L;
                    if (this.histogram0[n2] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n3 = v;
                        lArray[n3] = lArray[n3] - 1L;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n4 = k;
                            this.currentIRanks[n4] = this.currentIRanks[n4] - 1L;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n5 = k;
                        this.nextSharing.currentIRanks[n5] = this.nextSharing.currentIRanks[n5] - 1L;
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= (long)values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n6 = value = nArray[i];
                    this.histogram0[n6] = this.histogram0[n6] - 1L;
                    if (this.histogram0[n6] < 0L) {
                        long b = this.histogram0[value];
                        this.histogram0[value] = 0L;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        long[] lArray = this.histogram[k];
                        int n7 = v;
                        lArray[n7] = lArray[n7] - 1L;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n8 = k;
                        this.currentIRanks[n8] = this.currentIRanks[n8] - 1L;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1L;
                    }
                    LongHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n9 = k;
                            hist.currentIRanks[n9] = hist.currentIRanks[n9] - 1L;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1L;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= (long)values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToIRank(long rank) {
            block33: {
                block34: {
                    block35: {
                        block32: {
                            if (this.total == 0L) {
                                if (!LongHistogram.$assertionsDisabled && this.currentIRanks[0] != 0L) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            if (!LongHistogram.$assertionsDisabled && this.total <= 0L) {
                                throw new AssertionError();
                            }
                            if (rank < 0L) {
                                rank = 0L;
                            } else if (rank > this.total) {
                                rank = this.total;
                            }
                            if (rank != this.total) break block32;
                            this.moveToRightmostRank();
                            break block33;
                        }
                        if (rank >= this.currentIRanks[0]) break block34;
                        if (this.m <= 1) break block35;
                        k = 0;
                        while (k + 1 < this.m && rank < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!LongHistogram.$assertionsDisabled && rank >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                            } while (rank < this.currentIRanks[k]);
                            if (!LongHistogram.$assertionsDisabled && this.currentIRanks[k] < 0L) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            do {
                                level = this.bitLevels[--k];
                                if (!LongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                            } while (k > 0 && rank >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!LongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (rank >= this.currentIRanks[0]) break block33;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                    } while (rank < this.currentIRanks[0]);
                    if (!LongHistogram.$assertionsDisabled && this.currentIRanks[0] < 0L) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block33;
                }
                if (this.m > 1) {
                    if (rank >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && rank >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (rank >= this.currentIRanks[k] + b) {
                                v1 = k;
                                this.currentIRanks[v1] = this.currentIRanks[v1] + b;
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!LongHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!LongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                            } while (k > 0 && rank < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!LongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (rank >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!LongHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                frac = (double)(rank - this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToRank(double rank) {
            block35: {
                block36: {
                    block37: {
                        block34: {
                            if (Double.isNaN(rank)) {
                                throw new IllegalArgumentException("Illegal rank argument (NaN)");
                            }
                            if (this.total == 0L) {
                                if (!LongHistogram.$assertionsDisabled && this.currentIRanks[0] != 0L) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            this.currentPreciseRank = NaN;
                            if (!LongHistogram.$assertionsDisabled && this.total <= 0L) {
                                throw new AssertionError();
                            }
                            if (rank < 0.0) {
                                r = 0L;
                                rank = 0L;
                            } else if (rank > (double)this.total) {
                                r = this.total;
                                rank = r;
                            } else {
                                r = (int)rank;
                            }
                            if (r != this.total) break block34;
                            this.moveToRightmostRank();
                            break block35;
                        }
                        if (r >= this.currentIRanks[0]) break block36;
                        if (this.m <= 1) break block37;
                        k = 0;
                        while (k + 1 < this.m && r < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!LongHistogram.$assertionsDisabled && r >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                            } while (r < this.currentIRanks[k]);
                            if (!LongHistogram.$assertionsDisabled && this.currentIRanks[k] < 0L) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            do {
                                level = this.bitLevels[--k];
                                if (!LongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                            } while (k > 0 && r >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!LongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (r >= this.currentIRanks[0]) break block35;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                    } while (r < this.currentIRanks[0]);
                    if (!LongHistogram.$assertionsDisabled && this.currentIRanks[0] < 0L) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block35;
                }
                if (this.m > 1) {
                    if (r >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && r >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (r >= this.currentIRanks[k] + b) {
                                v1 = k;
                                this.currentIRanks[v1] = this.currentIRanks[v1] + b;
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!LongHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!LongHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                            } while (k > 0 && r < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!LongHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (r >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!LongHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public Histogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] < this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        long b;
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v < this.currentIValue);
                        do {
                            --this.currentIValue;
                            b = this.histogram[k][this.currentIValue];
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - b;
                        } while (v < this.currentIValue);
                        assert (this.currentIRanks[k] >= 0L) : "currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for value=" + value;
                        assert (this.currentIValue == v);
                        int previousValue = this.currentIValue + 1 << level;
                        assert (value < previousValue);
                        long previousRank = this.currentIRanks[k] + b;
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIValue = (previousValue >> level) - 1;
                            b = this.histogram[k][this.currentIValue];
                            this.currentIRanks[k] = previousRank - b;
                        } while (k > 0 && value >> level == this.currentIValue);
                        this.currentIValue <<= level;
                    }
                    assert (k == 0);
                    if (value == this.currentIValue) {
                        return this;
                    }
                    assert (value < this.currentIValue);
                }
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                }
                assert (this.currentIRanks[0] >= 0L) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] > this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v > this.currentIValue);
                        do {
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][this.currentIValue];
                            ++this.currentIValue;
                        } while (v > this.currentIValue);
                        assert (this.currentIRanks[k] <= this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + "> total=" + this.total + " for value=" + value;
                        assert (this.currentIValue == v);
                        this.currentIValue <<= level;
                        assert (this.currentIValue <= value);
                        long lastRank = this.currentIRanks[k];
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIRanks[k] = lastRank;
                        } while (k > 0 && value >> level == this.currentIValue >> level);
                    }
                    assert (k == 0);
                }
                for (int j = this.currentIValue; j < value; ++j) {
                    long b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public Histogram nextSharing() {
            if (this.shareCount == 1L) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Histogram share() {
            long[] lArray = this.histogram0;
            synchronized (this.histogram0) {
                LongHistogram result = new LongHistogram(this.histogram, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                LongHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert ((long)count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                LongHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "long histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1L ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void restoreRanks() {
            long[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0L || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                long s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = LongHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(LongHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + LongHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + LongHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + LongHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            block34: {
                block33: {
                    int v;
                    assert (this.total > 0L);
                    assert (this.currentIRanks[0] <= this.total);
                    if (this.currentIRanks[0] >= this.total) break block33;
                    if (this.m > 1) {
                        int k = 0;
                        while (k + 1 < this.m && this.total > this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            long b = this.histogram[k][this.currentIValue];
                            while (this.total > this.currentIRanks[k] + b) {
                                int n = k;
                                this.currentIRanks[n] = this.currentIRanks[n] + b;
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            assert (this.currentIRanks[k] < this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total;
                            this.currentIValue <<= level;
                            long lastRank = this.currentIRanks[k];
                            do {
                                level = this.bitLevels[--k];
                                assert (k > 0 || level == 0);
                                this.currentIRanks[k] = lastRank;
                            } while (k > 0 && this.total <= this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        assert (k == 0);
                    }
                    assert (this.currentIRanks[0] < this.total);
                    do {
                        long b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        ++this.currentIValue;
                    } while (this.currentIRanks[0] < this.total);
                    assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                    assert (this.histogram0[this.currentIValue - 1] > 0L);
                    if (this.m <= 1) break block34;
                    for (int k = 1; k < this.m && (v = this.currentIValue - 1 >> this.bitLevels[k]) < this.currentIValue >> this.bitLevels[k]; ++k) {
                        int n = k;
                        this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][v];
                    }
                    break block34;
                }
                if (this.histogram0[this.currentIValue - 1] == 0L) {
                    int k;
                    assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0L);
                    --this.currentIValue;
                    int previousValue = this.currentIValue + 1;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]] == 0L) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0L);
                            while (this.histogram[k][this.currentIValue - 1] == 0L) {
                                --this.currentIValue;
                                assert (this.currentIValue > 0);
                            }
                            int v = this.currentIValue - 1;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0L);
                            assert (this.histogram[k][v] > 0L);
                            this.currentIValue <<= level;
                            --k;
                        }
                    }
                    assert (this.currentIValue > 0);
                    assert (this.histogram0[this.currentIValue] == 0L);
                    while (this.histogram0[this.currentIValue - 1] == 0L) {
                        --this.currentIValue;
                        assert (this.currentIValue > 0);
                    }
                    if (this.m > 1) {
                        int v;
                        for (k = 1; k < this.m && (v = this.currentIValue >> this.bitLevels[k]) < previousValue >> this.bitLevels[k]; ++k) {
                            long b = this.histogram[k][v];
                            if (b <= 0L) continue;
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - this.histogram[k][v];
                        }
                    }
                }
            }
        }

        private static long[][] newMultilevelHistogram(long[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            long[][] result = new long[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static long sumOfAndCheck(long[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            long result = 0L;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0L) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0L) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Long.MAX_VALUE");
            }
            return result;
        }
    }

    static class Int1LevelHistogram
    extends Histogram {
        private final int[][] histogram;
        private final int[] histogram0;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private int total;
        private int[] currentIRanks;
        private int[] alternativeIRanks;
        private Int1LevelHistogram nextSharing = this;
        private int shareCount = 1;

        private Int1LevelHistogram(int[][] histogram, int total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new int[this.m];
            this.alternativeIRanks = new int[this.m];
        }

        Int1LevelHistogram(int[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(Int1LevelHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), histogramIsZeroFilled ? 0 : Int1LevelHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new int[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    int count = 0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : (long)this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return Int1LevelHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Integer.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Integer.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1;
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            Int1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1;
            if (this.histogram0[n] < 0) {
                int b = this.histogram0[value];
                this.histogram0[value] = 0;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            Int1LevelHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Integer.MAX_VALUE - values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Integer.MAX_VALUE");
            }
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1;
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] + 1;
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1;
                    }
                    Int1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1;
                    if (this.histogram0[n2] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n3 = value = nArray[i];
                    this.histogram0[n3] = this.histogram0[n3] - 1;
                    if (this.histogram0[n3] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1;
                    }
                    Int1LevelHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        @Override
        public Histogram moveToIRank(long rank) {
            if (this.total == 0) {
                assert (this.currentIRanks[0] == 0) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            assert (this.total > 0);
            if (rank < 0L) {
                rank = 0L;
            } else if (rank > (long)this.total) {
                rank = this.total;
            }
            if (rank == (long)this.total) {
                this.moveToRightmostRank();
            } else if (rank < (long)this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                } while (rank < (long)this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (rank >= (long)(this.currentIRanks[0] + b)) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (long)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                double frac = (double)(rank - (long)this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        @Override
        public Histogram moveToRank(double rank) {
            int b;
            int r;
            if (Double.isNaN(rank)) {
                throw new IllegalArgumentException("Illegal rank argument (NaN)");
            }
            if (this.total == 0) {
                assert (this.currentIRanks[0] == 0) : "non-zero current rank when total==0";
                this.currentPreciseRank = 0.0;
                this.currentValue = this.currentIValue;
                return this;
            }
            this.currentPreciseRank = Double.NaN;
            assert (this.total > 0);
            if (rank < 0.0) {
                r = 0;
                rank = 0;
            } else if (rank > (double)this.total) {
                r = this.total;
                rank = r;
            } else {
                r = (int)rank;
            }
            if (r == this.total) {
                this.moveToRightmostRank();
            } else if (r < this.currentIRanks[0]) {
                do {
                    --this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                } while (r < this.currentIRanks[0]);
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank;
            } else {
                b = this.histogram0[this.currentIValue];
                while (r >= this.currentIRanks[0] + b) {
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    ++this.currentIValue;
                    b = this.histogram0[this.currentIValue];
                }
                assert (this.currentIRanks[0] < this.total) : "currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank;
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                double frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public Histogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                }
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                for (int j = this.currentIValue; j < value; ++j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public Histogram nextSharing() {
            if (this.shareCount == 1) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Histogram share() {
            int[] nArray = this.histogram0;
            synchronized (this.histogram0) {
                Int1LevelHistogram result = new Int1LevelHistogram(this.histogram, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                Int1LevelHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert (count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                Int1LevelHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "int histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1 ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void restoreRanks() {
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0 || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                int s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = Int1LevelHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(Int1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + Int1LevelHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + Int1LevelHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + Int1LevelHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            assert (this.total > 0);
            assert (this.currentIRanks[0] <= this.total);
            if (this.currentIRanks[0] < this.total) {
                assert (this.currentIRanks[0] < this.total);
                do {
                    int b = this.histogram0[this.currentIValue];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                    ++this.currentIValue;
                } while (this.currentIRanks[0] < this.total);
                assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                assert (this.histogram0[this.currentIValue - 1] > 0);
            } else if (this.histogram0[this.currentIValue - 1] == 0) {
                assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0);
                --this.currentIValue;
                assert (this.currentIValue > 0);
                assert (this.histogram0[this.currentIValue] == 0);
                while (this.histogram0[this.currentIValue - 1] == 0) {
                    --this.currentIValue;
                    assert (this.currentIValue > 0);
                }
            }
        }

        private static int[][] newMultilevelHistogram(int[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            int[][] result = new int[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static int sumOfAndCheck(int[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            int result = 0;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Integer.MAX_VALUE");
            }
            return result;
        }
    }

    static class IntHistogram
    extends Histogram {
        private final int[][] histogram;
        private final int[] histogram0;
        private final int[] bitLevels;
        private final int[] highBitMasks;
        private final int m;
        private int total;
        private int[] currentIRanks;
        private int[] alternativeIRanks;
        private IntHistogram nextSharing = this;
        private int shareCount = 1;

        private IntHistogram(int[][] histogram, int total, int[] bitLevels) {
            super(histogram[0].length);
            int k;
            assert (bitLevels != null);
            this.m = bitLevels.length + 1;
            assert (histogram.length == this.m);
            this.histogram = histogram;
            this.histogram0 = histogram[0];
            this.total = total;
            this.bitLevels = new int[this.m];
            System.arraycopy(bitLevels, 0, this.bitLevels, 1, bitLevels.length);
            for (k = 1; k < this.m; ++k) {
                if (this.bitLevels[k] <= 0) {
                    throw new IllegalArgumentException("Negative or zero bitLevels[" + (k - 1) + "]=" + this.bitLevels[k]);
                }
                if (this.bitLevels[k] > 31) {
                    throw new IllegalArgumentException("Too high bitLevels[" + (k - 1) + "]=" + this.bitLevels[k] + " (only 1..31 values are allowed)");
                }
                if (this.bitLevels[k] > this.bitLevels[k - 1]) continue;
                throw new IllegalArgumentException("bitLevels[" + (k - 1) + "] must be greater than bitLevels[" + (k - 2) + "]");
            }
            this.highBitMasks = new int[this.m];
            for (k = 0; k < this.m; ++k) {
                this.highBitMasks[k] = ~((1 << this.bitLevels[k]) - 1);
            }
            this.currentIRanks = new int[this.m];
            this.alternativeIRanks = new int[this.m];
        }

        IntHistogram(int[] histogram, int[] bitLevels, boolean histogramIsZeroFilled) {
            this(IntHistogram.newMultilevelHistogram(histogram, bitLevels.length + 1), histogramIsZeroFilled ? 0 : IntHistogram.sumOfAndCheck(histogram, 0, Integer.MAX_VALUE), bitLevels);
            for (int k = 1; k < this.bitLevels.length; ++k) {
                int levelLen = 1 << this.bitLevels[k];
                int levelCount = histogram.length >> this.bitLevels[k];
                if (levelCount << this.bitLevels[k] != histogram.length) {
                    ++levelCount;
                }
                this.histogram[k] = new int[levelCount];
                if (histogramIsZeroFilled) continue;
                int value = 0;
                for (int i = 0; i < levelCount; ++i) {
                    int count = 0;
                    int max = value + Math.min(levelLen, this.length - value);
                    while (value < max) {
                        count += histogram[value];
                        ++value;
                    }
                    this.histogram[k][i] = count;
                }
            }
        }

        @Override
        public long total() {
            return this.total;
        }

        @Override
        public long bar(int value) {
            return value < 0 ? 0L : (value >= this.length ? 0L : (long)this.histogram0[value]);
        }

        @Override
        public long[] bars() {
            return IntHistogram.cloneBars(this.histogram0);
        }

        @Override
        public void include(int value) {
            if (this.total == Integer.MAX_VALUE) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new value " + value + ", because the current total number of values is Integer.MAX_VALUE");
            }
            int n = value;
            this.histogram0[n] = this.histogram0[n] + 1;
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                int[] nArray = this.histogram[k];
                int n2 = v;
                nArray[n2] = nArray[n2] + 1;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n3 = k;
                this.currentIRanks[n3] = this.currentIRanks[n3] + 1;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] + 1;
            }
            ++this.total;
            this.currentPreciseRank = Double.NaN;
            IntHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n4 = k;
                    hist.currentIRanks[n4] = hist.currentIRanks[n4] + 1;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                }
                ++hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void exclude(int value) {
            int n = value;
            this.histogram0[n] = this.histogram0[n] - 1;
            if (this.histogram0[n] < 0) {
                int b = this.histogram0[value];
                this.histogram0[value] = 0;
                throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
            }
            for (int k = this.m - 1; k > 0; --k) {
                int v = value >> this.bitLevels[k];
                int[] nArray = this.histogram[k];
                int n2 = v;
                nArray[n2] = nArray[n2] - 1;
                if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                int n3 = k;
                this.currentIRanks[n3] = this.currentIRanks[n3] - 1;
            }
            if (value < this.currentIValue) {
                this.currentIRanks[0] = this.currentIRanks[0] - 1;
            }
            --this.total;
            this.currentPreciseRank = Double.NaN;
            IntHistogram hist = this.nextSharing;
            while (hist != this) {
                assert (hist.m == this.m);
                assert (hist.histogram == this.histogram);
                for (int k = this.m - 1; k > 0; --k) {
                    if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                    int n4 = k;
                    hist.currentIRanks[n4] = hist.currentIRanks[n4] - 1;
                }
                if (value < hist.currentIValue) {
                    hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                }
                --hist.total;
                assert (hist.total == this.total);
                hist.currentPreciseRank = Double.NaN;
                hist = hist.nextSharing;
            }
        }

        @Override
        public void include(int ... values) {
            if (this.total > Integer.MAX_VALUE - values.length) {
                throw new IllegalStateException("Overflow of the histogram: cannot include new " + values.length + "values, because the total number of values will exceed Integer.MAX_VALUE");
            }
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] + 1;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray2 = this.histogram[k];
                        int n3 = v;
                        nArray2[n3] = nArray2[n3] + 1;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n4 = k;
                            this.currentIRanks[n4] = this.currentIRanks[n4] + 1;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n5 = k;
                        this.nextSharing.currentIRanks[n5] = this.nextSharing.currentIRanks[n5] + 1;
                    }
                    if (value < this.currentIValue) {
                        ++currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    ++currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total += values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n6 = value = nArray[i];
                    this.histogram0[n6] = this.histogram0[n6] + 1;
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray3 = this.histogram[k];
                        int n7 = v;
                        nArray3[n7] = nArray3[n7] + 1;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n8 = k;
                        this.currentIRanks[n8] = this.currentIRanks[n8] + 1;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] + 1;
                    }
                    IntHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n9 = k;
                            hist.currentIRanks[n9] = hist.currentIRanks[n9] + 1;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] + 1;
                        }
                        ++hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total += values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public void exclude(int ... values) {
            if (this.shareCount == 2) {
                int currentIRank1 = this.currentIRanks[0];
                int currentIRank2 = this.nextSharing.currentIRanks[0];
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n2 = value = nArray[i];
                    this.histogram0[n2] = this.histogram0[n2] - 1;
                    if (this.histogram0[n2] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray2 = this.histogram[k];
                        int n3 = v;
                        nArray2[n3] = nArray2[n3] - 1;
                        if (value < (this.currentIValue & this.highBitMasks[k])) {
                            int n4 = k;
                            this.currentIRanks[n4] = this.currentIRanks[n4] - 1;
                        }
                        if (value >= (this.nextSharing.currentIValue & this.nextSharing.highBitMasks[k])) continue;
                        int n5 = k;
                        this.nextSharing.currentIRanks[n5] = this.nextSharing.currentIRanks[n5] - 1;
                    }
                    if (value < this.currentIValue) {
                        --currentIRank1;
                    }
                    if (value >= this.nextSharing.currentIValue) continue;
                    --currentIRank2;
                }
                this.currentIRanks[0] = currentIRank1;
                this.nextSharing.currentIRanks[0] = currentIRank2;
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
                this.nextSharing.total -= values.length;
                this.nextSharing.currentPreciseRank = Double.NaN;
            } else {
                int[] nArray = values;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int value;
                    int n6 = value = nArray[i];
                    this.histogram0[n6] = this.histogram0[n6] - 1;
                    if (this.histogram0[n6] < 0) {
                        int b = this.histogram0[value];
                        this.histogram0[value] = 0;
                        throw new IllegalStateException("Disbalance in the histogram: negative number " + b + " of occurrences of " + value + " value");
                    }
                    for (int k = this.m - 1; k > 0; --k) {
                        int v = value >> this.bitLevels[k];
                        int[] nArray3 = this.histogram[k];
                        int n7 = v;
                        nArray3[n7] = nArray3[n7] - 1;
                        if (value >= (this.currentIValue & this.highBitMasks[k])) continue;
                        int n8 = k;
                        this.currentIRanks[n8] = this.currentIRanks[n8] - 1;
                    }
                    if (value < this.currentIValue) {
                        this.currentIRanks[0] = this.currentIRanks[0] - 1;
                    }
                    IntHistogram hist = this.nextSharing;
                    while (hist != this) {
                        assert (hist.m == this.m);
                        assert (hist.histogram == this.histogram);
                        for (int k = this.m - 1; k > 0; --k) {
                            if (value >= (hist.currentIValue & hist.highBitMasks[k])) continue;
                            int n9 = k;
                            hist.currentIRanks[n9] = hist.currentIRanks[n9] - 1;
                        }
                        if (value < hist.currentIValue) {
                            hist.currentIRanks[0] = hist.currentIRanks[0] - 1;
                        }
                        --hist.total;
                        hist.currentPreciseRank = Double.NaN;
                        hist = hist.nextSharing;
                    }
                }
                this.total -= values.length;
                this.currentPreciseRank = Double.NaN;
            }
        }

        @Override
        public long currentIRank() {
            return this.currentIRanks[0];
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToIRank(long rank) {
            block33: {
                block34: {
                    block35: {
                        block32: {
                            if (this.total == 0) {
                                if (!IntHistogram.$assertionsDisabled && this.currentIRanks[0] != 0) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            if (!IntHistogram.$assertionsDisabled && this.total <= 0) {
                                throw new AssertionError();
                            }
                            if (rank < 0L) {
                                rank = 0L;
                            } else if (rank > (long)this.total) {
                                rank = this.total;
                            }
                            if (rank != (long)this.total) break block32;
                            this.moveToRightmostRank();
                            break block33;
                        }
                        if (rank >= (long)this.currentIRanks[0]) break block34;
                        if (this.m <= 1) break block35;
                        k = 0;
                        while (k + 1 < this.m && rank < (long)this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!IntHistogram.$assertionsDisabled && rank >= (long)this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                            } while (rank < (long)this.currentIRanks[k]);
                            if (!IntHistogram.$assertionsDisabled && this.currentIRanks[k] < 0) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            do {
                                level = this.bitLevels[--k];
                                if (!IntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                            } while (k > 0 && rank >= (long)this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!IntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (rank >= (long)this.currentIRanks[0]) break block33;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                    } while (rank < (long)this.currentIRanks[0]);
                    if (!IntHistogram.$assertionsDisabled && this.currentIRanks[0] < 0) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block33;
                }
                if (this.m > 1) {
                    if (rank >= (long)(this.currentIRanks[0] + this.histogram0[this.currentIValue])) {
                        k = 0;
                        while (k + 1 < this.m && rank >= (long)(this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]])) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (rank >= (long)(this.currentIRanks[k] + b)) {
                                v1 = k;
                                this.currentIRanks[v1] = this.currentIRanks[v1] + b;
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!IntHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!IntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                            } while (k > 0 && rank < (long)(this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]));
                        }
                        if (!IntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (rank >= (long)(this.currentIRanks[0] + b)) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!IntHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (long)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                frac = (double)(rank - (long)this.currentIRanks[0]) / (double)this.histogram0[this.currentIValue];
                this.currentValue = (double)this.currentIValue + frac;
            }
            this.currentPreciseRank = rank;
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Histogram moveToRank(double rank) {
            block35: {
                block36: {
                    block37: {
                        block34: {
                            if (Double.isNaN(rank)) {
                                throw new IllegalArgumentException("Illegal rank argument (NaN)");
                            }
                            if (this.total == 0) {
                                if (!IntHistogram.$assertionsDisabled && this.currentIRanks[0] != 0) {
                                    throw new AssertionError((Object)"non-zero current rank when total==0");
                                }
                                this.currentPreciseRank = 0.0;
                                this.currentValue = this.currentIValue;
                                return this;
                            }
                            this.currentPreciseRank = NaN;
                            if (!IntHistogram.$assertionsDisabled && this.total <= 0) {
                                throw new AssertionError();
                            }
                            if (rank < 0.0) {
                                r = 0;
                                rank = 0;
                            } else if (rank > (double)this.total) {
                                r = this.total;
                                rank = r;
                            } else {
                                r = (int)rank;
                            }
                            if (r != this.total) break block34;
                            this.moveToRightmostRank();
                            break block35;
                        }
                        if (r >= this.currentIRanks[0]) break block36;
                        if (this.m <= 1) break block37;
                        k = 0;
                        while (k + 1 < this.m && r < this.currentIRanks[k + 1]) {
                            ++k;
                        }
                        while (k > 0) {
                            if (!IntHistogram.$assertionsDisabled && r >= this.currentIRanks[k]) {
                                throw new AssertionError();
                            }
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            do {
                                --this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                                v0 = k;
                                this.currentIRanks[v0] = this.currentIRanks[v0] - b;
                            } while (r < this.currentIRanks[k]);
                            if (!IntHistogram.$assertionsDisabled && this.currentIRanks[k] < 0) {
                                throw new AssertionError((Object)("currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for rank=" + rank));
                            }
                            previousValue = this.currentIValue + 1 << level;
                            previousRank = this.currentIRanks[k] + b;
                            do {
                                level = this.bitLevels[--k];
                                if (!IntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIValue = (previousValue >> level) - 1;
                                b = this.histogram[k][this.currentIValue];
                                this.currentIRanks[k] = previousRank - b;
                            } while (k > 0 && r >= this.currentIRanks[k]);
                            this.currentIValue <<= level;
                        }
                        if (!IntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        }
                        if (r >= this.currentIRanks[0]) break block35;
                    }
                    do {
                        --this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] - b;
                    } while (r < this.currentIRanks[0]);
                    if (!IntHistogram.$assertionsDisabled && this.currentIRanks[0] < 0) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " < 0 for rank=" + rank));
                    }
                    break block35;
                }
                if (this.m > 1) {
                    if (r >= this.currentIRanks[0] + this.histogram0[this.currentIValue]) {
                        k = 0;
                        while (k + 1 < this.m && r >= this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            b = this.histogram[k][this.currentIValue];
                            while (r >= this.currentIRanks[k] + b) {
                                v1 = k;
                                this.currentIRanks[v1] = this.currentIRanks[v1] + b;
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            if (!IntHistogram.$assertionsDisabled && this.currentIRanks[k] >= this.total) {
                                throw new AssertionError((Object)("currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total + " for rank=" + rank));
                            }
                            this.currentIValue <<= level;
                            lastRank = this.currentIRanks[k];
                            do {
                                level = this.bitLevels[--k];
                                if (!IntHistogram.$assertionsDisabled && k <= 0 && level != 0) {
                                    throw new AssertionError();
                                }
                                this.currentIRanks[k] = lastRank;
                            } while (k > 0 && r < this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        if (!IntHistogram.$assertionsDisabled && k != 0) {
                            throw new AssertionError();
                        } else {
                            ** GOTO lbl-1000
                        }
                    }
                } else lbl-1000:
                // 3 sources

                {
                    b = this.histogram0[this.currentIValue];
                    while (r >= this.currentIRanks[0] + b) {
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        ++this.currentIValue;
                        b = this.histogram0[this.currentIValue];
                    }
                    if (!IntHistogram.$assertionsDisabled && this.currentIRanks[0] >= this.total) {
                        throw new AssertionError((Object)("currentIRank=" + this.currentIRanks[0] + " >= total=" + this.total + " for rank=" + rank));
                    }
                }
            }
            if (rank == (double)this.currentIRanks[0]) {
                this.currentValue = this.currentIValue;
            } else {
                b = this.histogram0[this.currentIValue];
                frac = (rank - (double)this.currentIRanks[0]) / (double)b;
                this.currentValue = (double)this.currentIValue + frac;
            }
            return this;
        }

        @Override
        public Histogram moveToIValue(int value) {
            if (value < 0) {
                value = 0;
            } else if (value > this.length) {
                value = this.length;
            }
            this.currentValue = value;
            this.currentPreciseRank = Double.NaN;
            if (value == this.currentIValue) {
                return this;
            }
            if (value < this.currentIValue) {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] < this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int b;
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v < this.currentIValue);
                        do {
                            --this.currentIValue;
                            b = this.histogram[k][this.currentIValue];
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - b;
                        } while (v < this.currentIValue);
                        assert (this.currentIRanks[k] >= 0) : "currentIRanks[" + k + "]=" + this.currentIRanks[k] + " < 0 for value=" + value;
                        assert (this.currentIValue == v);
                        int previousValue = this.currentIValue + 1 << level;
                        assert (value < previousValue);
                        int previousRank = this.currentIRanks[k] + b;
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIValue = (previousValue >> level) - 1;
                            b = this.histogram[k][this.currentIValue];
                            this.currentIRanks[k] = previousRank - b;
                        } while (k > 0 && value >> level == this.currentIValue);
                        this.currentIValue <<= level;
                    }
                    assert (k == 0);
                    if (value == this.currentIValue) {
                        return this;
                    }
                    assert (value < this.currentIValue);
                }
                for (int j = this.currentIValue - 1; j >= value; --j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] - b;
                }
                assert (this.currentIRanks[0] >= 0) : "currentIRank=" + this.currentIRanks[0] + " < 0 for value=" + value;
            } else {
                if (this.m > 1) {
                    int k = 0;
                    while (k + 1 < this.m && value >> this.bitLevels[k + 1] > this.currentIValue >> this.bitLevels[k + 1]) {
                        ++k;
                    }
                    while (k > 0) {
                        int level = this.bitLevels[k];
                        int v = value >> level;
                        this.currentIValue >>= level;
                        assert (v > this.currentIValue);
                        do {
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][this.currentIValue];
                            ++this.currentIValue;
                        } while (v > this.currentIValue);
                        assert (this.currentIRanks[k] <= this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + "> total=" + this.total + " for value=" + value;
                        assert (this.currentIValue == v);
                        this.currentIValue <<= level;
                        assert (this.currentIValue <= value);
                        int lastRank = this.currentIRanks[k];
                        do {
                            level = this.bitLevels[--k];
                            assert (k > 0 || level == 0);
                            this.currentIRanks[k] = lastRank;
                        } while (k > 0 && value >> level == this.currentIValue >> level);
                    }
                    assert (k == 0);
                }
                for (int j = this.currentIValue; j < value; ++j) {
                    int b = this.histogram0[j];
                    this.currentIRanks[0] = this.currentIRanks[0] + b;
                }
                assert (this.currentIRanks[0] <= this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total + " for value=" + value;
            }
            this.currentIValue = value;
            return this;
        }

        @Override
        public long shareCount() {
            return this.shareCount;
        }

        @Override
        public Histogram nextSharing() {
            if (this.shareCount == 1) {
                throw new IllegalStateException("No sharing instances");
            }
            return this.nextSharing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Histogram share() {
            int[] nArray = this.histogram0;
            synchronized (this.histogram0) {
                IntHistogram result = new IntHistogram(this.histogram, this.total, JArrays.copyOfRange(this.bitLevels, 1, this.m));
                IntHistogram last = this;
                int count = 1;
                while (last.nextSharing != this) {
                    last = last.nextSharing;
                    ++count;
                }
                assert (count == this.shareCount);
                last.nextSharing = result;
                result.nextSharing = this;
                this.shareCount = count + 1;
                IntHistogram hist = this.nextSharing;
                while (hist != this) {
                    hist.shareCount = count + 1;
                    hist = hist.nextSharing;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
        }

        public String toString() {
            return "int histogram with " + this.length + " bars and " + this.m + " bit level" + (String)(this.m == 1 ? "" : "s {" + JArrays.toString(this.bitLevels, ",", 100) + "}") + ", current value " + this.currentIValue + " (precise " + this.currentValue + "), current rank " + this.currentIRanks[0] + " (precise " + String.valueOf(Double.isNaN(this.currentPreciseRank) ? "unknown" : Double.valueOf(this.currentPreciseRank)) + ")" + (String)(this.shareCount == 1 ? "" : ", shared between " + this.shareCount + " instances");
        }

        @Override
        void saveRanks() {
            System.arraycopy(this.currentIRanks, 0, this.alternativeIRanks, 0, this.m);
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void restoreRanks() {
            int[] tempRanks = this.currentIRanks;
            this.currentIRanks = this.alternativeIRanks;
            this.alternativeIRanks = tempRanks;
        }

        @Override
        void checkIntegrity() {
            if (this.currentIValue < 0 || this.currentIValue > this.length) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIValue = " + this.currentIValue + " is out of range 0.." + this.length));
            }
            if (this.currentIRanks[0] < 0 || this.currentIRanks[0] > this.total) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": currentIRank = " + this.currentIRanks[0] + " is out of range 0.." + this.total));
            }
            for (int k = 0; k < this.m; ++k) {
                int s;
                if (k == 0) {
                    // empty if block
                }
                if (this.currentIRanks[k] != (s = IntHistogram.sumOfAndCheck(this.histogram[k], 0, this.currentIValue >> this.bitLevels[k]))) {
                    throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": illegal currentIRanks[" + k + "] = " + this.currentIRanks[k] + " != " + s + " for " + this.currentIValue + ": " + this.histogram[k].length + " bars " + JArrays.toString(this.histogram[k], ",", 3000)));
                }
            }
            if (!Double.isNaN(this.currentPreciseRank) && !this.outsideNonZeroPart() && Math.abs(IntHistogram.preciseValue(this.histogram0, this.currentPreciseRank) - this.currentValue) > 0.001) {
                throw new AssertionError((Object)("Bug in " + String.valueOf(this) + ": for rank=" + this.currentPreciseRank + ", precise value is " + this.currentValue + " instead of " + IntHistogram.preciseValue(this.histogram0, this.currentPreciseRank) + ", currentIValue = " + this.currentIValue + ", results of iValue()/iPreciseValue() methods are " + IntHistogram.iValue(this.histogram0, this.currentIRank()) + " and " + IntHistogram.iPreciseValue(this.histogram0, this.currentPreciseRank) + ", " + this.histogram0.length + " bars " + JArrays.toString(this.histogram0, ",", 3000)));
            }
        }

        private void moveToRightmostRank() {
            block34: {
                block33: {
                    int v;
                    int k;
                    assert (this.total > 0);
                    assert (this.currentIRanks[0] <= this.total);
                    if (this.currentIRanks[0] >= this.total) break block33;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.total > this.currentIRanks[k + 1] + this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]]) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            int b = this.histogram[k][this.currentIValue];
                            while (this.total > this.currentIRanks[k] + b) {
                                int n = k;
                                this.currentIRanks[n] = this.currentIRanks[n] + b;
                                ++this.currentIValue;
                                b = this.histogram[k][this.currentIValue];
                            }
                            assert (this.currentIRanks[k] < this.total) : "currentIRank[" + k + "]=" + this.currentIRanks[k] + ">= total=" + this.total;
                            this.currentIValue <<= level;
                            int lastRank = this.currentIRanks[k];
                            do {
                                level = this.bitLevels[--k];
                                assert (k > 0 || level == 0);
                                this.currentIRanks[k] = lastRank;
                            } while (k > 0 && this.total <= this.currentIRanks[k] + this.histogram[k][this.currentIValue >> level]);
                        }
                        assert (k == 0);
                    }
                    assert (this.currentIRanks[0] < this.total);
                    do {
                        int b = this.histogram0[this.currentIValue];
                        this.currentIRanks[0] = this.currentIRanks[0] + b;
                        ++this.currentIValue;
                    } while (this.currentIRanks[0] < this.total);
                    assert (this.currentIRanks[0] == this.total) : "currentIRank=" + this.currentIRanks[0] + " > total=" + this.total;
                    assert (this.histogram0[this.currentIValue - 1] > 0);
                    if (this.m <= 1) break block34;
                    for (k = 1; k < this.m && (v = this.currentIValue - 1 >> this.bitLevels[k]) < this.currentIValue >> this.bitLevels[k]; ++k) {
                        int n = k;
                        this.currentIRanks[n] = this.currentIRanks[n] + this.histogram[k][v];
                    }
                    break block34;
                }
                if (this.histogram0[this.currentIValue - 1] == 0) {
                    int k;
                    assert (this.currentIValue == this.length || this.histogram0[this.currentIValue] == 0);
                    --this.currentIValue;
                    int previousValue = this.currentIValue + 1;
                    if (this.m > 1) {
                        k = 0;
                        while (k + 1 < this.m && this.histogram[k + 1][this.currentIValue >> this.bitLevels[k + 1]] == 0) {
                            ++k;
                        }
                        while (k > 0) {
                            int level = this.bitLevels[k];
                            this.currentIValue >>= level;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0);
                            while (this.histogram[k][this.currentIValue - 1] == 0) {
                                --this.currentIValue;
                                assert (this.currentIValue > 0);
                            }
                            int v = this.currentIValue - 1;
                            assert (this.currentIValue > 0);
                            assert (this.histogram[k][this.currentIValue] == 0);
                            assert (this.histogram[k][v] > 0);
                            this.currentIValue <<= level;
                            --k;
                        }
                    }
                    assert (this.currentIValue > 0);
                    assert (this.histogram0[this.currentIValue] == 0);
                    while (this.histogram0[this.currentIValue - 1] == 0) {
                        --this.currentIValue;
                        assert (this.currentIValue > 0);
                    }
                    if (this.m > 1) {
                        int v;
                        for (k = 1; k < this.m && (v = this.currentIValue >> this.bitLevels[k]) < previousValue >> this.bitLevels[k]; ++k) {
                            int b = this.histogram[k][v];
                            if (b <= 0) continue;
                            int n = k;
                            this.currentIRanks[n] = this.currentIRanks[n] - this.histogram[k][v];
                        }
                    }
                }
            }
        }

        private static int[][] newMultilevelHistogram(int[] histogram, int numberOfLevels) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (numberOfLevels > 31) {
                throw new IllegalArgumentException("Number of levels must not be greater than 31");
            }
            int[][] result = new int[numberOfLevels][];
            result[0] = histogram;
            return result;
        }

        private static int sumOfAndCheck(int[] histogram, int from, int to) {
            Objects.requireNonNull(histogram, "Null histogram argument");
            if (to > histogram.length) {
                to = histogram.length;
            }
            int result = 0;
            for (int k = from; k < to; ++k) {
                if (histogram[k] < 0) {
                    throw new IllegalArgumentException("Negative histogram[" + k + "]=" + histogram[k]);
                }
                if ((result += histogram[k]) >= 0) continue;
                throw new IllegalArgumentException("Total number of values (sum of all bars in the histogram) is >Integer.MAX_VALUE");
            }
            return result;
        }
    }
}

