/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.algart.arrays.Arrays;
import net.algart.arrays.TooLargeArrayException;

class InternalUtils {
    static final boolean JAVA_7;
    static final boolean JAVA_32;
    static final boolean SERVER_OPTIMIZATION;
    static final int MAX_AVAILABLE_PROCESSORS;
    static final long MAX_TEMP_JAVA_MEMORY;
    static final long MAX_TEMP_JAVA_MEMORY_FOR_TILING;
    static final long MAX_MULTITHREADING_MEMORY;
    static final boolean PROFILING;
    static final long[] DEFAULT_MATRIX_TILE_SIDES;
    private static final char[] HEX_DIGITS;
    static final String LF;

    private InternalUtils() {
    }

    static long longMulAndException(long a, long b) {
        long result = Arrays.longMul(a, b);
        if (result < 0L) {
            throw new TooLargeArrayException("Too large desired array length: " + (double)a * (double)b);
        }
        return result;
    }

    static String toHexString(byte v) {
        char[] s = new char[]{HEX_DIGITS[v >>> 4 & 0xF], HEX_DIGITS[v & 0xF]};
        return new String(s);
    }

    static String toHexString(short v) {
        char[] s = new char[]{HEX_DIGITS[v >>> 12 & 0xF], HEX_DIGITS[v >>> 8 & 0xF], HEX_DIGITS[v >>> 4 & 0xF], HEX_DIGITS[v & 0xF]};
        return new String(s);
    }

    static String toHexString(int v) {
        char[] s = new char[]{HEX_DIGITS[v >>> 28], HEX_DIGITS[v >>> 24 & 0xF], HEX_DIGITS[v >>> 20 & 0xF], HEX_DIGITS[v >>> 16 & 0xF], HEX_DIGITS[v >>> 12 & 0xF], HEX_DIGITS[v >>> 8 & 0xF], HEX_DIGITS[v >>> 4 & 0xF], HEX_DIGITS[v & 0xF]};
        return new String(s);
    }

    static String toHexString(long v) {
        return InternalUtils.toHexString((int)(v >>> 32)) + InternalUtils.toHexString((int)v);
    }

    public static int availableProcessors() {
        int n = Runtime.getRuntime().availableProcessors();
        if (n < 1) {
            throw new InternalError("Illegal result of Runtime.getRuntime().availableProcessors()");
        }
        return Math.min(n, MAX_AVAILABLE_PROCESSORS);
    }

    public static boolean serverOptimizationMode() {
        return SERVER_OPTIMIZATION;
    }

    static String getStringProperty(String propertyName, String defaultValue) {
        try {
            return System.getProperty(propertyName, defaultValue);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static int getIntProperty(String propertyName, int defaultValue) {
        try {
            return InternalUtils.parseIntWithMetricalSuffixes(System.getProperty(propertyName, String.valueOf(defaultValue)));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static int getIntPropertyWithImportant(String propertyName, int defaultValue) {
        try {
            String s = System.getProperty(propertyName + "Important");
            if (s == null) {
                s = System.getProperty(propertyName, String.valueOf(defaultValue));
            }
            return InternalUtils.parseIntWithMetricalSuffixes(s);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static Integer getIntegerWrapperProperty(String propertyName, Integer defaultValue) {
        try {
            return Integer.getInteger(propertyName, defaultValue);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static long getLongProperty(String propertyName, long defaultValue) {
        try {
            return InternalUtils.parseLongWithMetricalSuffixes(System.getProperty(propertyName, String.valueOf(defaultValue)));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static long getLongPropertyWithImportant(String propertyName, long defaultValue) {
        try {
            String s = System.getProperty(propertyName + "Important");
            if (s == null) {
                s = System.getProperty(propertyName, String.valueOf(defaultValue));
            }
            return InternalUtils.parseLongWithMetricalSuffixes(s);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static double getDoubleProperty(String propertyName, double defaultValue) {
        try {
            return Double.parseDouble(System.getProperty(propertyName, String.valueOf(defaultValue)));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        if (defaultValue) {
            return InternalUtils.getBooleanDefTrue(propertyName);
        }
        try {
            return Boolean.getBoolean(propertyName);
        }
        catch (Exception ex) {
            return false;
        }
    }

    static int parseIntWithMetricalSuffixes(String s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int sh = 0;
        if (s.endsWith("K") || s.endsWith("k")) {
            sh = 10;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("M") || s.endsWith("m")) {
            sh = 20;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("G") || s.endsWith("g")) {
            sh = 30;
            s = s.substring(0, s.length() - 1);
        }
        int result = Integer.parseInt(s);
        if (result << sh >> sh != result) {
            throw new NumberFormatException("Too large 32-bit integer value");
        }
        return result << sh;
    }

    static long parseLongWithMetricalSuffixes(String s) {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int sh = 0;
        if (s.endsWith("K") || s.endsWith("k")) {
            sh = 10;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("M") || s.endsWith("m")) {
            sh = 20;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("G") || s.endsWith("g")) {
            sh = 30;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("T") || s.endsWith("t")) {
            sh = 40;
            s = s.substring(0, s.length() - 1);
        }
        long result = Long.parseLong(s);
        if (result << sh >> sh != result) {
            throw new NumberFormatException("Too large 64-bit long integer value");
        }
        return result << sh;
    }

    private static boolean getBooleanDefTrue(String name) {
        try {
            return !"false".equalsIgnoreCase(System.getProperty(name));
        }
        catch (Exception e) {
            return true;
        }
    }

    static <T> T cast(Object object) {
        return (T)object;
    }

    static <T> T getClassInstance(String propertyName, String defaultClassName, Class<T> requiredClass, Logger logger, String additionalMessage, String ... aliases) {
        String className;
        try {
            className = System.getProperty(propertyName);
        }
        catch (Exception ex) {
            className = null;
        }
        if (className == null) {
            className = defaultClassName;
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            for (int k = 0; k < aliases.length; k += 2) {
                if (!className.equals(aliases[k])) continue;
                className = aliases[k + 1];
                break;
            }
            try {
                Object inst;
                Class<?> clazz = Class.forName(className);
                try {
                    inst = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    inst = null;
                }
                if (inst == null) {
                    Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
                    inst = method.invoke(null, new Object[0]);
                }
                if (inst == null) {
                    throw new IllegalArgumentException("Illegal class " + className + ": it creates null instance");
                }
                return requiredClass.cast(inst);
            }
            catch (Exception ex1) {
                if (className.equals(defaultClassName)) {
                    throw new InternalError(ex1.toString());
                }
                logger.severe("Cannot create an instance of " + className + " class: " + String.valueOf(ex1));
                logger.severe(additionalMessage);
                className = defaultClassName;
                continue;
            }
        }
        throw new AssertionError((Object)"Should never occur");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addShutdownTask(Runnable task, Arrays.TaskExecutionOrder whenToExecute) {
        Object object = Hooks.hookLock;
        synchronized (object) {
            if (whenToExecute == null) {
                Hooks.tasksStandard.add(task);
            } else if (whenToExecute == Arrays.TaskExecutionOrder.BEFORE_STANDARD) {
                Hooks.tasksBefore.add(task);
            } else if (whenToExecute == Arrays.TaskExecutionOrder.AFTER_STANDARD) {
                Hooks.tasksAfter.add(task);
            } else {
                throw new AssertionError((Object)"Illegal whenToExecute value");
            }
            if (!Hooks.hookInstalled) {
                Runtime.getRuntime().addShutdownHook(new Hooks());
                Hooks.hookInstalled = true;
            }
        }
    }

    static {
        boolean java32;
        boolean java7;
        String prop;
        try {
            prop = System.getProperty("java.version");
            java7 = prop != null && !prop.startsWith("1.6.") && !prop.startsWith("1.5.");
        }
        catch (Exception ex) {
            java7 = false;
        }
        try {
            prop = System.getProperty("os.arch");
            java32 = prop != null && !prop.contains("64") && prop.toLowerCase().contains("x86");
            prop = System.getProperty("sun.arch.data.model");
            if (prop != null) {
                if (prop.contains("32")) {
                    java32 = true;
                } else if (prop.contains("64")) {
                    java32 = false;
                }
            }
        }
        catch (Exception ex) {
            java32 = false;
        }
        JAVA_7 = java7;
        JAVA_32 = java32;
        SERVER_OPTIMIZATION = InternalUtils.getBooleanProperty("net.algart.arrays.serverOptimization", false);
        MAX_AVAILABLE_PROCESSORS = Math.max(1, Math.min(32768, InternalUtils.getIntPropertyWithImportant("net.algart.arrays.maxAvailableProcessors", JAVA_32 ? 16 : 16384)));
        MAX_TEMP_JAVA_MEMORY = Math.min(0x100000000000000L, Math.max(0L, InternalUtils.getLongPropertyWithImportant("net.algart.arrays.maxTempJavaMemory", 0x4000000L)));
        MAX_TEMP_JAVA_MEMORY_FOR_TILING = Math.min(0x100000000000000L, Math.max(0L, InternalUtils.getLongPropertyWithImportant("net.algart.arrays.maxTempJavaMemoryForTiling", Math.max(0x8000000L, MAX_TEMP_JAVA_MEMORY))));
        MAX_MULTITHREADING_MEMORY = Math.min(0x100000000000000L, Math.max(256L, InternalUtils.getLongPropertyWithImportant("net.algart.arrays.maxMultithreadingMemory", 0x100000L)));
        boolean ea = false;
        if (!$assertionsDisabled) {
            ea = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        PROFILING = InternalUtils.getBooleanProperty("net.algart.arrays.profiling", ea);
        DEFAULT_MATRIX_TILE_SIDES = new long[]{-1L, 65536L, Math.max(16L, InternalUtils.getLongProperty("net.algart.arrays.matrixTile2D", 4096L)), Math.max(4L, InternalUtils.getLongProperty("net.algart.arrays.matrixTile3D", 256L)), Math.max(4L, InternalUtils.getLongProperty("net.algart.arrays.matrixTile4D", 64L)), Math.max(4L, InternalUtils.getLongProperty("net.algart.arrays.matrixTile5D", 32L)), Math.max(4L, InternalUtils.getLongProperty("net.algart.arrays.matrixTileND", 16L))};
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        LF = String.format("%n", new Object[0]);
    }

    private static class Hooks
    extends Thread {
        private static final List<Runnable> tasksBefore = new ArrayList<Runnable>();
        private static final List<Runnable> tasksStandard = new ArrayList<Runnable>();
        private static final List<Runnable> tasksAfter = new ArrayList<Runnable>();
        private static final Object hookLock = new Object();
        private static boolean hookInstalled = false;

        private Hooks() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Runnable> allTasks = new ArrayList<Runnable>();
            Iterator iterator = hookLock;
            synchronized (iterator) {
                allTasks.addAll(tasksBefore);
                allTasks.addAll(tasksStandard);
                allTasks.addAll(tasksAfter);
            }
            for (Runnable task : allTasks) {
                try {
                    task.run();
                }
                catch (Throwable ex) {
                    System.err.println("Unexpected error while AlgART arrays shutdown hook! " + String.valueOf(ex));
                }
            }
        }
    }
}

