/*
 * Decompiled with CFR 0.152.
 */
package net.algart.arrays;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import net.algart.arrays.ArrayComparator32;
import net.algart.arrays.ArrayExchanger32;
import net.algart.arrays.Arrays;
import net.algart.arrays.InternalUtils;
import net.algart.arrays.MutableCharArray;
import net.algart.arrays.SimpleMemoryModel;
import net.algart.arrays.TooLargeArrayException;

public class JArrays {
    private static final int HASH_BLOCK_LEN = 256;
    private static final boolean OPTIMIZE_BYTE_MIN_MAX_BY_TABLES = false;
    public static final boolean[] EMPTY_BOOLEANS = new boolean[0];
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final char[] EMPTY_CHARS = new char[0];
    public static final short[] EMPTY_SHORTS = new short[0];
    public static final int[] EMPTY_INTS = new int[0];
    public static final long[] EMPTY_LONGS = new long[0];
    public static final float[] EMPTY_FLOATS = new float[0];
    public static final double[] EMPTY_DOUBLES = new double[0];

    private JArrays() {
    }

    public static Object copyOfRange(Object array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        int length = Array.getLength(array);
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), toIndex - fromIndex);
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, length) - fromIndex);
        return result;
    }

    public static boolean[] copyOfRange(boolean[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        boolean[] result = new boolean[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static byte[] copyOfRange(byte[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        byte[] result = new byte[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static char[] copyOfRange(char[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        char[] result = new char[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static short[] copyOfRange(short[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        short[] result = new short[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static int[] copyOfRange(int[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        int[] result = new int[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static long[] copyOfRange(long[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        long[] result = new long[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static float[] copyOfRange(float[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        float[] result = new float[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static double[] copyOfRange(double[] array, int fromIndex, int toIndex) {
        Objects.requireNonNull(array, "Null array argument in copyOfRange method");
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("Illegal indexes: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (fromIndex < 0 || fromIndex > array.length) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        double[] result = new double[toIndex - fromIndex];
        System.arraycopy(array, fromIndex, result, 0, Math.min(toIndex, array.length) - fromIndex);
        return result;
    }

    public static byte[] copy(byte[] dest, byte[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new byte[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static byte[] copy(byte[] dest, byte[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new byte[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static char[] copy(char[] dest, char[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new char[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array char[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static char[] copy(char[] dest, char[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array char[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new char[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array char[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static short[] copy(short[] dest, short[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new short[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array short[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static short[] copy(short[] dest, short[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array short[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new short[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array short[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static int[] copy(int[] dest, int[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new int[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array int[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static int[] copy(int[] dest, int[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array int[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new int[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array int[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static long[] copy(long[] dest, long[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new long[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array long[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static long[] copy(long[] dest, long[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array long[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new long[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array long[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static float[] copy(float[] dest, float[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new float[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array float[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static float[] copy(float[] dest, float[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array float[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new float[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array float[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static double[] copy(double[] dest, double[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new double[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array double[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static double[] copy(double[] dest, double[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array double[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new double[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array double[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static boolean[] copy(boolean[] dest, boolean[] src) {
        Objects.requireNonNull(src, "Null src argument");
        if (dest == null) {
            dest = new boolean[src.length];
        } else if (src.length > dest.length) {
            throw new IllegalArgumentException("Too short destination array boolean[" + dest.length + "]: it must contain at least " + src.length + " elements");
        }
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    public static boolean[] copy(boolean[] dest, boolean[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array boolean[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new boolean[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array boolean[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        System.arraycopy(src, 0, dest, 0, n);
        return dest;
    }

    public static byte[] copyAndSwapByteOrder(byte[] src, Class<?> elementType) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.copyAndSwapByteOrder(null, src, elementType);
    }

    public static byte[] copyAndSwapByteOrder(byte[] dest, byte[] src, Class<?> elementType) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.copyAndSwapByteOrder(dest, src, src.length, elementType);
    }

    public static byte[] copyAndSwapByteOrder(byte[] dest, byte[] src, int length, Class<?> elementType) {
        Objects.requireNonNull(src, "Null src argument");
        int bytesPerElement = Arrays.bytesPerElement(elementType);
        if (bytesPerElement == -1 || elementType == Boolean.TYPE) {
            throw new IllegalArgumentException("Unsupported element type: " + String.valueOf(elementType) + " (must be a primitive type except boolean)");
        }
        return JArrays.copyAndSwapByteOrder(dest, src, length, bytesPerElement);
    }

    public static byte[] copyAndSwapByteOrder(byte[] dest, byte[] src, int length, int bytesPerElement) {
        Objects.requireNonNull(src, "Null src argument");
        if (bytesPerElement != 1 && bytesPerElement != 2 && bytesPerElement != 4 && bytesPerElement != 8) {
            throw new IllegalArgumentException("Illegal bytesPerElement = " + bytesPerElement + " (must be 1, 2, 4 or 8)");
        }
        if (bytesPerElement == 1) {
            return JArrays.copy(dest, src, length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative length = " + length);
        }
        if (length > src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + length + " elements");
        }
        if (dest == null) {
            dest = new byte[length];
        } else if (length > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least " + length + " elements");
        }
        ByteBuffer srcBuffer = ByteBuffer.wrap(src);
        srcBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer destBuffer = ByteBuffer.wrap(dest);
        destBuffer.order(ByteOrder.BIG_ENDIAN);
        switch (bytesPerElement) {
            case 2: {
                destBuffer.asShortBuffer().put(0, srcBuffer.asShortBuffer(), 0, length >> 1);
                break;
            }
            case 4: {
                destBuffer.asIntBuffer().put(0, srcBuffer.asIntBuffer(), 0, length >> 2);
                break;
            }
            case 8: {
                destBuffer.asLongBuffer().put(0, srcBuffer.asLongBuffer(), 0, length >> 3);
            }
        }
        return dest;
    }

    public static long getBytes8(byte[] src, int srcPos, int count, ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return JArrays.getBytes8(src, srcPos, count);
        }
        return JArrays.getBytes8InBigEndianOrder(src, srcPos, count);
    }

    public static long getBytes8(byte[] src, int srcPos, int count) {
        Objects.requireNonNull(src, "Null src");
        if (count == 4) {
            return (long)src[srcPos] & 0xFFL | ((long)src[srcPos + 1] & 0xFFL) << 8 | ((long)src[srcPos + 2] & 0xFFL) << 16 | ((long)src[srcPos + 3] & 0xFFL) << 24;
        }
        if (count == 3) {
            return (long)src[srcPos] & 0xFFL | ((long)src[srcPos + 1] & 0xFFL) << 8 | ((long)src[srcPos + 2] & 0xFFL) << 16;
        }
        JArrays.rangeCheckForBytes8(src.length, srcPos, count);
        int numberOfBits = count << 3;
        long result = 0L;
        int shift = 0;
        while (shift < numberOfBits) {
            result |= ((long)src[srcPos] & 0xFFL) << shift;
            shift += 8;
            ++srcPos;
        }
        return result;
    }

    public static long getBytes8InBigEndianOrder(byte[] src, int srcPos, int count) {
        Objects.requireNonNull(src, "Null src");
        if (count == 4) {
            return ((long)src[srcPos] & 0xFFL) << 24 | ((long)src[srcPos + 1] & 0xFFL) << 16 | ((long)src[srcPos + 2] & 0xFFL) << 8 | (long)src[srcPos + 3] & 0xFFL;
        }
        if (count == 3) {
            return ((long)src[srcPos] & 0xFFL) << 16 | ((long)src[srcPos + 1] & 0xFFL) << 8 | (long)src[srcPos + 2] & 0xFFL;
        }
        JArrays.rangeCheckForBytes8(src.length, srcPos, count);
        long result = 0L;
        int shift = (count << 3) - 8;
        while (shift >= 0) {
            result |= ((long)src[srcPos] & 0xFFL) << shift;
            shift -= 8;
            ++srcPos;
        }
        return result;
    }

    public static void setBytes8(byte[] dest, int destPos, long packedBytes, int count, ByteOrder byteOrder) {
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            JArrays.setBytes8(dest, destPos, packedBytes, count);
        } else {
            JArrays.setBytes8InBigEndianOrder(dest, destPos, packedBytes, count);
        }
    }

    public static void setBytes8(byte[] dest, int destPos, long packedBytes, int count) {
        Objects.requireNonNull(dest, "Null dest");
        JArrays.rangeCheckForBytes8(dest.length, destPos, count);
        int i = 0;
        while (i < count) {
            dest[destPos] = (byte)packedBytes;
            packedBytes >>>= 8;
            ++i;
            ++destPos;
        }
    }

    public static void setBytes8InBigEndianOrder(byte[] dest, int destPos, long packedBytes, int count) {
        Objects.requireNonNull(dest, "Null dest");
        JArrays.rangeCheckForBytes8(dest.length, destPos, count);
        int shift = (count << 3) - 8;
        while (shift >= 0) {
            dest[destPos] = (byte)(packedBytes >>> shift);
            shift -= 8;
            ++destPos;
        }
    }

    public static byte[] arrayToBytes(Object src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (src instanceof byte[]) {
            byte[] a = (byte[])src;
            return (byte[])a.clone();
        }
        if (src instanceof boolean[]) {
            boolean[] a = (boolean[])src;
            return JArrays.booleanArrayToBytes(a);
        }
        if (src instanceof char[]) {
            char[] a = (char[])src;
            return JArrays.charArrayToBytes(a, byteOrder);
        }
        if (src instanceof short[]) {
            short[] a = (short[])src;
            return JArrays.shortArrayToBytes(a, byteOrder);
        }
        if (src instanceof int[]) {
            int[] a = (int[])src;
            return JArrays.intArrayToBytes(a, byteOrder);
        }
        if (src instanceof long[]) {
            long[] a = (long[])src;
            return JArrays.longArrayToBytes(a, byteOrder);
        }
        if (src instanceof float[]) {
            float[] a = (float[])src;
            return JArrays.floatArrayToBytes(a, byteOrder);
        }
        if (src instanceof double[]) {
            double[] a = (double[])src;
            return JArrays.doubleArrayToBytes(a, byteOrder);
        }
        if (src instanceof Object[]) {
            throw new IllegalArgumentException("Array of objects cannot be copied into byte[]");
        }
        throw new IllegalArgumentException("The src argument is not a Java array (" + src.getClass().getCanonicalName() + ")");
    }

    public static byte[] arrayToBytes(Object src, long n, ByteOrder byteOrder) {
        return JArrays.arrayToBytes(null, src, n, byteOrder);
    }

    public static byte[] arrayToBytes(byte[] dest, Object src, long n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0L) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large number of elements " + n + ": it is greater than 2^31-1 and, of course, greater than the length of the source Java array");
        }
        if (src instanceof byte[]) {
            byte[] a = (byte[])src;
            return JArrays.copy(dest, a, (int)n);
        }
        if (src instanceof boolean[]) {
            boolean[] a = (boolean[])src;
            return JArrays.booleanArrayToBytes(dest, a, (int)n);
        }
        if (src instanceof char[]) {
            char[] a = (char[])src;
            return JArrays.charArrayToBytes(dest, a, (int)n, byteOrder);
        }
        if (src instanceof short[]) {
            short[] a = (short[])src;
            return JArrays.shortArrayToBytes(dest, a, (int)n, byteOrder);
        }
        if (src instanceof int[]) {
            int[] a = (int[])src;
            return JArrays.intArrayToBytes(dest, a, (int)n, byteOrder);
        }
        if (src instanceof long[]) {
            long[] a = (long[])src;
            return JArrays.longArrayToBytes(dest, a, (int)n, byteOrder);
        }
        if (src instanceof float[]) {
            float[] a = (float[])src;
            return JArrays.floatArrayToBytes(dest, a, (int)n, byteOrder);
        }
        if (src instanceof double[]) {
            double[] a = (double[])src;
            return JArrays.doubleArrayToBytes(dest, a, (int)n, byteOrder);
        }
        if (src instanceof Object[]) {
            throw new IllegalArgumentException("Array of objects cannot be copied into byte[]");
        }
        throw new IllegalArgumentException("The src argument is not a Java array (" + src.getClass().getCanonicalName() + ")");
    }

    public static Object bytesToArray(byte[] src, Class<?> elementType, ByteOrder byteOrder) {
        Objects.requireNonNull(elementType, "Null elementType");
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        int bytesPerElement = Arrays.bytesPerElement(elementType);
        if (bytesPerElement < 0) {
            throw new IllegalArgumentException("Element type is not primitive: " + String.valueOf(elementType));
        }
        int n = src.length / bytesPerElement;
        Object dest = Array.newInstance(elementType, n);
        if (dest instanceof byte[]) {
            byte[] a = (byte[])dest;
            return JArrays.copy(a, src, n);
        }
        if (dest instanceof boolean[]) {
            boolean[] a = (boolean[])dest;
            return JArrays.bytesToBooleanArray(a, src, n);
        }
        if (dest instanceof char[]) {
            char[] a = (char[])dest;
            return JArrays.bytesToCharArray(a, src, n, byteOrder);
        }
        if (dest instanceof short[]) {
            short[] a = (short[])dest;
            return JArrays.bytesToShortArray(a, src, n, byteOrder);
        }
        if (dest instanceof int[]) {
            int[] a = (int[])dest;
            return JArrays.bytesToIntArray(a, src, n, byteOrder);
        }
        if (dest instanceof long[]) {
            long[] a = (long[])dest;
            return JArrays.bytesToLongArray(a, src, n, byteOrder);
        }
        if (dest instanceof float[]) {
            float[] a = (float[])dest;
            return JArrays.bytesToFloatArray(a, src, n, byteOrder);
        }
        if (dest instanceof double[]) {
            double[] a = (double[])dest;
            return JArrays.bytesToDoubleArray(a, src, n, byteOrder);
        }
        if (dest instanceof Object[]) {
            throw new AssertionError((Object)"Invalid component type: Object[] (was checked above)");
        }
        throw new AssertionError((Object)("The dest argument is not a Java array (" + dest.getClass().getCanonicalName() + ")"));
    }

    public static Object bytesToArray(byte[] src, long n, Class<?> elementType, ByteOrder byteOrder) {
        return JArrays.bytesToArray(null, src, n, elementType, byteOrder);
    }

    public static Object bytesToArray(Object dest, byte[] src, long n, Class<?> elementType, ByteOrder byteOrder) {
        Objects.requireNonNull(elementType, "Null elementType");
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0L) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        int bytesPerElement = Arrays.bytesPerElement(elementType);
        if (bytesPerElement < 0) {
            throw new IllegalArgumentException("Element type is not primitive: " + String.valueOf(elementType));
        }
        if ((long)bytesPerElement * n > (long)src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = Array.newInstance(elementType, (int)n);
        } else {
            Class<?> componentType = dest.getClass().getComponentType();
            if (componentType == null) {
                throw new IllegalArgumentException("dest argument is not an array");
            }
            if (!elementType.equals(componentType)) {
                throw new IllegalArgumentException("Element type of destination array " + componentType.getSimpleName() + "[] does not match the argument elementType: " + String.valueOf(elementType));
            }
        }
        if (dest instanceof byte[]) {
            byte[] a = (byte[])dest;
            return JArrays.copy(a, src, (int)n);
        }
        if (dest instanceof boolean[]) {
            boolean[] a = (boolean[])dest;
            return JArrays.bytesToBooleanArray(a, src, (int)n);
        }
        if (dest instanceof char[]) {
            char[] a = (char[])dest;
            return JArrays.bytesToCharArray(a, src, (int)n, byteOrder);
        }
        if (dest instanceof short[]) {
            short[] a = (short[])dest;
            return JArrays.bytesToShortArray(a, src, (int)n, byteOrder);
        }
        if (dest instanceof int[]) {
            int[] a = (int[])dest;
            return JArrays.bytesToIntArray(a, src, (int)n, byteOrder);
        }
        if (dest instanceof long[]) {
            long[] a = (long[])dest;
            return JArrays.bytesToLongArray(a, src, (int)n, byteOrder);
        }
        if (dest instanceof float[]) {
            float[] a = (float[])dest;
            return JArrays.bytesToFloatArray(a, src, (int)n, byteOrder);
        }
        if (dest instanceof double[]) {
            double[] a = (double[])dest;
            return JArrays.bytesToDoubleArray(a, src, (int)n, byteOrder);
        }
        if (dest instanceof Object[]) {
            throw new AssertionError((Object)"Invalid component type: Object[] (was checked above)");
        }
        throw new AssertionError((Object)("The dest argument is not a Java array (" + dest.getClass().getCanonicalName() + ")"));
    }

    public static byte[] charArrayToBytes(char[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.charArrayToBytes(null, src, src.length, byteOrder);
    }

    public static byte[] charArrayToBytes(char[] src, int n, ByteOrder byteOrder) {
        return JArrays.charArrayToBytes(null, src, n, byteOrder);
    }

    public static byte[] charArrayToBytes(byte[] dest, char[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array char[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (2L * (long)n > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of elements " + n + ": it must be less than 2^31 / 2 = 1073741824");
        }
        int numberOfBytes = 2 * n;
        if (dest == null) {
            dest = new byte[numberOfBytes];
        } else if (numberOfBytes > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least 2 * " + n + " = " + numberOfBytes + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(dest);
        bb.order(byteOrder);
        bb.asCharBuffer().put(src, 0, n);
        return dest;
    }

    public static char[] bytesToCharArray(byte[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.bytesToCharArray(null, src, src.length / 2, byteOrder);
    }

    public static char[] bytesToCharArray(byte[] src, int n, ByteOrder byteOrder) {
        return JArrays.bytesToCharArray(null, src, n, byteOrder);
    }

    public static char[] bytesToCharArray(char[] dest, byte[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (2L * (long)n > (long)src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + 2L * (long)n + " bytes to store " + n + " char elements");
        }
        if (dest == null) {
            dest = new char[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array char[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(src);
        bb.order(byteOrder);
        bb.asCharBuffer().get(dest, 0, n);
        return dest;
    }

    public static byte[] shortArrayToBytes(short[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.shortArrayToBytes(null, src, src.length, byteOrder);
    }

    public static byte[] shortArrayToBytes(short[] src, int n, ByteOrder byteOrder) {
        return JArrays.shortArrayToBytes(null, src, n, byteOrder);
    }

    public static byte[] shortArrayToBytes(byte[] dest, short[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array short[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (2L * (long)n > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of elements " + n + ": it must be less than 2^31 / 2 = 1073741824");
        }
        int numberOfBytes = 2 * n;
        if (dest == null) {
            dest = new byte[numberOfBytes];
        } else if (numberOfBytes > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least 2 * " + n + " = " + numberOfBytes + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(dest);
        bb.order(byteOrder);
        bb.asShortBuffer().put(src, 0, n);
        return dest;
    }

    public static short[] bytesToShortArray(byte[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.bytesToShortArray(null, src, src.length / 2, byteOrder);
    }

    public static short[] bytesToShortArray(byte[] src, int n, ByteOrder byteOrder) {
        return JArrays.bytesToShortArray(null, src, n, byteOrder);
    }

    public static short[] bytesToShortArray(short[] dest, byte[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (2L * (long)n > (long)src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + 2L * (long)n + " bytes to store " + n + " short elements");
        }
        if (dest == null) {
            dest = new short[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array short[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(src);
        bb.order(byteOrder);
        bb.asShortBuffer().get(dest, 0, n);
        return dest;
    }

    public static byte[] intArrayToBytes(int[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.intArrayToBytes(null, src, src.length, byteOrder);
    }

    public static byte[] intArrayToBytes(int[] src, int n, ByteOrder byteOrder) {
        return JArrays.intArrayToBytes(null, src, n, byteOrder);
    }

    public static byte[] intArrayToBytes(byte[] dest, int[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array int[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (4L * (long)n > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of elements " + n + ": it must be less than 2^31 / 4 = 536870912");
        }
        int numberOfBytes = 4 * n;
        if (dest == null) {
            dest = new byte[numberOfBytes];
        } else if (numberOfBytes > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least 4 * " + n + " = " + numberOfBytes + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(dest);
        bb.order(byteOrder);
        bb.asIntBuffer().put(src, 0, n);
        return dest;
    }

    public static int[] bytesToIntArray(byte[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.bytesToIntArray(null, src, src.length / 4, byteOrder);
    }

    public static int[] bytesToIntArray(byte[] src, int n, ByteOrder byteOrder) {
        return JArrays.bytesToIntArray(null, src, n, byteOrder);
    }

    public static int[] bytesToIntArray(int[] dest, byte[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (4L * (long)n > (long)src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + 4L * (long)n + " bytes to store " + n + " int elements");
        }
        if (dest == null) {
            dest = new int[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array int[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(src);
        bb.order(byteOrder);
        bb.asIntBuffer().get(dest, 0, n);
        return dest;
    }

    public static byte[] longArrayToBytes(long[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.longArrayToBytes(null, src, src.length, byteOrder);
    }

    public static byte[] longArrayToBytes(long[] src, int n, ByteOrder byteOrder) {
        return JArrays.longArrayToBytes(null, src, n, byteOrder);
    }

    public static byte[] longArrayToBytes(byte[] dest, long[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array long[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (8L * (long)n > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of elements " + n + ": it must be less than 2^31 / 8 = 268435456");
        }
        int numberOfBytes = 8 * n;
        if (dest == null) {
            dest = new byte[numberOfBytes];
        } else if (numberOfBytes > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least 8 * " + n + " = " + numberOfBytes + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(dest);
        bb.order(byteOrder);
        bb.asLongBuffer().put(src, 0, n);
        return dest;
    }

    public static long[] bytesToLongArray(byte[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.bytesToLongArray(null, src, src.length / 8, byteOrder);
    }

    public static long[] bytesToLongArray(byte[] src, int n, ByteOrder byteOrder) {
        return JArrays.bytesToLongArray(null, src, n, byteOrder);
    }

    public static long[] bytesToLongArray(long[] dest, byte[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (8L * (long)n > (long)src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + 8L * (long)n + " bytes to store " + n + " long elements");
        }
        if (dest == null) {
            dest = new long[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array long[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(src);
        bb.order(byteOrder);
        bb.asLongBuffer().get(dest, 0, n);
        return dest;
    }

    public static byte[] floatArrayToBytes(float[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.floatArrayToBytes(null, src, src.length, byteOrder);
    }

    public static byte[] floatArrayToBytes(float[] src, int n, ByteOrder byteOrder) {
        return JArrays.floatArrayToBytes(null, src, n, byteOrder);
    }

    public static byte[] floatArrayToBytes(byte[] dest, float[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array float[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (4L * (long)n > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of elements " + n + ": it must be less than 2^31 / 4 = 536870912");
        }
        int numberOfBytes = 4 * n;
        if (dest == null) {
            dest = new byte[numberOfBytes];
        } else if (numberOfBytes > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least 4 * " + n + " = " + numberOfBytes + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(dest);
        bb.order(byteOrder);
        bb.asFloatBuffer().put(src, 0, n);
        return dest;
    }

    public static float[] bytesToFloatArray(byte[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.bytesToFloatArray(null, src, src.length / 4, byteOrder);
    }

    public static float[] bytesToFloatArray(byte[] src, int n, ByteOrder byteOrder) {
        return JArrays.bytesToFloatArray(null, src, n, byteOrder);
    }

    public static float[] bytesToFloatArray(float[] dest, byte[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (4L * (long)n > (long)src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + 4L * (long)n + " bytes to store " + n + " float elements");
        }
        if (dest == null) {
            dest = new float[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array float[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(src);
        bb.order(byteOrder);
        bb.asFloatBuffer().get(dest, 0, n);
        return dest;
    }

    public static byte[] doubleArrayToBytes(double[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.doubleArrayToBytes(null, src, src.length, byteOrder);
    }

    public static byte[] doubleArrayToBytes(double[] src, int n, ByteOrder byteOrder) {
        return JArrays.doubleArrayToBytes(null, src, n, byteOrder);
    }

    public static byte[] doubleArrayToBytes(byte[] dest, double[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array double[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (8L * (long)n > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large number of elements " + n + ": it must be less than 2^31 / 8 = 268435456");
        }
        int numberOfBytes = 8 * n;
        if (dest == null) {
            dest = new byte[numberOfBytes];
        } else if (numberOfBytes > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least 8 * " + n + " = " + numberOfBytes + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(dest);
        bb.order(byteOrder);
        bb.asDoubleBuffer().put(src, 0, n);
        return dest;
    }

    public static double[] bytesToDoubleArray(byte[] src, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.bytesToDoubleArray(null, src, src.length / 8, byteOrder);
    }

    public static double[] bytesToDoubleArray(byte[] src, int n, ByteOrder byteOrder) {
        return JArrays.bytesToDoubleArray(null, src, n, byteOrder);
    }

    public static double[] bytesToDoubleArray(double[] dest, byte[] src, int n, ByteOrder byteOrder) {
        Objects.requireNonNull(src, "Null src argument");
        Objects.requireNonNull(byteOrder, "Null byteOrder");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (8L * (long)n > (long)src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + 8L * (long)n + " bytes to store " + n + " double elements");
        }
        if (dest == null) {
            dest = new double[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array double[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        ByteBuffer bb = ByteBuffer.wrap(src);
        bb.order(byteOrder);
        bb.asDoubleBuffer().get(dest, 0, n);
        return dest;
    }

    public static byte[] booleanArrayToBytes(boolean[] src) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.booleanArrayToBytes(null, src, src.length);
    }

    public static byte[] booleanArrayToBytes(boolean[] src, int n) {
        return JArrays.booleanArrayToBytes(null, src, n);
    }

    public static byte[] booleanArrayToBytes(byte[] dest, boolean[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array boolean[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new byte[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array byte[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        for (int k = 0; k < n; ++k) {
            dest[k] = (byte)(src[k] ? 1 : 0);
        }
        return dest;
    }

    public static boolean[] bytesToBooleanArray(byte[] src) {
        Objects.requireNonNull(src, "Null src argument");
        return JArrays.bytesToBooleanArray(null, src, src.length);
    }

    public static boolean[] bytesToBooleanArray(byte[] src, int n) {
        return JArrays.bytesToBooleanArray(null, src, n);
    }

    public static boolean[] bytesToBooleanArray(boolean[] dest, byte[] src, int n) {
        Objects.requireNonNull(src, "Null src argument");
        if (n < 0) {
            throw new IllegalArgumentException("Negative n = " + n);
        }
        if (n > src.length) {
            throw new IllegalArgumentException("Too short source array byte[" + src.length + "]: it must contain at least " + n + " elements");
        }
        if (dest == null) {
            dest = new boolean[n];
        } else if (n > dest.length) {
            throw new IllegalArgumentException("Too short destination array boolean[" + dest.length + "]: it must contain at least " + n + " elements");
        }
        for (int k = 0; k < n; ++k) {
            dest[k] = src[k] != 0;
        }
        return dest;
    }

    public static void fill(boolean[] dest, boolean value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillBooleanArray(boolean[] dest, int destPos, int count, boolean value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(byte[] dest, byte value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillByteArray(byte[] dest, int destPos, int count, byte value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(char[] dest, char value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillCharArray(char[] dest, int destPos, int count, char value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(short[] dest, short value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillShortArray(short[] dest, int destPos, int count, short value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(int[] dest, int value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillIntArray(int[] dest, int destPos, int count, int value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(long[] dest, long value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillLongArray(long[] dest, int destPos, int count, long value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(float[] dest, float value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillFloatArray(float[] dest, int destPos, int count, float value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(double[] dest, double value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillDoubleArray(double[] dest, int destPos, int count, double value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fill(Object[] dest, Object value) {
        Objects.requireNonNull(dest, "Null dest argument");
        java.util.Arrays.fill(dest, value);
    }

    public static void fillObjectArray(Object[] dest, int destPos, int count, Object value) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        java.util.Arrays.fill(dest, destPos, destPos + count, value);
    }

    public static void fillIntProgression(int[] dest, int destPos, int count, int start, int increment) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        int toIndex = destPos + count;
        for (int i = destPos; i < toIndex; ++i) {
            dest[i] = start;
            start += increment;
        }
    }

    public static void fillIntProgression(int[] dest, int start, int increment) {
        Objects.requireNonNull(dest, "Null dest argument");
        int len = dest.length;
        for (int i = 0; i < len; ++i) {
            dest[i] = start;
            start += increment;
        }
    }

    public static void zeroFillArray(Object dest, int destPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        if (dest instanceof boolean[]) {
            JArrays.fillBooleanArray((boolean[])dest, destPos, count, false);
        } else if (dest instanceof char[]) {
            JArrays.fillCharArray((char[])dest, destPos, count, '\u0000');
        } else if (dest instanceof byte[]) {
            JArrays.fillByteArray((byte[])dest, destPos, count, (byte)0);
        } else if (dest instanceof short[]) {
            JArrays.fillShortArray((short[])dest, destPos, count, (short)0);
        } else if (dest instanceof int[]) {
            JArrays.fillIntArray((int[])dest, destPos, count, 0);
        } else if (dest instanceof long[]) {
            JArrays.fillLongArray((long[])dest, destPos, count, 0L);
        } else if (dest instanceof float[]) {
            JArrays.fillFloatArray((float[])dest, destPos, count, 0.0f);
        } else if (dest instanceof double[]) {
            JArrays.fillDoubleArray((double[])dest, destPos, count, 0.0);
        } else if (dest instanceof Object[]) {
            JArrays.fillObjectArray((Object[])dest, destPos, count, null);
        } else {
            throw new IllegalArgumentException("The passed argument is not a Java array (" + String.valueOf(dest.getClass()) + ")");
        }
    }

    public static boolean areElementsZero(Object array, int pos, int count) {
        Objects.requireNonNull(array, "Null array argument");
        int arrayLen = Array.getLength(array);
        JArrays.rangeCheck(arrayLen, pos, count);
        if (array instanceof boolean[]) {
            boolean[] a = (boolean[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos]) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof char[]) {
            char[] a = (char[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != '\u0000') {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof byte[]) {
            byte[] a = (byte[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != 0) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof short[]) {
            short[] a = (short[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != 0) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof int[]) {
            int[] a = (int[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != 0) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof long[]) {
            long[] a = (long[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != 0L) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof float[]) {
            float[] a = (float[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != 0.0f) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof double[]) {
            double[] a = (double[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != 0.0) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        if (array instanceof Object[]) {
            Object[] a = (Object[])array;
            int posMax = pos + count;
            while (pos < posMax) {
                if (a[pos] != null) {
                    return false;
                }
                ++pos;
            }
            return true;
        }
        throw new InternalError("Internal error: this check should never occur");
    }

    public static int arrayHashCode(Object array, int fromIndex, int toIndex) {
        CRC32 sum = new CRC32();
        JArrays.updateArrayHashCode(array, fromIndex, toIndex, sum);
        return fromIndex == toIndex ? 0 : (int)sum.getValue();
    }

    public static void updateArrayHashCode(Object array, int fromIndex, int toIndex, Checksum hash) {
        Objects.requireNonNull(hash, "Null previousHash argument");
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (fromIndex > toIndex) {
            throw new ArrayIndexOutOfBoundsException("Array index out of range: initial index = " + fromIndex + " > end index = " + toIndex);
        }
        if (array == null && toIndex > 0) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        if (fromIndex == toIndex) {
            return;
        }
        int countEven = toIndex - fromIndex & 0xFFFFFF00;
        if (array instanceof byte[]) {
            byte[] a = (byte[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            hash.update(a, fromIndex, toIndex - fromIndex);
        } else if (array instanceof boolean[]) {
            boolean[] a = (boolean[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            boolean ELEM_SIZE = true;
            byte[] bytes = new byte[256];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 256);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 1 * (toIndex - kMax));
        } else if (array instanceof char[]) {
            char[] a = (char[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            int ELEM_SIZE = 2;
            byte[] bytes = new byte[512];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 512);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 2 * (toIndex - kMax));
        } else if (array instanceof short[]) {
            short[] a = (short[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            int ELEM_SIZE = 2;
            byte[] bytes = new byte[512];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 512);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 2 * (toIndex - kMax));
        } else if (array instanceof int[]) {
            int[] a = (int[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            int ELEM_SIZE = 4;
            byte[] bytes = new byte[1024];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 1024);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 4 * (toIndex - kMax));
        } else if (array instanceof long[]) {
            long[] a = (long[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            int ELEM_SIZE = 8;
            byte[] bytes = new byte[2048];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 2048);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 8 * (toIndex - kMax));
        } else if (array instanceof float[]) {
            float[] a = (float[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            int ELEM_SIZE = 4;
            byte[] bytes = new byte[1024];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 1024);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 4 * (toIndex - kMax));
        } else if (array instanceof double[]) {
            double[] a = (double[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            int ELEM_SIZE = 8;
            byte[] bytes = new byte[2048];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 2048);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 8 * (toIndex - kMax));
        } else if (array instanceof Object[]) {
            Object[] a = (Object[])array;
            if (toIndex > a.length) {
                throw new ArrayIndexOutOfBoundsException(toIndex);
            }
            int ELEM_SIZE = 4;
            byte[] bytes = new byte[1024];
            int kMax = fromIndex + countEven;
            for (int k = fromIndex; k < kMax; k += 256) {
                JArrays.getBytes(a, k, 256, bytes);
                hash.update(bytes, 0, 1024);
            }
            JArrays.getBytes(a, kMax, toIndex - kMax, bytes);
            hash.update(bytes, 0, 4 * (toIndex - kMax));
        } else {
            throw new IllegalArgumentException("The passed argument is not a Java array (" + String.valueOf(array.getClass()) + ")");
        }
    }

    public static boolean arrayEquals(Object array1, int pos1, Object array2, int pos2, int length) {
        int length2;
        int length1 = array1 == null ? 0 : Array.getLength(array1);
        int n = length2 = array2 == null ? 0 : Array.getLength(array2);
        if (length < 0) {
            throw new IllegalArgumentException("Negative number of compared elements: length = " + length);
        }
        if (pos1 < 0) {
            throw new ArrayIndexOutOfBoundsException(pos1);
        }
        if (pos2 < 0) {
            throw new ArrayIndexOutOfBoundsException(pos2);
        }
        if (pos1 + length > length1) {
            throw new ArrayIndexOutOfBoundsException(pos1 + length);
        }
        if (pos2 + length > length2) {
            throw new ArrayIndexOutOfBoundsException(pos2 + length);
        }
        if (array1 == array2) {
            return array1 == null || pos1 == pos2;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1 instanceof boolean[]) {
            boolean[] a1 = (boolean[])array1;
            if (!(array2 instanceof boolean[])) {
                return false;
            }
            boolean[] a2 = (boolean[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (a1[pos1] != a2[pos2]) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof char[]) {
            char[] a1 = (char[])array1;
            if (!(array2 instanceof char[])) {
                return false;
            }
            char[] a2 = (char[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (a1[pos1] != a2[pos2]) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof byte[]) {
            byte[] a1 = (byte[])array1;
            if (!(array2 instanceof byte[])) {
                return false;
            }
            byte[] a2 = (byte[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (a1[pos1] != a2[pos2]) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof short[]) {
            short[] a1 = (short[])array1;
            if (!(array2 instanceof short[])) {
                return false;
            }
            short[] a2 = (short[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (a1[pos1] != a2[pos2]) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof int[]) {
            int[] a1 = (int[])array1;
            if (!(array2 instanceof int[])) {
                return false;
            }
            int[] a2 = (int[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (a1[pos1] != a2[pos2]) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof long[]) {
            long[] a1 = (long[])array1;
            if (!(array2 instanceof long[])) {
                return false;
            }
            long[] a2 = (long[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (a1[pos1] != a2[pos2]) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof float[]) {
            float[] a1 = (float[])array1;
            if (!(array2 instanceof float[])) {
                return false;
            }
            float[] a2 = (float[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (Float.floatToIntBits(a1[pos1]) != Float.floatToIntBits(a2[pos2])) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof double[]) {
            double[] a1 = (double[])array1;
            if (!(array2 instanceof double[])) {
                return false;
            }
            double[] a2 = (double[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (Double.doubleToLongBits(a1[pos1]) != Double.doubleToLongBits(a2[pos2])) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else if (array1 instanceof Object[]) {
            Object[] a1 = (Object[])array1;
            if (!(array2 instanceof Object[])) {
                return false;
            }
            Object[] a2 = (Object[])array2;
            int pos1Max = pos1 + length;
            while (pos1 < pos1Max) {
                if (!Objects.equals(a1[pos1], a2[pos2])) {
                    return false;
                }
                ++pos1;
                ++pos2;
            }
        } else {
            throw new InternalError("Internal error: this check should never occur");
        }
        return true;
    }

    public static int indexOfBoolean(boolean[] array, int lowIndex, int highIndex, boolean value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfBoolean(boolean[] array, int lowIndex, int highIndex, boolean value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfByte(byte[] array, int lowIndex, int highIndex, byte value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfByte(byte[] array, int lowIndex, int highIndex, byte value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfChar(char[] array, int lowIndex, int highIndex, char value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfChar(char[] array, int lowIndex, int highIndex, char value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfShort(short[] array, int lowIndex, int highIndex, short value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfShort(short[] array, int lowIndex, int highIndex, short value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfInt(int[] array, int lowIndex, int highIndex, int value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfInt(int[] array, int lowIndex, int highIndex, int value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfLong(long[] array, int lowIndex, int highIndex, long value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfLong(long[] array, int lowIndex, int highIndex, long value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfFloat(float[] array, int lowIndex, int highIndex, float value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfFloat(float[] array, int lowIndex, int highIndex, float value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfDouble(double[] array, int lowIndex, int highIndex, double value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        while (lowIndex < maxPlus1) {
            if (array[lowIndex] == value) {
                return lowIndex;
            }
            ++lowIndex;
        }
        return -1;
    }

    public static int lastIndexOfDouble(double[] array, int lowIndex, int highIndex, double value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        while (highIndex > min) {
            if (array[--highIndex] != value) continue;
            return highIndex;
        }
        return -1;
    }

    public static int indexOfObject(Object[] array, int lowIndex, int highIndex, Object value) {
        Objects.requireNonNull(array, "Null array argument");
        if (lowIndex < 0) {
            lowIndex = 0;
        }
        int maxPlus1 = Math.min(array.length, highIndex);
        if (value == null) {
            while (lowIndex < maxPlus1) {
                if (array[lowIndex] == null) {
                    return lowIndex;
                }
                ++lowIndex;
            }
        } else {
            while (lowIndex < maxPlus1) {
                if (value.equals(array[lowIndex])) {
                    return lowIndex;
                }
                ++lowIndex;
            }
        }
        return -1;
    }

    public static int lastIndexOfObject(Object[] array, int lowIndex, int highIndex, Object value) {
        Objects.requireNonNull(array, "Null array argument");
        if (highIndex > array.length) {
            highIndex = array.length;
        }
        int min = Math.max(lowIndex, 0);
        if (value == null) {
            while (highIndex > min) {
                if (array[--highIndex] != null) continue;
                return highIndex;
            }
        } else {
            while (highIndex > min) {
                if (!value.equals(array[--highIndex])) continue;
                return highIndex;
            }
        }
        return -1;
    }

    public static void minByteArray(byte[] dest, int destPos, byte[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int a = src[srcPos] & 0xFF;
            int b = dest[destPos] & 0xFF;
            dest[destPos] = (byte)Math.min(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxByteArray(byte[] dest, int destPos, byte[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int a = src[srcPos] & 0xFF;
            int b = dest[destPos] & 0xFF;
            dest[destPos] = (byte)Math.max(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void minShortArray(short[] dest, int destPos, short[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int a = src[srcPos] & 0xFFFF;
            int b = dest[destPos] & 0xFFFF;
            dest[destPos] = (short)Math.min(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxShortArray(short[] dest, int destPos, short[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int a = src[srcPos] & 0xFFFF;
            int b = dest[destPos] & 0xFFFF;
            dest[destPos] = (short)Math.max(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void minCharArray(char[] dest, int destPos, char[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            char a = src[srcPos];
            char b = dest[destPos];
            dest[destPos] = (char)Math.min(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxCharArray(char[] dest, int destPos, char[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            char a = src[srcPos];
            char b = dest[destPos];
            dest[destPos] = (char)Math.max(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void minIntArray(int[] dest, int destPos, int[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int a = src[srcPos];
            int b = dest[destPos];
            dest[destPos] = Math.min(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxIntArray(int[] dest, int destPos, int[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int a = src[srcPos];
            int b = dest[destPos];
            dest[destPos] = Math.max(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void minLongArray(long[] dest, int destPos, long[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            long a = src[srcPos];
            long b = dest[destPos];
            dest[destPos] = Math.min(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxLongArray(long[] dest, int destPos, long[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            long a = src[srcPos];
            long b = dest[destPos];
            dest[destPos] = Math.max(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void minFloatArray(float[] dest, int destPos, float[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            float a = src[srcPos];
            float b = dest[destPos];
            dest[destPos] = Math.min(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxFloatArray(float[] dest, int destPos, float[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            float a = src[srcPos];
            float b = dest[destPos];
            dest[destPos] = Math.max(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void minDoubleArray(double[] dest, int destPos, double[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            double a = src[srcPos];
            double b = dest[destPos];
            dest[destPos] = Math.min(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void maxDoubleArray(double[] dest, int destPos, double[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            double a = src[srcPos];
            double b = dest[destPos];
            dest[destPos] = Math.max(a, b);
            ++srcPos;
            ++destPos;
        }
    }

    public static void addByteArray(int[] dest, int destPos, byte[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (src[srcPos] & 0xFF);
            ++srcPos;
        }
    }

    public static void addByteArray(double[] dest, int destPos, byte[] src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src[srcPos] & 0xFF);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)(src[srcPos] & 0xFF);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src[srcPos] & 0xFF) * mult;
                ++srcPos;
            }
        }
    }

    public static void addCharArray(int[] dest, int destPos, char[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + src[srcPos];
            ++srcPos;
        }
    }

    public static void addCharArray(double[] dest, int destPos, char[] src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos];
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src[srcPos];
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos] * mult;
                ++srcPos;
            }
        }
    }

    public static void addShortArray(int[] dest, int destPos, short[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (src[srcPos] & 0xFFFF);
            ++srcPos;
        }
    }

    public static void addShortArray(double[] dest, int destPos, short[] src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src[srcPos] & 0xFFFF);
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)(src[srcPos] & 0xFFFF);
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)(src[srcPos] & 0xFFFF) * mult;
                ++srcPos;
            }
        }
    }

    public static void addIntArray(int[] dest, int destPos, int[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + src[srcPos];
            ++srcPos;
        }
    }

    public static void addIntArray(double[] dest, int destPos, int[] src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos];
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src[srcPos];
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos] * mult;
                ++srcPos;
            }
        }
    }

    public static void addLongArray(int[] dest, int destPos, long[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (int)src[srcPos];
            ++srcPos;
        }
    }

    public static void addLongArray(double[] dest, int destPos, long[] src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos];
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src[srcPos];
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos] * mult;
                ++srcPos;
            }
        }
    }

    public static void addFloatArray(int[] dest, int destPos, float[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (int)src[srcPos];
            ++srcPos;
        }
    }

    public static void addFloatArray(double[] dest, int destPos, float[] src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos];
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - (double)src[srcPos];
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + (double)src[srcPos] * mult;
                ++srcPos;
            }
        }
    }

    public static void addDoubleArray(int[] dest, int destPos, double[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] + (int)src[srcPos];
            ++srcPos;
        }
    }

    public static void addDoubleArray(double[] dest, int destPos, double[] src, int srcPos, int count, double mult) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (mult == 0.0) {
            return;
        }
        if (mult == 1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + src[srcPos];
                ++srcPos;
            }
        } else if (mult == -1.0) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - src[srcPos];
                ++srcPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] + src[srcPos] * mult;
                ++srcPos;
            }
        }
    }

    public static void subtractByteArray(byte[] dest, int destPos, byte[] src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int v = (dest[destPos] & 0xFF) - (src[srcPos] & 0xFF);
                dest[destPos] = v < 0 ? (byte)0 : (byte)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = (byte)(dest[n] - src[srcPos]);
                ++srcPos;
            }
        }
    }

    public static void subtractCharArray(char[] dest, int destPos, char[] src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int v = dest[destPos] - src[srcPos];
                dest[destPos] = v < 0 ? (char)'\u0000' : (char)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = (char)(dest[n] - src[srcPos]);
                ++srcPos;
            }
        }
    }

    public static void subtractShortArray(short[] dest, int destPos, short[] src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int v = (dest[destPos] & 0xFFFF) - (src[srcPos] & 0xFFFF);
                dest[destPos] = v < 0 ? (short)0 : (short)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = (short)(dest[n] - src[srcPos]);
                ++srcPos;
            }
        }
    }

    public static void subtractIntArray(int[] dest, int destPos, int[] src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                long v = (long)dest[destPos] - (long)src[srcPos];
                dest[destPos] = v < Integer.MIN_VALUE ? Integer.MIN_VALUE : (v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v);
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                int n = destPos++;
                dest[n] = dest[n] - src[srcPos];
                ++srcPos;
            }
        }
    }

    public static void subtractLongArray(long[] dest, int destPos, long[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] - src[srcPos];
            ++srcPos;
        }
    }

    public static void subtractFloatArray(float[] dest, int destPos, float[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] - src[srcPos];
            ++srcPos;
        }
    }

    public static void subtractDoubleArray(double[] dest, int destPos, double[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            int n = destPos++;
            dest[n] = dest[n] - src[srcPos];
            ++srcPos;
        }
    }

    public static void absDiffOfByteArray(byte[] dest, int destPos, byte[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            dest[destPos] = (dest[destPos] & 0xFF) >= (src[srcPos] & 0xFF) ? (byte)(dest[destPos] - src[srcPos]) : (byte)(src[srcPos] - dest[destPos]);
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfCharArray(char[] dest, int destPos, char[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            dest[destPos] = dest[destPos] >= src[srcPos] ? (char)(dest[destPos] - src[srcPos]) : (char)(src[srcPos] - dest[destPos]);
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfShortArray(short[] dest, int destPos, short[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            dest[destPos] = (dest[destPos] & 0xFFFF) >= (src[srcPos] & 0xFFFF) ? (short)(dest[destPos] - src[srcPos]) : (short)(src[srcPos] - dest[destPos]);
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfLongArray(long[] dest, int destPos, long[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            dest[destPos] = dest[destPos] >= src[srcPos] ? dest[destPos] - src[srcPos] : src[srcPos] - dest[destPos];
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfFloatArray(float[] dest, int destPos, float[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            dest[destPos] = dest[destPos] >= src[srcPos] ? dest[destPos] - src[srcPos] : src[srcPos] - dest[destPos];
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfDoubleArray(double[] dest, int destPos, double[] src, int srcPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        int srcPosMax = srcPos + count;
        while (srcPos < srcPosMax) {
            dest[destPos] = dest[destPos] >= src[srcPos] ? dest[destPos] - src[srcPos] : src[srcPos] - dest[destPos];
            ++srcPos;
            ++destPos;
        }
    }

    public static void absDiffOfIntArray(int[] dest, int destPos, int[] src, int srcPos, int count, boolean truncateOverflows) {
        Objects.requireNonNull(dest, "Null dest argument");
        Objects.requireNonNull(src, "Null src argument");
        JArrays.rangeCheck(dest.length, destPos, src.length, srcPos, count);
        if (truncateOverflows) {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                long v = (long)dest[destPos] - (long)src[srcPos];
                if (v < 0L) {
                    v = -v;
                }
                dest[destPos] = v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v;
                ++srcPos;
                ++destPos;
            }
        } else {
            int srcPosMax = srcPos + count;
            while (srcPos < srcPosMax) {
                dest[destPos] = dest[destPos] >= src[srcPos] ? dest[destPos] - src[srcPos] : src[srcPos] - dest[destPos];
                ++srcPos;
                ++destPos;
            }
        }
    }

    public static void oppositeByteArray(byte[] dest) {
        Objects.requireNonNull(dest, "Null dest argument");
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = -dest[destPos];
        }
    }

    public static void oppositeByteArray(byte[] dest, int destPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        int destPosMax = destPos + count;
        while (destPos < destPosMax) {
            dest[destPos] = -dest[destPos];
            ++destPos;
        }
    }

    public static void oppositeShortArray(short[] dest) {
        Objects.requireNonNull(dest, "Null dest argument");
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = -dest[destPos];
        }
    }

    public static void oppositeShortArray(short[] dest, int destPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        int destPosMax = destPos + count;
        while (destPos < destPosMax) {
            dest[destPos] = -dest[destPos];
            ++destPos;
        }
    }

    public static void oppositeIntArray(int[] dest) {
        Objects.requireNonNull(dest, "Null dest argument");
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = -dest[destPos];
        }
    }

    public static void oppositeIntArray(int[] dest, int destPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        int destPosMax = destPos + count;
        while (destPos < destPosMax) {
            dest[destPos] = -dest[destPos];
            ++destPos;
        }
    }

    public static void oppositeLongArray(long[] dest) {
        Objects.requireNonNull(dest, "Null dest argument");
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = -dest[destPos];
        }
    }

    public static void oppositeLongArray(long[] dest, int destPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        int destPosMax = destPos + count;
        while (destPos < destPosMax) {
            dest[destPos] = -dest[destPos];
            ++destPos;
        }
    }

    public static void oppositeFloatArray(float[] dest) {
        Objects.requireNonNull(dest, "Null dest argument");
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = -dest[destPos];
        }
    }

    public static void oppositeFloatArray(float[] dest, int destPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        int destPosMax = destPos + count;
        while (destPos < destPosMax) {
            dest[destPos] = -dest[destPos];
            ++destPos;
        }
    }

    public static void oppositeDoubleArray(double[] dest) {
        Objects.requireNonNull(dest, "Null dest argument");
        for (int destPos = 0; destPos < dest.length; ++destPos) {
            dest[destPos] = -dest[destPos];
        }
    }

    public static void oppositeDoubleArray(double[] dest, int destPos, int count) {
        Objects.requireNonNull(dest, "Null dest argument");
        JArrays.rangeCheck(dest.length, destPos, count);
        int destPosMax = destPos + count;
        while (destPos < destPosMax) {
            dest[destPos] = -dest[destPos];
            ++destPos;
        }
    }

    public static String toString(boolean[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(char[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(byte[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(short[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(int[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(long[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(float[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(double[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(Object[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray ca = SimpleMemoryModel.getInstance().newEmptyCharArray();
        ca.append(String.valueOf(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (ca.length() >= (long)maxStringLength) {
                ca.append(separator).append("...");
                break;
            }
            ca.append(separator).append(String.valueOf(array[k]));
        }
        return Arrays.toString(ca);
    }

    public static String toString(byte[] array, Locale locale, String format, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(String.format(locale, format, array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(String.format(locale, format, array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toString(short[] array, Locale locale, String format, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(String.format(locale, format, array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(String.format(locale, format, array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toString(int[] array, Locale locale, String format, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(String.format(locale, format, array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(String.format(locale, format, array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toString(long[] array, Locale locale, String format, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(String.format(locale, format, array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(String.format(locale, format, array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toString(float[] array, Locale locale, String format, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(String.format(locale, format, Float.valueOf(array[0])));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(String.format(locale, format, Float.valueOf(array[k])));
        }
        return Arrays.toString(cv);
    }

    public static String toString(double[] array, Locale locale, String format, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(String.format(locale, format, array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(String.format(locale, format, array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toBinaryString(boolean[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(array[0] ? "1" : "0");
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(array[k] ? "1" : "0");
        }
        return Arrays.toString(cv);
    }

    public static String toHexString(char[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(InternalUtils.toHexString((short)array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(InternalUtils.toHexString((short)array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toHexString(byte[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(InternalUtils.toHexString(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(InternalUtils.toHexString(array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toHexString(short[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(InternalUtils.toHexString(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(InternalUtils.toHexString(array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toHexString(int[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(InternalUtils.toHexString(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(InternalUtils.toHexString(array[k]));
        }
        return Arrays.toString(cv);
    }

    public static String toHexString(long[] array, String separator, int maxStringLength) {
        Objects.requireNonNull(array, "Null array argument");
        Objects.requireNonNull(separator, "Null separator argument");
        if (maxStringLength <= 0) {
            throw new IllegalArgumentException("maxStringLength argument must be positive");
        }
        if (array.length == 0) {
            return "";
        }
        MutableCharArray cv = SimpleMemoryModel.getInstance().newEmptyCharArray();
        cv.append(InternalUtils.toHexString(array[0]));
        for (int k = 1; k < array.length; ++k) {
            if (cv.length() >= (long)maxStringLength) {
                cv.append(separator).append("...");
                break;
            }
            cv.append(separator).append(InternalUtils.toHexString(array[k]));
        }
        return Arrays.toString(cv);
    }

    static void rangeCheck(int arrayLen, int pos, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (pos < 0) {
            throw new IndexOutOfBoundsException("Start position = " + pos + " < 0");
        }
        if (pos > arrayLen - count) {
            throw new IndexOutOfBoundsException("End position (last index + 1) = " + (pos + count) + " > array length = " + arrayLen);
        }
    }

    static void rangeCheck(int arrayLen1, int pos1, int arrayLen2, int pos2, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Negative number of elements (" + count + ")");
        }
        if (pos1 < 0) {
            throw new IndexOutOfBoundsException("Start position = " + pos1 + " < 0");
        }
        if (pos1 > arrayLen1 - count) {
            throw new IndexOutOfBoundsException("End position (last index + 1) = " + (pos1 + count) + " > array length = " + arrayLen1);
        }
        if (pos2 < 0) {
            throw new IndexOutOfBoundsException("Start position = " + pos2 + " < 0");
        }
        if (pos2 > arrayLen2 - count) {
            throw new IndexOutOfBoundsException("End position (last index + 1) = " + (pos2 + count) + " > array length = " + arrayLen2);
        }
    }

    private static void rangeCheckForBytes8(int arrayLength, int pos, int count) {
        if (count > 8) {
            throw new IllegalArgumentException("Too large count argument: " + count + "; it cannot be > 8");
        }
        JArrays.rangeCheck(arrayLength, pos, count);
    }

    private static void getBytes(boolean[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            result[disp++] = array[offset] ? 11 : 17;
            ++offset;
        }
    }

    private static void getBytes(char[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            char value = array[offset];
            result[disp++] = (byte)(value ^ 0x43);
            result[disp++] = (byte)(value >>> 8);
            ++offset;
        }
    }

    private static void getBytes(short[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            short value = array[offset];
            result[disp++] = (byte)(value ^ 0x53);
            result[disp++] = (byte)(value >>> 8);
            ++offset;
        }
    }

    private static void getBytes(int[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            int value = array[offset];
            result[disp++] = (byte)(value ^ 0x49);
            result[disp++] = (byte)(value >>> 8);
            result[disp++] = (byte)(value >>> 16);
            result[disp++] = (byte)(value >>> 24);
            ++offset;
        }
    }

    private static void getBytes(long[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            long l = array[offset];
            int value = (int)l ^ 0x4C;
            result[disp++] = (byte)value;
            result[disp++] = (byte)(value >>> 8);
            result[disp++] = (byte)(value >>> 16);
            result[disp++] = (byte)(value >>> 24);
            value = (int)(l >>> 32) ^ 0x4C;
            result[disp++] = (byte)value;
            result[disp++] = (byte)(value >>> 8);
            result[disp++] = (byte)(value >>> 16);
            result[disp++] = (byte)(value >>> 24);
            ++offset;
        }
    }

    private static void getBytes(float[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            int value = Float.floatToIntBits(array[offset]) ^ 0x46;
            result[disp++] = (byte)value;
            result[disp++] = (byte)(value >>> 8);
            result[disp++] = (byte)(value >>> 16);
            result[disp++] = (byte)(value >>> 24);
            ++offset;
        }
    }

    private static void getBytes(double[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            long l = Double.doubleToLongBits(array[offset]);
            int value = (int)l ^ 0x44;
            result[disp++] = (byte)value;
            result[disp++] = (byte)(value >>> 8);
            result[disp++] = (byte)(value >>> 16);
            result[disp++] = (byte)(value >>> 24);
            value = (int)(l >>> 32) ^ 0x44;
            result[disp++] = (byte)value;
            result[disp++] = (byte)(value >>> 8);
            result[disp++] = (byte)(value >>> 16);
            result[disp++] = (byte)(value >>> 24);
            ++offset;
        }
    }

    private static void getBytes(Object[] array, int offset, int count, byte[] result) {
        int disp = 0;
        int offsetMax = offset + count;
        while (offset < offsetMax) {
            int value = array[offset] == null ? 0 : array[offset].hashCode();
            result[disp++] = (byte)value;
            result[disp++] = (byte)(value >>> 8);
            result[disp++] = (byte)(value >>> 16);
            result[disp++] = (byte)(value >>> 24);
            ++offset;
        }
    }

    static class MinMaxTables {
        static final byte[] MIN_TABLE = new byte[65536];
        static final byte[] MAX_TABLE = new byte[65536];

        MinMaxTables() {
        }

        static {
            for (int b1 = 0; b1 < 256; ++b1) {
                for (int b2 = 0; b2 < 256; ++b2) {
                    MinMaxTables.MIN_TABLE[b1 << 8 | b2] = (byte)Math.min(b1, b2);
                    MinMaxTables.MAX_TABLE[b1 << 8 | b2] = (byte)Math.max(b1, b2);
                }
            }
        }
    }

    public static class DoubleAndIndexArrayExchanger
    implements ArrayExchanger32 {
        private final double[] array;
        private final int[] indexes;

        public DoubleAndIndexArrayExchanger(double[] array, int[] indexes) {
            Objects.requireNonNull(array, "Null array");
            Objects.requireNonNull(indexes, "Null indexes");
            this.array = array;
            this.indexes = indexes;
        }

        @Override
        public void swap(int first, int second) {
            double temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
            int index = this.indexes[first];
            this.indexes[first] = this.indexes[second];
            this.indexes[second] = index;
        }
    }

    public static class DoubleArrayExchanger
    implements ArrayExchanger32 {
        private final double[] array;

        public DoubleArrayExchanger(double[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public void swap(int first, int second) {
            double temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
        }
    }

    public static class DoubleArrayComparator
    implements ArrayComparator32 {
        private final double[] array;

        public DoubleArrayComparator(double[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public boolean less(int first, int second) {
            return this.array[first] < this.array[second];
        }
    }

    public static class FloatAndIndexArrayExchanger
    implements ArrayExchanger32 {
        private final float[] array;
        private final int[] indexes;

        public FloatAndIndexArrayExchanger(float[] array, int[] indexes) {
            Objects.requireNonNull(array, "Null array");
            Objects.requireNonNull(indexes, "Null indexes");
            this.array = array;
            this.indexes = indexes;
        }

        @Override
        public void swap(int first, int second) {
            float temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
            int index = this.indexes[first];
            this.indexes[first] = this.indexes[second];
            this.indexes[second] = index;
        }
    }

    public static class FloatArrayExchanger
    implements ArrayExchanger32 {
        private final float[] array;

        public FloatArrayExchanger(float[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public void swap(int first, int second) {
            float temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
        }
    }

    public static class FloatArrayComparator
    implements ArrayComparator32 {
        private final float[] array;

        public FloatArrayComparator(float[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public boolean less(int first, int second) {
            return this.array[first] < this.array[second];
        }
    }

    public static class LongAndIndexArrayExchanger
    implements ArrayExchanger32 {
        private final long[] array;
        private final int[] indexes;

        public LongAndIndexArrayExchanger(long[] array, int[] indexes) {
            Objects.requireNonNull(array, "Null array");
            Objects.requireNonNull(indexes, "Null indexes");
            this.array = array;
            this.indexes = indexes;
        }

        @Override
        public void swap(int first, int second) {
            long temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
            int index = this.indexes[first];
            this.indexes[first] = this.indexes[second];
            this.indexes[second] = index;
        }
    }

    public static class LongArrayExchanger
    implements ArrayExchanger32 {
        private final long[] array;

        public LongArrayExchanger(long[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public void swap(int first, int second) {
            long temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
        }
    }

    public static class LongArrayComparator
    implements ArrayComparator32 {
        private final long[] array;

        public LongArrayComparator(long[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public boolean less(int first, int second) {
            return this.array[first] < this.array[second];
        }
    }

    public static class IntAndIndexArrayExchanger
    implements ArrayExchanger32 {
        private final int[] array;
        private final int[] indexes;

        public IntAndIndexArrayExchanger(int[] array, int[] indexes) {
            Objects.requireNonNull(array, "Null array");
            Objects.requireNonNull(indexes, "Null indexes");
            this.array = array;
            this.indexes = indexes;
        }

        @Override
        public void swap(int first, int second) {
            int temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
            int index = this.indexes[first];
            this.indexes[first] = this.indexes[second];
            this.indexes[second] = index;
        }
    }

    public static class IntArrayExchanger
    implements ArrayExchanger32 {
        private final int[] array;

        public IntArrayExchanger(int[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public void swap(int first, int second) {
            int temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
        }
    }

    public static class IntArrayComparator
    implements ArrayComparator32 {
        private final int[] array;

        public IntArrayComparator(int[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public boolean less(int first, int second) {
            return this.array[first] < this.array[second];
        }
    }

    public static class ShortAndIndexArrayExchanger
    implements ArrayExchanger32 {
        private final short[] array;
        private final int[] indexes;

        public ShortAndIndexArrayExchanger(short[] array, int[] indexes) {
            Objects.requireNonNull(array, "Null array");
            Objects.requireNonNull(indexes, "Null indexes");
            this.array = array;
            this.indexes = indexes;
        }

        @Override
        public void swap(int first, int second) {
            short temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
            int index = this.indexes[first];
            this.indexes[first] = this.indexes[second];
            this.indexes[second] = index;
        }
    }

    public static class ShortArrayExchanger
    implements ArrayExchanger32 {
        private final short[] array;

        public ShortArrayExchanger(short[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public void swap(int first, int second) {
            short temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
        }
    }

    public static class ShortArrayComparator
    implements ArrayComparator32 {
        private final short[] array;

        public ShortArrayComparator(short[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public boolean less(int first, int second) {
            return (this.array[first] & 0xFFFF) < (this.array[second] & 0xFFFF);
        }
    }

    public static class CharAndIndexArrayExchanger
    implements ArrayExchanger32 {
        private final char[] array;
        private final int[] indexes;

        public CharAndIndexArrayExchanger(char[] array, int[] indexes) {
            Objects.requireNonNull(array, "Null array");
            Objects.requireNonNull(indexes, "Null indexes");
            this.array = array;
            this.indexes = indexes;
        }

        @Override
        public void swap(int first, int second) {
            char temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
            int index = this.indexes[first];
            this.indexes[first] = this.indexes[second];
            this.indexes[second] = index;
        }
    }

    public static class CharArrayExchanger
    implements ArrayExchanger32 {
        private final char[] array;

        public CharArrayExchanger(char[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public void swap(int first, int second) {
            char temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
        }
    }

    public static class CharArrayComparator
    implements ArrayComparator32 {
        private final char[] array;

        public CharArrayComparator(char[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public boolean less(int first, int second) {
            return this.array[first] < this.array[second];
        }
    }

    public static class ByteAndIndexArrayExchanger
    implements ArrayExchanger32 {
        private final byte[] array;
        private final int[] indexes;

        public ByteAndIndexArrayExchanger(byte[] array, int[] indexes) {
            Objects.requireNonNull(array, "Null array");
            Objects.requireNonNull(indexes, "Null indexes");
            this.array = array;
            this.indexes = indexes;
        }

        @Override
        public void swap(int first, int second) {
            byte temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
            int index = this.indexes[first];
            this.indexes[first] = this.indexes[second];
            this.indexes[second] = index;
        }
    }

    public static class ByteArrayExchanger
    implements ArrayExchanger32 {
        private final byte[] array;

        public ByteArrayExchanger(byte[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public void swap(int first, int second) {
            byte temp = this.array[first];
            this.array[first] = this.array[second];
            this.array[second] = temp;
        }
    }

    public static class ByteArrayComparator
    implements ArrayComparator32 {
        private final byte[] array;

        public ByteArrayComparator(byte[] array) {
            Objects.requireNonNull(array, "Null array");
            this.array = array;
        }

        @Override
        public boolean less(int first, int second) {
            return (this.array[first] & 0xFF) < (this.array[second] & 0xFF);
        }
    }
}

